use anchor_lang::prelude::*;

pub const CERTIFICATE_SEED: &str = "certificate";
pub const MINT_MANAGER_SEED: &str = "mint-manager";

#[derive(Clone, Debug, PartialEq, AnchorSerialize, AnchorDeserialize)]
#[repr(u8)]
pub enum CertificateState {
    /// Certificate is issued
    Issued = 1,
    /// Certificate is claimed and valid
    Claimed = 2,
    /// Certificate is invalid
    Invalidated = 3,
}


#[derive(Clone, Debug, PartialEq, AnchorSerialize, AnchorDeserialize)]
#[repr(u8)]
pub enum CertificateKind {
    /// Certificate a managed rental and will be returned to issuer
    Managed = 1,
    /// Certificate is unmanaged and can be traded freely until expiration
    Unmanaged = 2,
}

pub const CERTIFICATE_SIZE: usize = 8 + std::mem::size_of::<Certificate>() + 8; 
#[account]
pub struct Certificate {
    pub issuer: Pubkey,
    pub mint: Pubkey,
    pub amount: u64,
    pub kind: u8,
    pub bump: u8,
    pub recipient: Option<Pubkey>,
    // only keeping track of this because we don't know which token account they used to claim
    pub recipient_token_account: Option<Pubkey>,

    // pay
    pub payment_amount: Option<u64>,
    pub payment_mint: Option<Pubkey>,
    
    // original mint
    pub original_mint: Option<Pubkey>,

    // time expiry
    pub expiration: Option<i64>,
    pub duration: Option<i64>,
    pub start_at_issuance: Option<bool>,

    // usage expiry
    pub max_usages: Option<u64>,
    pub total_usages: Option<u64>,
    pub usages: u64,

    // manual expiry
    pub revoke_authority: Option<Pubkey>,

    // invalidation
    pub is_returnable: bool,
    pub is_extendable: bool,

    // lifecycle
    pub issued_at: i64,
    pub claimed_at: i64,
    pub invalidated_at: i64,
    pub state: u8,
}

pub const MINT_MANAGER_SIZE: usize = 8 + std::mem::size_of::<MintManager>() + 8; 
#[account]
pub struct MintManager {
    pub bump: u8,
    pub initializer: Pubkey,
    pub outstanding_certificates: i64,
}
