use {
    crate::{state::*, errors::*},
    anchor_lang::{prelude::*}
};
use anchor_spl::{
    token::{TokenAccount},
};

#[derive(Accounts)]
pub struct UseCertificateCtx<'info> {
    #[account(mut, constraint = certificate.state == CertificateState::Claimed as u8
        && (certificate.expiration == None || Clock::get().unwrap().unix_timestamp < certificate.expiration.unwrap())
        && (certificate.max_usages == None || certificate.usages < certificate.max_usages.unwrap()) 
        @ ErrorCode::CannotUse,
        seeds = [CERTIFICATE_SEED.as_bytes(), certificate.mint.as_ref()], bump = certificate.bump
    )]
    pub certificate: Account<'info, Certificate>,
    #[account(constraint = user.key() == recipient_token_account.owner @ ErrorCode::InvalidOwnership)]
    pub user: Signer<'info>,
    #[account(constraint = recipient_token_account.amount > 0
        && recipient_token_account.mint == certificate.mint @ ErrorCode::InvalidCertificateTokenAccount)]
    pub recipient_token_account: Account<'info, TokenAccount>,
}

pub fn handler(ctx: Context<UseCertificateCtx>) -> ProgramResult {
    let certificate = &mut ctx.accounts.certificate;
    certificate.usages += 1;
    return Ok(())
}