use clap::{ App, Arg, SubCommand };



pub fn component() -> App<'static, 'static> {
    SubCommand::with_name("network")
        .alias("n")
        .about("Perform actions on docker networks")
        .version("1.0")
        .author("0x20F")
        .subcommand(SubCommand::with_name("create")
                        .alias("mk")
                        .about("Create a new docker network")
                        .version("1.0")
                        .author("0x20F")
                        .arg(Arg::with_name("name")
                                .help("The name of the network")
                                .required(true)
                                .index(1))
                    )
        .subcommand(SubCommand::with_name("remove")
                        .alias("rm")
                        .about("Remove a docker network")
                        .version("1.0")
                        .author("0x20F")
                        .arg(Arg::with_name("name")
                                .help("The name of the network")
                                .required(true)
                                .index(1))
                    )
        .subcommand(SubCommand::with_name("list")
                        .alias("ls")
                        .about("List all docker networks")
                        .version("1.0")
                        .author("0x20F")
                    )
        .subcommand(SubCommand::with_name("connect")
                        .alias("c")
                        .about("Connect a container to a network")
                        .version("1.0")
                        .author("0x20F")
                        .arg(Arg::with_name("network")
                                .help("The name of the network")
                                .required(true)
                                .index(1))
                        .arg(Arg::with_name("container")
                                .help("The name/names of all containers that should connect to the network")
                                .required(true)
                                .index(2)
                                .min_values(1))
                    )
        .subcommand(SubCommand::with_name("disconnect")
                        .alias("dc")
                        .about("Disconnect a container from a network")
                        .version("1.0")
                        .author("0x20F")
                        .arg(Arg::with_name("network")
                                .help("The name of the network")
                                .required(true)
                                .index(1))
                        .arg(Arg::with_name("container")
                                .help("The name/names of all containers that should disconnect from the network")
                                .required(true)
                                .index(2)
                                .min_values(1))
                    )
}