use clap::{ App, Arg, SubCommand };



pub fn component() -> App<'static, 'static> {
    SubCommand::with_name("env")
        .about("Manage dotenv files")
        .alias("e")
        .subcommand(SubCommand::with_name("add")
                        .alias("mk")
                        .about("Add a new dotenv file path")
                        .arg(Arg::with_name("path")
                                .help("Path to the dotenv file")
                                .required(true)
                                .index(1)
                        )
                        .arg(Arg::with_name("identifier")
                                .help("Identifier for the dotenv file")
                                .required(true)
                                .index(2)
                        )
                    )
        .subcommand(SubCommand::with_name("list")
                        .alias("ls")
                        .about("List all dotenv files")
                    )
        .subcommand(SubCommand::with_name("remove")
                        .alias("rm")
                        .about("Remove a dotenv file path")
                        .arg(Arg::with_name("identifier")
                                .help("The ID of the path you want to remove")
                                .required(true)
                                .index(1)
                            )
                    )
        .subcommand(SubCommand::with_name("activate")
                        .alias("a")
                        .about("Set a dotenv file as active")
                        .arg(Arg::with_name("identifier")
                                .help("The ID of the path you want to activate")
                                .required(true)
                                .index(1)
                            )
                    )
}