mod canonicalize_impl;
mod ensure_cloexec;
mod file_metadata;
mod file_path;
mod open_entry_impl;
mod open_impl;
mod procfs;
mod set_permissions_impl;
mod set_times_impl;
mod stat_impl;

pub(crate) use crate::fs::via_parent::set_times_nofollow as set_times_nofollow_impl;
pub(crate) use canonicalize_impl::canonicalize_impl;
pub(crate) use ensure_cloexec::ensure_cloexec;
pub(crate) use file_path::file_path;
pub(crate) use open_entry_impl::open_entry_impl;
pub(crate) use open_impl::{open_beneath, open_impl};
pub(crate) use set_permissions_impl::set_permissions_impl;
pub(crate) use set_times_impl::set_times_impl;
pub(crate) use stat_impl::stat_impl;

use file_metadata::file_metadata;

// In theory we could optimize `link` using `openat2` with `O_PATH` and
// `linkat` with `AT_EMPTY_PATH`, however that requires `CAP_DAC_READ_SEARCH`,
// so it isn't very widely applicable.
