use cfg_if::cfg_if;

cfg_if! {
    if #[cfg(not(target_arch = "wasm32"))] {
        #[cfg(unix)]
        pub use tokio::net::{UnixListener, UnixStream};
        pub use tokio::net::{TcpListener, TcpStream};
        pub use tokio::io::AsyncRead as Read;
        pub use tokio::io::AsyncReadExt as ReadExt;
        pub use tokio::io::AsyncWrite as Write;
        pub use tokio::io::AsyncWriteExt as WriteExt;

        pub use tokio::net::ToSocketAddrs;

        pub(crate) use tokio::time::sleep;
        pub use async_tungstenite as wss;
    } else if #[cfg(target_arch = "wasm32")] {
        pub use futures_lite::AsyncRead as Read;
        pub use futures_lite::AsyncReadExt as ReadExt;
        pub use futures_lite::AsyncWrite as Write;
        pub use futures_lite::AsyncWriteExt as WriteExt;
    }
}
