/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/. */

pub(super) const NODE: &str = "Node";
pub(super) const CATEGORY: &str = "Category";
pub(super) const INTEGER: &str = "Integer";
pub(super) const INT_REG: &str = "IntReg";
pub(super) const MASKED_INT_REG: &str = "MaskedIntReg";
pub(super) const BOOLEAN: &str = "Boolean";
pub(super) const COMMAND: &str = "Command";
pub(super) const ENUMERATION: &str = "Enumeration";
pub(super) const ENUM_ENTRY: &str = "EnumEntry";
pub(super) const FLOAT: &str = "Float";
pub(super) const FLOAT_REG: &str = "FloatReg";
pub(super) const STRING: &str = "String";
pub(super) const STRING_REG: &str = "StringReg";
pub(super) const REGISTER: &str = "Register";
pub(super) const CONVERTER: &str = "Converter";
pub(super) const INT_CONVERTER: &str = "IntConverter";
pub(super) const SWISS_KNIFE: &str = "SwissKnife";
pub(super) const INT_SWISS_KNIFE: &str = "IntSwissKnife";
pub(super) const PORT: &str = "Port";
pub(super) const CONF_ROM: &str = "ConfRom";
pub(super) const TEXT_DESC: &str = "TextDesc";
pub(super) const INT_KEY: &str = "IntKey";
pub(super) const ADV_FEATURE_LOCK: &str = "AdvFeatureLock";
pub(super) const SMART_FEATURE: &str = "SmartFeature";
pub(super) const STRUCT_REG: &str = "StructReg";
pub(super) const STRUCT_ENTRY: &str = "StructEntry";
pub(super) const GROUP: &str = "Group";

pub(super) const P_INVALIDATOR: &str = "pInvalidator";
pub(super) const P_SELECTED: &str = "pSelected";
pub(super) const P_FEATURE: &str = "pFeature";
pub(super) const P_VARIABLE: &str = "pVariable";
pub(super) const P_IS_IMPLEMENTED: &str = "pIsImplemented";
pub(super) const P_IS_AVAILABLE: &str = "pIsAvailable";
pub(super) const P_IS_LOCKED: &str = "pIsLocked";
pub(super) const P_BLOCK_POLLING: &str = "pBlockPolling";
pub(super) const P_ERROR: &str = "pError";
pub(super) const P_ALIAS: &str = "pAlias";
pub(super) const P_CAST_ALIAS: &str = "pCastAlias";
pub(super) const STREAMABLE: &str = "Streamable";
pub(super) const POLLING_TIME: &str = "PollingTime";
pub(super) const ON_VALUE: &str = "OnValue";
pub(super) const OFF_VALUE: &str = "OffValue";
pub(super) const NUMERIC_VALUE: &str = "NumericValue";
pub(super) const IS_SELF_CLEARING: &str = "IsSelfClearing";
pub(super) const MIN: &str = "Min";
pub(super) const P_MIN: &str = "pMin";
pub(super) const MAX: &str = "Max";
pub(super) const P_MAX: &str = "pMax";
pub(super) const INC: &str = "Inc";
pub(super) const P_INC: &str = "pInc";
pub(super) const CONSTANT: &str = "Constant";
pub(super) const EXPRESSION: &str = "Expression";
pub(super) const SIGN: &str = "Sign";
pub(super) const UNIT: &str = "Unit";
pub(super) const REPRESENTATION: &str = "Representation";
pub(super) const DISPLAY_NOTATION: &str = "DisplayNotation";
pub(super) const DISPLAY_PRECISION: &str = "DisplayPrecision";
pub(super) const ENDIANNESS: &str = "Endianess"; // Schema typos "Endianness" to "Endianess"
pub(super) const EXTENSION: &str = "Extension";
pub(super) const DESCRIPTION: &str = "Description";
pub(super) const DISPLAY_NAME: &str = "DisplayName";
pub(super) const VISIBILITY: &str = "Visibility";
pub(super) const DOCU_URL: &str = "DocuURL";
pub(super) const IS_DEPRECATED: &str = "IsDeprecated";
pub(super) const EVENT_ID: &str = "EventID";
pub(super) const IMPOSED_ACCESS_MODE: &str = "ImposedAccessMode";
pub(super) const ADDRESS: &str = "Address";
pub(super) const P_ADDRESS: &str = "pAddress";
pub(super) const INDEX: &str = "Index";
pub(super) const P_INDEX: &str = "pIndex";
pub(super) const ACCESS_MODE: &str = "AccessMode";
pub(super) const CACHEABLE: &str = "Cachable"; // Schema typos "Cacheable" to "Cachable"
pub(super) const VALUE: &str = "Value";
pub(super) const P_VALUE: &str = "pValue";
pub(super) const P_VALUE_COPY: &str = "pValueCopy";
pub(super) const VALUE_INDEXED: &str = "ValueIndexed";
pub(super) const P_VALUE_INDEXED: &str = "pValueIndexed";
pub(super) const BIT: &str = "Bit";
pub(super) const SLOPE: &str = "Slope";
pub(super) const IS_LINEAR: &str = "IsLinear";
pub(super) const CHUNK_ID: &str = "ChunkID";
pub(super) const P_CHUNK_ID: &str = "pChunkID";
pub(super) const SWAP_ENDIANNESS: &str = "SwapEndianess"; // Schema typos "Endianness" to "Endianess".
pub(super) const CACHE_CHUNK_DATA: &str = "CacheChunkData";

pub(super) const NAME: &str = "Name";
pub(super) const NAME_SPACE: &str = "NameSpace";
pub(super) const MERGE_PRIORITY: &str = "MergePriority";
pub(super) const EXPOSE_STATIC: &str = "ExposeStatic";

pub(super) const REGISTER_DESCRIPTION: &str = "RegisterDescription";
pub(super) const MODEL_NAME: &str = "ModelName";
pub(super) const VENDOR_NAME: &str = "VendorName";
pub(super) const TOOL_TIP: &str = "ToolTip";
pub(super) const STANDARD_NAME_SPCACE: &str = "StandardNameSpace";
pub(super) const SCHEMA_MAJOR_VERSION: &str = "SchemaMajorVersion";
pub(super) const SCHEMA_MINOR_VERSION: &str = "SchemaMinorVersion";
pub(super) const SCHEMA_SUB_MINOR_VERSION: &str = "SchemaSubMinorVersion";
pub(super) const MAJOR_VERSION: &str = "MajorVersion";
pub(super) const MINOR_VERSION: &str = "MinorVersion";
pub(super) const SUB_MINOR_VERSION: &str = "SubMinorVersion";
pub(super) const PRODUCT_GUID: &str = "ProductGuid";
pub(super) const VERSION_GUID: &str = "VersionGuid";

pub(super) const OFFSET: &str = "Offset";
pub(super) const P_OFFSET: &str = "pOffset";
