extern crate callpass;
extern crate docopt;
extern crate serde_derive;

use callpass::Callpass;
use docopt::Docopt;
use serde_derive::Deserialize;

const USAGE: &str = "
Usage:
    callpass [--verbose] <callsign>...

Options:
    --verbose, -v   Include the callsign after the callpass
";

#[derive(Deserialize)]
struct Args {
    arg_callsign: Vec<String>,
    flag_verbose: bool,
}

pub fn main() {
    let args: Args = Docopt::new(USAGE)
        .and_then(|d| d.deserialize())
        .unwrap_or_else(|e| e.exit());
    for callsign in args.arg_callsign {
        let callpass: Callpass = (&callsign).into();
        show(&callsign, &callpass, &args.flag_verbose)
    }
}

fn show(callsign: &str, callpass: &Callpass, verbose: &bool) {
    match *verbose {
        false => {
            println!("{}", callpass);
        }
        true => {
            println!("{} {}", callpass, callsign);
        }
    }
}
