#[macro_use]
extern crate diesel;

use chrono::NaiveDateTime;

#[derive(Queryable)]
pub struct Annotation {
    pub id: i32,
    pub book: i32,
    pub format: String,
    pub user_type: String,
    pub user: String,
    pub timestamp: f32,
    pub annot_id: String,
    pub annot_type: String,
    pub annot_data: String,
    pub searchable_text: String,
}

table! {
    annotations (id) {
        id -> Integer,
        book -> Integer,
        format -> Text,
        user_type -> Text,
        user -> Text,
        timestamp -> Float,
        annot_id -> Text,
        annot_type -> Text,
        annot_data -> Text,
        searchable_text -> Text,
    }
}

#[derive(Queryable)]
pub struct Author {
    pub id: i32,
    pub name: String,
    pub sort: Option<String>,
    pub link: String,
}

table! {
    authors (id) {
        id -> Integer,
        name -> Text,
        sort -> Nullable<Text>,
        link -> Text,
    }
}

#[derive(Queryable)]
pub struct Book {
    pub id: i32,
    pub title: String,
    pub sort: Option<String>,
    pub timestamp: Option<NaiveDateTime>,
    pub pubdate: Option<NaiveDateTime>,
    pub series_index: f32,
    pub author_sort: Option<String>,
    pub isbn: Option<String>,
    pub lccn: Option<String>,
    pub path: String,
    pub flags: i32,
    pub uuid: Option<String>,
    pub has_cover: Option<bool>,
    pub last_modified: NaiveDateTime,
}

table! {
    books (id) {
        id -> Integer,
        title -> Text,
        sort -> Nullable<Text>,
        timestamp -> Nullable<Timestamp>,
        pubdate -> Nullable<Timestamp>,
        series_index -> Float,
        author_sort -> Nullable<Text>,
        isbn -> Nullable<Text>,
        lccn -> Nullable<Text>,
        path -> Text,
        flags -> Integer,
        uuid -> Nullable<Text>,
        has_cover -> Nullable<Bool>,
        last_modified -> Timestamp,
    }
}

#[derive(Queryable)]
pub struct Comment {
    pub id: i32,
    pub book: i32,
    pub text: String,
}

table! {
    comments (id) {
        id -> Integer,
        book -> Integer,
        text -> Text,
    }
}

#[derive(Queryable)]
pub struct ConversionOptions {
    pub id: i32,
    pub format: String,
    pub book: Option<i32>,
    pub data: Vec<u8>,
}

table! {
    conversion_options (id) {
        id -> Integer,
        format -> Text,
        book -> Nullable<Integer>,
        data -> Binary,
    }
}

#[derive(Queryable)]
pub struct CustomColumn {
    pub id: i32,
    pub label: String,
    pub name: String,
    pub datatype: String,
    pub mark_for_delete: bool,
    pub editable: bool,
    pub display: String,
    pub is_multiple: bool,
    pub normalized: bool,
}

table! {
    custom_columns (id) {
        id -> Integer,
        label -> Text,
        name -> Text,
        datatype -> Text,
        mark_for_delete -> Bool,
        editable -> Bool,
        display -> Text,
        is_multiple -> Bool,
        normalized -> Bool,
    }
}

#[derive(Queryable)]
pub struct Data {
    pub id: i32,
    pub book: i32,
    pub format: String,
    pub uncompressed_size: i32,
    pub name: String,
}

table! {
    data (id) {
        id -> Integer,
        book -> Integer,
        format -> Text,
        uncompressed_size -> Integer,
        name -> Text,
    }
}

#[derive(Queryable)]
pub struct Feed {
    pub id: i32,
    pub title: String,
    pub script: String,
}

table! {
    feeds (id) {
        id -> Integer,
        title -> Text,
        script -> Text,
    }
}

#[derive(Queryable)]
pub struct Identifier {
    pub id: i32,
    pub book: i32,
    pub type_: String,
    pub val: String,
}

table! {
    identifiers (id) {
        id -> Integer,
        book -> Integer,
        #[sql_name = "type"]
        type_ -> Text,
        val -> Text,
    }
}

#[derive(Queryable)]
pub struct Language {
    pub id: i32,
    pub lang_code: String,
}

table! {
    languages (id) {
        id -> Integer,
        lang_code -> Text,
    }
}

#[derive(Queryable)]
pub struct LastReadPosition {
    pub id: i32,
    pub book: i32,
    pub format: String,
    pub user: String,
    pub device: String,
    pub cfi: String,
    pub epoch: f32,
    pub pos_frac: f32,
}

table! {
    last_read_positions (id) {
        id -> Integer,
        book -> Integer,
        format -> Text,
        user -> Text,
        device -> Text,
        cfi -> Text,
        epoch -> Float,
        pos_frac -> Float,
    }
}

#[derive(Queryable)]
pub struct LibraryID {
    pub id: i32,
    pub uuid: String,
}

table! {
    library_id (id) {
        id -> Integer,
        uuid -> Text,
    }
}

#[derive(Queryable)]
pub struct MetadataDirtied {
    pub id: i32,
    pub book: i32,
}

table! {
    metadata_dirtied (id) {
        id -> Integer,
        book -> Integer,
    }
}

#[derive(Queryable)]
pub struct Preference {
    pub id: i32,
    pub key: String,
    pub val: String,
}

table! {
    preferences (id) {
        id -> Integer,
        key -> Text,
        val -> Text,
    }
}

#[derive(Queryable)]
pub struct Publisher {
    pub id: i32,
    pub name: Option<String>,
    pub sort: Option<String>,
}

table! {
    publishers (id) {
        id -> Integer,
        name -> Nullable<Text>,
        sort -> Nullable<Text>,
    }
}

#[derive(Queryable)]
pub struct Rating {
    pub id: i32,
    pub rating: i32,
}

table! {
    ratings (id) {
        id -> Integer,
        rating -> Integer,
    }
}

#[derive(Queryable)]
pub struct Series {
    pub id: i32,
    pub name: String,
    pub sort: Option<String>,
}

table! {
    series (id) {
        id -> Integer,
        name -> Text,
        sort -> Nullable<Text>,
    }
}

#[derive(Queryable)]
pub struct Tag {
    pub id: i32,
    pub name: String,
}

table! {
    tags (id) {
        id -> Integer,
        name -> Text,
    }
}

#[derive(Queryable)]
pub struct BookAuthorLink {
    pub id: i32,
    pub book: i32,
    pub author: i32,
}

table! {
    books_authors_link (id) {
        id -> Integer,
        book -> Integer,
        author -> Integer,
    }
}

#[derive(Queryable)]
pub struct BookLanguageLink {
    pub id: i32,
    pub book: i32,
    pub lang_code: i32,
    pub item_order: i32,
}

table! {
    books_languages_link (id) {
        id -> Integer,
        book -> Integer,
        lang_code -> Integer,
        item_order -> Integer,
    }
}

#[derive(Queryable)]
pub struct BookPluginData {
    pub id: i32,
    pub book: i32,
    pub name: String,
    pub val: String,
}

table! {
    books_plugin_data (id) {
        id -> Integer,
        book -> Integer,
        name -> Text,
        val -> Text,
    }
}

#[derive(Queryable)]
pub struct BookPublisherLink {
    pub id: i32,
    pub book: i32,
    pub publisher: i32,
}

table! {
    books_publishers_link (id) {
        id -> Integer,
        book -> Integer,
        publisher -> Integer,
    }
}

#[derive(Queryable)]
pub struct BookRatingLink {
    pub id: i32,
    pub book: i32,
    pub rating: i32,
}

table! {
    books_ratings_link (id) {
        id -> Integer,
        book -> Integer,
        rating -> Integer,
    }
}

#[derive(Queryable)]
pub struct BookSeriesLink {
    pub id: i32,
    pub book: i32,
    pub series: i32,
}

table! {
    books_series_link (id) {
        id -> Integer,
        book -> Integer,
        series -> Integer,
    }
}

#[derive(Queryable)]
pub struct BookTagLink {
    pub id: i32,
    pub book: i32,
    pub tag: i32,
}

table! {
    books_tags_link (id) {
        id -> Integer,
        book -> Integer,
        tag -> Integer,
    }
}
