### Status: works, v0.1.9

# What's this?
Meet `c_rs`. It is a fork of no longer maintained project.

This crate lets you write C code directly inside Rust.

GCC and rustc nightly are required!

# So how do I use it?
Specify your Cargo.toml with
```toml
[build-dependencies.c_rs]
git = "https://github.com/mrMiiao/c_rs"
version = "*"
features = ["build"]

[dependencies.c_rs]
git = "https://github.com/mrMiiao/c_rs"
version = "*"
features = ["macro"]
```
And put this to Build.rs
```rust
extern crate c_rs;
fn main()
{
    c_rs::build("src/main.rs", "crate_name", |cfg|
    {
        // cfg is a gcc::Config object. You can use it to add additional
        // configuration options to the invocation of the C compiler.
    });
}
```
Example of main.rs
```rust
extern crate c_rs;
use c_rs::c;
use c_rs::ctypes::_void;

c!{
    #include <stdio.h>
    raw{
        void hello_world() {
            puts("Hello, World!");
        }
    }
}

extern "C" {
    fn hello_world() -> _void;
}

fn main() {
    unsafe{
        hello_world();
    }
}
```
You can find more examples [here](github.com/mrMiiao/c_rs/blob/main/examples)

## Goals:
- [x] Fix header linkage error
- [x] Add local header support using "crate"
- [x] Add ctypes

