use rsix::io::Error;

pub(crate) const fn error_str(e: Error) -> Option<&'static str> {
    // Recognize errors documented in POSIX and use the documented strings.
    // <https://pubs.opengroup.org/onlinepubs/9699919799/basedefs/errno.h.html>
    Some(match e {
        Error::TOOBIG => "Argument list too long.",
        Error::ACCES => "Permission denied.",
        Error::ADDRINUSE => "Address in use.",
        Error::ADDRNOTAVAIL => "Address not available.",
        Error::AFNOSUPPORT => "Address family not supported.",
        Error::AGAIN => "Resource unavailable, try again.",
        Error::ALREADY => "Connection already in progress.",
        Error::BADF => "Bad file descriptor.",
        Error::BADMSG => "Bad message.",
        Error::BUSY => "Device or resource busy.",
        Error::CANCELED => "Operation canceled.",
        Error::CHILD => "No child processes.",
        Error::CONNABORTED => "Connection aborted.",
        Error::CONNREFUSED => "Connection refused.",
        Error::CONNRESET => "Connection reset.",
        Error::DEADLK => "Resource deadlock would occur.",
        Error::DESTADDRREQ => "Destination address required.",
        Error::DOM => "Mathematics argument out of domain of function.",
        Error::DQUOT => "Reserved.",
        Error::EXIST => "File exists.",
        Error::FAULT => "Bad address.",
        Error::FBIG => "File too large.",
        Error::HOSTUNREACH => "Host is unreachable.",
        Error::IDRM => "Identifier removed.",
        Error::ILSEQ => "Illegal byte sequence.",
        Error::INPROGRESS => "Operation in progress.",
        Error::INTR => "Interrupted function.",
        Error::INVAL => "Invalid argument.",
        Error::IO => "I/O error.",
        Error::ISCONN => "Socket is connected.",
        Error::ISDIR => "Is a directory.",
        Error::LOOP => "Too many levels of symbolic links.",
        Error::MFILE => "File descriptor value too large.",
        Error::MLINK => "Too many links.",
        Error::MSGSIZE => "Message too large.",
        Error::MULTIHOP => "Reserved.",
        Error::NAMETOOLONG => "Filename too long.",
        Error::NETDOWN => "Network is down.",
        Error::NETRESET => "Connection aborted by network.",
        Error::NETUNREACH => "Network unreachable.",
        Error::NFILE => "Too many files open in system.",
        Error::NOBUFS => "No buffer space available.",
        Error::NODATA => "No message is available on the STREAM head read queue.",
        Error::NODEV => "No such device.",
        Error::NOENT => "No such file or directory.",
        Error::NOEXEC => "Executable file format error.",
        Error::NOLCK => "No locks available.",
        Error::NOLINK => "Reserved.",
        Error::NOMEM => "Not enough space.",
        Error::NOMSG => "No message of the desired type.",
        Error::NOPROTOOPT => "Protocol not available.",
        Error::NOSPC => "No space left on device.",
        Error::NOSR => "No STREAM resources.",
        Error::NOSTR => "Not a STREAM.",
        Error::NOSYS => "Functionality not supported.",
        Error::NOTCONN => "The socket is not connected.",
        Error::NOTDIR => "Not a directory or a symbolic link to a directory.",
        Error::NOTEMPTY => "Directory not empty.",
        Error::NOTRECOVERABLE => "State not recoverable.",
        Error::NOTSOCK => "Not a socket.",
        Error::NOTSUP => "Not supported.",
        Error::NOTTY => "Inappropriate I/O control operation.",
        Error::NXIO => "No such device or address.",
        //Error::OPNOTSUPP => "Operation not supported on socket.", // same as `NOTSUP`
        Error::OVERFLOW => "Value too large to be stored in data type.",
        Error::OWNERDEAD => "Previous owner died.",
        Error::PERM => "Operation not permitted.",
        Error::PIPE => "Broken pipe.",
        Error::PROTO => "Protocol error.",
        Error::PROTONOSUPPORT => "Protocol not supported.",
        Error::PROTOTYPE => "Protocol wrong type for socket.",
        Error::RANGE => "Result too large.",
        Error::ROFS => "Read-only file system.",
        Error::SPIPE => "Invalid seek.",
        Error::SRCH => "No such process.",
        Error::STALE => "Reserved.",
        Error::TIME => "Stream ioctl() timeout.",
        Error::TIMEDOUT => "Connection timed out.",
        Error::TXTBSY => "Text file busy.",
        //Error::WOULDBLOCK => "Operation would block.", // same as `AGAIN`
        Error::XDEV => "Cross-device link.",
        _ => return None,
    })
}
