use bytecoding::Bytecode;
use bytes::BytesMut;
use std::fmt;

#[derive(Debug, PartialEq, Eq, Bytecode)]
pub struct NamedComposed {
    a: u8,
    b: u16,
}

#[derive(Debug, PartialEq, Eq, Bytecode)]
pub struct UnnamedComposed(u8, u16);

pub enum Mutability {
    Immutable,
    Mutable,
}

#[derive(Debug, PartialEq, Eq, Bytecode)]
#[bytecode(type = u8)]
pub enum Instruction {
    // A,
    // B,
    C(u8),
    // D {
    //     a: u16,
    //     b: u64,
    // },
    // #[bytecode(flatten_all = [true, false])]
    // E(bool),
    // SetMutability {
    //     #[instruction(per_value = [Mutability::Immutable, Mutability::Mutable])]
    //     mutability: Mutability,
    //     index: usize,
    // },
}

fn test<T: Bytecode + Eq + fmt::Debug>(instructions: Vec<T>, expected_bytes: Vec<u8>) {
    let mut bytes = BytesMut::new();
    for i in &instructions {
        i.encode(&mut bytes);
    }
    assert_eq!(&bytes, &expected_bytes);
    println!("passed 1");
    let mut instructions2 = Vec::new();
    while !bytes.is_empty() {
        instructions2.push(T::decode(&mut bytes).unwrap());
    }
    assert_eq!(instructions2, instructions2);
    println!("passed 2");
}

pub fn main() {
    test(
        vec![
            // Instruction::A,
            // Instruction::B,
            Instruction::C(4),
            // Instruction::D { a: 8, b: 16 },
        ],
        vec![0, 1, 2, 4, 3, 0, 8, 0, 0, 0, 0, 0, 0, 0, 16],
    );
    test(
        vec![NamedComposed { a: 5, b: 6 }, NamedComposed { a: 12, b: 13 }],
        vec![5, 0, 6, 12, 0, 13],
    );
    test(
        vec![UnnamedComposed(5, 6), UnnamedComposed(12, 13)],
        vec![5, 0, 6, 12, 0, 13],
    );
}
