use std::str::FromStr;
use aoko::no_std::{functions::ext::Utf8Ext, pipelines::pipe::Pipe};
use ibig::UBig;

pub mod cli;

fn muti(s: &str, f: impl FnMut(&str)) {
    s.split(",").for_each(f)
}

pub fn int_to_hex(i: &str) {
    muti(i, |e| print!("int to hex: 0x{:0>64x}\n", UBig::from_str(e).unwrap()))
}

pub fn str_to_hex(s: &str) {
    muti(s, |e| print!("str to hex: 0x{:0<64x}\n", e.as_bytes().pipe(UBig::from_be_bytes)))
}

fn hex_to(s: &str) -> Vec<u8> {
    s.trim_start_matches("0x").pipe(hex::decode).unwrap()
}

pub fn hex_to_int(h: &str) {
    muti(h, |e| print!("hex to int: {}\n", hex_to(e).as_slice().pipe(UBig::from_be_bytes)))
}

pub fn hex_to_str(h: &str) {
    muti(h, |e| print!("hex to str: {}\n", hex_to(e).to_str().unwrap()))
}