use aoko::no_std::algebraic::sum::TimeUnit;
use clap::Parser;

/// A CLI tool for converting (int | str) <==> (hex)

#[derive(Parser)]
#[clap(version = "0.1.7", author = "hzqd <hzqelf@yeah.net>", disable_help_subcommand = true)]
pub struct Args {
    /// Specify the time unit, support nanos, micros, millis, secs
    #[clap(short, long, default_value = "micros")]
    pub time: TimeUnit,
    
    /// Set the conversion mode
    #[clap(subcommand)]
    pub subcmd: Mode,
}

#[derive(Parser)]
pub enum Mode {
    /// Specify the mode to "int_to_hex";
    /// Split by `,`
    IH {
        #[clap()]
        int: String,
    },

    /// Specify the mode to "str_to_hex"
    /// Split by `,`
    SH {
        #[clap()]
        str: String,
    },

    /// Specify the mode to "hex_to_int"
    /// Split by `,`
    HI {
        #[clap()]
        hex: String,
    },

    /// Specify the mode to "hex_to_str"
    /// Split by `,`
    HS {
        #[clap()]
        hex: String,
    },
}

pub fn get_args() -> Args {
    Args::parse()
}