use std::time::Duration;
use aoko::{no_std::{algebraic::sum::TimeUnit, pipelines::pipe::Pipe}, standard::functions::fun::{time_conversion_with_unit, measure_time_with_value}};
use byt32::{cli::get_args, int_to_hex, str_to_hex, hex_to_int, hex_to_str, cli::Mode::*};

fn byt32() -> (impl FnOnce(Duration) -> u128, TimeUnit) {
    let (unit, subcmd) = get_args().pipe(|s| (s.time, s.subcmd));
    match subcmd {
        IH { ref int } => int_to_hex(int),
        SH { ref str } => str_to_hex(str),
        HI { ref hex } => hex_to_int(hex),
        HS { ref hex } => hex_to_str(hex),
    }
    time_conversion_with_unit(unit)
}

fn main() {
    measure_time_with_value(byt32)
        .pipe(|(e, (f, u))| println!("Execution time: {} {u:?}.", f(e)));
}