use aoko::no_std::algebraic::sum::TimeUnit;
use clap::Parser;

/// A CLI tool for converting "str to hex" or "hex to str"

#[derive(Parser)]
#[clap(disable_help_subcommand = true, version = "0.1.5", author = "hzqd <hzqelf@yeah.net>")]
pub struct Args {
    /// Specify the time unit, support nanos, micros, millis, secs
    #[clap(short, long, default_value = "micros")]
    pub time: TimeUnit,
    
    /// Set the conversion mode
    #[clap(subcommand)]
    pub subcmd: Mode,
}

#[derive(Parser)]
pub enum Mode {
    /// Specify the mode to "int_to_hex"
    IH {
        #[clap()]
        int: String,
    },

    /// Specify the mode to "str_to_hex"
    SH {
        #[clap()]
        str: String,
    },

    /// Specify the mode to "hex_to_int"
    HI {
        #[clap()]
        hex: String,
    },

    /// Specify the mode to "hex_to_str"
    HS {
        #[clap()]
        hex: String,
    },
}

pub fn get_args() -> Args {
    Args::parse()
}