use std::time::Duration;
use aoko::{no_std::{algebraic::sum::TimeUnit, pipelines::pipe::Pipe}, standard::functions::fun::{time_conversion_with_unit, measure_time_with_value}};
use byt32::{cli::get_args, str_to_hex, hex_to_str};

fn byt32() -> (impl FnOnce(Duration) -> u128, TimeUnit) {
    let (s, h, unit) = get_args().pipe(|s| (s.str_to_hex, s.hex_to_str, s.time));
    let (s2h, h2s) = (s.chars().next().is_some(), h.chars().next().is_some());
    match (s2h, h2s) {
        (true, true) => str_to_hex(&s).pipe(|_| hex_to_str(&h)),
        (true, false) => str_to_hex(&s),
        (false, true) => hex_to_str(&h),
        (false, false) => {
            print!("Use -h for 'hex to str'\n");
            println!("Use -s for 'str to hex'");
        },
    }
    time_conversion_with_unit(unit)
}

fn main() {
    measure_time_with_value(byt32)
        .pipe(|(e, (f, u))| println!("Execution time: {} {u:?}.", f(e)));
}