use aoko::no_std::algebraic::sum::TimeUnit;
use clap::Parser;

/// A CLI tool for converting "str to hex" or "hex to str"

#[derive(Parser)]
#[clap(disable_help_flag = true, version = "0.1.3", author = "hzqd <hzqelf@yeah.net>")]
pub struct Args {
    /// Convert str to hex
    #[clap(short, long, default_value = "")]
    pub str_to_hex: String,

    /// Convert hex to str
    #[clap(short, long, default_value = "")]
    pub hex_to_str: String,

    /// Specify the time unit, support nanos, micros, millis, secs
    #[clap(short, long, default_value = "micros")]
    pub time: TimeUnit,
}

pub fn get_args() -> Args {
    Args::parse()
}