use aoko::no_std::algebraic::sum::TimeUnit;
use clap::{Parser, AppSettings};

/// A CLI tool for converting "str to hex" or "hex to str"

#[derive(Parser)]
#[clap(global_setting=AppSettings::DisableHelpFlag, version = "0.1.1", author = "hzqd <hzqelf@yeah.net>")]
pub struct Args {
    /// Specify the input str or hex
    #[clap(short, long)]
    pub input: String,

    /// Specify the time unit, support nanos, micros, millis, secs
    #[clap(short, long, default_value = "micros")]
    pub time: TimeUnit,

    /// Set the mode to "str_to_hex" or "hex_to_str"
    #[clap(subcommand)]
    pub subcmd: Mode,
}

#[derive(Parser)]
pub enum Mode {
    /// A subcommand for specify the mode to "str_to_hex" or "hex_to_str" by -h
    S {
        #[clap(short, long)]
        hex: bool,
    },
}

pub fn get_args() -> Args {
    Args::parse()
}