use std::time::Duration;
use aoko::{no_std::{functions::ext::AnyExt1, algebraic::sum::TimeUnit}, standard::functions::fun::{time_conversion_with_unit, measure_time_with_value}};
use byt32::{cli::{Mode::S, get_args}, str_to_hex, hex_to_str};

fn byt32() -> (impl FnOnce(Duration) -> u128, TimeUnit) {
    let (r#in, S { hex }, unit) = get_args().let_owned(|s| (s.input, s.subcmd, s.time));
    if hex { hex_to_str(&r#in) } else { str_to_hex(&r#in) }
    time_conversion_with_unit(unit)
}

fn main() {
    measure_time_with_value(byt32)
        .let_owned(|((f, u), e)| println!("Execution time: {} {u:?}.", f(e)));
}