# byt

Encode and decode various byte encodings.

# Examples

For example, if you have the hex string 4f33 and would like to base64-encode the
bytes [0x4f, 0x33] rather than the ASCII/UTF-8 characters '4', 'f', etc., you
could run the following:

```shell
$ byt -r hex -R base64 4f33
TzM=
```

To avoid padding the result and/or only use URL-safe characters, use the
--url-safe and --no-padding flags:

```shell
$ byt -r hex -R base64 --url-safe --no-padding 4f33
TzM
```

# Installation

Ensure you have a rust toolchain available, clone this repository, and run `make
install`.

# Usage

```
USAGE:
    byt [FLAGS] [OPTIONS] [data]

FLAGS:
    -h, --help          Prints help information
    -n, --no-padding    [base64-only] Don't pad the output
    -u, --url-safe      [base64-only] Use URL-safe encoding
    -V, --version       Prints version information

OPTIONS:
    -r, --radix <input-radix>            Treat the input as an encoded integer and decode it using this radix [default:
                                         utf8]
    -R, --output-radix <output-radix>    The desired radix of the output string [default: 64]

ARGS:
    <data>    Data to (de|en)code. Will read from STDIN if not passed as an argument
```
