pub(crate) const BYTE_TABLE: [u32; 256] = [
    0x0000, 0x00af, 0x015e, 0x01f1, 0x02bc, 0x0213, 0x03e2, 0x034d, 0x0578, 0x05d7, 0x0426, 0x0489,
    0x07c4, 0x076b, 0x069a, 0x0635, 0x0af0, 0x0a5f, 0x0bae, 0x0b01, 0x084c, 0x08e3, 0x0912, 0x09bd,
    0x0f88, 0x0f27, 0x0ed6, 0x0e79, 0x0d34, 0x0d9b, 0x0c6a, 0x0cc5, 0x15e0, 0x154f, 0x14be, 0x1411,
    0x175c, 0x17f3, 0x1602, 0x16ad, 0x1098, 0x1037, 0x11c6, 0x1169, 0x1224, 0x128b, 0x137a, 0x13d5,
    0x1f10, 0x1fbf, 0x1e4e, 0x1ee1, 0x1dac, 0x1d03, 0x1cf2, 0x1c5d, 0x1a68, 0x1ac7, 0x1b36, 0x1b99,
    0x18d4, 0x187b, 0x198a, 0x1925, 0x2bc0, 0x2b6f, 0x2a9e, 0x2a31, 0x297c, 0x29d3, 0x2822, 0x288d,
    0x2eb8, 0x2e17, 0x2fe6, 0x2f49, 0x2c04, 0x2cab, 0x2d5a, 0x2df5, 0x2130, 0x219f, 0x206e, 0x20c1,
    0x238c, 0x2323, 0x22d2, 0x227d, 0x2448, 0x24e7, 0x2516, 0x25b9, 0x26f4, 0x265b, 0x27aa, 0x2705,
    0x3e20, 0x3e8f, 0x3f7e, 0x3fd1, 0x3c9c, 0x3c33, 0x3dc2, 0x3d6d, 0x3b58, 0x3bf7, 0x3a06, 0x3aa9,
    0x39e4, 0x394b, 0x38ba, 0x3815, 0x34d0, 0x347f, 0x358e, 0x3521, 0x366c, 0x36c3, 0x3732, 0x379d,
    0x31a8, 0x3107, 0x30f6, 0x3059, 0x3314, 0x33bb, 0x324a, 0x32e5, 0x5780, 0x572f, 0x56de, 0x5671,
    0x553c, 0x5593, 0x5462, 0x54cd, 0x52f8, 0x5257, 0x53a6, 0x5309, 0x5044, 0x50eb, 0x511a, 0x51b5,
    0x5d70, 0x5ddf, 0x5c2e, 0x5c81, 0x5fcc, 0x5f63, 0x5e92, 0x5e3d, 0x5808, 0x58a7, 0x5956, 0x59f9,
    0x5ab4, 0x5a1b, 0x5bea, 0x5b45, 0x4260, 0x42cf, 0x433e, 0x4391, 0x40dc, 0x4073, 0x4182, 0x412d,
    0x4718, 0x47b7, 0x4646, 0x46e9, 0x45a4, 0x450b, 0x44fa, 0x4455, 0x4890, 0x483f, 0x49ce, 0x4961,
    0x4a2c, 0x4a83, 0x4b72, 0x4bdd, 0x4de8, 0x4d47, 0x4cb6, 0x4c19, 0x4f54, 0x4ffb, 0x4e0a, 0x4ea5,
    0x7c40, 0x7cef, 0x7d1e, 0x7db1, 0x7efc, 0x7e53, 0x7fa2, 0x7f0d, 0x7938, 0x7997, 0x7866, 0x78c9,
    0x7b84, 0x7b2b, 0x7ada, 0x7a75, 0x76b0, 0x761f, 0x77ee, 0x7741, 0x740c, 0x74a3, 0x7552, 0x75fd,
    0x73c8, 0x7367, 0x7296, 0x7239, 0x7174, 0x71db, 0x702a, 0x7085, 0x69a0, 0x690f, 0x68fe, 0x6851,
    0x6b1c, 0x6bb3, 0x6a42, 0x6aed, 0x6cd8, 0x6c77, 0x6d86, 0x6d29, 0x6e64, 0x6ecb, 0x6f3a, 0x6f95,
    0x6350, 0x63ff, 0x620e, 0x62a1, 0x61ec, 0x6143, 0x60b2, 0x601d, 0x6628, 0x6687, 0x6776, 0x67d9,
    0x6494, 0x643b, 0x65ca, 0x6565,
];

pub(crate) const WORD_TABLE: [[u32; 256]; 8] = [
    [
        0x00000000, 0xaf000000, 0x5e010000, 0xf1010000, 0xbc020000, 0x13020000, 0xe2030000,
        0x4d030000, 0x78050000, 0xd7050000, 0x26040000, 0x89040000, 0xc4070000, 0x6b070000,
        0x9a060000, 0x35060000, 0xf00a0000, 0x5f0a0000, 0xae0b0000, 0x010b0000, 0x4c080000,
        0xe3080000, 0x12090000, 0xbd090000, 0x880f0000, 0x270f0000, 0xd60e0000, 0x790e0000,
        0x340d0000, 0x9b0d0000, 0x6a0c0000, 0xc50c0000, 0xe0150000, 0x4f150000, 0xbe140000,
        0x11140000, 0x5c170000, 0xf3170000, 0x02160000, 0xad160000, 0x98100000, 0x37100000,
        0xc6110000, 0x69110000, 0x24120000, 0x8b120000, 0x7a130000, 0xd5130000, 0x101f0000,
        0xbf1f0000, 0x4e1e0000, 0xe11e0000, 0xac1d0000, 0x031d0000, 0xf21c0000, 0x5d1c0000,
        0x681a0000, 0xc71a0000, 0x361b0000, 0x991b0000, 0xd4180000, 0x7b180000, 0x8a190000,
        0x25190000, 0xc02b0000, 0x6f2b0000, 0x9e2a0000, 0x312a0000, 0x7c290000, 0xd3290000,
        0x22280000, 0x8d280000, 0xb82e0000, 0x172e0000, 0xe62f0000, 0x492f0000, 0x042c0000,
        0xab2c0000, 0x5a2d0000, 0xf52d0000, 0x30210000, 0x9f210000, 0x6e200000, 0xc1200000,
        0x8c230000, 0x23230000, 0xd2220000, 0x7d220000, 0x48240000, 0xe7240000, 0x16250000,
        0xb9250000, 0xf4260000, 0x5b260000, 0xaa270000, 0x05270000, 0x203e0000, 0x8f3e0000,
        0x7e3f0000, 0xd13f0000, 0x9c3c0000, 0x333c0000, 0xc23d0000, 0x6d3d0000, 0x583b0000,
        0xf73b0000, 0x063a0000, 0xa93a0000, 0xe4390000, 0x4b390000, 0xba380000, 0x15380000,
        0xd0340000, 0x7f340000, 0x8e350000, 0x21350000, 0x6c360000, 0xc3360000, 0x32370000,
        0x9d370000, 0xa8310000, 0x07310000, 0xf6300000, 0x59300000, 0x14330000, 0xbb330000,
        0x4a320000, 0xe5320000, 0x80570000, 0x2f570000, 0xde560000, 0x71560000, 0x3c550000,
        0x93550000, 0x62540000, 0xcd540000, 0xf8520000, 0x57520000, 0xa6530000, 0x09530000,
        0x44500000, 0xeb500000, 0x1a510000, 0xb5510000, 0x705d0000, 0xdf5d0000, 0x2e5c0000,
        0x815c0000, 0xcc5f0000, 0x635f0000, 0x925e0000, 0x3d5e0000, 0x08580000, 0xa7580000,
        0x56590000, 0xf9590000, 0xb45a0000, 0x1b5a0000, 0xea5b0000, 0x455b0000, 0x60420000,
        0xcf420000, 0x3e430000, 0x91430000, 0xdc400000, 0x73400000, 0x82410000, 0x2d410000,
        0x18470000, 0xb7470000, 0x46460000, 0xe9460000, 0xa4450000, 0x0b450000, 0xfa440000,
        0x55440000, 0x90480000, 0x3f480000, 0xce490000, 0x61490000, 0x2c4a0000, 0x834a0000,
        0x724b0000, 0xdd4b0000, 0xe84d0000, 0x474d0000, 0xb64c0000, 0x194c0000, 0x544f0000,
        0xfb4f0000, 0x0a4e0000, 0xa54e0000, 0x407c0000, 0xef7c0000, 0x1e7d0000, 0xb17d0000,
        0xfc7e0000, 0x537e0000, 0xa27f0000, 0x0d7f0000, 0x38790000, 0x97790000, 0x66780000,
        0xc9780000, 0x847b0000, 0x2b7b0000, 0xda7a0000, 0x757a0000, 0xb0760000, 0x1f760000,
        0xee770000, 0x41770000, 0x0c740000, 0xa3740000, 0x52750000, 0xfd750000, 0xc8730000,
        0x67730000, 0x96720000, 0x39720000, 0x74710000, 0xdb710000, 0x2a700000, 0x85700000,
        0xa0690000, 0x0f690000, 0xfe680000, 0x51680000, 0x1c6b0000, 0xb36b0000, 0x426a0000,
        0xed6a0000, 0xd86c0000, 0x776c0000, 0x866d0000, 0x296d0000, 0x646e0000, 0xcb6e0000,
        0x3a6f0000, 0x956f0000, 0x50630000, 0xff630000, 0x0e620000, 0xa1620000, 0xec610000,
        0x43610000, 0xb2600000, 0x1d600000, 0x28660000, 0x87660000, 0x76670000, 0xd9670000,
        0x94640000, 0x3b640000, 0xca650000, 0x65650000,
    ],
    [
        0x00000000, 0x00af0000, 0x005e0100, 0x00f10100, 0x00bc0200, 0x00130200, 0x00e20300,
        0x004d0300, 0x00780500, 0x00d70500, 0x00260400, 0x00890400, 0x00c40700, 0x006b0700,
        0x009a0600, 0x00350600, 0x00f00a00, 0x005f0a00, 0x00ae0b00, 0x00010b00, 0x004c0800,
        0x00e30800, 0x00120900, 0x00bd0900, 0x00880f00, 0x00270f00, 0x00d60e00, 0x00790e00,
        0x00340d00, 0x009b0d00, 0x006a0c00, 0x00c50c00, 0x00e01500, 0x004f1500, 0x00be1400,
        0x00111400, 0x005c1700, 0x00f31700, 0x00021600, 0x00ad1600, 0x00981000, 0x00371000,
        0x00c61100, 0x00691100, 0x00241200, 0x008b1200, 0x007a1300, 0x00d51300, 0x00101f00,
        0x00bf1f00, 0x004e1e00, 0x00e11e00, 0x00ac1d00, 0x00031d00, 0x00f21c00, 0x005d1c00,
        0x00681a00, 0x00c71a00, 0x00361b00, 0x00991b00, 0x00d41800, 0x007b1800, 0x008a1900,
        0x00251900, 0x00c02b00, 0x006f2b00, 0x009e2a00, 0x00312a00, 0x007c2900, 0x00d32900,
        0x00222800, 0x008d2800, 0x00b82e00, 0x00172e00, 0x00e62f00, 0x00492f00, 0x00042c00,
        0x00ab2c00, 0x005a2d00, 0x00f52d00, 0x00302100, 0x009f2100, 0x006e2000, 0x00c12000,
        0x008c2300, 0x00232300, 0x00d22200, 0x007d2200, 0x00482400, 0x00e72400, 0x00162500,
        0x00b92500, 0x00f42600, 0x005b2600, 0x00aa2700, 0x00052700, 0x00203e00, 0x008f3e00,
        0x007e3f00, 0x00d13f00, 0x009c3c00, 0x00333c00, 0x00c23d00, 0x006d3d00, 0x00583b00,
        0x00f73b00, 0x00063a00, 0x00a93a00, 0x00e43900, 0x004b3900, 0x00ba3800, 0x00153800,
        0x00d03400, 0x007f3400, 0x008e3500, 0x00213500, 0x006c3600, 0x00c33600, 0x00323700,
        0x009d3700, 0x00a83100, 0x00073100, 0x00f63000, 0x00593000, 0x00143300, 0x00bb3300,
        0x004a3200, 0x00e53200, 0x00805700, 0x002f5700, 0x00de5600, 0x00715600, 0x003c5500,
        0x00935500, 0x00625400, 0x00cd5400, 0x00f85200, 0x00575200, 0x00a65300, 0x00095300,
        0x00445000, 0x00eb5000, 0x001a5100, 0x00b55100, 0x00705d00, 0x00df5d00, 0x002e5c00,
        0x00815c00, 0x00cc5f00, 0x00635f00, 0x00925e00, 0x003d5e00, 0x00085800, 0x00a75800,
        0x00565900, 0x00f95900, 0x00b45a00, 0x001b5a00, 0x00ea5b00, 0x00455b00, 0x00604200,
        0x00cf4200, 0x003e4300, 0x00914300, 0x00dc4000, 0x00734000, 0x00824100, 0x002d4100,
        0x00184700, 0x00b74700, 0x00464600, 0x00e94600, 0x00a44500, 0x000b4500, 0x00fa4400,
        0x00554400, 0x00904800, 0x003f4800, 0x00ce4900, 0x00614900, 0x002c4a00, 0x00834a00,
        0x00724b00, 0x00dd4b00, 0x00e84d00, 0x00474d00, 0x00b64c00, 0x00194c00, 0x00544f00,
        0x00fb4f00, 0x000a4e00, 0x00a54e00, 0x00407c00, 0x00ef7c00, 0x001e7d00, 0x00b17d00,
        0x00fc7e00, 0x00537e00, 0x00a27f00, 0x000d7f00, 0x00387900, 0x00977900, 0x00667800,
        0x00c97800, 0x00847b00, 0x002b7b00, 0x00da7a00, 0x00757a00, 0x00b07600, 0x001f7600,
        0x00ee7700, 0x00417700, 0x000c7400, 0x00a37400, 0x00527500, 0x00fd7500, 0x00c87300,
        0x00677300, 0x00967200, 0x00397200, 0x00747100, 0x00db7100, 0x002a7000, 0x00857000,
        0x00a06900, 0x000f6900, 0x00fe6800, 0x00516800, 0x001c6b00, 0x00b36b00, 0x00426a00,
        0x00ed6a00, 0x00d86c00, 0x00776c00, 0x00866d00, 0x00296d00, 0x00646e00, 0x00cb6e00,
        0x003a6f00, 0x00956f00, 0x00506300, 0x00ff6300, 0x000e6200, 0x00a16200, 0x00ec6100,
        0x00436100, 0x00b26000, 0x001d6000, 0x00286600, 0x00876600, 0x00766700, 0x00d96700,
        0x00946400, 0x003b6400, 0x00ca6500, 0x00656500,
    ],
    [
        0x00000000, 0x0000af00, 0x00005e01, 0x0000f101, 0x0000bc02, 0x00001302, 0x0000e203,
        0x00004d03, 0x00007805, 0x0000d705, 0x00002604, 0x00008904, 0x0000c407, 0x00006b07,
        0x00009a06, 0x00003506, 0x0000f00a, 0x00005f0a, 0x0000ae0b, 0x0000010b, 0x00004c08,
        0x0000e308, 0x00001209, 0x0000bd09, 0x0000880f, 0x0000270f, 0x0000d60e, 0x0000790e,
        0x0000340d, 0x00009b0d, 0x00006a0c, 0x0000c50c, 0x0000e015, 0x00004f15, 0x0000be14,
        0x00001114, 0x00005c17, 0x0000f317, 0x00000216, 0x0000ad16, 0x00009810, 0x00003710,
        0x0000c611, 0x00006911, 0x00002412, 0x00008b12, 0x00007a13, 0x0000d513, 0x0000101f,
        0x0000bf1f, 0x00004e1e, 0x0000e11e, 0x0000ac1d, 0x0000031d, 0x0000f21c, 0x00005d1c,
        0x0000681a, 0x0000c71a, 0x0000361b, 0x0000991b, 0x0000d418, 0x00007b18, 0x00008a19,
        0x00002519, 0x0000c02b, 0x00006f2b, 0x00009e2a, 0x0000312a, 0x00007c29, 0x0000d329,
        0x00002228, 0x00008d28, 0x0000b82e, 0x0000172e, 0x0000e62f, 0x0000492f, 0x0000042c,
        0x0000ab2c, 0x00005a2d, 0x0000f52d, 0x00003021, 0x00009f21, 0x00006e20, 0x0000c120,
        0x00008c23, 0x00002323, 0x0000d222, 0x00007d22, 0x00004824, 0x0000e724, 0x00001625,
        0x0000b925, 0x0000f426, 0x00005b26, 0x0000aa27, 0x00000527, 0x0000203e, 0x00008f3e,
        0x00007e3f, 0x0000d13f, 0x00009c3c, 0x0000333c, 0x0000c23d, 0x00006d3d, 0x0000583b,
        0x0000f73b, 0x0000063a, 0x0000a93a, 0x0000e439, 0x00004b39, 0x0000ba38, 0x00001538,
        0x0000d034, 0x00007f34, 0x00008e35, 0x00002135, 0x00006c36, 0x0000c336, 0x00003237,
        0x00009d37, 0x0000a831, 0x00000731, 0x0000f630, 0x00005930, 0x00001433, 0x0000bb33,
        0x00004a32, 0x0000e532, 0x00008057, 0x00002f57, 0x0000de56, 0x00007156, 0x00003c55,
        0x00009355, 0x00006254, 0x0000cd54, 0x0000f852, 0x00005752, 0x0000a653, 0x00000953,
        0x00004450, 0x0000eb50, 0x00001a51, 0x0000b551, 0x0000705d, 0x0000df5d, 0x00002e5c,
        0x0000815c, 0x0000cc5f, 0x0000635f, 0x0000925e, 0x00003d5e, 0x00000858, 0x0000a758,
        0x00005659, 0x0000f959, 0x0000b45a, 0x00001b5a, 0x0000ea5b, 0x0000455b, 0x00006042,
        0x0000cf42, 0x00003e43, 0x00009143, 0x0000dc40, 0x00007340, 0x00008241, 0x00002d41,
        0x00001847, 0x0000b747, 0x00004646, 0x0000e946, 0x0000a445, 0x00000b45, 0x0000fa44,
        0x00005544, 0x00009048, 0x00003f48, 0x0000ce49, 0x00006149, 0x00002c4a, 0x0000834a,
        0x0000724b, 0x0000dd4b, 0x0000e84d, 0x0000474d, 0x0000b64c, 0x0000194c, 0x0000544f,
        0x0000fb4f, 0x00000a4e, 0x0000a54e, 0x0000407c, 0x0000ef7c, 0x00001e7d, 0x0000b17d,
        0x0000fc7e, 0x0000537e, 0x0000a27f, 0x00000d7f, 0x00003879, 0x00009779, 0x00006678,
        0x0000c978, 0x0000847b, 0x00002b7b, 0x0000da7a, 0x0000757a, 0x0000b076, 0x00001f76,
        0x0000ee77, 0x00004177, 0x00000c74, 0x0000a374, 0x00005275, 0x0000fd75, 0x0000c873,
        0x00006773, 0x00009672, 0x00003972, 0x00007471, 0x0000db71, 0x00002a70, 0x00008570,
        0x0000a069, 0x00000f69, 0x0000fe68, 0x00005168, 0x00001c6b, 0x0000b36b, 0x0000426a,
        0x0000ed6a, 0x0000d86c, 0x0000776c, 0x0000866d, 0x0000296d, 0x0000646e, 0x0000cb6e,
        0x00003a6f, 0x0000956f, 0x00005063, 0x0000ff63, 0x00000e62, 0x0000a162, 0x0000ec61,
        0x00004361, 0x0000b260, 0x00001d60, 0x00002866, 0x00008766, 0x00007667, 0x0000d967,
        0x00009464, 0x00003b64, 0x0000ca65, 0x00006565,
    ],
    [
        0x00000000, 0x000000af, 0xaf00005e, 0xaf0000f1, 0x5e0100bc, 0x5e010013, 0xf10100e2,
        0xf101004d, 0x13020078, 0x130200d7, 0xbc020026, 0xbc020089, 0x4d0300c4, 0x4d03006b,
        0xe203009a, 0xe2030035, 0x260400f0, 0x2604005f, 0x890400ae, 0x89040001, 0x7805004c,
        0x780500e3, 0xd7050012, 0xd70500bd, 0x35060088, 0x35060027, 0x9a0600d6, 0x9a060079,
        0x6b070034, 0x6b07009b, 0xc407006a, 0xc40700c5, 0xe30800e0, 0xe308004f, 0x4c0800be,
        0x4c080011, 0xbd09005c, 0xbd0900f3, 0x12090002, 0x120900ad, 0xf00a0098, 0xf00a0037,
        0x5f0a00c6, 0x5f0a0069, 0xae0b0024, 0xae0b008b, 0x010b007a, 0x010b00d5, 0xc50c0010,
        0xc50c00bf, 0x6a0c004e, 0x6a0c00e1, 0x9b0d00ac, 0x9b0d0003, 0x340d00f2, 0x340d005d,
        0xd60e0068, 0xd60e00c7, 0x790e0036, 0x790e0099, 0x880f00d4, 0x880f007b, 0x270f008a,
        0x270f0025, 0x691100c0, 0x6911006f, 0xc611009e, 0xc6110031, 0x3710007c, 0x371000d3,
        0x98100022, 0x9810008d, 0x7a1300b8, 0x7a130017, 0xd51300e6, 0xd5130049, 0x24120004,
        0x241200ab, 0x8b12005a, 0x8b1200f5, 0x4f150030, 0x4f15009f, 0xe015006e, 0xe01500c1,
        0x1114008c, 0x11140023, 0xbe1400d2, 0xbe14007d, 0x5c170048, 0x5c1700e7, 0xf3170016,
        0xf31700b9, 0x021600f4, 0x0216005b, 0xad1600aa, 0xad160005, 0x8a190020, 0x8a19008f,
        0x2519007e, 0x251900d1, 0xd418009c, 0xd4180033, 0x7b1800c2, 0x7b18006d, 0x991b0058,
        0x991b00f7, 0x361b0006, 0x361b00a9, 0xc71a00e4, 0xc71a004b, 0x681a00ba, 0x681a0015,
        0xac1d00d0, 0xac1d007f, 0x031d008e, 0x031d0021, 0xf21c006c, 0xf21c00c3, 0x5d1c0032,
        0x5d1c009d, 0xbf1f00a8, 0xbf1f0007, 0x101f00f6, 0x101f0059, 0xe11e0014, 0xe11e00bb,
        0x4e1e004a, 0x4e1e00e5, 0x7d220080, 0x7d22002f, 0xd22200de, 0xd2220071, 0x2323003c,
        0x23230093, 0x8c230062, 0x8c2300cd, 0x6e2000f8, 0x6e200057, 0xc12000a6, 0xc1200009,
        0x30210044, 0x302100eb, 0x9f21001a, 0x9f2100b5, 0x5b260070, 0x5b2600df, 0xf426002e,
        0xf4260081, 0x052700cc, 0x05270063, 0xaa270092, 0xaa27003d, 0x48240008, 0x482400a7,
        0xe7240056, 0xe72400f9, 0x162500b4, 0x1625001b, 0xb92500ea, 0xb9250045, 0x9e2a0060,
        0x9e2a00cf, 0x312a003e, 0x312a0091, 0xc02b00dc, 0xc02b0073, 0x6f2b0082, 0x6f2b002d,
        0x8d280018, 0x8d2800b7, 0x22280046, 0x222800e9, 0xd32900a4, 0xd329000b, 0x7c2900fa,
        0x7c290055, 0xb82e0090, 0xb82e003f, 0x172e00ce, 0x172e0061, 0xe62f002c, 0xe62f0083,
        0x492f0072, 0x492f00dd, 0xab2c00e8, 0xab2c0047, 0x042c00b6, 0x042c0019, 0xf52d0054,
        0xf52d00fb, 0x5a2d000a, 0x5a2d00a5, 0x14330040, 0x143300ef, 0xbb33001e, 0xbb3300b1,
        0x4a3200fc, 0x4a320053, 0xe53200a2, 0xe532000d, 0x07310038, 0x07310097, 0xa8310066,
        0xa83100c9, 0x59300084, 0x5930002b, 0xf63000da, 0xf6300075, 0x323700b0, 0x3237001f,
        0x9d3700ee, 0x9d370041, 0x6c36000c, 0x6c3600a3, 0xc3360052, 0xc33600fd, 0x213500c8,
        0x21350067, 0x8e350096, 0x8e350039, 0x7f340074, 0x7f3400db, 0xd034002a, 0xd0340085,
        0xf73b00a0, 0xf73b000f, 0x583b00fe, 0x583b0051, 0xa93a001c, 0xa93a00b3, 0x063a0042,
        0x063a00ed, 0xe43900d8, 0xe4390077, 0x4b390086, 0x4b390029, 0xba380064, 0xba3800cb,
        0x1538003a, 0x15380095, 0xd13f0050, 0xd13f00ff, 0x7e3f000e, 0x7e3f00a1, 0x8f3e00ec,
        0x8f3e0043, 0x203e00b2, 0x203e001d, 0xc23d0028, 0xc23d0087, 0x6d3d0076, 0x6d3d00d9,
        0x9c3c0094, 0x9c3c003b, 0x333c00ca, 0x333c0065,
    ],
    [
        0x00000000, 0x55440000, 0xaa880000, 0xffcc0000, 0x54110100, 0x01550100, 0xfe990100,
        0xabdd0100, 0xa8220200, 0xfd660200, 0x02aa0200, 0x57ee0200, 0xfc330300, 0xa9770300,
        0x56bb0300, 0x03ff0300, 0x50450400, 0x05010400, 0xfacd0400, 0xaf890400, 0x04540500,
        0x51100500, 0xaedc0500, 0xfb980500, 0xf8670600, 0xad230600, 0x52ef0600, 0x07ab0600,
        0xac760700, 0xf9320700, 0x06fe0700, 0x53ba0700, 0xa08a0800, 0xf5ce0800, 0x0a020800,
        0x5f460800, 0xf49b0900, 0xa1df0900, 0x5e130900, 0x0b570900, 0x08a80a00, 0x5dec0a00,
        0xa2200a00, 0xf7640a00, 0x5cb90b00, 0x09fd0b00, 0xf6310b00, 0xa3750b00, 0xf0cf0c00,
        0xa58b0c00, 0x5a470c00, 0x0f030c00, 0xa4de0d00, 0xf19a0d00, 0x0e560d00, 0x5b120d00,
        0x58ed0e00, 0x0da90e00, 0xf2650e00, 0xa7210e00, 0x0cfc0f00, 0x59b80f00, 0xa6740f00,
        0xf3300f00, 0x40151100, 0x15511100, 0xea9d1100, 0xbfd91100, 0x14041000, 0x41401000,
        0xbe8c1000, 0xebc81000, 0xe8371300, 0xbd731300, 0x42bf1300, 0x17fb1300, 0xbc261200,
        0xe9621200, 0x16ae1200, 0x43ea1200, 0x10501500, 0x45141500, 0xbad81500, 0xef9c1500,
        0x44411400, 0x11051400, 0xeec91400, 0xbb8d1400, 0xb8721700, 0xed361700, 0x12fa1700,
        0x47be1700, 0xec631600, 0xb9271600, 0x46eb1600, 0x13af1600, 0xe09f1900, 0xb5db1900,
        0x4a171900, 0x1f531900, 0xb48e1800, 0xe1ca1800, 0x1e061800, 0x4b421800, 0x48bd1b00,
        0x1df91b00, 0xe2351b00, 0xb7711b00, 0x1cac1a00, 0x49e81a00, 0xb6241a00, 0xe3601a00,
        0xb0da1d00, 0xe59e1d00, 0x1a521d00, 0x4f161d00, 0xe4cb1c00, 0xb18f1c00, 0x4e431c00,
        0x1b071c00, 0x18f81f00, 0x4dbc1f00, 0xb2701f00, 0xe7341f00, 0x4ce91e00, 0x19ad1e00,
        0xe6611e00, 0xb3251e00, 0x802a2200, 0xd56e2200, 0x2aa22200, 0x7fe62200, 0xd43b2300,
        0x817f2300, 0x7eb32300, 0x2bf72300, 0x28082000, 0x7d4c2000, 0x82802000, 0xd7c42000,
        0x7c192100, 0x295d2100, 0xd6912100, 0x83d52100, 0xd06f2600, 0x852b2600, 0x7ae72600,
        0x2fa32600, 0x847e2700, 0xd13a2700, 0x2ef62700, 0x7bb22700, 0x784d2400, 0x2d092400,
        0xd2c52400, 0x87812400, 0x2c5c2500, 0x79182500, 0x86d42500, 0xd3902500, 0x20a02a00,
        0x75e42a00, 0x8a282a00, 0xdf6c2a00, 0x74b12b00, 0x21f52b00, 0xde392b00, 0x8b7d2b00,
        0x88822800, 0xddc62800, 0x220a2800, 0x774e2800, 0xdc932900, 0x89d72900, 0x761b2900,
        0x235f2900, 0x70e52e00, 0x25a12e00, 0xda6d2e00, 0x8f292e00, 0x24f42f00, 0x71b02f00,
        0x8e7c2f00, 0xdb382f00, 0xd8c72c00, 0x8d832c00, 0x724f2c00, 0x270b2c00, 0x8cd62d00,
        0xd9922d00, 0x265e2d00, 0x731a2d00, 0xc03f3300, 0x957b3300, 0x6ab73300, 0x3ff33300,
        0x942e3200, 0xc16a3200, 0x3ea63200, 0x6be23200, 0x681d3100, 0x3d593100, 0xc2953100,
        0x97d13100, 0x3c0c3000, 0x69483000, 0x96843000, 0xc3c03000, 0x907a3700, 0xc53e3700,
        0x3af23700, 0x6fb63700, 0xc46b3600, 0x912f3600, 0x6ee33600, 0x3ba73600, 0x38583500,
        0x6d1c3500, 0x92d03500, 0xc7943500, 0x6c493400, 0x390d3400, 0xc6c13400, 0x93853400,
        0x60b53b00, 0x35f13b00, 0xca3d3b00, 0x9f793b00, 0x34a43a00, 0x61e03a00, 0x9e2c3a00,
        0xcb683a00, 0xc8973900, 0x9dd33900, 0x621f3900, 0x375b3900, 0x9c863800, 0xc9c23800,
        0x360e3800, 0x634a3800, 0x30f03f00, 0x65b43f00, 0x9a783f00, 0xcf3c3f00, 0x64e13e00,
        0x31a53e00, 0xce693e00, 0x9b2d3e00, 0x98d23d00, 0xcd963d00, 0x325a3d00, 0x671e3d00,
        0xccc33c00, 0x99873c00, 0x664b3c00, 0x330f3c00,
    ],
    [
        0x00000000, 0x00554400, 0x00aa8800, 0x00ffcc00, 0x00541101, 0x00015501, 0x00fe9901,
        0x00abdd01, 0x00a82202, 0x00fd6602, 0x0002aa02, 0x0057ee02, 0x00fc3303, 0x00a97703,
        0x0056bb03, 0x0003ff03, 0x00504504, 0x00050104, 0x00facd04, 0x00af8904, 0x00045405,
        0x00511005, 0x00aedc05, 0x00fb9805, 0x00f86706, 0x00ad2306, 0x0052ef06, 0x0007ab06,
        0x00ac7607, 0x00f93207, 0x0006fe07, 0x0053ba07, 0x00a08a08, 0x00f5ce08, 0x000a0208,
        0x005f4608, 0x00f49b09, 0x00a1df09, 0x005e1309, 0x000b5709, 0x0008a80a, 0x005dec0a,
        0x00a2200a, 0x00f7640a, 0x005cb90b, 0x0009fd0b, 0x00f6310b, 0x00a3750b, 0x00f0cf0c,
        0x00a58b0c, 0x005a470c, 0x000f030c, 0x00a4de0d, 0x00f19a0d, 0x000e560d, 0x005b120d,
        0x0058ed0e, 0x000da90e, 0x00f2650e, 0x00a7210e, 0x000cfc0f, 0x0059b80f, 0x00a6740f,
        0x00f3300f, 0x00401511, 0x00155111, 0x00ea9d11, 0x00bfd911, 0x00140410, 0x00414010,
        0x00be8c10, 0x00ebc810, 0x00e83713, 0x00bd7313, 0x0042bf13, 0x0017fb13, 0x00bc2612,
        0x00e96212, 0x0016ae12, 0x0043ea12, 0x00105015, 0x00451415, 0x00bad815, 0x00ef9c15,
        0x00444114, 0x00110514, 0x00eec914, 0x00bb8d14, 0x00b87217, 0x00ed3617, 0x0012fa17,
        0x0047be17, 0x00ec6316, 0x00b92716, 0x0046eb16, 0x0013af16, 0x00e09f19, 0x00b5db19,
        0x004a1719, 0x001f5319, 0x00b48e18, 0x00e1ca18, 0x001e0618, 0x004b4218, 0x0048bd1b,
        0x001df91b, 0x00e2351b, 0x00b7711b, 0x001cac1a, 0x0049e81a, 0x00b6241a, 0x00e3601a,
        0x00b0da1d, 0x00e59e1d, 0x001a521d, 0x004f161d, 0x00e4cb1c, 0x00b18f1c, 0x004e431c,
        0x001b071c, 0x0018f81f, 0x004dbc1f, 0x00b2701f, 0x00e7341f, 0x004ce91e, 0x0019ad1e,
        0x00e6611e, 0x00b3251e, 0x00802a22, 0x00d56e22, 0x002aa222, 0x007fe622, 0x00d43b23,
        0x00817f23, 0x007eb323, 0x002bf723, 0x00280820, 0x007d4c20, 0x00828020, 0x00d7c420,
        0x007c1921, 0x00295d21, 0x00d69121, 0x0083d521, 0x00d06f26, 0x00852b26, 0x007ae726,
        0x002fa326, 0x00847e27, 0x00d13a27, 0x002ef627, 0x007bb227, 0x00784d24, 0x002d0924,
        0x00d2c524, 0x00878124, 0x002c5c25, 0x00791825, 0x0086d425, 0x00d39025, 0x0020a02a,
        0x0075e42a, 0x008a282a, 0x00df6c2a, 0x0074b12b, 0x0021f52b, 0x00de392b, 0x008b7d2b,
        0x00888228, 0x00ddc628, 0x00220a28, 0x00774e28, 0x00dc9329, 0x0089d729, 0x00761b29,
        0x00235f29, 0x0070e52e, 0x0025a12e, 0x00da6d2e, 0x008f292e, 0x0024f42f, 0x0071b02f,
        0x008e7c2f, 0x00db382f, 0x00d8c72c, 0x008d832c, 0x00724f2c, 0x00270b2c, 0x008cd62d,
        0x00d9922d, 0x00265e2d, 0x00731a2d, 0x00c03f33, 0x00957b33, 0x006ab733, 0x003ff333,
        0x00942e32, 0x00c16a32, 0x003ea632, 0x006be232, 0x00681d31, 0x003d5931, 0x00c29531,
        0x0097d131, 0x003c0c30, 0x00694830, 0x00968430, 0x00c3c030, 0x00907a37, 0x00c53e37,
        0x003af237, 0x006fb637, 0x00c46b36, 0x00912f36, 0x006ee336, 0x003ba736, 0x00385835,
        0x006d1c35, 0x0092d035, 0x00c79435, 0x006c4934, 0x00390d34, 0x00c6c134, 0x00938534,
        0x0060b53b, 0x0035f13b, 0x00ca3d3b, 0x009f793b, 0x0034a43a, 0x0061e03a, 0x009e2c3a,
        0x00cb683a, 0x00c89739, 0x009dd339, 0x00621f39, 0x00375b39, 0x009c8638, 0x00c9c238,
        0x00360e38, 0x00634a38, 0x0030f03f, 0x0065b43f, 0x009a783f, 0x00cf3c3f, 0x0064e13e,
        0x0031a53e, 0x00ce693e, 0x009b2d3e, 0x0098d23d, 0x00cd963d, 0x00325a3d, 0x00671e3d,
        0x00ccc33c, 0x0099873c, 0x00664b3c, 0x00330f3c,
    ],
    [
        0x00000000, 0x00005544, 0x0000aa88, 0x0000ffcc, 0xaf005411, 0xaf000155, 0xaf00fe99,
        0xaf00abdd, 0x5e01a822, 0x5e01fd66, 0x5e0102aa, 0x5e0157ee, 0xf101fc33, 0xf101a977,
        0xf10156bb, 0xf10103ff, 0xbc025045, 0xbc020501, 0xbc02facd, 0xbc02af89, 0x13020454,
        0x13025110, 0x1302aedc, 0x1302fb98, 0xe203f867, 0xe203ad23, 0xe20352ef, 0xe20307ab,
        0x4d03ac76, 0x4d03f932, 0x4d0306fe, 0x4d0353ba, 0x7805a08a, 0x7805f5ce, 0x78050a02,
        0x78055f46, 0xd705f49b, 0xd705a1df, 0xd7055e13, 0xd7050b57, 0x260408a8, 0x26045dec,
        0x2604a220, 0x2604f764, 0x89045cb9, 0x890409fd, 0x8904f631, 0x8904a375, 0xc407f0cf,
        0xc407a58b, 0xc4075a47, 0xc4070f03, 0x6b07a4de, 0x6b07f19a, 0x6b070e56, 0x6b075b12,
        0x9a0658ed, 0x9a060da9, 0x9a06f265, 0x9a06a721, 0x35060cfc, 0x350659b8, 0x3506a674,
        0x3506f330, 0x5f0a4015, 0x5f0a1551, 0x5f0aea9d, 0x5f0abfd9, 0xf00a1404, 0xf00a4140,
        0xf00abe8c, 0xf00aebc8, 0x010be837, 0x010bbd73, 0x010b42bf, 0x010b17fb, 0xae0bbc26,
        0xae0be962, 0xae0b16ae, 0xae0b43ea, 0xe3081050, 0xe3084514, 0xe308bad8, 0xe308ef9c,
        0x4c084441, 0x4c081105, 0x4c08eec9, 0x4c08bb8d, 0xbd09b872, 0xbd09ed36, 0xbd0912fa,
        0xbd0947be, 0x1209ec63, 0x1209b927, 0x120946eb, 0x120913af, 0x270fe09f, 0x270fb5db,
        0x270f4a17, 0x270f1f53, 0x880fb48e, 0x880fe1ca, 0x880f1e06, 0x880f4b42, 0x790e48bd,
        0x790e1df9, 0x790ee235, 0x790eb771, 0xd60e1cac, 0xd60e49e8, 0xd60eb624, 0xd60ee360,
        0x9b0db0da, 0x9b0de59e, 0x9b0d1a52, 0x9b0d4f16, 0x340de4cb, 0x340db18f, 0x340d4e43,
        0x340d1b07, 0xc50c18f8, 0xc50c4dbc, 0xc50cb270, 0xc50ce734, 0x6a0c4ce9, 0x6a0c19ad,
        0x6a0ce661, 0x6a0cb325, 0xbe14802a, 0xbe14d56e, 0xbe142aa2, 0xbe147fe6, 0x1114d43b,
        0x1114817f, 0x11147eb3, 0x11142bf7, 0xe0152808, 0xe0157d4c, 0xe0158280, 0xe015d7c4,
        0x4f157c19, 0x4f15295d, 0x4f15d691, 0x4f1583d5, 0x0216d06f, 0x0216852b, 0x02167ae7,
        0x02162fa3, 0xad16847e, 0xad16d13a, 0xad162ef6, 0xad167bb2, 0x5c17784d, 0x5c172d09,
        0x5c17d2c5, 0x5c178781, 0xf3172c5c, 0xf3177918, 0xf31786d4, 0xf317d390, 0xc61120a0,
        0xc61175e4, 0xc6118a28, 0xc611df6c, 0x691174b1, 0x691121f5, 0x6911de39, 0x69118b7d,
        0x98108882, 0x9810ddc6, 0x9810220a, 0x9810774e, 0x3710dc93, 0x371089d7, 0x3710761b,
        0x3710235f, 0x7a1370e5, 0x7a1325a1, 0x7a13da6d, 0x7a138f29, 0xd51324f4, 0xd51371b0,
        0xd5138e7c, 0xd513db38, 0x2412d8c7, 0x24128d83, 0x2412724f, 0x2412270b, 0x8b128cd6,
        0x8b12d992, 0x8b12265e, 0x8b12731a, 0xe11ec03f, 0xe11e957b, 0xe11e6ab7, 0xe11e3ff3,
        0x4e1e942e, 0x4e1ec16a, 0x4e1e3ea6, 0x4e1e6be2, 0xbf1f681d, 0xbf1f3d59, 0xbf1fc295,
        0xbf1f97d1, 0x101f3c0c, 0x101f6948, 0x101f9684, 0x101fc3c0, 0x5d1c907a, 0x5d1cc53e,
        0x5d1c3af2, 0x5d1c6fb6, 0xf21cc46b, 0xf21c912f, 0xf21c6ee3, 0xf21c3ba7, 0x031d3858,
        0x031d6d1c, 0x031d92d0, 0x031dc794, 0xac1d6c49, 0xac1d390d, 0xac1dc6c1, 0xac1d9385,
        0x991b60b5, 0x991b35f1, 0x991bca3d, 0x991b9f79, 0x361b34a4, 0x361b61e0, 0x361b9e2c,
        0x361bcb68, 0xc71ac897, 0xc71a9dd3, 0xc71a621f, 0xc71a375b, 0x681a9c86, 0x681ac9c2,
        0x681a360e, 0x681a634a, 0x251930f0, 0x251965b4, 0x25199a78, 0x2519cf3c, 0x8a1964e1,
        0x8a1931a5, 0x8a19ce69, 0x8a199b2d, 0x7b1898d2, 0x7b18cd96, 0x7b18325a, 0x7b18671e,
        0xd418ccc3, 0xd4189987, 0xd418664b, 0xd418330f,
    ],
    [
        0x00000000, 0x7c290055, 0xf85200aa, 0x847b00ff, 0x5fa50054, 0x238c0001, 0xa7f700fe,
        0xdbde00ab, 0xbe4a01a8, 0xc26301fd, 0x46180102, 0x3a310157, 0xe1ef01fc, 0x9dc601a9,
        0x19bd0156, 0x65940103, 0xd3950250, 0xafbc0205, 0x2bc702fa, 0x57ee02af, 0x8c300204,
        0xf0190251, 0x746202ae, 0x084b02fb, 0x6ddf03f8, 0x11f603ad, 0x958d0352, 0xe9a40307,
        0x327a03ac, 0x4e5303f9, 0xca280306, 0xb6010353, 0xa62b05a0, 0xda0205f5, 0x5e79050a,
        0x2250055f, 0xf98e05f4, 0x85a705a1, 0x01dc055e, 0x7df5050b, 0x18610408, 0x6448045d,
        0xe03304a2, 0x9c1a04f7, 0x47c4045c, 0x3bed0409, 0xbf9604f6, 0xc3bf04a3, 0x75be07f0,
        0x099707a5, 0x8dec075a, 0xf1c5070f, 0x2a1b07a4, 0x563207f1, 0xd249070e, 0xae60075b,
        0xcbf40658, 0xb7dd060d, 0x33a606f2, 0x4f8f06a7, 0x9451060c, 0xe8780659, 0x6c0306a6,
        0x102a06f3, 0xe3570a40, 0x9f7e0a15, 0x1b050aea, 0x672c0abf, 0xbcf20a14, 0xc0db0a41,
        0x44a00abe, 0x38890aeb, 0x5d1d0be8, 0x21340bbd, 0xa54f0b42, 0xd9660b17, 0x02b80bbc,
        0x7e910be9, 0xfaea0b16, 0x86c30b43, 0x30c20810, 0x4ceb0845, 0xc89008ba, 0xb4b908ef,
        0x6f670844, 0x134e0811, 0x973508ee, 0xeb1c08bb, 0x8e8809b8, 0xf2a109ed, 0x76da0912,
        0x0af30947, 0xd12d09ec, 0xad0409b9, 0x297f0946, 0x55560913, 0x457c0fe0, 0x39550fb5,
        0xbd2e0f4a, 0xc1070f1f, 0x1ad90fb4, 0x66f00fe1, 0xe28b0f1e, 0x9ea20f4b, 0xfb360e48,
        0x871f0e1d, 0x03640ee2, 0x7f4d0eb7, 0xa4930e1c, 0xd8ba0e49, 0x5cc10eb6, 0x20e80ee3,
        0x96e90db0, 0xeac00de5, 0x6ebb0d1a, 0x12920d4f, 0xc94c0de4, 0xb5650db1, 0x311e0d4e,
        0x4d370d1b, 0x28a30c18, 0x548a0c4d, 0xd0f10cb2, 0xacd80ce7, 0x77060c4c, 0x0b2f0c19,
        0x8f540ce6, 0xf37d0cb3, 0xc6af1480, 0xba8614d5, 0x3efd142a, 0x42d4147f, 0x990a14d4,
        0xe5231481, 0x6158147e, 0x1d71142b, 0x78e51528, 0x04cc157d, 0x80b71582, 0xfc9e15d7,
        0x2740157c, 0x5b691529, 0xdf1215d6, 0xa33b1583, 0x153a16d0, 0x69131685, 0xed68167a,
        0x9141162f, 0x4a9f1684, 0x36b616d1, 0xb2cd162e, 0xcee4167b, 0xab701778, 0xd759172d,
        0x532217d2, 0x2f0b1787, 0xf4d5172c, 0x88fc1779, 0x0c871786, 0x70ae17d3, 0x60841120,
        0x1cad1175, 0x98d6118a, 0xe4ff11df, 0x3f211174, 0x43081121, 0xc77311de, 0xbb5a118b,
        0xdece1088, 0xa2e710dd, 0x269c1022, 0x5ab51077, 0x816b10dc, 0xfd421089, 0x79391076,
        0x05101023, 0xb3111370, 0xcf381325, 0x4b4313da, 0x376a138f, 0xecb41324, 0x909d1371,
        0x14e6138e, 0x68cf13db, 0x0d5b12d8, 0x7172128d, 0xf5091272, 0x89201227, 0x52fe128c,
        0x2ed712d9, 0xaaac1226, 0xd6851273, 0x25f81ec0, 0x59d11e95, 0xddaa1e6a, 0xa1831e3f,
        0x7a5d1e94, 0x06741ec1, 0x820f1e3e, 0xfe261e6b, 0x9bb21f68, 0xe79b1f3d, 0x63e01fc2,
        0x1fc91f97, 0xc4171f3c, 0xb83e1f69, 0x3c451f96, 0x406c1fc3, 0xf66d1c90, 0x8a441cc5,
        0x0e3f1c3a, 0x72161c6f, 0xa9c81cc4, 0xd5e11c91, 0x519a1c6e, 0x2db31c3b, 0x48271d38,
        0x340e1d6d, 0xb0751d92, 0xcc5c1dc7, 0x17821d6c, 0x6bab1d39, 0xefd01dc6, 0x93f91d93,
        0x83d31b60, 0xfffa1b35, 0x7b811bca, 0x07a81b9f, 0xdc761b34, 0xa05f1b61, 0x24241b9e,
        0x580d1bcb, 0x3d991ac8, 0x41b01a9d, 0xc5cb1a62, 0xb9e21a37, 0x623c1a9c, 0x1e151ac9,
        0x9a6e1a36, 0xe6471a63, 0x50461930, 0x2c6f1965, 0xa814199a, 0xd43d19cf, 0x0fe31964,
        0x73ca1931, 0xf7b119ce, 0x8b98199b, 0xee0c1898, 0x922518cd, 0x165e1832, 0x6a771867,
        0xb1a918cc, 0xcd801899, 0x49fb1866, 0x35d21833,
    ],
];
