#![deny(unsafe_code)]
#![warn(missing_debug_implementations, unused_import_braces)]

use std::io::stdin;

use structopt::StructOpt;

use crate::dag::Dag;
use crate::opt::Opt;

mod dag;
mod opt;

fn main() {
    let mut args: Opt = Opt::from_args();
    let input_string = get_input_string(&mut args);
    let mut dag = Dag::parse_str(input_string).expect("Could not parse input");
    if !args.no_verify {
        dag.verify().expect("Given DAG is invalid");
    }
    if let Some(strips) = args.strip {
        for strip in strips {
            dag.remove_node(strip);
        }
    }
    println!("{}", dag.print_alphabetically());
}

fn get_input_string(args: &mut Opt) -> String {
    if let Some(in_val) = args.in_.take() {
        return in_val;
    }
    let mut buffer = String::new();
    stdin()
        .read_line(&mut buffer)
        .expect("Could not read from stdin");
    buffer
}
