# buzzec-strip-dag-node
This command line application strips nodes from a given DAG. The dag is given in the format of `[x-y],*` where `x` and `y` are any utf-8 strings without whitespace, `-`, or `,`.

If no strip flag is added then the command will remove duplicate edges, verify the DAG, and alphabetize.
### Strip behavior
When a node is removed, all it's children are added to all it's parents.

## Help output:
```
buzzec-strip-dag-node 0.1.0
Strips out a dag node. Defaults to stdin, use --in to input a command line argument. If skip and no-verify are not
present will verify and format the given DAG.

USAGE:
    buzzec-strip-dag-node [FLAGS] [OPTIONS]

FLAGS:
    -h, --help         Prints help information
        --no-verify    Disables verification. No guarantees on the output if given a bad DST
    -V, --version      Prints version information

OPTIONS:
    -i, --in <in>             Optional argument for evaluating from a command line argument rather than stdin
    -s, --strip <strip>...    Strips a given node from the DAG. If the node is not present the DAG will not change
```

## Installation
Install with:
```shell
cargo install buzzec-strip-dag-node
```

To update use:
```shell
cargo install buzzec-strip-dag-node --force
```

## Example

```shell
buzzec-strip-dag-node --in a-b,b-c,c-d --strip c
> a-b,b-d
```
