# Contributor Covenant Code of Conduct

## Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our
project and our community a harassment-free experience for everyone,
regardless of age (see addendum), body size, disability, ethnicity,
gender identity and expression, level of experience, nationality,
personal appearance, race, religion, or sexual identity and
orientation.

## Our Standards

Examples of behavior that contributes to creating a positive
environment include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of unnecessary sexualized language or imagery and unwelcome
  sexual attention or advances
* Trolling, insulting/derogatory comments, and personal or political
  attacks
* Public or private harassment
* Publishing others' private information, such as a physical or
  electronic address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in
  a professional setting

## Our Responsibilities

Project maintainers are responsible for clarifying the standards of
acceptable behavior and are expected to take appropriate and fair
corrective action in response to any instances of unacceptable
behavior.

Project maintainers have the right and responsibility to remove, edit,
or reject comments, commits, code, wiki edits, issues, and other
contributions that are not aligned to this Code of Conduct, or to ban
temporarily or permanently any contributor for other behaviors that
they deem inappropriate, threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within project spaces and in public
spaces when an individual is representing the project or its
community. Examples of representing a project or community include
using an official project e-mail address, posting via an official
social media account, or acting as an appointed representative at an
online or offline event. Representation of a project may be further
defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior
May be reported by contacting the project team at
admin@metafetish.com. All complaints will be reviewed and investigated
and will result in a response that is deemed necessary and appropriate
to the circumstances. The project team is obligated to maintain
confidentiality with regard to the reporter of an incident. Further
details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct
in good faith may face temporary or permanent repercussions as
determined by other members of the project's leadership.

## Addendum for Metafetish Related Projects

While the project team seeks to welcome all contributors and
participants, due to the sexual nature of projects related to the
Metafetish organization, all contributors and participants should be
of provable legal age.

Working on projects related to the Metafetish organization may at
times require sexual situations to be discussed in project forums, be
they message boards, social media, chat systems, or other means not
listed here. These discussions should pertain only to usage of the
projects they involve, and should only include required details to
express some sort of issue or feature request. If the discussion
includes material that others may find objectionable for some reason,
the discussions should be prepended with content warnings.

While usage stories about projects are appreciated, unless they
express some issue with specific usage, we ask that they be kept to
outside forums, where they would be appropriate. There are many
sub-reddits, fetlife groups, and forum instances available for a
multitude of interests where usage can be discussed. If a proper venue
is not known, please contact project maintainers, as they may be able
to point to one.

If any contributor or project member feels that these considerations
have not been met, they should contact the project maintainers at
admin@metafetish.com.

# Moderation

These are the policies for upholding our community's standards of
conduct. If you feel that a thread needs moderation, please contact
the [Metafetish moderation team](mailto:admin@metafetish.com).

1. Remarks that violate the standard of conduct, including hateful,
   hurtful, oppressive, or exclusionary remarks, are not allowed.
   (Cursing is allowed, but never targeting another user, and never in
   a hateful manner.)
2. Remarks that moderators find inappropriate, whether listed in the
   code of conduct or not, are also not allowed.
3. Moderators will first respond to such remarks with a warning.
4. If the warning is unheeded, the user will be "kicked," i.e., kicked
   out of the communication channel to cool off.
5. If the user comes back and continues to make trouble, they will be
   banned, i.e., indefinitely excluded.
6. Moderators may choose at their discretion to un-ban the user if it
   was a first offense and they offer the offended party a genuine
   apology.
7. If a moderator bans someone and you think it was unjustified,
   please take it up with that moderator, or with a different
   moderator, **in private**. Complaints about bans in-channel are not
   allowed.
8. Moderators are held to a higher standard than other community
   members. If a moderator creates an inappropriate situation, they
   should expect less leeway than others.

In this community we strive to go the extra step to look out for each
other. Don't just aim to be technically unimpeachable, try to be your
best self. In particular, avoid flirting with offensive or sensitive
issues, particularly if they're off-topic; this all too often leads to
unnecessary fights, hurt feelings, and damaged trust; worse, it can
drive people away from the community entirely.

And if someone takes issue with something you said or did, resist the
urge to be defensive. Just stop doing what it was they complained
about and apologize. Even if you feel you were misinterpreted or
unfairly accused, chances are good there was something you could've
communicated better — remember that it's your responsibility to make
your fellow community members comfortable. Everyone wants to get along
and we are all here first and foremost because we want to talk about
cool technology. You will find that people will be eager to assume
good intent and forgive as long as you earn their trust.

The enforcement policies listed above apply to all official Metafetish
venues; including all Slack channels and their related bridged IRC
channels, repositories and their respective issue trackers/wikis/etc,
message boards, and social media networks. For other projects adopting
this Code of Conduct, please contact the maintainers of those projects
for enforcement. If you wish to use this code of conduct for your own
project, consider explicitly mentioning your moderation policy or
making a copy with your own moderation policy so as to avoid
confusion.

# Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at [http://contributor-covenant.org/version/1/4][version]

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/

The Moderation portion of this Code of Conduct is adapted from
the
[Rust Language Code of Conduct](https://www.rust-lang.org/en-US/conduct.html).
