#[macro_use]
extern crate log;

extern crate core;

#[macro_use]
extern crate pest_derive;

mod render;
mod parsers;
mod models;

#[cfg(test)]
mod tests {
    use std::time::Instant;
    use stretch::geometry::Size;
    use stretch::number::Number;
    use crate::models::{ChildUpdate, InsertInstruction, MyElement, MyNode, MyNodeChange, MyText, UpdateInstruction};
    use crate::parsers::css::parse_css;
    use crate::render::Document;

    extern crate env_logger;

    #[test]
    fn test_something() {

        let css = "div {} cell { background-color: beige; background-image: none; }";
        let css = "div {} cell { background-color: beige; }";
        let stylesheet = parse_css(include_str!("style.css")).unwrap();
        println!("st {:?}", stylesheet);

        let mut document = Document::new(1024.0, 256.0, stylesheet);
        let update = UpdateInstruction {
            children: vec![
                ChildUpdate::Insert(InsertInstruction {
                    node: MyElement::with_children(".row", vec![
                        MyElement::with_text(".cell", "1/3"),
                        MyElement::with_text(".cell", include_str!("lorem.txt")),
                        MyElement::with_text(".cell", "3/3"),
                    ])
                }),
            ]
        };
        let change = MyNodeChange::Update(update);
        document.apply(document.root(), change);
        document.calculate_styles();
        document.layout().unwrap();
        document.paint_to(1024, 256, "test_something");
    }
}
