use crate::codec::BubbleCodec;
use crate::dispatcher::Dispatcher;
use crate::params::Params;
use crate::session::BubbleSessionActor;
use actix::{Actor, Addr, Context, Handler, Message, StreamHandler};
use std::net;
use std::sync::Arc;
use tokio::net::TcpStream;
use tokio_util::codec::FramedRead;

pub(crate) struct Server {
    pub(crate) params: Arc<Params>,
    pub(crate) waxs_dispatcher: Addr<Dispatcher>,
    pub(crate) saxs_dispatcher: Addr<Dispatcher>,
}

impl Actor for Server {
    type Context = Context<Self>;
}

#[derive(Message)]
#[rtype(result = "()")]
pub struct TcpConnect(pub TcpStream, pub net::SocketAddr);

impl Handler<TcpConnect> for Server {
    type Result = ();

    fn handle(&mut self, msg: TcpConnect, _: &mut Context<Self>) {
        BubbleSessionActor::create(move |ctx| {
            let (r, w) = tokio::io::split(msg.0);
            BubbleSessionActor::add_stream(FramedRead::new(r, BubbleCodec), ctx);
            BubbleSessionActor::new(
                self.params.clone(),
                msg.1.to_string(),
                self.waxs_dispatcher.clone(),
                self.saxs_dispatcher.clone(),
                actix::io::FramedWrite::new(w, BubbleCodec, ctx),
            )
        });
    }
}
