use anyhow::Result;
use vergen::{vergen, Config, ShaKind, TimeZone, TimestampKind};

fn main() -> Result<()> {
    let mut config = Config::default();
    *config.build_mut().kind_mut() = TimestampKind::All;
    *config.build_mut().timezone_mut() = TimeZone::Local;
    *config.git_mut().sha_kind_mut() = ShaKind::Normal;
    *config.git_mut().commit_timestamp_mut() = true;
    *config.git_mut().commit_timestamp_kind_mut() = TimestampKind::All;
    vergen(config)
}
