//! # btui
//! ## beautiful text user interfaces
//!
//! with btui you can create beautiful text user interfaces for the terminal.
//! To get started add `btui` as a dependency to your project:
//! ```toml
//! btui = "0.6.7"
//! ```
//!
//! # Examples
//! This is a basic coloring example which will output hello world in red:
//! ```
//! use btui::effects::{Color, Special};
//! use btui::print::{fg, sp};
//!
//! println!("{}Hello World!{}", fg(Color::Red), sp(Special::Reset));
//! ```

#[cfg(feature = "core")]
mod ft;

#[cfg(feature = "linux")]
/// module containing stuff for basic linux based print operations
pub mod linux;

#[cfg(feature = "pbar")]
/// module containing a progressbar
pub mod pbar;

pub use linux::Terminal;

pub use ft::{effects, print};

#[cfg(test)]
mod tests {
    use crate::effects::Color::Black;
    use crate::print::fg;
    use crate::Terminal;
    #[test]
    fn correct_color() {
        assert_eq!(String::from("\x1b[30m"), fg(Black));
    }
    #[test]
    fn printing_with_terminal() {
        let t: Terminal = Terminal::default();
        match t.println("Hello World!") {
            Ok(_) => (),
            Err(e) => panic!("{}", e),

        }
    }
}
