/// module containig different console actions for linux
pub mod console {
    /// enum for display control
    pub enum DisplayControl {
        /// clear the display (doesnt move cursor)
        Clear,
        /// clear the current line the cursor is on (doesn't move the cursor)
        ClearLine,
        /// reset the display
        Reset,
    }

    /// enum for cursor control
    pub enum CursorControl {
        /// move cursor left specified amount of columns
        Left(usize),
        /// move cursor right specified amount of columns
        Right(usize),
        /// move cursor to specified column
        Col(usize),
        /// move cursor specified amount of rows up
        Up(usize),
        /// move cursor specified amount of rows down
        Down(usize),
        /// move cursor to position(col, row)
        Pos(usize, usize),
    }

    /// function to perform an action for display controlling (using a `DisplayControl` enum)
    /// # Arguments
    /// *`sequence`: sequence to perform
    pub fn dc_sequence(sequence: DisplayControl) {
        let seq: String = match sequence {
            DisplayControl::Clear => String::from("\x1b[2J"),
            DisplayControl::ClearLine => String::from("\x1b[2K"),
            DisplayControl::Reset => String::from("\x1bc"),
        };

        print!("{}", seq);
    }
    /// function to perform an action for cursor controlling (using a `CursorControl` enum)
    /// # Arguments
    /// *`sequence`: the sequence to perform
    pub fn cc_sequence(sequence: CursorControl) {
        let seq: String = match sequence {
            CursorControl::Left(n) => format!("\x1b[{}D", n),
            CursorControl::Right(n) => format!("\x1b[{}C", n),
            CursorControl::Col(n) => format!("\x1b[{}G", n),
            CursorControl::Up(n) => format!("\x1b[{}A", n),
            CursorControl::Down(n) => format!("\x1b[{}B", n),
            CursorControl::Pos(x, y) => format!("\x1b[{};{}H", x, y),
        };

        print!("{}", seq);
    }
}
