//! # btui
//! ## beautiful text user intefaces
//!
//! with btui you can create beautiful text user interfaces for the terminal.
//! To get started add `btui` as a dependency to your project:
//! ```toml
//! btui = "0.4.4"
//! ```

#[cfg(feature = "core")]
mod ft;
#[cfg(feature = "linux")]
pub mod linux;
pub use ft::{effects, print};

#[cfg(test)]
mod tests {
    use crate::effects::Color::Black;
    use crate::print::fg;
    #[test]
    fn correct_color() {
        assert_eq!(String::from("\x1b[30m"), fg(Black));
    }
}
