pub mod colors {
    /// enum to represent colored text
    pub enum ColoredText {
        Black(String),
        Red(String),
        Green(String),
        Yellow(String),
        Blue(String),
        Magenta(String),
        Cyan(String),
        White(String),
    }

    /// enum to represent a background color
    pub enum ColoredBg {
        Black,
        Red,
        Green,
        Yellow,
        Blue,
        Magenta,
        Cyan,
        White,
    }
}

pub mod formatting {
    use crate::ft::colors::*;
    use crate::Variant;

    /// format text with colors to be printed
    ///
    /// # Arguments
    ///
    /// * `text`: the text in form of a vector of either colored text or colored background
    ///
    /// # Returns
    ///
    /// the formatted text with escape characters to be printed to the terminal
    pub fn format(text: Vec<Variant<ColoredText, ColoredBg>>) -> String {
        let mut out: String = String::new();

        for elm in text {
            let add: String = match elm {
                Variant::One(n) => match n {
                    ColoredText::Black(p) => format!("\x1b[30m{}", p),
                    ColoredText::Red(p) => format!("\x1b[31m{}", p),
                    ColoredText::Green(p) => format!("\x1b[32m{}", p),
                    ColoredText::Yellow(p) => format!("\x1b[33m{}", p),
                    ColoredText::Blue(p) => format!("\x1b[34m{}", p),
                    ColoredText::Magenta(p) => format!("\x1b[35m{}", p),
                    ColoredText::Cyan(p) => format!("\x1b[36m{}", p),
                    ColoredText::White(p) => format!("\x1b[37m{}", p),
                },
                Variant::Two(n) => match n {
                    ColoredBg::Black => String::from("\x1b[40m"),
                    ColoredBg::Red => String::from("\x1b[41m"),
                    ColoredBg::Green => String::from("\x1b[42m"),
                    ColoredBg::Yellow => String::from("\x1b[43m"),
                    ColoredBg::Blue => String::from("\x1b[44m"),
                    ColoredBg::Magenta => String::from("\x1b[45m"),
                    ColoredBg::Cyan => String::from("\x1b[46m"),
                    ColoredBg::White => String::from("\x1b[47m"),
                },
            };
            out.push_str(add.as_str());
        }

        out.push_str("\x1b[0m");
        out
    }
}
