pub mod colors {
    /// enum to represent colored text
    pub enum ColoredText {
        Black(String),
        Red(String),
        Green(String),
        Yellow(String),
        Blue(String),
        Magenta(String),
        Cyan(String),
        White(String),
    }

    /// enum to represent a background color
    pub enum ColoredBg {
        Black,
        Red,
        Green,
        Yellow,
        Blue,
        Magenta,
        Cyan,
        White,
    }
}

pub mod formatting {
    use crate::Variant;
    use crate::ft::colors::*;

    /// format text with colors to be printed
    ///
    /// # Arguments
    ///
    /// * `text`: the text in form of a vector of either colored text or colored background
    ///
    /// # Returns
    ///
    /// the formatted text with escape characters to be printed to the terminal
    pub fn format(text: Vec<Variant<ColoredText, ColoredBg>>) -> String {
        let mut out: String = String::new();

        for elm in text {
            let add: String = match elm {
                Variant::One(n) => {
                    match n {
                        ColoredText::Black(p) => format!("\033[30m{}", p),
                        ColoredText::Red(p) => format!("\033[31m{}", p),
                        ColoredText::Green(p) => format!("\033[32m{}", p),
                        ColoredText::Yellow(p) => format!("\033[33m{}", p),
                        ColoredText::Blue(p) => format!("\033[34m{}", p),
                        ColoredText::Magenta(p) => format!("\033[35m{}", p),
                        ColoredText::Cyan(p) => format!("\033[36m{}", p),
                        ColoredText::White(p) => format!("\033[37m{}", p),
                    }
                }
                Variant::Two(n) => {
                    match n {
                        ColoredBg::Black => String::from("\033[40m"),
                        ColoredBg::Red => String::from("\033[41m"),
                        ColoredBg::Green => String::from("\033[42m"),
                        ColoredBg::Yellow => String::from("\033[43m"),
                        ColoredBg::Blue => String::from("\033[44m"),
                        ColoredBg::Magenta => String::from("\033[45m"),
                        ColoredBg::Cyan => String::from("\033[46m"),
                        ColoredBg::White => String::from("\033[47m"),
                    }
                },
            };
            out.push_str(add.as_str());
        }

        out
    }
}
