CREATE TABLE IF NOT EXISTS "clips" (
    "uuid" UUID PRIMARY KEY,
    "created_on" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "last_played" TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
    "plays" BIGINT NOT NULL DEFAULT 0,
    "phrase" TEXT NOT NULL,
    "description" TEXT NOT NULL,
    "audio_file" TEXT NOT NULL
);

CREATE TABLE IF NOT EXISTS "clip_phrases" (
    "uuid" UUID PRIMARY KEY,
    "clip" UUID NOT NULL,
    "phrase" TEXT NOT NULL,
    FOREIGN KEY (clip) REFERENCES clips(uuid) ON DELETE CASCADE ON UPDATE NO ACTION
);
