// Copyright (c) 2019, 2021 FaultyRAM
//
// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option. This file may not be copied,
// modified, or distributed except according to those terms.

const TRIBUNAL_BSA: &[(&str, u32, u32)] = &[
    (r"meshes\i\act_sotha_powertubes.nif", 0x0123_040B, 0x16CA_84D1),
    (r"meshes\i\act_sotha_mach_door.nif", 0x0123_040B, 0x2E25_90CC),
    (r"meshes\i\act_sotha_oilbridge.nif", 0x0123_040B, 0x3557_4810),
    (r"meshes\i\act_sotha_collide00.nif", 0x0123_040B, 0x6C67_042D),
    (r"meshes\i\act_sotha_tenderizer.nif", 0x0123_040B, 0xBD9F_AB79),
    (r"meshes\i\act_sotha_clockwork.nif", 0x0123_040B, 0xD13D_DD1D),
    (r"meshes\i\act_sotha_long_gear00.nif", 0x0123_0463, 0x14BA_22FB),
    (r"meshes\i\act_sotha_long_gear02.nif", 0x0123_0463, 0x3AE2_5C29),
    (r"meshes\i\act_sotha_long_gear03.nif", 0x0123_0463, 0xC806_4A71),
    (r"meshes\i\act_sotha_long_gear01.nif", 0x0123_0463, 0xDF2A_7798),
    (r"meshes\i\in_dwe_corr2_00_exp.nif", 0x0124_0830, 0x2CCD_F01F),
    (r"meshes\i\in_dwe_hall_enter_00.nif", 0x0124_0830, 0x72B9_8317),
    (r"meshes\i\in_dwe_archway00_exp.nif", 0x0124_0830, 0x8F02_0EE3),
    (r"meshes\i\in_dwe_turbine00_exp.nif", 0x0124_0830, 0xA6CB_280A),
    (r"meshes\i\in_dwe_pillar00_exp.nif", 0x0124_0830, 0xC5AC_9E13),
    (r"meshes\i\in_dwe_archway00_end.nif", 0x0124_0830, 0xE7C5_99D3),
    (r"meshes\i\in_dwe_utilcorr00_exp.nif", 0x0124_0845, 0x9552_CB8B),
    (r"meshes\i\in_dwe_utilcorr01_exp.nif", 0x0124_0845, 0xC21D_2031),
    (r"meshes\i\in_dwe_weathmach00_exp.nif", 0x0124_0847, 0xB751_588C),
    (r"meshes\i\in_dwe_hall_wall00_bk.nif", 0x0124_0858, 0x5BCA_7ED1),
    (r"meshes\i\in_dwe_hall_wall00_exp.nif", 0x0124_0858, 0x715F_B35E),
    (r"meshes\i\contain_rock_apy_09.nif", 0x0129_1420, 0x3484_10A4),
    (r"meshes\i\contain_rock_apy_08.nif", 0x0129_1420, 0x3484_14A4),
    (r"meshes\i\contain_rock_apy_14.nif", 0x0129_1420, 0x3484_24A0),
    (r"meshes\i\contain_rock_apy_11.nif", 0x0129_1420, 0x3484_30A0),
    (r"meshes\i\contain_rock_apy_10.nif", 0x0129_1420, 0x3484_34A0),
    (r"meshes\i\contain_rock_apy_13.nif", 0x0129_1420, 0x3484_38A0),
    (r"meshes\i\contain_rock_apy_12.nif", 0x0129_1420, 0x3484_3CA0),
    (r"meshes\i\in_om_end.nif", 0x0141_7F54, 0x1425_BB7C),
    (r"meshes\i\in_om_trap.nif", 0x0141_7F54, 0x390B_F477),
    (r"meshes\i\in_om_diaz.nif", 0x0141_7F54, 0x9926_105E),
    (r"meshes\i\act_spikes.nif", 0x014C_7754, 0x22EE_7175),
    (r"meshes\a\a_helsethguard_helm.nif", 0x0403_1B31, 0xA349_B826),
    (r"meshes\a\a_helsethguard_skins.nif", 0x0403_1B31, 0xC92E_5C48),
    (r"meshes\a\a_helsethguard_cur_gnd.nif", 0x0403_1B45, 0xE8D0_05C2),
    (r"meshes\a\a_helsethguard_pauld_gnd.nif", 0x0403_7345, 0x9277_47F8),
    (r"meshes\a\a_helsethguard_skins.1st.nif", 0x0403_7345, 0xAE18_B9FB),
    (r"meshes\a\a_helsethguard_boots_gnd.nif", 0x0403_7345, 0xB037_AEE9),
    (r"meshes\c\c_f_shirt_common2_skin.nif", 0x0418_0679, 0xCA3D_6A8A),
    (r"meshes\c\c_f_shirt_common1_skin.nif", 0x0418_0679, 0xD1CD_A929),
    (r"meshes\a\a_helsethguard_gauntl_gnd.nif", 0x0464_7345, 0xCDCD_B4D0),
    (r"meshes\a\a_helsethguard_greave_gnd.nif", 0x0464_7345, 0xD5BA_94DC),
    (r"icons\n\tx_horn_lily_bulb_01.dds", 0x0530_3501, 0xBF00_33EC),
    (r"meshes\a\a_almindoril_helmet.nif", 0x0619_1A38, 0x2062_AD31),
    (r"meshes\a\a_almindoril_greave_k.nif", 0x0619_1A5C, 0x0267_F80C),
    (r"meshes\a\a_almindoril_greaves_g.nif", 0x0619_1A5C, 0x041A_1A04),
    (r"meshes\a\a_almindoril_greave_ul.nif", 0x0619_1A5C, 0x311B_AF5C),
    (r"meshes\a\a_almindoril_boot_gnd.nif", 0x0619_1A5C, 0x98B8_3A44),
    (r"meshes\a\a_almindoril_skins.1st.nif", 0x0619_1A5C, 0xD27C_476C),
    (r"meshes\a\a_almindoril_cuirass_gnd.nif", 0x0619_755C, 0x3FE4_DE0C),
    (r"meshes\a\a_almindoril_greaves_gnd.nif", 0x0619_755C, 0x5660_1118),
    (r"meshes\a\a_almindoril_pauldron_cl.nif", 0x0619_755C, 0x802F_E148),
    (r"meshes\a\a_almindoril_pauldron_fa.nif", 0x0619_755C, 0x942F_E17C),
    (r"meshes\a\a_almindoril_pauldron_ua.nif", 0x0619_755C, 0xD82F_E17C),
    (r"meshes\a\a_almindoril_pauldron_gnd.nif", 0x066B_755C, 0x4F29_EDEC),
    (r"meshes\a\a_almindoril_gauntlet_gnd.nif", 0x066B_755C, 0x7435_0BC4),
    (r"textures\tx_dwe_weat_thunder.dds", 0x0700_1439, 0x396B_809C),
    (r"textures\tx_dwe_weat_overcast.dds", 0x0700_1439, 0xB794_480C),
    (r"textures\tx_b_n_barenziah_hair.dds", 0x070B_3C5D, 0x5996_B871),
    (r"textures\tx_b_n_barenziah_head.dds", 0x070B_3C5D, 0xB8F1_378A),
    (r"textures\tx_pit_concretefloor.dds", 0x0711_0A2D, 0xA10A_C293),
    (r"meshes\w\w_nerevarblade_flame.nif", 0x0715_1331, 0x3BAF_403E),
    (r"meshes\w\w_nerevarblademiddle.nif", 0x0715_1331, 0x50DC_2D80),
    (r"meshes\w\w_nerevarbladeright.nif", 0x0715_1331, 0x526A_3CA9),
    (r"meshes\w\w_nerevarblade_regular.nif", 0x0715_1350, 0x3A6A_04F0),
    (r"textures\tx_wall.dds", 0x071D_635D, 0x612E_F4B1),
    (r"textures\tx_om_edge.dds", 0x0765_635D, 0x4E26_9A70),
    (r"textures\tx_casket.dds", 0x0765_635D, 0x853E_C494),
    (r"textures\tx_hot_oil.dds", 0x0765_635D, 0x88D6_76DE),
    (r"textures\tx_om_door.dds", 0x0765_635D, 0x942B_3A66),
    (r"textures\tx_blade00.dds", 0x0765_635D, 0xFF6A_3C9A),
    (r"meshes\c\c_m_pants_common2_g.nif", 0x0811_050B, 0x35EA_4E9C),
    (r"meshes\c\c_m_pants_common2_a.nif", 0x0811_050B, 0x35EA_569C),
    (r"meshes\c\c_m_pants_common2_k.nif", 0x0811_050B, 0x35EA_7E9C),
    (r"meshes\c\c_m_pants_common1_g.nif", 0x0811_050B, 0x39EA_4E9C),
    (r"meshes\c\c_m_pants_common1_a.nif", 0x0811_050B, 0x39EA_569C),
    (r"meshes\c\c_m_pants_common1_k.nif", 0x0811_050B, 0x39EA_7E9C),
    (r"meshes\c\c_m_pants_common1_ul.nif", 0x0811_050B, 0x5C4D_0E30),
    (r"meshes\c\c_m_pants_common2_ul.nif", 0x0811_050B, 0x5C8D_0E30),
    (r"meshes\c\c_m_pants_mournhold_a.nif", 0x0811_057F, 0x0C7F_21A7),
    (r"meshes\c\c_m_pants_common2_gnd.nif", 0x0811_057F, 0x10FF_44D7),
    (r"meshes\c\c_m_pants_mournhold_ul.nif", 0x0811_057F, 0x8185_4C4D),
    (r"meshes\c\c_m_pants_mournhold_k.nif", 0x0811_057F, 0xDE05_CE1F),
    (r"meshes\c\c_m_pants_common1_gnd.nif", 0x0811_057F, 0xE03C_EA7C),
    (r"meshes\c\c_m_pants_mournhold_g.nif", 0x0811_057F, 0xE3C2_D2DD),
    (r"meshes\c\c_m_pants_mournhold_gnd.nif", 0x0811_767F, 0x7CFC_C39A),
    (r"meshes\a\a_dwemer_shield_battle.nif", 0x081D_1251, 0x49E3_EB99),
    (r"meshes\f\act_m_sewer_crank_01.nif", 0x0913_1A0B, 0x91DE_1EB7),
    (r"meshes\a\a_adamantium_boots_f.nif", 0x091D_1630, 0x5EFF_7317),
    (r"meshes\a\a_adamantium_boots_a.nif", 0x091D_1630, 0x7CFC_CD61),
    (r"meshes\a\a_adamantium_greaves_k.nif", 0x091D_165E, 0x041B_DF59),
    (r"meshes\a\a_adamantium_greaves_g.nif", 0x091D_165E, 0x041B_DF5F),
    (r"meshes\a\a_adamantium_cuirass_c.nif", 0x091D_165E, 0x0F88_717C),
    (r"meshes\a\a_adamantium_boots_gnd.nif", 0x091D_165E, 0x9307_1C9A),
    (r"meshes\a\a_adamantium_bracer_w.nif", 0x091D_165E, 0xD9A0_A3DE),
    (r"meshes\a\a_adamantium_bracer_gnd.nif", 0x091D_625E, 0x13F1_5E23),
    (r"meshes\a\a_adamantium_greaves_gnd.nif", 0x091D_625E, 0x3160_1C3F),
    (r"meshes\a\a_adamantium_cl_pauldron.nif", 0x091D_625E, 0x5723_C4AD),
    (r"meshes\a\a_adamantium_greaves_ul.nif", 0x091D_625E, 0x63F3_2E18),
    (r"meshes\a\a_adamantium_cuirass_gnd.nif", 0x091D_625E, 0x712A_DE16),
    (r"meshes\a\a_adamantium_pauldron_fa.nif", 0x091D_625E, 0x8E61_2F7C),
    (r"meshes\a\a_adamantium_pauldron_ua.nif", 0x091D_625E, 0xC261_2F7C),
    (r"meshes\f\furn_museum_display_02.nif", 0x0937_2F49, 0x583F_C4C7),
    (r"meshes\f\furn_museum_display_01.nif", 0x0937_2F49, 0xD83F_C4C6),
    (r"meshes\a\a_adamantium_pauldron_gnd.nif", 0x0974_625E, 0x4F1D_6E45),
    (r"meshes\c\c_m_helseth_robe.1st.nif", 0x0A15_1D0B, 0x30D8_D412),
    (r"meshes\c\c_m_helseth_robe_gnd.nif", 0x0A15_1D0B, 0xB109_4458),
    (r"meshes\c\c_shoes_common1_gnd.nif", 0x0B15_1A3C, 0xDBF1_8011),
    (r"meshes\c\c_shoes_common2_gnd.nif", 0x0B15_1A3C, 0xDBF1_9811),
    (r"meshes\c\c_shoes_mournhold_gnd.nif", 0x0B15_1A63, 0xF0F9_6634),
    (r"meshes\c\c_skirt_common1_gnd.nif", 0x0C02_1C3F, 0xDBF1_8011),
    (r"meshes\c\c_skirt_common2_gnd.nif", 0x0C02_1C3F, 0xDBF1_9811),
    (r"meshes\c\c_skirt_mournhold_gnd.nif", 0x0C02_1C60, 0xF0F9_6634),
    (r"meshes\d\door_sotha_double00.nif", 0x0C33_2D26, 0x1212_D448),
    (r"meshes\d\door_sotha_pre_load.nif", 0x0C33_2D26, 0x1F9B_BD18),
    (r"meshes\w\w_dwarvenspheredart.nif", 0x0D02_0023, 0x6752_3C43),
    (r"meshes\i\xact_sotha_oilbridge.nif", 0x0D3D_3120, 0x209F_E9C5),
    (r"meshes\i\xact_sotha_oilbridge.kf", 0x0D3D_3120, 0x28FF_712E),
    (r"meshes\i\xact_sotha_mach_door.kf", 0x0D3D_3120, 0x7240_A05F),
    (r"meshes\i\xact_sotha_powertubes.kf", 0x0D3D_3120, 0x7D39_77C1),
    (r"meshes\i\xact_sotha_clockwork.kf", 0x0D3D_3120, 0x85A0_FFCC),
    (r"meshes\i\xact_sotha_fabsteam.nif", 0x0D3D_3120, 0x8857_25F0),
    (r"meshes\i\xact_sotha_pre_door.nif", 0x0D3D_3120, 0x9190_3A78),
    (r"meshes\i\xact_sotha_clockwork.nif", 0x0D3D_3120, 0xAA2A_97FE),
    (r"meshes\i\xact_sotha_mach_door.nif", 0x0D3D_3120, 0xE5F5_1680),
    (r"meshes\i\xact_sotha_powertubes.nif", 0x0D3D_3154, 0x16CA_84D1),
    (r"meshes\l\light_mh_rope_lantern.nif", 0x0E19_0E54, 0xE058_96A1),
    (r"meshes\l\light_mh_streetlamp_01.nif", 0x0E19_0E54, 0xF570_56DA),
    (r"meshes\l\light_mh_streetlight_01.nif", 0x0E19_5154, 0x4CC4_FDF3),
    (r"meshes\c\c_m_shirt_common2_ua.nif", 0x0F18_060B, 0xC610_4AE0),
    (r"meshes\c\c_m_shirt_common1_ua.nif", 0x0F18_060B, 0xC610_4AE6),
    (r"meshes\c\c_m_shirt_common2_w.nif", 0x0F18_060B, 0xD5EA_0DE4),
    (r"meshes\c\c_m_shirt_common2_f.nif", 0x0F18_060B, 0xD5EA_49E4),
    (r"meshes\c\c_m_shirt_common1_w.nif", 0x0F18_060B, 0xD9EA_0DE4),
    (r"meshes\c\c_m_shirt_common1_f.nif", 0x0F18_060B, 0xD9EA_49E4),
    (r"meshes\c\c_m_shirt_mournhold_ua.nif", 0x0F18_0679, 0x0187_044B),
    (r"meshes\c\c_m_shirt_common2_gnd.nif", 0x0F18_0679, 0x10FF_4047),
    (r"meshes\c\c_m_shirt_mournhold_f.nif", 0x0F18_0679, 0x4D7B_6C78),
    (r"meshes\c\c_m_shirt_common2_skin.nif", 0x0F18_0679, 0xCA3D_6A8A),
    (r"meshes\c\c_m_shirt_common1_skin.nif", 0x0F18_0679, 0xD1CD_A929),
    (r"meshes\c\c_m_shirt_common1_gnd.nif", 0x0F18_0679, 0xE03C_E35C),
    (r"meshes\c\c_m_shirt_mournhold_w.nif", 0x0F18_0679, 0xF3C5_525E),
    (r"meshes\c\c_m_shirt_mournhold_gnd.nif", 0x0F18_7279, 0x7CFC_C39A),
    (r"meshes\l\light_lamp_burnedout.nif", 0x0F19_0E3C, 0x7120_79C7),
    (r"meshes\l\light_logpile_burnedout.nif", 0x0F19_6953, 0x842D_6034),
    (r"meshes\a\a_darkbrotherhood_skin.nif", 0x0F1B_0547, 0x2CA9_0C22),
    (r"meshes\a\a_darkbrotherhood_1st.nif", 0x0F1B_0547, 0x9C3D_A182),
    (r"meshes\a\a_darkbrotherhood_helmet.nif", 0x0F1B_6A47, 0x1E30_80BF),
    (r"meshes\a\a_darkbrotherhood_pa_fa.nif", 0x0F1B_6A47, 0x61A7_FF86),
    (r"meshes\a\a_darkbrotherhood_pa_gnd.nif", 0x0F1B_6A47, 0x628A_9AAB),
    (r"meshes\a\a_darkbrotherhood_pa_ua.nif", 0x0F1B_6A47, 0xA9DA_DB5D),
    (r"meshes\a\a_darkbrotherhood_boot_a.nif", 0x0F1B_6A47, 0xE00B_8EA3),
    (r"meshes\a\a_darkbrotherhood_boot_f.nif", 0x0F1B_6A47, 0xE00B_8EBF),
    (r"meshes\a\a_darkbrotherhood_gr_gnd.nif", 0x0F1B_6A47, 0xFA32_9AAB),
    (r"meshes\a\a_darkbrotherhood_c_gnd.nif", 0x0F1B_6A47, 0xFE44_71CC),
    (r"meshes\a\a_darkbrotherhood_b_gnd.nif", 0x0F1B_6A47, 0xFE46_71CC),
    (r"meshes\a\a_darkbrotherhood_gau_gnd.nif", 0x0F6F_6A47, 0x4973_1253),
    (r"meshes\a\a_darkbrotherhood_grev_ul.nif", 0x0F6F_6A47, 0xE1DD_5AC1),
    (r"meshes\a\a_darkbrotherhood_greav_k.nif", 0x0F6F_6A47, 0xEBBA_30C7),
    (r"meshes\a\a_darkbrotherhood_greav_g.nif", 0x0F6F_6A47, 0xEBBA_30F7),
    (r"meshes\l\light_sotha_sparks_hi.nif", 0x1019_0E53, 0xA4B1_89EA),
    (r"meshes\i\act_dwe_explosion00.nif", 0x103B_130B, 0x7C72_E988),
    (r"meshes\w\w_almalexia_scimitar.nif", 0x1211_0C38, 0x4211_46C6),
    (r"meshes\a\a_imperial_c_female.nif", 0x1215_0739, 0xE1AA_9390),
    (r"meshes\a\a_imperialchain _c_female.nif", 0x1279_6650, 0x6A77_0103),
    (r"meshes\w\w_art_maceofslurring.nif", 0x132F_1526, 0x573D_060C),
    (r"meshes\f\furn_throne_canopy_01.nif", 0x142E_2F48, 0x5F5E_E8C0),
    (r"meshes\x\editormarker_box_02.nif", 0x1439_1C20, 0x901E_6D59),
    (r"meshes\f\furn_chandelier_burnedout.nif", 0x145D_415B, 0xEEA5_FF56),
    (r"meshes\f\flora_treedead_mh_01.nif", 0x151C_1126, 0x4031_A03D),
    (r"meshes\f\flora_treedead_mh_02.nif", 0x151C_1126, 0xF56F_B7FB),
    (r"meshes\i\xact_dwe_explosion00.kf", 0x152A_3120, 0x0745_1878),
    (r"meshes\i\xact_dwe_explosion00.nif", 0x152A_3120, 0x7821_0060),
    (r"meshes\b\b_n_dark elf_m_helseth.nif", 0x1611_1060, 0xF60D_FB71),
    (r"meshes\b\b_n_dark elf_f_barenziah.nif", 0x1611_3060, 0x38EE_5DB6),
    (r"meshes\b\b_n_darkelf_f_barenziahh.nif", 0x1611_7560, 0x87F1_B960),
    (r"meshes\a\a_steel_cuir_female.nif", 0x1615_1220, 0x5078_5DB6),
    (r"meshes\b\b_n_darkelf_m_helsethhair.nif", 0x167D_7560, 0xFD9F_A1B3),
    (r"meshes\l\light_torch_burnedout.nif", 0x1719_0E53, 0x3122_3EDF),
    (r"meshes\m\misc_fabricant_elixir.nif", 0x1720_2455, 0xDDC2_A5C9),
    (r"meshes\r\xfabricant_imperfect.kf", 0x1820_1C36, 0x252A_176B),
    (r"meshes\r\xfabricant_imperfect.nif", 0x1820_1C36, 0x34A8_BC5C),
    (r"meshes\r\fabricant_imperfect.nif", 0x192D_1926, 0x11A5_629D),
    (r"textures\darkbrotherhood_head.dds", 0x1A0E_1136, 0x3B2B_787E),
    (r"textures\darkbrotherhood_arm.dds", 0x1A0E_1136, 0x9C65_B121),
    (r"textures\darkbrotherhood_foot.dds", 0x1A0E_1136, 0xB120_C675),
    (r"meshes\r\xdurzog.kf", 0x1A2F_1654, 0x3EF6_020E),
    (r"meshes\r\liche.nif", 0x1A2F_1654, 0xB508_6CD4),
    (r"meshes\r\durzog.nif", 0x1A2F_1654, 0xC6C2_1809),
    (r"meshes\r\packrat.nif", 0x1A2F_6654, 0xE0CB_EBE2),
    (r"meshes\r\xpackrat.kf", 0x1A2F_6E54, 0x75FE_A31F),
    (r"meshes\r\xgoblin02.kf", 0x1A2F_6E54, 0x7C00_7085),
    (r"meshes\r\xgoblin03.kf", 0x1A2F_6E54, 0x7C00_7485),
    (r"meshes\r\xgoblin01.kf", 0x1A2F_6E54, 0x7C00_7C85),
    (r"meshes\r\xdurzog.nif", 0x1A2F_6E54, 0xC6C2_1809),
    (r"meshes\r\xpackrat.nif", 0x1A2F_6E54, 0xEECD_B1A3),
    (r"meshes\r\goblin01.nif", 0x1A2F_7154, 0x5AF8_F722),
    (r"meshes\r\goblin03.nif", 0x1A2F_7154, 0x5AF8_F72A),
    (r"meshes\r\goblin02.nif", 0x1A2F_7154, 0x5AF8_F72E),
    (r"meshes\r\xliche_king.kf", 0x1A43_6E54, 0xD5F0_5D5B),
    (r"meshes\r\almelexia.nif", 0x1A43_7754, 0x4446_C110),
    (r"meshes\r\liche_king.nif", 0x1A46_7A54, 0x7064_C026),
    (r"meshes\r\xgoblin01.nif", 0x1A48_6E54, 0x5AF8_F722),
    (r"meshes\r\xgoblin03.nif", 0x1A48_6E54, 0x5AF8_F72A),
    (r"meshes\r\xgoblin02.nif", 0x1A48_6E54, 0x5AF8_F72E),
    (r"meshes\r\xfabricant.kf", 0x1A49_6E54, 0xB5F6_4E00),
    (r"meshes\r\xfabricant.nif", 0x1A49_6E54, 0xD3F9_4B00),
    (r"meshes\r\xalmelexia.nif", 0x1A4E_6E54, 0x2B7C_46F1),
    (r"meshes\r\xalmelexia.kf", 0x1A4E_6E54, 0x4D73_43F1),
    (r"meshes\r\fabricant.nif", 0x1A4E_7054, 0x5D2D_1603),
    (r"meshes\w\w_art_bipolar_blade.nif", 0x1C2F_1526, 0x68E2_6CA2),
    (r"meshes\f\furn_banner_stage_01.nif", 0x1D38_2F3A, 0x3C55_65BF),
    (r"meshes\f\furn_banner_helseth_01.nif", 0x1D38_2F54, 0x6C47_D537),
    (r"meshes\f\furn_banner_hanger_01.nif", 0x1D38_2F54, 0xD44B_6AD9),
    (r"meshes\f\furn_banner_helseth_02.nif", 0x1D38_2F54, 0xEC47_D536),
    (r"meshes\w\w_adamantium_claymore.nif", 0x1F1D_005E, 0x4EB3_7648),
    (r"meshes\w\w_adamantium_shortsword.nif", 0x1F1D_745E, 0xD04A_A6FD),
    (r"meshes\d\ex_mh_sewer_trapdoor_01.nif", 0x2008_6C5C, 0x7538_0501),
    (r"meshes\d\ex_mh_palace_gate_01.nif", 0x2308_1B39, 0xA5B6_1553),
    (r"meshes\d\ex_mh_wall_gate_door.nif", 0x2408_1B39, 0x63B2_C543),
    (r"icons\w\tx_w_dwarvenspheredart.dds", 0x2430_2343, 0xDD86_5F15),
    (r"meshes\f\active_mh_forcefield.nif", 0x2529_013D, 0x78B6_145E),
    (r"meshes\d\ex_mh_temple_door_01.nif", 0x2708_1B39, 0x3634_C5A9),
    (r"meshes\l\ex_mh_streetlamp_01.nif", 0x2808_1B39, 0x23C9_0258),
    (r"icons\w\tx_w_almalexia_scimitar.dds", 0x282B_2650, 0xFA86_8DF0),
    (r"textures\tx_mh_palace_win_01.dds", 0x283A_0B30, 0x6919_E00D),
    (r"textures\tx_mh_palace_door_01.dds", 0x283A_0B30, 0x7C4A_23A0),
    (r"meshes\i\in_om_waterfall_small.nif", 0x291E_125A, 0xDD9C_1457),
    (r"textures\tx_w_art_maceofslurring.dds", 0x2A04_635E, 0x1D84_547E),
    (r"textures\tx_fabricant_hulking.dds", 0x2A07_023B, 0x1619_C93C),
    (r"textures\tx_fabricant_robottemp.dds", 0x2A07_0252, 0x36C7_9675),
    (r"meshes\i\in_mh_temple_hall_01.nif", 0x2A1E_1739, 0xCD14_A159),
    (r"meshes\i\in_mh_throne_room_01.nif", 0x2A1E_1739, 0xD662_DE4A),
    (r"meshes\i\in_mh_temple_tower_01.nif", 0x2A1E_175C, 0x9138_9762),
    (r"textures\tx_brassmech_ceil00.dds", 0x2B04_113F, 0xC3B4_6CDB),
    (r"meshes\x\ex_mh_canal_grate_01.nif", 0x2C08_1B39, 0x5218_ECCE),
    (r"textures\tx_a_steel_c_female.dds", 0x2C16_3C3C, 0x86A7_899C),
    (r"meshes\x\ex_mh_bazaar_bridge.nif", 0x2D08_1B39, 0x131E_99C4),
    (r"meshes\x\ex_mh_bazaar_cart_01.nif", 0x2D08_1B39, 0xB252_232A),
    (r"meshes\x\ex_mh_bazaar_bench_01.nif", 0x2D08_1B58, 0x8E92_ADBB),
    (r"meshes\x\ex_mh_bazaar_booth_01.nif", 0x2D08_1B58, 0x9E24_AF6A),
    (r"meshes\x\ex_mh_bazaar_stage_02.nif", 0x2D08_1B58, 0xCDAD_933A),
    (r"meshes\x\ex_mh_bazaar_planter_02.nif", 0x2D08_6158, 0x15B5_903B),
    (r"meshes\x\ex_mh_bazaar_planter_01.nif", 0x2D08_6158, 0x95B5_903A),
    (r"textures\tx_menubook_quests_over.dds", 0x2D0B_6952, 0x0675_4C7E),
    (r"textures\tx_menubook_options_idle.dds", 0x2D0B_6952, 0x4293_D1A5),
    (r"textures\tx_menubook_options_over.dds", 0x2D0B_6952, 0x7A4C_86D6),
    (r"textures\tx_menubook_cancel_over.dds", 0x2D0B_6952, 0xEA27_452C),
    (r"textures\tx_menubook_quests_idle.dds", 0x2D0B_6952, 0xF6CB_E8E0),
    (r"textures\tx_natural_cavern_wall20.dds", 0x2D11_6341, 0x4C7F_CD58),
    (r"textures\tx_m_ruins_trim_05a.dds", 0x2D17_3C30, 0x14DF_3CA5),
    (r"textures\tx_m_ruins_floor_02.dds", 0x2D17_3C30, 0xF91C_0D0A),
    (r"icons\a\tx_shield_almindoril.dds", 0x2D34_2E06, 0x4265_8689),
    (r"textures\tx_menubook_cancel_pressed.dds", 0x2D64_6952, 0x1CB8_1EFE),
    (r"textures\tx_menubook_quests_pressed.dds", 0x2D64_6952, 0x55D0_3408),
    (r"meshes\x\ex_mh_almalexia_whole.nif", 0x2E08_1B55, 0xC3C8_3110),
    (r"meshes\i\in_mh_palace_room_01.nif", 0x2E1E_1739, 0x107E_7F89),
    (r"meshes\i\in_mh_pav_lava_cave.nif", 0x2E1E_1739, 0x8475_2F7E),
    (r"textures\tx_mh_water_spray_02.dds", 0x2F3A_0B30, 0xEE16_7D2B),
    (r"textures\tx_eb_helm of tohan.dds", 0x303A_0138, 0xB41E_6828),
    (r"textures\tx_shrine_statue1_feet.dds", 0x3117_0B40, 0x27C6_C77B),
    (r"textures\tx_shrine_statue1_hand.dds", 0x3117_0B40, 0x58F0_966C),
    (r"textures\tx_shrine_statue1_face.dds", 0x3117_0B40, 0xCC5B_D9A3),
    (r"textures\tx_shrine_statue1_skirt.dds", 0x3117_6E40, 0x2515_1E51),
    (r"textures\tx_shrine_statue2__face.dds", 0x3117_6E40, 0xA155_3EA5),
    (r"textures\tx_shrine_statue2__feet.dds", 0x3117_6E40, 0xBC85_7EBA),
    (r"icons\c\tx_mournhold_cuirass.dds", 0x3121_3201, 0x8670_1401),
    (r"icons\c\tx_mournhold_greaves.dds", 0x3121_3201, 0xD863_52C0),
    (r"icons\w\tx_w_adtium_claymore.dds", 0x3123_2631, 0x4C45_A9EB),
    (r"icons\w\tx_w_adtium_shortsword.dds", 0x3123_2658, 0xB6A7_A424),
    (r"textures\tx_shrine_statue1_upperleg.dds", 0x3148_6E40, 0x30DB_38DB),
    (r"textures\tx_shrine_statue1_lowerleg.dds", 0x3148_6E40, 0x4A58_EFCB),
    (r"icons\a\tx_adamantium_bracer.dds", 0x323C_260A, 0x0C08_0F86),
    (r"icons\a\tx_adamantium_greaves.dds", 0x323C_260A, 0x7581_9496),
    (r"icons\a\tx_adamantium_cuirass.dds", 0x323C_260A, 0xBBC6_4554),
    (r"icons\a\tx_adamantium_pauldron.dds", 0x323C_2664, 0xA4E2_2292),
    (r"textures\tx_darkbrotherhood_torso.dds", 0x3317_705B, 0x0F14_18F7),
    (r"textures\tx_a_almindorilpads.dds", 0x3404_3C3C, 0x0D03_5863),
    (r"textures\tx_a_almindoril_mask.dds", 0x3404_3C3C, 0xBDF6_3BBC),
    (r"textures\tx_a_almindoril_cloth.dds", 0x3404_3C51, 0x1BE0_1FEB),
    (r"textures\tx_a_almindoril_shield.dds", 0x3404_3C51, 0x66B0_EFDE),
    (r"textures\tx_a_almindoril_boota.dds", 0x3404_3C51, 0xB0C6_16D9),
    (r"textures\tx_a_almindoril_pauldron.dds", 0x3404_5551, 0x3E4F_EDEE),
    (r"textures\tx_a_almindoril_gauntlet.dds", 0x3404_5551, 0x7411_FFCB),
    (r"textures\tx_a_almindoril_shield01.dds", 0x3404_5551, 0xA126_5589),
    (r"textures\tx_w_almalexia_scimitar.dds", 0x3404_5D47, 0xFA86_8DF0),
    (r"icons\n\tx_nirthfly_stalks_01.dds", 0x342A_3507, 0xCFC3_1861),
    (r"textures\tx_mh_lantern_post_01.dds", 0x343A_0B51, 0x05EB_96B2),
    (r"icons\a\tx_darkbrotherhood_helm.dds", 0x343A_357D, 0x263E_6F99),
    (r"icons\a\tx_darkbrotherhood_cuir.dds", 0x343A_357D, 0x458D_C605),
    (r"icons\a\tx_darkbrotherhood_boot.dds", 0x343A_357D, 0xEA4D_6A4E),
    (r"icons\a\tx_darkbrotherhood_pauld.dds", 0x343A_5A7D, 0x2CC0_F81D),
    (r"icons\a\tx_darkbrotherhood_greav.dds", 0x343A_5A7D, 0x3DA8_D78A),
    (r"icons\a\tx_darkbrotherhood_gaunt.dds", 0x343A_5A7D, 0x9922_8F10),
    (r"textures\tx_a_imperial_c_female.dds", 0x350C_3C4C, 0x7C09_31DD),
    (r"textures\tx_a_imperialchain_f_c.dds", 0x350C_3C4C, 0xF56D_0132),
    (r"textures\tx_item_pot_glass_blue_02.dds", 0x356F_676B, 0x3974_F16B),
    (r"textures\tx_a_imperial_belt_female.dds", 0x357E_594C, 0x3717_6E25),
    (r"icons\w\w_nerevar_blade_fire.dds", 0x3600_051F, 0x7760_9F5C),
    (r"textures\tx_banner_helseth_02.dds", 0x360B_023F, 0xAC87_6466),
    (r"textures\tx_banner_helseth_01.dds", 0x360B_023F, 0xE75C_7D58),
    (r"meshes\d\in_m_sewer_trapdoor_01.nif", 0x3632_204E, 0x7538_0501),
    (r"meshes\i\in_sotha_door_broke.nif", 0x3635_1027, 0x0630_5717),
    (r"meshes\i\in_sotha_plank_oil00.nif", 0x3635_1027, 0x154B_E276),
    (r"meshes\i\in_sotha_corr_wall00.nif", 0x3635_1027, 0x3786_0B39),
    (r"meshes\i\in_sotha_resistor00.nif", 0x3635_1027, 0x5209_00C8),
    (r"meshes\i\in_sotha_lab_panel00.nif", 0x3635_1027, 0x85A3_CCF3),
    (r"meshes\i\in_sotha_pre_arch00.nif", 0x3635_1027, 0xA81D_4038),
    (r"meshes\i\in_sotha_pre2_wall00.nif", 0x3635_1027, 0xB174_4FC9),
    (r"meshes\i\in_sotha_pre2_trap00.nif", 0x3635_1027, 0xD0FA_B4C8),
    (r"meshes\i\in_sotha_dorjam_oil00.nif", 0x3635_1046, 0x9B52_F7AD),
    (r"meshes\i\in_sotha_spiral_stair.nif", 0x3635_1046, 0x9D39_B93F),
    (r"meshes\i\in_sotha_corr2_stairs.nif", 0x3635_1046, 0xDA68_5C61),
    (r"meshes\i\in_sotha_gear_chamber00.nif", 0x3635_4F46, 0x4E60_C386),
    (r"meshes\i\in_sotha_pillar_wings00.nif", 0x3635_4F46, 0xF754_3897),
    (r"textures\tx_w_goblin_shield2.dds", 0x3702_3C2A, 0x96A1_FB26),
    (r"textures\tx_c_mournhold_skirt.dds", 0x3708_3C3E, 0x8385_9460),
    (r"textures\tx_c_mournhold_pants.dds", 0x3708_3C3E, 0xA2ED_7AA7),
    (r"textures\tx_c_mournhold_cape.dds", 0x3708_3C3E, 0xA981_841C),
    (r"textures\tx_c_mournhold_torso.dds", 0x3708_3C3E, 0xB3E0_48F9),
    (r"textures\tx_c_mournhold_lngskirt.dds", 0x3708_4E4B, 0xAE06_12EA),
    (r"textures\tx_velothi_doorstrip_01.dds", 0x3709_6E5F, 0xABFB_22F7),
    (r"meshes\i\in_mh_int_column_01.nif", 0x371E_1739, 0x406B_30C9),
    (r"meshes\i\in_mh_int_center_01.nif", 0x371E_1739, 0x54B2_FF10),
    (r"meshes\i\in_mh_int_corner_04.nif", 0x371E_1739, 0x9761_097D),
    (r"meshes\i\in_mh_int_corner_02.nif", 0x371E_1739, 0x9761_117D),
    (r"meshes\i\in_mh_int_corner_03.nif", 0x371E_1739, 0x9761_157D),
    (r"meshes\i\in_mh_int_corner_01.nif", 0x371E_1739, 0x9761_1D7D),
    (r"meshes\i\in_mh_int_stairs_01.nif", 0x371E_1739, 0x9846_B9EF),
    (r"meshes\i\in_mh_int_entrance_01.nif", 0x371E_1757, 0xC2E2_FB8A),
    (r"icons\w\tx_w_nerevarbladeleft.dds", 0x3722_2931, 0x72D1_89C7),
    (r"icons\w\tx_w_nerevarblademiddle.dds", 0x3722_2954, 0xB23C_C385),
    (r"icons\w\tx_w_nerevarbladeright.dds", 0x3722_2954, 0xBC3D_86A7),
    (r"meshes\x\ex_mh_wall_tower_01.nif", 0x3808_1B39, 0xB962_8845),
    (r"textures\tx_creature_almelexia.dds", 0x3900_114A, 0xC946_7B47),
    (r"textures\tx_metal_iron_rusty.dds", 0x3911_0630, 0x464D_B135),
    (r"textures\tx_scraped_copper01.dds", 0x3917_002E, 0xE7A5_83B3),
    (r"textures\tx_scraped_copper00.dds", 0x3917_002E, 0xE7A5_87B3),
    (r"textures\tx_scraped_copper03.dds", 0x3917_002E, 0xE7A5_8BB3),
    (r"textures\tx_scraped_copper02.dds", 0x3917_002E, 0xE7A5_8FB3),
    (r"textures\tx_w_ebony_scimitar.dds", 0x3A00_3C2A, 0xEDCC_9684),
    (r"meshes\i\in_m_sewer_column_01.nif", 0x3B32_2039, 0x3691_F939),
    (r"meshes\i\in_m_sewer_niche_02.nif", 0x3B32_2039, 0x5844_4E7A),
    (r"meshes\i\in_m_sewer_corner_01.nif", 0x3B32_2039, 0x7E82_3A49),
    (r"meshes\i\in_m_sewer_drain_01.nif", 0x3B32_2039, 0xD3B4_0743),
    (r"meshes\i\in_m_sewer_fountain_01.nif", 0x3B32_204E, 0x2E39_9ED3),
    (r"meshes\i\in_m_sewer_cistern_01.nif", 0x3B32_204E, 0x42D1_F237),
    (r"meshes\i\in_m_sewer_connect_01.nif", 0x3B32_204E, 0x4AF3_EDB9),
    (r"meshes\i\in_m_sewer_doorcap_01.nif", 0x3B32_204E, 0x8DB2_055E),
    (r"textures\tx_mh_cobblestone_01.dds", 0x3B3A_0B30, 0xF2D4_CBDB),
    (r"textures\tx_w_adtium_shtblade.dds", 0x3C04_3C2A, 0x47AA_7EC3),
    (r"textures\tx_w_adtium_lngsword.dds", 0x3C04_3C2A, 0xE84F_C6E7),
    (r"textures\tx_a_adamantium_boots.dds", 0x3C04_3C5D, 0x1AF4_07C7),
    (r"textures\tx_a_adamantium_bracer.dds", 0x3C04_3C5D, 0xBEAE_5E41),
    (r"textures\tx_a_adamantium_up_arm.dds", 0x3C04_3C5D, 0xF33E_268D),
    (r"textures\tx_wood_brown_shelf.dds", 0x3C0A_0C2A, 0x8C2F_27EF),
    (r"textures\tx_wood_oldwood_strip.dds", 0x3C0A_0C75, 0x62E0_3C1C),
    (r"textures\tx_mh_deadleaves_01.dds", 0x3C3A_0B30, 0x2476_01FD),
    (r"textures\tx_mh_deadleaves_02.dds", 0x3C3A_0B30, 0x2476_0DFD),
    (r"textures\tx_wood_oldwood_design_01.dds", 0x3C66_6375, 0xE5FC_8F33),
    (r"textures\tx_wood_weathered_rings_01.dds", 0x3C6F_7B75, 0x27EE_9C36),
    (r"textures\tx_a_netchneckcloth.dds", 0x3D0B_3C3C, 0xC9DB_5803),
    (r"textures\tx_c_new_common2_skirt.dds", 0x3D0B_3C49, 0x43AE_7C84),
    (r"textures\tx_c_new_common1_skirt.dds", 0x3D0B_3C49, 0x43AE_7C9C),
    (r"textures\tx_spherearcherdart.dds", 0x3D0D_132E, 0x42EF_B2C3),
    (r"textures\tx_a_helseth_helmet.dds", 0x3D0D_3C3C, 0x8163_3256),
    (r"textures\tx_a_helseth_pauldron.dds", 0x3D0D_3C50, 0x64E2_7210),
    (r"textures\tx_a_helseth_gauntlet.dds", 0x3D0D_3C50, 0xC66A_3148),
    (r"textures\tx_a_helseth_pauldron01.dds", 0x3D0D_4F50, 0xB777_9AE8),
    (r"textures\tx_c_helseth_extravagant.dds", 0x3D0D_4F52, 0x40A8_15BA),
    (r"textures\tx_m_sewer_floor_01.dds", 0x3D16_3C30, 0xF9CE_069E),
    (r"textures\tx_m_sewer_floor_02.dds", 0x3D16_3C30, 0xF9CE_0A9E),
    (r"textures\tx_m_sewer_doorstrip_01.dds", 0x3D16_5947, 0x4FFB_2353),
    (r"textures\tx_streetlamp_glass.dds", 0x3D17_172E, 0xFC93_6A3C),
    (r"textures\tx_streetlamp_banding.dds", 0x3D17_174B, 0x17DA_6765),
    (r"icons\a\tx_almindoril_helmet.dds", 0x3D38_2A02, 0x356F_A731),
    (r"icons\a\tx_almindoril_greaves.dds", 0x3D38_2A02, 0x402B_2DB0),
    (r"icons\a\tx_almindoril_cuirass.dds", 0x3D38_2A02, 0xD89C_EEC6),
    (r"icons\a\tx_almindoril_gauntlet.dds", 0x3D38_2A66, 0x111A_3104),
    (r"icons\a\tx_almindoril_pauldron.dds", 0x3D38_2A66, 0x14E2_3EC7),
    (r"textures\tx_a_netchleatherc_female.dds", 0x3D63_5F48, 0xE94E_15B6),
    (r"textures\tx_c_helseth_extravagant2.dds", 0x3D68_4F52, 0x89F2_8113),
    (r"meshes\n\ingred_sweetpulp_01.nif", 0x3E25_1A26, 0x6ED9_725A),
    (r"meshes\n\ingred_meadow_rye_01.nif", 0x3E25_1A26, 0x9E04_6258),
    (r"meshes\n\ingred_golden_sedge_01.nif", 0x3E25_1A41, 0xA052_A559),
    (r"meshes\n\ingred_durzog_meat_01.nif", 0x3E25_1A42, 0x94E1_0F72),
    (r"meshes\n\ingred_noble_sedge_01.nif", 0x3E25_1A48, 0x9B69_05BF),
    (r"meshes\n\ingred_timsa-come-by_01.nif", 0x3E25_7352, 0x0C04_D832),
    (r"meshes\n\ingred_horn_lily_bulb_01.nif", 0x3E25_754E, 0xF00F_1539),
    (r"meshes\n\ingred_scrib_cabbage_01.nif", 0x3E25_7955, 0x656B_FA75),
    (r"meshes\n\ingred_lloramor_spines_01.nif", 0x3E4A_764A, 0x0C37_9ECF),
    (r"meshes\n\ingred_nirthfly_stalks_01.nif", 0x3E57_7348, 0x2C78_5902),
    (r"meshes\x\ex_mh_pav_rubble_01.nif", 0x3F08_1B39, 0x136F_583B),
    (r"meshes\x\ex_mh_pav_bstatue_13.nif", 0x3F08_1B39, 0x16ED_4B85),
    (r"meshes\x\ex_mh_pav_bstatue_06.nif", 0x3F08_1B39, 0x184C_A68E),
    (r"meshes\x\ex_mh_palace_wall_02.nif", 0x3F08_1B39, 0x2A2F_4FC9),
    (r"meshes\x\ex_mh_palace_tower02.nif", 0x3F08_1B39, 0x43EB_0A57),
    (r"meshes\x\ex_mh_pav_bstatue_07.nif", 0x3F08_1B39, 0x5951_37AA),
    (r"meshes\x\ex_mh_pav_gate_door.nif", 0x3F08_1B39, 0x6903_8C8F),
    (r"meshes\x\ex_mh_pav_bstatue_09.nif", 0x3F08_1B39, 0x6998_9B61),
    (r"meshes\x\ex_mh_pav_bstatue_08.nif", 0x3F08_1B39, 0x79DF_FF0C),
    (r"meshes\x\ex_mh_paldoorjamb_01.nif", 0x3F08_1B39, 0x7CFC_8013),
    (r"meshes\x\ex_mh_pavillion_gate.nif", 0x3F08_1B39, 0x8709_DCFE),
    (r"meshes\x\ex_mh_pav_bstatue_12.nif", 0x3F08_1B39, 0x8734_5FC0),
    (r"meshes\x\ex_mh_pav_bstatue_02.nif", 0x3F08_1B39, 0x8734_5FC1),
    (r"meshes\x\ex_mh_pav_bstatue_03.nif", 0x3F08_1B39, 0x96ED_4B85),
    (r"meshes\x\ex_mh_pav_bstatue_05.nif", 0x3F08_1B39, 0x9A77_84B6),
    (r"meshes\x\ex_mh_pav_bstatue_04.nif", 0x3F08_1B39, 0x9E01_C0E7),
    (r"meshes\x\ex_mh_pav_bstatue_01.nif", 0x3F08_1B39, 0xA486_7049),
    (r"meshes\x\ex_mh_pav_bstatue_11.nif", 0x3F08_1B39, 0xA486_704B),
    (r"meshes\x\ex_mh_pav_bstatue_15.nif", 0x3F08_1B39, 0xBA77_84B6),
    (r"meshes\x\ex_mh_pav_bstatue_14.nif", 0x3F08_1B39, 0xDE01_C0E7),
    (r"meshes\x\ex_mh_pav_bstatue_10.nif", 0x3F08_1B39, 0xE3E2_2D5D),
    (r"meshes\x\ex_mh_palace_wall_01.nif", 0x3F08_1B39, 0xFEB0_5058),
    (r"meshes\x\ex_mh_pav_water_spray.nif", 0x3F08_1B58, 0x1398_558A),
    (r"meshes\x\ex_mh_palace_courtyard.nif", 0x3F08_1B58, 0x15FC_6E33),
    (r"meshes\x\ex_mh_pavillion_wall_w.nif", 0x3F08_1B58, 0x3C6B_AE05),
    (r"meshes\x\ex_mh_pavillion_wall_e.nif", 0x3F08_1B58, 0x3C6B_AE0C),
    (r"meshes\x\ex_mh_pavillion_gate_02.nif", 0x3F08_6D58, 0x6678_0759),
    (r"textures\tx_rough_stone_wall.dds", 0x3F10_0C2F, 0x78D0_0F05),
    (r"textures\tx_rough_stone_wall02.dds", 0x3F10_0C47, 0xD6AD_748F),
    (r"meshes\i\in_om_aquaduct_end02.nif", 0x3F1E_123B, 0x7B35_C8B5),
    (r"icons\a\tx_helsethguard_boots.dds", 0x3F22_2B0B, 0x1AFA_0557),
    (r"icons\a\tx_helsethguard_helmet.dds", 0x3F22_2B7F, 0x0E87_AE6A),
    (r"icons\a\tx_helsethguard_greave.dds", 0x3F22_2B7F, 0x6F64_A903),
    (r"icons\a\tx_helsethguard_cuirass.dds", 0x3F22_2B7F, 0xC013_DACA),
    (r"icons\a\tx_helsethguard_gauntlet.dds", 0x3F22_437F, 0xDE71_8EFD),
    (r"icons\a\tx_helsethguard_pauldron.dds", 0x3F22_437F, 0xE8E5_CDE2),
    (r"icons\n\tx_lloramor_spines_01.dds", 0x3F2C_2802, 0x65DA_5832),
    (r"icons\c\tx_robe_helseth.dds", 0x4053_4701, 0x77D5_CA0C),
    (r"icons\c\tx_robe_white.dds", 0x4053_476E, 0x2848_B68E),
    (r"icons\n\tx_scrib_cabbage_01.dds", 0x4137_350D, 0x396B_DB26),
    (r"icons\s\tx_s_smmn_fabrict.dds", 0x4143_3431, 0x8473_7AA5),
    (r"icons\n\tx_sweetpulp_01.dds", 0x415E_4719, 0xFBAD_AFD3),
    (r"textures\tx_shrine_statue2__frontskirt.dds", 0x4248_6E34, 0x1442_D779),
    (r"textures\tx_shrine_statue2__fronttorso.dds", 0x4248_6E34, 0xCF94_7960),
    (r"textures\tx_shrine_statue2__upperleg.dds", 0x4248_6E40, 0x03F6_7A40),
    (r"textures\tx_shrine_statue2__lowerleg.dds", 0x4248_6E40, 0x10DD_D9AD),
    (r"textures\tx_shrine_statue1_backtorso.dds", 0x4248_6E40, 0x3F54_631F),
    (r"textures\tx_shrine_statue1_fronttorso.dds", 0x4248_6E40, 0x99E2_D22E),
    (r"textures\tx_shrine_statue2__backskirt.dds", 0x4248_6E40, 0xFAB8_5417),
    (r"icons\m\tx_paper_roll_01.dds", 0x425D_370F, 0x0BCA_7BAD),
    (r"textures\tx_ingred_horn_lily_bulb_01.dds", 0x425D_6951, 0x490E_73E7),
    (r"icons\w\tx_w_goblin_shield.dds", 0x4528_2031, 0xB7CF_FF93),
    (r"icons\w\tx_w_stendarshammer.dds", 0x4533_3431, 0x9959_8B1A),
    (r"icons\w\tx_w_goblin_sword.dds", 0x4547_2031, 0x1DA1_FCFF),
    (r"icons\w\tx_w_goblin_club.dds", 0x4547_2031, 0xAB3E_4B54),
    (r"icons\w\tx_w_adtium_mace.dds", 0x4547_2631, 0x17C6_FCBE),
    (r"icons\w\tx_w_adtium_spear.dds", 0x4547_2631, 0x55FD_D76C),
    (r"icons\w\tx_w_nerevarblade.dds", 0x4547_2931, 0xC08F_B41C),
    (r"icons\w\tx_w_adtium_axe.dds", 0x4547_4731, 0x6196_B66A),
    (r"textures\tx_menubook_quests_active_pressed.dds", 0x4611_180D, 0xEF1E_CCD7),
    (r"icons\n\tx_timsa-come-by_01.dds", 0x462D_2A07, 0xCFCD_24FD),
    (r"textures\tx_menubook_quests_active_over.dds", 0x4664_690D, 0x3F47_2528),
    (r"textures\tx_menubook_quests_all_pressed.dds", 0x4664_690D, 0x4C6A_B2D2),
    (r"textures\tx_menubook_quests_active_idle.dds", 0x4664_690D, 0x5AB9_8C32),
    (r"textures\tx_menubook_quests_all_idle.dds", 0x4664_6952, 0x71DD_ECFE),
    (r"textures\tx_menubook_quests_all_over.dds", 0x4664_6952, 0x9595_ADD0),
    (r"textures\tx_menubook_options_pressed.dds", 0x4664_6952, 0x95B0_9AC4),
    (r"icons\s\b_tx_s_smmn_fabrict.dds", 0x4A37_1327, 0x697A_C941),
    (r"meshes\x\ex_mh_palace_gate.nif", 0x4F08_1B39, 0x0344_C66C),
    (r"meshes\x\ex_mh_lantern_post.nif", 0x4F08_1B39, 0x093C_BA20),
    (r"meshes\x\ex_mh_temple_base.nif", 0x4F08_1B39, 0x0A58_B9A5),
    (r"meshes\x\ex_mh_wall_gate_01.nif", 0x4F08_1B39, 0x15EA_DF56),
    (r"meshes\x\ex_mh_doorjamb_03.nif", 0x4F08_1B39, 0x15FB_1AC3),
    (r"meshes\x\ex_mh_doorjamb_02.nif", 0x4F08_1B39, 0x15FB_1AC7),
    (r"meshes\x\ex_mh_doorjamb_01.nif", 0x4F08_1B39, 0x15FB_1ACB),
    (r"meshes\x\ex_mh_temple_door.nif", 0x4F08_1B39, 0x291D_CEA0),
    (r"meshes\x\ex_mh_building_01.nif", 0x4F08_1B39, 0x319B_9C83),
    (r"meshes\x\ex_mh_building_03.nif", 0x4F08_1B39, 0x319B_9C8B),
    (r"meshes\x\ex_mh_building_02.nif", 0x4F08_1B39, 0x319B_9C8F),
    (r"meshes\x\ex_mh_building_05.nif", 0x4F08_1B39, 0x319B_9C93),
    (r"meshes\x\ex_mh_building_04.nif", 0x4F08_1B39, 0x319B_9C97),
    (r"meshes\x\ex_mh_building_07.nif", 0x4F08_1B39, 0x319B_9C9B),
    (r"meshes\x\ex_mh_building_06.nif", 0x4F08_1B39, 0x319B_9C9F),
    (r"meshes\x\ex_mh_building_09.nif", 0x4F08_1B39, 0x319B_9CA3),
    (r"meshes\x\ex_mh_building_08.nif", 0x4F08_1B39, 0x319B_9CA7),
    (r"meshes\x\ex_mh_building_10.nif", 0x4F08_1B39, 0x359B_9C87),
    (r"meshes\x\ex_mh_palacewin_02.nif", 0x4F08_1B39, 0x4F9F_32E1),
    (r"meshes\x\ex_mh_palacewin_03.nif", 0x4F08_1B39, 0x4F9F_36E1),
    (r"meshes\x\ex_mh_palacewin_01.nif", 0x4F08_1B39, 0x4F9F_3EE1),
    (r"meshes\x\ex_mh_palace_tower.nif", 0x4F08_1B39, 0x7937_ED8D),
    (r"meshes\x\ex_mh_platform_01.nif", 0x4F08_1B39, 0x96A9_74D5),
    (r"meshes\x\ex_mh_platform_02.nif", 0x4F08_1B39, 0x96A9_74D9),
    (r"meshes\x\ex_mh_platform_03.nif", 0x4F08_1B39, 0x96A9_74DD),
    (r"meshes\x\ex_mh_pav_fountain.nif", 0x4F08_1B39, 0x9F12_8A19),
    (r"meshes\x\ex_mh_bazaar_stage.nif", 0x4F08_1B39, 0xC228_6B2F),
    (r"meshes\x\ex_mh_bazaar_tent.nif", 0x4F08_1B39, 0xF185_E04D),
    (r"meshes\x\ex_mh_pav_walk_s.nif", 0x4F57_1B39, 0x2C15_840D),
    (r"meshes\x\ex_mh_pav_walk_n.nif", 0x4F57_1B39, 0x2C15_8479),
    (r"meshes\x\ex_mh_pav_spout.nif", 0x4F57_1B39, 0x3A7D_3BE4),
    (r"meshes\x\ex_mh_pav_tower.nif", 0x4F57_1B39, 0x6229_1F8F),
    (r"meshes\x\ex_mh_pav_steps.nif", 0x4F57_1B39, 0x6FFE_287D),
    (r"meshes\x\ex_mh_pav_ladder.nif", 0x4F57_1B39, 0x76B7_72E1),
    (r"meshes\x\ex_mh_window_01.nif", 0x4F57_1B39, 0x7C4B_57E4),
    (r"meshes\x\ex_mh_window_03.nif", 0x4F57_1B39, 0x7C4B_57E5),
    (r"meshes\x\ex_mh_pav_crack.nif", 0x4F57_1B39, 0x9EAF_AA3D),
    (r"meshes\x\ex_mh_pav_land_e.nif", 0x4F57_1B39, 0x9EB7_703D),
    (r"meshes\x\ex_mh_pav_land_w.nif", 0x4F57_1B39, 0x9EB7_7075),
    (r"meshes\x\ex_mh_wall_02.nif", 0x4F57_7339, 0x065E_FF7F),
    (r"meshes\x\ex_mh_road_01.nif", 0x4F57_7339, 0x5532_BBDE),
    (r"meshes\x\ex_mh_road_03.nif", 0x4F57_7339, 0x6A80_7960),
    (r"meshes\x\ex_mh_steps_01.nif", 0x4F57_7339, 0x7CC2_14A3),
    (r"meshes\x\ex_mh_road_02.nif", 0x4F57_7339, 0x7FEE_3A0A),
    (r"meshes\x\ex_mh_door_01.nif", 0x4F57_7339, 0x9B5C_4BA4),
    (r"meshes\x\ex_mh_wall_01.nif", 0x4F57_7339, 0xA653_3134),
    (r"meshes\x\ex_mh_pav_top.nif", 0x4F57_7339, 0xBFB8_EE01),
    (r"meshes\x\ex_mh_bar_01.nif", 0x4F57_7354, 0x1029_BBB8),
    (r"meshes\x\ex_mh_temple.nif", 0x4F57_7354, 0x5D6D_4183),
    (r"icons\w\tx_bipolar_blade.dds", 0x5047_3707, 0x9CC6_87EC),
    (r"icons\m\misc_dwe_satchel00.dds", 0x5106_3228, 0x556B_3799),
    (r"icons\c\tx_common2_cuirass.dds", 0x513E_2A01, 0x2A58_F4F3),
    (r"icons\c\tx_common1_cuirass.dds", 0x513E_2A01, 0x2A58_F7F3),
    (r"icons\c\tx_common2_greaves.dds", 0x513E_2A01, 0xB43E_F8FD),
    (r"icons\c\tx_common1_greaves.dds", 0x513E_2A01, 0xB43F_78FD),
    (r"icons\c\tx_common2_shoes.dds", 0x5153_2A01, 0xABC4_2660),
    (r"icons\c\tx_common1_shoes.dds", 0x5153_2A01, 0xABC7_2660),
    (r"icons\c\tx_common2_skirt.dds", 0x5153_2A01, 0xD8F5_A46B),
    (r"icons\c\tx_common1_skirt.dds", 0x5153_2A01, 0xD8F5_A473),
    (r"icons\c\tx_c_liche_robe.dds", 0x5153_4731, 0xE352_8846),
    (r"meshes\d\ex_mh_wall_gate_01.nif", 0x5308_1B39, 0x15EA_DF56),
    (r"meshes\d\ex_mh_doorjamb_02.nif", 0x5308_1B39, 0x15FB_1AC7),
    (r"meshes\d\ex_mh_doorjamb_01.nif", 0x5308_1B39, 0x15FB_1ACB),
    (r"meshes\d\in_mh_jaildoor_01.nif", 0x531E_1739, 0x0B97_79CB),
    (r"meshes\d\in_mh_trapdoor_01.nif", 0x531E_1739, 0xA217_7A8C),
    (r"meshes\d\in_db_door_oval_02.nif", 0x531E_1D30, 0x70FD_D140),
    (r"meshes\d\in_m_sewer_door_01.nif", 0x5332_2039, 0xC174_200B),
    (r"meshes\d\in_m_sewer_door_02.nif", 0x5332_2039, 0xC174_2C0B),
    (r"icons\a\tx_almindoril_boots.dds", 0x5338_2A02, 0x78E9_973B),
    (r"icons\a\tx_adamantium_helm.dds", 0x533C_260A, 0x55F0_2467),
    (r"icons\a\tx_adamantium_boots.dds", 0x533C_260A, 0xC6B7_B8F7),
    (r"meshes\d\in_om_door_round.nif", 0x5341_123B, 0x6F16_F804),
    (r"meshes\d\in_db_door_oval.nif", 0x5341_1D30, 0x1A1C_A627),
    (r"meshes\d\in_mh_door_02.nif", 0x5341_7F39, 0x18D9_4237),
    (r"meshes\d\in_mh_door_01.nif", 0x5341_7F39, 0x9B5C_4BA4),
    (r"meshes\d\in_db_door01.nif", 0x5341_7F54, 0xD9EA_A750),
    (r"meshes\d\ex_mh_door_02.nif", 0x5357_7339, 0x18D9_4237),
    (r"icons\n\tx_adamantium.dds", 0x535E_476E, 0x7507_9D54),
    (r"icons\m\tx_fabricant_elixir.dds", 0x542F_250F, 0x37E8_2351),
    (r"icons\n\tx_golden_sedge_01.dds", 0x553A_2B01, 0xC867_C4E3),
    (r"icons\n\tx_durzog_meat_01.dds", 0x565E_351B, 0xDDF1_04CA),
    (r"icons\a\a_nerevar_b_shield.dds", 0x5716_0509, 0x9FC3_C98D),
    (r"icons\w\tx_ebony_scimitar.dds", 0x5747_280C, 0x7312_1A11),
    (r"textures\tx_dwe_weat_foggy.dds", 0x5800_1439, 0x6CB3_F129),
    (r"textures\tx_dwe_weat_cloudy.dds", 0x5800_1439, 0x7F22_4A58),
    (r"textures\tx_dwe_weat_rainy.dds", 0x5800_1439, 0x896D_4291),
    (r"textures\tx_dwe_studplate00.dds", 0x5800_1439, 0x9652_6913),
    (r"textures\tx_dwe_weat_clear.dds", 0x5800_1439, 0xFB09_CDEA),
    (r"textures\tx_w_goblin_sword.dds", 0x5802_3C2A, 0x1DA1_FCFF),
    (r"textures\tx_w_goblin_shield.dds", 0x5802_3C2A, 0x722E_B472),
    (r"textures\tx_weapon_stendar.dds", 0x5804_062A, 0xC537_C909),
    (r"textures\tx_planter_relief.dds", 0x5804_0F2D, 0x9429_5CAA),
    (r"textures\tx_brassmech_arch.dds", 0x5804_113F, 0x8EBD_9A01),
    (r"textures\tx_swampycopper02.dds", 0x5804_142E, 0xF851_0510),
    (r"textures\tx_swampycopper03.dds", 0x5804_142E, 0xF851_1510),
    (r"textures\tx_swampycopper00.dds", 0x5804_142E, 0xF851_2510),
    (r"textures\tx_swampycopper01.dds", 0x5804_142E, 0xF851_3510),
    (r"textures\tx_w_adtium_spear.dds", 0x5804_3C2A, 0x55FD_D76C),
    (r"textures\tx_a_adamantium_c.dds", 0x5804_3C3C, 0xBA79_2992),
    (r"textures\tx_a_adamantium_g.dds", 0x5804_3C3C, 0xBA79_6992),
    (r"textures\tx_a_almindoril_g.dds", 0x5804_3C3C, 0xBB2F_3E0E),
    (r"textures\tx_a_almindoril_c.dds", 0x5804_3C3C, 0xBB2F_7E0E),
    (r"textures\tx_a_almindoril_ul.dds", 0x5804_3C3C, 0xF1E3_BB5E),
    (r"textures\tx_goblinweapon01.dds", 0x5807_0C3A, 0x0619_2639),
    (r"textures\tx_goblinweapon00.dds", 0x5807_0C3A, 0x0619_3639),
    (r"textures\tx_goblinccloth00.dds", 0x5807_0C3A, 0x56D1_EAAC),
    (r"textures\tx_w_bipolar_blade.dds", 0x5807_3C2A, 0x7DEF_66A2),
    (r"textures\tx_c_mournhold_acc.dds", 0x5808_3C3E, 0xEE8D_899B),
    (r"textures\tx_c_mournhold_arm.dds", 0x5808_3C3E, 0xEE8D_B1DF),
    (r"textures\tx_velothi_door_02.dds", 0x5809_062B, 0xB3DF_200D),
    (r"textures\tx_velothi_door_01.dds", 0x5809_062B, 0xB3DF_2C0D),
    (r"textures\tx_velothi_door_04.dds", 0x5809_062B, 0xB3DF_380D),
    (r"textures\tx_stl_cop_pipe00.dds", 0x5809_172E, 0x9158_3CDD),
    (r"textures\tx_eroded_stone03.dds", 0x580A_1138, 0x8661_37ED),
    (r"textures\tx_eroded_stone04.dds", 0x580A_1138, 0x8661_47ED),
    (r"textures\tx_banner_stage_01.dds", 0x580B_023F, 0xEC2B_25B8),
    (r"textures\tx_concrete_trim2.dds", 0x580B_0C3E, 0xE541_946D),
    (r"textures\tx_w_nerevarblade.dds", 0x580B_3C2A, 0xC08F_B41C),
    (r"textures\tx_b_n_helsethhair.dds", 0x580B_3C3F, 0x40FE_3EB0),
    (r"textures\tx_b_n_helsethhead.dds", 0x580B_3C3F, 0x50FE_6690),
    (r"textures\tx_spherearcher_00.dds", 0x580D_132E, 0x3628_95EA),
    (r"textures\tx_a_helseth_boota.dds", 0x580D_3C3C, 0x6B1D_0413),
    (r"textures\tx_mournhold_shoes.dds", 0x5810_0C30, 0xA991_33C3),
    (r"textures\tx_metal_strip_02.dds", 0x5811_0630, 0x1245_E0AB),
    (r"textures\tx_pit_concrete03.dds", 0x5811_0A2D, 0x4DFC_8349),
    (r"textures\tx_pit_concrete02.dds", 0x5811_0A2D, 0x4DFC_9349),
    (r"textures\tx_pit_concrete01.dds", 0x5811_0A2D, 0x4DFC_A349),
    (r"textures\tx_pit_concrete00.dds", 0x5811_0A2D, 0x4DFC_B349),
    (r"textures\tx_pit_concrete05.dds", 0x5811_0A2D, 0x4DFC_E349),
    (r"textures\tx_pit_concrete04.dds", 0x5811_0A2D, 0x4DFC_F349),
    (r"textures\tx_sotha sil_var1.dds", 0x5811_0C2E, 0xCC86_E4C4),
    (r"textures\tx_rawsteel_oil00.dds", 0x5812_022F, 0x4B4D_48AF),
    (r"textures\tx_rawsteel_oil01.dds", 0x5812_022F, 0x4B4D_58AF),
    (r"textures\tx_rawsteel_trim01.dds", 0x5812_022F, 0xA3CF_10A8),
    (r"textures\tx_rawsteel_trim00.dds", 0x5812_022F, 0xA3CF_14A8),
    (r"textures\tx_copper_inset00.dds", 0x5815_0C3E, 0x9E7F_21D7),
    (r"textures\tx_m_sewer_wall_01.dds", 0x5816_3C30, 0x253A_D5F7),
    (r"textures\tx_m_sewer_wall_02.dds", 0x5816_3C30, 0x253A_D9F7),
    (r"textures\tx_m_sewer_pipe_01.dds", 0x5816_3C30, 0x7C07_1855),
    (r"textures\tx_m_sewer_trim_02.dds", 0x5816_3C30, 0xB8CF_F67A),
    (r"textures\tx_m_sewer_trim_01.dds", 0x5816_3C30, 0xB8CF_FA7A),
    (r"textures\tx_m_sewer_door_02.dds", 0x5816_3C30, 0xD479_260B),
    (r"textures\tx_m_sewer_door_01.dds", 0x5816_3C30, 0xD479_2A0B),
    (r"textures\tx_scraped_metal02.dds", 0x5817_002E, 0xD8A1_D59E),
    (r"textures\tx_scraped_metal01.dds", 0x5817_002E, 0xD8A1_D99E),
    (r"textures\tx_scraped_metal00.dds", 0x5817_002E, 0xD8A1_DD9E),
    (r"textures\tx_shrine_amalexia.dds", 0x5817_0B2E, 0xE897_5A97),
    (r"textures\tx_durzog_meat_01.dds", 0x5817_1639, 0xDDF1_04CA),
    (r"textures\tx_streetlamp_foot.dds", 0x5817_172E, 0x6A20_C269),
    (r"textures\tx_streetlamp_rail.dds", 0x5817_172E, 0x8A97_8A66),
    (r"textures\tx_streetlamp_base.dds", 0x5817_172E, 0xA80E_8C87),
    (r"textures\tx_streetlamp_tray.dds", 0x5817_172E, 0xE48F_1674),
    (r"textures\tx_streetlamp_cap.dds", 0x5817_172E, 0xE66E_F6A9),
    (r"textures\tx_m_ruins_trim_07.dds", 0x5817_3C30, 0xFAE2_62B0),
    (r"textures\tx_m_ruins_trim_06.dds", 0x5817_3C30, 0xFAE2_66B0),
    (r"textures\tx_m_ruins_trim_04.dds", 0x5817_3C30, 0xFAE2_6EB0),
    (r"textures\tx_mh_deadbark_01.dds", 0x583A_0B30, 0x8EDD_3006),
    (r"textures\tx_mh_rusty_grate.dds", 0x583A_0B30, 0x98B9_DC58),
    (r"textures\tx_mh_water_spray.dds", 0x583A_0B30, 0xFD8C_4F58),
    (r"textures\tx_om_stone_carve.dds", 0x583A_0E32, 0x03CA_764E),
    (r"textures\tx_tall_grass_01.dds", 0x5865_0229, 0x579D_8821),
    (r"textures\tx_waterfall_01.dds", 0x5865_022A, 0x29AA_9ED3),
    (r"textures\tx_waterfall_02.dds", 0x5865_022A, 0x29AA_9EE3),
    (r"textures\tx_sand_mosaic02.dds", 0x5865_022E, 0x19D3_3853),
    (r"textures\tx_cart_clothcap.dds", 0x5865_023E, 0xFAC9_06A0),
    (r"textures\tx_banner_imp_01.dds", 0x5865_023F, 0x706A_81BA),
    (r"textures\tx_temple_carve.dds", 0x5865_0629, 0xDC22_6779),
    (r"textures\tx_sewer_trim_03.dds", 0x5865_062E, 0x4A2B_91F3),
    (r"textures\tx_sewer_wall_02.dds", 0x5865_062E, 0x73BF_16FA),
    (r"textures\tx_sewer_wall_01.dds", 0x5865_062E, 0x73BF_26FA),
    (r"textures\tx_metal_silver.dds", 0x5865_0630, 0x024B_B527),
    (r"textures\tx_tile_broken02.dds", 0x5865_0A29, 0xBF02_280B),
    (r"textures\tx_tile_broken03.dds", 0x5865_0A29, 0xBF02_380B),
    (r"textures\tx_tile_broken04.dds", 0x5865_0A29, 0xBF02_480B),
    (r"textures\tx_bizarre_tent.dds", 0x5865_0A3F, 0xB566_C7FF),
    (r"textures\tx_mh_door_burnt.dds", 0x5865_0B30, 0x0786_8457),
    (r"textures\tx_mh_temple_15.dds", 0x5865_0B30, 0x1E48_310B),
    (r"textures\tx_mh_temple_14.dds", 0x5865_0B30, 0x1E48_311B),
    (r"textures\tx_mh_temple_17.dds", 0x5865_0B30, 0x1E48_312B),
    (r"textures\tx_mh_temple_16.dds", 0x5865_0B30, 0x1E48_313B),
    (r"textures\tx_mh_temple_11.dds", 0x5865_0B30, 0x1E48_314B),
    (r"textures\tx_mh_temple_10.dds", 0x5865_0B30, 0x1E48_315B),
    (r"textures\tx_mh_temple_13.dds", 0x5865_0B30, 0x1E48_316B),
    (r"textures\tx_mh_temple_12.dds", 0x5865_0B30, 0x1E48_317B),
    (r"textures\tx_mh_temple_19.dds", 0x5865_0B30, 0x1E48_31CB),
    (r"textures\tx_mh_leaves_02.dds", 0x5865_0B30, 0x4209_CC8A),
    (r"textures\tx_mh_leaves_01.dds", 0x5865_0B30, 0x4209_CCBA),
    (r"textures\tx_mh_window_01.dds", 0x5865_0B30, 0x59C6_4F8F),
    (r"textures\tx_mh_ceiling_02.dds", 0x5865_0B30, 0x69D9_58E7),
    (r"textures\tx_mh_ceiling_01.dds", 0x5865_0B30, 0x69D9_68E7),
    (r"textures\tx_mh_streetlamp.dds", 0x5865_0B30, 0xBF2B_5CE1),
    (r"textures\tx_mh_temple_20.dds", 0x5865_0B30, 0xEA47_CCA8),
    (r"textures\tx_mh_temple_21.dds", 0x5865_0B30, 0xEA47_CCB8),
    (r"textures\tx_mh_temple_09.dds", 0x5865_0B30, 0xF657_C22C),
    (r"textures\tx_mh_temple_08.dds", 0x5865_0B30, 0xF657_C23C),
    (r"textures\tx_mh_temple_03.dds", 0x5865_0B30, 0xF657_C28C),
    (r"textures\tx_mh_temple_02.dds", 0x5865_0B30, 0xF657_C29C),
    (r"textures\tx_mh_temple_01.dds", 0x5865_0B30, 0xF657_C2AC),
    (r"textures\tx_mh_temple_07.dds", 0x5865_0B30, 0xF657_C2CC),
    (r"textures\tx_mh_temple_06.dds", 0x5865_0B30, 0xF657_C2DC),
    (r"textures\tx_mh_temple_05.dds", 0x5865_0B30, 0xF657_C2EC),
    (r"textures\tx_mh_temple_04.dds", 0x5865_0B30, 0xF657_C2FC),
    (r"textures\tx_wood_wethered.dds", 0x5865_0C2A, 0x1368_676D),
    (r"textures\tx_wood_oldwood.dds", 0x5865_0C2A, 0x75CD_B070),
    (r"textures\tx_poison_steam.dds", 0x5865_0C2D, 0xB8C7_C178),
    (r"textures\tx_sotha_floor00.dds", 0x5865_0C2E, 0x0943_28DE),
    (r"textures\tx_sotha_armor00.dds", 0x5865_0C2E, 0x3B09_6C05),
    (r"textures\tx_sotha_armor01.dds", 0x5865_0C2E, 0x3B09_7C05),
    (r"textures\tx_sotha_steps01.dds", 0x5865_0C2E, 0x94AF_486C),
    (r"textures\tx_sotha_steps00.dds", 0x5865_0C2E, 0x94AF_586C),
    (r"textures\tx_sotha_steps02.dds", 0x5865_0C2E, 0x94AF_786C),
    (r"textures\tx_sotha_green00.dds", 0x5865_0C2E, 0xAD1F_CDF0),
    (r"textures\tx_rough_rubber.dds", 0x5865_0C2F, 0x198A_4B57),
    (r"textures\tx_goblin_2skin.dds", 0x5865_0C3A, 0x1177_28E9),
    (r"textures\tx_coilcopper02.dds", 0x5865_0C3E, 0x14FF_A1C7),
    (r"textures\tx_coilcopper00.dds", 0x5865_0C3E, 0x14FF_A1E7),
    (r"textures\tx_coilcopper01.dds", 0x5865_0C3E, 0x14FF_A1F7),
    (r"textures\tx_copperpipe00.dds", 0x5865_0C3E, 0x47F0_C156),
    (r"textures\tx_concrete_trim.dds", 0x5865_0C3E, 0xE219_49DF),
    (r"textures\tx_booth_fabric.dds", 0x5865_0C3F, 0x8385_CDD3),
    (r"textures\tx_smokealpha00a.dds", 0x5865_0E2E, 0xA42D_1A7C),
    (r"textures\tx_om_door_burnt.dds", 0x5865_0E32, 0x0786_8457),
    (r"textures\tx_om_tile_stone.dds", 0x5865_0E32, 0x400C_0704),
    (r"textures\tx_om_door_oval.dds", 0x5865_0E32, 0x9338_77E3),
    (r"textures\tx_planter_trim.dds", 0x5865_0F2D, 0x77E1_DAF1),
    (r"textures\tx_planter_dirt.dds", 0x5865_0F2D, 0x95DA_298D),
    (r"textures\tx_planter_base.dds", 0x5865_0F2D, 0xA38E_C9A3),
    (r"textures\tx_eroded_stone.dds", 0x5865_1138, 0xE8B6_BCD6),
    (r"textures\tx_grey_stone01.dds", 0x5865_113A, 0xD7EA_C939),
    (r"textures\tx_greenstone01.dds", 0x5865_113A, 0xD7EA_F825),
    (r"textures\tx_brownstone02.dds", 0x5865_113F, 0xD4C2_2607),
    (r"textures\tx_sweetpulp_01.dds", 0x5865_142E, 0xFBAD_AFD3),
    (r"textures\tx_dwrv_rubber00.dds", 0x5865_1439, 0x05B7_E6ED),
    (r"textures\tx_dwe_mosaic00.dds", 0x5865_1439, 0x30DF_4C8E),
    (r"textures\tx_dwe_satchel00.dds", 0x5865_1439, 0x556B_3799),
    (r"textures\tx_dwe_weat_ash.dds", 0x5865_1439, 0x8FF5_1109),
    (r"textures\tx_dwe_stucco01.dds", 0x5865_1439, 0xCB5F_AF4F),
    (r"textures\tx_dwe_stucco00.dds", 0x5865_1439, 0xCB5F_AF5F),
    (r"textures\tx_dwe_stucco02.dds", 0x5865_1439, 0xCB5F_AF7F),
    (r"textures\tx_dwe_column00.dds", 0x5865_1439, 0xD672_C98F),
    (r"textures\tx_dwe_weat_none.dds", 0x5865_1439, 0xD9EE_FBFA),
    (r"textures\tx_steel_inset02.dds", 0x5865_172E, 0x0A48_01D6),
    (r"textures\tx_steel_inset03.dds", 0x5865_172E, 0x0A48_11D6),
    (r"textures\tx_steel_inset10.dds", 0x5865_172E, 0x0A48_21C6),
    (r"textures\tx_steel_inset00.dds", 0x5865_172E, 0x0A48_21D6),
    (r"textures\tx_steel_inset11.dds", 0x5865_172E, 0x0A48_31C6),
    (r"textures\tx_steel_inset01.dds", 0x5865_172E, 0x0A48_31D6),
    (r"textures\tx_steel_inset06.dds", 0x5865_172E, 0x0A48_41D6),
    (r"textures\tx_steel_inset07.dds", 0x5865_172E, 0x0A48_51D6),
    (r"textures\tx_steel_inset04.dds", 0x5865_172E, 0x0A48_61D6),
    (r"textures\tx_steel_inset05.dds", 0x5865_172E, 0x0A48_71D6),
    (r"textures\tx_steel_inset08.dds", 0x5865_172E, 0x0A48_A1D6),
    (r"textures\tx_steel_inset09.dds", 0x5865_172E, 0x0A48_B1D6),
    (r"textures\tx_stone_wall_02.dds", 0x5865_172E, 0x41C6_56FA),
    (r"textures\tx_stone_base03.dds", 0x5865_172E, 0x9DE8_1F1F),
    (r"textures\tx_stone_base06.dds", 0x5865_172E, 0x9DE8_1F4F),
    (r"textures\tx_stone_base_07.dds", 0x5865_172E, 0xBCC3_A05E),
    (r"textures\tx_steelspike00.dds", 0x5865_172E, 0xC567_5007),
    (r"textures\tx_w_adtium_mace.dds", 0x5865_3C2A, 0x14E6_D827),
    (r"textures\tx_w_goblin_club.dds", 0x5865_3C2A, 0x1DCE_94D8),
    (r"textures\tx_w_adtium_axe.dds", 0x5865_3C2A, 0x6196_B66A),
    (r"textures\tx_a_helseth_ul.dds", 0x5865_3C3C, 0x9FC9_3AFD),
    (r"textures\tx_c_mournhold_g.dds", 0x5865_3C3E, 0x5344_C75A),
    (r"textures\tx_c_robeofliche.dds", 0x5865_3C3E, 0x7FFA_57DF),
    (r"textures\tx_c_new_common1.dds", 0x5865_3C3E, 0xD2E8_1230),
    (r"textures\tx_c_new_common2.dds", 0x5865_3C3E, 0xD2E8_2230),
    (r"textures\tx_c_robe_white.dds", 0x5865_3C3E, 0xD3EB_5FF5),
    (r"textures\tx_terra_tile.dds", 0x5865_6329, 0x085E_B172),
    (r"textures\tx_tiles_blue.dds", 0x5865_6329, 0x2374_B776),
    (r"textures\tx_temple_trim.dds", 0x5865_6329, 0xA650_9768),
    (r"textures\tx_tile_broken.dds", 0x5865_6329, 0xF8BA_5EF2),
    (r"textures\tx_wax_tan_01.dds", 0x5865_632A, 0x1969_61AD),
    (r"textures\tx_wood_burnt.dds", 0x5865_632A, 0xDC3D_5551),
    (r"textures\tx_sothasilgod.dds", 0x5865_632E, 0x06E9_A07A),
    (r"textures\tx_sotha_panel.dds", 0x5865_632E, 0x2B94_130A),
    (r"textures\tx_stone_base.dds", 0x5865_632E, 0x36F2_B735),
    (r"textures\tx_steelgrid00.dds", 0x5865_632E, 0x5D25_3AAD),
    (r"textures\tx_steelgrid01.dds", 0x5865_632E, 0x5D25_3ABD),
    (r"textures\tx_sludgehound.dds", 0x5865_632E, 0xD4B3_C2DE),
    (r"textures\tx_sotha_red00.dds", 0x5865_632E, 0xDFEA_7A76),
    (r"textures\tx_sandstone03.dds", 0x5865_632E, 0xE442_F20E),
    (r"textures\tx_sandstone02.dds", 0x5865_632E, 0xE442_F21E),
    (r"textures\tx_rawsteel00.dds", 0x5865_632F, 0xD637_935D),
    (r"textures\tx_mh_dome_02.dds", 0x5865_6330, 0x0397_D67C),
    (r"textures\tx_mh_wall_04.dds", 0x5865_6330, 0x0643_537A),
    (r"textures\tx_mh_trim_06.dds", 0x5865_6330, 0x090C_05A7),
    (r"textures\tx_mh_bark_01.dds", 0x5865_6330, 0x1FB6_521A),
    (r"textures\tx_mh_brick_01.dds", 0x5865_6330, 0x2363_6EA8),
    (r"textures\tx_mh_wall_06.dds", 0x5865_6330, 0x242D_2371),
    (r"textures\tx_mh_wall_09.dds", 0x5865_6330, 0x3102_0573),
    (r"textures\tx_mh_roof_02.dds", 0x5865_6330, 0x31BA_67CA),
    (r"textures\tx_mh_trim_07.dds", 0x5865_6330, 0x43EF_5819),
    (r"textures\tx_mh_grass_01.dds", 0x5865_6330, 0x4B8A_9D32),
    (r"textures\tx_mh_wall_07.dds", 0x5865_6330, 0x557F_CB72),
    (r"textures\tx_mh_trim_08.dds", 0x5865_6330, 0x673E_F6C6),
    (r"textures\tx_mh_trim_02.dds", 0x5865_6330, 0x69E8_FE34),
    (r"textures\tx_mh_trim_01.dds", 0x5865_6330, 0x6D83_49FD),
    (r"textures\tx_mh_floor_01.dds", 0x5865_6330, 0x803D_5E0C),
    (r"textures\tx_mh_floor_02.dds", 0x5865_6330, 0x803D_5E3C),
    (r"textures\tx_mh_wall_03.dds", 0x5865_6330, 0x9ED4_1361),
    (r"textures\tx_mh_trim_05.dds", 0x5865_6330, 0x9F4A_BEDB),
    (r"textures\tx_mh_trim_04.dds", 0x5865_6330, 0xB2C7_C822),
    (r"textures\tx_mh_dome_01.dds", 0x5865_6330, 0xB97D_196D),
    (r"textures\tx_mh_wall_02.dds", 0x5865_6330, 0xBBFA_9356),
    (r"textures\tx_mh_wall_05.dds", 0x5865_6330, 0xC508_F377),
    (r"textures\tx_mh_wall_01.dds", 0x5865_6330, 0xC9A7_9338),
    (r"textures\tx_mh_wall_08.dds", 0x5865_6330, 0xEC76_BF73),
    (r"textures\tx_mh_metal_02.dds", 0x5865_6330, 0xF45C_F88F),
    (r"textures\tx_mh_metal_03.dds", 0x5865_6330, 0xF45C_F89F),
    (r"textures\tx_mh_metal_01.dds", 0x5865_6330, 0xF45C_F8BF),
    (r"textures\tx_mh_metal_04.dds", 0x5865_6330, 0xF45C_F8EF),
    (r"textures\tx_mh_trim_09.dds", 0x5865_6330, 0xF4A6_21A9),
    (r"textures\tx_mh_trim_03.dds", 0x5865_6330, 0xF7DD_25D0),
    (r"textures\tx_leadtrim00.dds", 0x5865_6331, 0xA0C8_4B49),
    (r"textures\tx_oldcopper04.dds", 0x5865_6332, 0x17DB_A127),
    (r"textures\tx_oldcopper02.dds", 0x5865_6332, 0x17DB_A147),
    (r"textures\tx_oldcopper03.dds", 0x5865_6332, 0x17DB_A157),
    (r"textures\tx_oldcopper00.dds", 0x5865_6332, 0x17DB_A167),
    (r"textures\tx_oldcopper01.dds", 0x5865_6332, 0x17DB_A177),
    (r"textures\tx_dwe_wall05.dds", 0x5865_6339, 0x0045_AF25),
    (r"textures\tx_dwrv_wall40.dds", 0x5865_6339, 0x12CD_1A87),
    (r"textures\tx_dirt_tiled.dds", 0x5865_6339, 0x1391_DAC8),
    (r"textures\tx_dwe_trim03.dds", 0x5865_6339, 0x1684_AB5C),
    (r"textures\tx_dwrv_wall80.dds", 0x5865_6339, 0x530A_686E),
    (r"textures\tx_dirt_floor.dds", 0x5865_6339, 0x5A78_6961),
    (r"textures\tx_dwe_paint00.dds", 0x5865_6339, 0x5C8A_9CC2),
    (r"textures\tx_dwe_steel00.dds", 0x5865_6339, 0x6462_C94B),
    (r"textures\tx_dwe_trim00.dds", 0x5865_6339, 0x7F98_5208),
    (r"textures\tx_dirt_carve.dds", 0x5865_6339, 0x8921_4597),
    (r"textures\tx_dwe_wall03.dds", 0x5865_6339, 0x8BE1_622A),
    (r"textures\tx_dark_lead01.dds", 0x5865_6339, 0x8F7A_E40C),
    (r"textures\tx_dark_lead00.dds", 0x5865_6339, 0x8F7A_E41C),
    (r"textures\tx_dwe_wall02.dds", 0x5865_6339, 0x9190_71C0),
    (r"textures\tx_dwe_wall00.dds", 0x5865_6339, 0x94B6_19BC),
    (r"textures\tx_dwe_wall01.dds", 0x5865_6339, 0x9D72_5614),
    (r"textures\tx_dwe_trim05.dds", 0x5865_6339, 0xA71C_DD78),
    (r"textures\tx_dwe_trim02.dds", 0x5865_6339, 0xAB5B_E32D),
    (r"textures\tx_dwe_brick00.dds", 0x5865_6339, 0xB958_E89D),
    (r"textures\tx_dwe_trim04.dds", 0x5865_6339, 0xC26B_0F64),
    (r"textures\tx_dwe_tile01.dds", 0x5865_6339, 0xCD83_98B3),
    (r"textures\tx_dwe_floor00.dds", 0x5865_6339, 0xD6EE_1C4C),
    (r"textures\tx_dwe_trim01.dds", 0x5865_6339, 0xE8E5_73CE),
    (r"textures\tx_dwe_gyro00.dds", 0x5865_6339, 0xF63B_355C),
    (r"textures\tx_dwe_metal03.dds", 0x5865_6339, 0xFEC4_2446),
    (r"textures\tx_dwe_metal02.dds", 0x5865_6339, 0xFEC4_2456),
    (r"textures\tx_dwe_metal01.dds", 0x5865_6339, 0xFEC4_2466),
    (r"textures\tx_dwe_metal00.dds", 0x5865_6339, 0xFEC4_2476),
    (r"textures\tx_dwrv_lens00.dds", 0x5865_6339, 0xFF67_0B5C),
    (r"textures\tx_grey_stone.dds", 0x5865_633A, 0x44D1_E55E),
    (r"textures\tx_gold_flecks.dds", 0x5865_633A, 0x4DF7_6001),
    (r"textures\tx_goblinskin.dds", 0x5865_633A, 0x75A7_065F),
    (r"textures\tx_goblin_helm.dds", 0x5865_633A, 0xBFE7_7907),
    (r"textures\tx_firealpha10.dds", 0x5865_633B, 0x2F31_A23B),
    (r"textures\tx_firealpha01.dds", 0x5865_633B, 0x94A4_E46C),
    (r"textures\tx_a_helseth_c.dds", 0x5865_633C, 0x3EEF_2C2C),
    (r"textures\tx_a_helseth_g.dds", 0x5865_633C, 0x3EEF_2C6C),
    (r"textures\tx_adamantium.dds", 0x5865_633C, 0x7507_9D54),
    (r"textures\tx_cart_cloth.dds", 0x5865_633E, 0x75F2_28CD),
    (r"textures\tx_cart_wheel.dds", 0x5865_633E, 0x9ECD_A329),
    (r"textures\tx_cart_wheel2.dds", 0x5865_633E, 0xA190_1DA7),
    (r"textures\tx_cart_wheel3.dds", 0x5865_633E, 0xA190_1DB7),
    (r"textures\tx_copperarm00.dds", 0x5865_633E, 0xA9C7_2F10),
    (r"textures\tx_booth_adobe.dds", 0x5865_633F, 0x34BA_57A9),
    (r"textures\tx_brocade_03.dds", 0x5865_633F, 0x9017_4EE3),
    (r"textures\tx_brassmech01.dds", 0x5865_633F, 0xC9A6_6626),
    (r"textures\tx_brassmech00.dds", 0x5865_633F, 0xC9A6_6636),
    (r"textures\tx_booth_wood.dds", 0x5865_633F, 0xF29D_D9F0),
    (r"textures\tx_brocade_01.dds", 0x5865_633F, 0xF2AA_E530),
    (r"textures\tx_booth_rail.dds", 0x5865_633F, 0xF5A5_3529),
    (r"textures\tx_cart_base.dds", 0x5865_635D, 0x006E_AFD7),
    (r"textures\tx_cart_pole.dds", 0x5865_635D, 0x0E7C_AFC8),
    (r"textures\tx_plant_09.dds", 0x5865_635D, 0x1458_DBDC),
    (r"textures\tx_plant_08.dds", 0x5865_635D, 0x1458_DFDC),
    (r"textures\tx_plant_17.dds", 0x5865_635D, 0x1458_E3D8),
    (r"textures\tx_plant_07.dds", 0x5865_635D, 0x1458_E3DC),
    (r"textures\tx_plant_16.dds", 0x5865_635D, 0x1458_E7D8),
    (r"textures\tx_plant_06.dds", 0x5865_635D, 0x1458_E7DC),
    (r"textures\tx_plant_15.dds", 0x5865_635D, 0x1458_EBD8),
    (r"textures\tx_plant_05.dds", 0x5865_635D, 0x1458_EBDC),
    (r"textures\tx_plant_14.dds", 0x5865_635D, 0x1458_EFD8),
    (r"textures\tx_plant_04.dds", 0x5865_635D, 0x1458_EFDC),
    (r"textures\tx_plant_13.dds", 0x5865_635D, 0x1458_F3D8),
    (r"textures\tx_plant_03.dds", 0x5865_635D, 0x1458_F3DC),
    (r"textures\tx_plant_12.dds", 0x5865_635D, 0x1458_F7D8),
    (r"textures\tx_plant_02.dds", 0x5865_635D, 0x1458_F7DC),
    (r"textures\tx_plant_11.dds", 0x5865_635D, 0x1458_FBD8),
    (r"textures\tx_plant_01.dds", 0x5865_635D, 0x1458_FBDC),
    (r"textures\tx_plant_10.dds", 0x5865_635D, 0x1458_FFD8),
    (r"textures\tx_firelight.dds", 0x5865_635D, 0x2033_1DF0),
    (r"textures\tx_liche_001.dds", 0x5865_635D, 0x247A_38CB),
    (r"textures\tx_dwe_fan00.dds", 0x5865_635D, 0x33CC_1211),
    (r"textures\tx_oil_crust.dds", 0x5865_635D, 0x35FF_6AF2),
    (r"textures\tx_fireglow.dds", 0x5865_635D, 0x5096_8E56),
    (r"textures\tx_dwe_gem00.dds", 0x5865_635D, 0x5B84_1977),
    (r"textures\tx_booth_tap.dds", 0x5865_635D, 0x67FE_6A8F),
    (r"textures\tx_fireash00.dds", 0x5865_635D, 0x8C14_447C),
    (r"textures\tx_cart_six.dds", 0x5865_635D, 0xB545_2636),
    (r"textures\tx_licheking.dds", 0x5865_635D, 0xC2D2_679D),
    (r"textures\tx_om_cavern.dds", 0x5865_635D, 0xE41C_8CE3),
    (r"icons\l\light_com_torch_01.dds", 0x5A07_0902, 0xF4C7_C46D),
    (r"icons\n\tx_noble_sedge_01.dds", 0x5C5E_2501, 0xCB49_04E8),
    (r"meshes\i\in_om_temple_ruins.nif", 0x5E1E_123B, 0x2643_AFC3),
    (r"meshes\i\in_om_rubble_sm01.nif", 0x5E1E_123B, 0x72F6_8180),
    (r"meshes\i\in_om_wall_curve02.nif", 0x5E1E_123B, 0x787B_611D),
    (r"meshes\i\in_om_wall_curve01.nif", 0x5E1E_123B, 0x787B_6D1D),
    (r"meshes\i\in_om_arch_center.nif", 0x5E1E_123B, 0x7A76_3123),
    (r"meshes\i\in_om_wall_pillar.nif", 0x5E1E_123B, 0xA9C5_6464),
    (r"meshes\i\in_om_rock_stairs.nif", 0x5E1E_123B, 0xDE85_7FA2),
    (r"meshes\i\in_om_aquaduct_end.nif", 0x5E1E_123B, 0xE081_2C18),
    (r"meshes\i\in_om_stone_ramp02.nif", 0x5E1E_123B, 0xE6FB_5F08),
    (r"meshes\i\in_mh_doorjamb_02.nif", 0x5E1E_1739, 0x15FB_1AC7),
    (r"meshes\i\in_mh_doorjamb_01.nif", 0x5E1E_1739, 0x15FB_1ACB),
    (r"meshes\i\in_mh_int_rail_01.nif", 0x5E1E_1739, 0x1CCD_6E6B),
    (r"meshes\i\in_mh_palacewin_01.nif", 0x5E1E_1739, 0x4F9F_3EE1),
    (r"meshes\i\in_mh_int_wall_01.nif", 0x5E1E_1739, 0xBD9A_F440),
    (r"meshes\i\in_dwe_ramp00_exp.nif", 0x5E24_0830, 0x2A7E_557E),
    (r"meshes\i\in_dwe_hall00_exp.nif", 0x5E24_0830, 0x3F10_AA83),
    (r"meshes\i\in_dwe_pipe00_exp.nif", 0x5E24_0830, 0x8EA2_A057),
    (r"meshes\i\in_m_sewer_hall_02.nif", 0x5E32_2039, 0x3030_13F7),
    (r"meshes\i\in_m_sewer_hall_01.nif", 0x5E32_2039, 0x3030_1FF7),
    (r"meshes\i\in_m_sewer_4way_01.nif", 0x5E32_2039, 0x997A_D174),
    (r"meshes\i\in_m_sewer_3way_01.nif", 0x5E32_2039, 0x997A_D17A),
    (r"meshes\i\in_m_sewer_cap_03.nif", 0x5E32_2039, 0xAEE0_F490),
    (r"meshes\i\in_m_sewer_cap_02.nif", 0x5E32_2039, 0xAEE0_F494),
    (r"meshes\i\in_m_sewer_cap_01.nif", 0x5E32_2039, 0xAEE0_F498),
    (r"meshes\i\in_m_sewer_arch_01.nif", 0x5E32_2039, 0xF8EE_E99F),
    (r"meshes\i\in_sotha_corr_trap.nif", 0x5E35_1027, 0x09BB_B6B7),
    (r"meshes\i\in_sotha_doorjam00.nif", 0x5E35_1027, 0x3D6E_FF99),
    (r"meshes\i\in_sotha_mon_mach.nif", 0x5E35_1027, 0x4461_8FA3),
    (r"meshes\i\in_sotha_pillars01.nif", 0x5E35_1027, 0x7F31_E903),
    (r"meshes\i\in_sotha_stairs00.nif", 0x5E35_1027, 0x83E1_C1A3),
    (r"meshes\i\in_sotha_oilcan00.nif", 0x5E35_1027, 0x9FD2_EC2D),
    (r"meshes\i\in_sotha_bladeroom.nif", 0x5E35_1027, 0xA974_1F39),
    (r"meshes\i\in_sotha_corr_dj00.nif", 0x5E35_1027, 0xD7E7_09AA),
    (r"meshes\i\in_sotha_corr2_00.nif", 0x5E35_1027, 0xE6D1_54A3),
    (r"meshes\i\in_sotha_corr2_01.nif", 0x5E35_1027, 0xE6D1_54A7),
    (r"meshes\i\in_sotha_corr4_00.nif", 0x5E35_1027, 0xE6D1_64A3),
    (r"meshes\i\in_dwe_rod00_exp.nif", 0x5E41_0830, 0x036C_B5A9),
    (r"meshes\i\in_dwe_rod01_exp.nif", 0x5E41_0830, 0x236C_B5A9),
    (r"meshes\i\in_dwe_rubble02.nif", 0x5E41_0830, 0x2CCD_8500),
    (r"meshes\i\in_dwe_rubble00.nif", 0x5E41_0830, 0x2CCD_8501),
    (r"meshes\i\in_dwe_end00_exp.nif", 0x5E41_0830, 0x2D6C_B5AB),
    (r"meshes\i\in_dwe_room4_exp.nif", 0x5E41_0830, 0x7DAE_ECFC),
    (r"meshes\i\in_dwe_pill_bk02.nif", 0x5E41_0830, 0x9463_6682),
    (r"meshes\i\in_dwe_pill_bk03.nif", 0x5E41_0830, 0x9463_6686),
    (r"meshes\i\in_dwe_pill_bk00.nif", 0x5E41_0830, 0x9463_668A),
    (r"meshes\i\in_dwe_pill_bk01.nif", 0x5E41_0830, 0x9463_668E),
    (r"meshes\i\in_dwe_room3_exp.nif", 0x5E41_0830, 0x9DAE_ECFC),
    (r"meshes\i\in_dwe_rubble01.nif", 0x5E41_0830, 0xACCD_8501),
    (r"meshes\i\in_dwe_corr4_exp.nif", 0x5E41_0830, 0xE5A9_61DC),
    (r"meshes\i\in_sotha_altar00.nif", 0x5E41_1027, 0x0F19_A982),
    (r"meshes\i\in_sotha_gear00.nif", 0x5E41_1027, 0x5B63_C146),
    (r"meshes\i\in_sotha_gear02.nif", 0x5E41_1027, 0x5B63_C147),
    (r"meshes\i\in_sotha_dome00.nif", 0x5E41_1027, 0x7931_AA08),
    (r"meshes\i\in_sotha_pre2_02.nif", 0x5E41_1027, 0xA816_0161),
    (r"meshes\i\in_sotha_pre2_00.nif", 0x5E41_1027, 0xA816_0169),
    (r"meshes\i\in_sotha_pre2_01.nif", 0x5E41_1027, 0xA816_016D),
    (r"meshes\i\in_sotha_pre1_00.nif", 0x5E41_1027, 0xA816_1969),
    (r"meshes\i\in_sotha_pre4_00.nif", 0x5E41_1027, 0xA816_3169),
    (r"meshes\i\in_sotha_gear01.nif", 0x5E41_1027, 0xDB63_C146),
    (r"meshes\i\in_sotha_gear03.nif", 0x5E41_1027, 0xDB63_C147),
    (r"meshes\i\in_om_stone_ramp.nif", 0x5E41_123B, 0x04BF_AAFC),
    (r"meshes\i\in_om_wall_spike.nif", 0x5E41_123B, 0x06EC_2C8F),
    (r"meshes\i\in_om_floor_512.nif", 0x5E41_123B, 0x0BDC_4B67),
    (r"meshes\i\in_om_skullpile.nif", 0x5E41_123B, 0x0D61_AB90),
    (r"meshes\i\in_om_waterfall.nif", 0x5E41_123B, 0x1F79_E4E0),
    (r"meshes\i\in_om_connect_01.nif", 0x5E41_123B, 0x26C9_08D2),
    (r"meshes\i\in_om_floor_1024.nif", 0x5E41_123B, 0x3A28_6273),
    (r"meshes\i\in_om_doorjam_03.nif", 0x5E41_123B, 0x4DFB_735F),
    (r"meshes\i\in_om_wallruin04.nif", 0x5E41_123B, 0x84E5_9641),
    (r"meshes\i\in_om_wallruin05.nif", 0x5E41_123B, 0x84E5_9645),
    (r"meshes\i\in_om_wallruin06.nif", 0x5E41_123B, 0x84E5_9649),
    (r"meshes\i\in_om_wallruin07.nif", 0x5E41_123B, 0x84E5_964D),
    (r"meshes\i\in_om_wallruin01.nif", 0x5E41_123B, 0x84E5_9655),
    (r"meshes\i\in_om_wallruin02.nif", 0x5E41_123B, 0x84E5_9659),
    (r"meshes\i\in_om_wallruin03.nif", 0x5E41_123B, 0x84E5_965D),
    (r"meshes\i\in_om_corner_01.nif", 0x5E41_123B, 0xAD61_37F0),
    (r"meshes\i\in_om_corner_03.nif", 0x5E41_123B, 0xAD61_37F1),
    (r"meshes\i\in_om_rubble_sm.nif", 0x5E41_123B, 0xCB34_7D72),
    (r"meshes\i\in_om_platform_s.nif", 0x5E41_123B, 0xD1A6_DFBB),
    (r"meshes\i\in_om_mezzanine.nif", 0x5E41_123B, 0xDE97_90D2),
    (r"meshes\i\in_mh_temple_01.nif", 0x5E41_1739, 0x6137_DB8D),
    (r"meshes\i\in_mh_pav_ladder.nif", 0x5E41_1739, 0x76B7_72E1),
    (r"meshes\i\in_mh_window_01.nif", 0x5E41_1739, 0x7C4B_57E4),
    (r"meshes\i\in_mh_corner_01.nif", 0x5E41_1739, 0xAD61_37F0),
    (r"meshes\i\in_mh_stairs_01.nif", 0x5E41_1739, 0xD553_75C2),
    (r"meshes\i\in_mh_temple_02.nif", 0x5E41_1739, 0xE137_DB8C),
    (r"meshes\i\in_m_sewer_bend.nif", 0x5E41_2039, 0x493B_117A),
    (r"meshes\i\in_m_sewer_wall.nif", 0x5E41_2039, 0x6A86_E037),
    (r"meshes\i\in_m_sewer_ramp.nif", 0x5E41_2039, 0x8FAF_BDB8),
    (r"meshes\i\in_sotha_corr1.nif", 0x5E41_7F27, 0x94C6_088E),
    (r"meshes\i\in_sotha_lab00.nif", 0x5E41_7F27, 0xB275_3648),
    (r"meshes\i\in_sotha_sil00.nif", 0x5E41_7F27, 0xB67A_B64F),
    (r"meshes\i\in_dwe_slate11.nif", 0x5E41_7F30, 0x5862_436C),
    (r"meshes\i\in_dwe_slate03.nif", 0x5E41_7F30, 0x6D1D_1570),
    (r"meshes\i\in_dwe_slate01.nif", 0x5E41_7F30, 0x6D1D_1571),
    (r"meshes\i\in_dwe_slate07.nif", 0x5E41_7F30, 0x6D1D_1572),
    (r"meshes\i\in_dwe_slate05.nif", 0x5E41_7F30, 0x6D1D_1573),
    (r"meshes\i\in_dwe_slate09.nif", 0x5E41_7F30, 0x6D1D_1575),
    (r"meshes\i\in_db_front01.nif", 0x5E41_7F30, 0xAEB0_43A4),
    (r"meshes\i\in_db_front03.nif", 0x5E41_7F30, 0xD460_C77E),
    (r"meshes\i\in_dwe_slate10.nif", 0x5E41_7F30, 0xD862_436C),
    (r"meshes\i\in_dwe_slate02.nif", 0x5E41_7F30, 0xED1D_1570),
    (r"meshes\i\in_dwe_slate00.nif", 0x5E41_7F30, 0xED1D_1571),
    (r"meshes\i\in_dwe_slate06.nif", 0x5E41_7F30, 0xED1D_1572),
    (r"meshes\i\in_dwe_slate04.nif", 0x5E41_7F30, 0xED1D_1573),
    (r"meshes\i\in_dwe_slate08.nif", 0x5E41_7F30, 0xED1D_1575),
    (r"meshes\i\in_mh_4way_01.nif", 0x5E41_7F39, 0x1308_BBC6),
    (r"meshes\i\in_mh_3way_01.nif", 0x5E41_7F39, 0x1408_BBC6),
    (r"meshes\i\in_mh_hall_01.nif", 0x5E41_7F39, 0xA650_D134),
    (r"meshes\i\in_mh_wall_01.nif", 0x5E41_7F39, 0xA653_3134),
    (r"meshes\i\in_mh_ramp_01.nif", 0x5E41_7F39, 0xF7D2_FF2F),
    (r"meshes\i\in_om_hall_02.nif", 0x5E41_7F3B, 0x00E9_8F7F),
    (r"meshes\i\in_om_doorjam.nif", 0x5E41_7F3B, 0x0CEB_034F),
    (r"meshes\i\in_om_ductcap.nif", 0x5E41_7F3B, 0x125B_C887),
    (r"meshes\i\in_om_column14.nif", 0x5E41_7F3B, 0x1E5A_103C),
    (r"meshes\i\in_om_column16.nif", 0x5E41_7F3B, 0x1E5A_103D),
    (r"meshes\i\in_om_column10.nif", 0x5E41_7F3B, 0x1E5A_103E),
    (r"meshes\i\in_om_column12.nif", 0x5E41_7F3B, 0x1E5A_103F),
    (r"meshes\i\in_om_spike01.nif", 0x5E41_7F3B, 0x2068_85B0),
    (r"meshes\i\in_om_plat512.nif", 0x5E41_7F3B, 0x20FE_3A3F),
    (r"meshes\i\in_om_4way_01a.nif", 0x5E41_7F3B, 0x28E2_D152),
    (r"meshes\i\in_om_spike02.nif", 0x5E41_7F3B, 0x4543_253D),
    (r"meshes\i\in_om_column08.nif", 0x5E41_7F3B, 0x616D_B3D0),
    (r"meshes\i\in_om_column02.nif", 0x5E41_7F3B, 0x616D_B3D5),
    (r"meshes\i\in_om_column04.nif", 0x5E41_7F3B, 0x616D_B3D6),
    (r"meshes\i\in_om_column06.nif", 0x5E41_7F3B, 0x616D_B3D7),
    (r"meshes\i\in_om_statue2.nif", 0x5E41_7F3B, 0x617E_3A67),
    (r"meshes\i\in_om_statue1.nif", 0x5E41_7F3B, 0x6812_BB04),
    (r"meshes\i\in_om_dbfloor.nif", 0x5E41_7F3B, 0x72F8_B74F),
    (r"meshes\i\in_om_4way_01.nif", 0x5E41_7F3B, 0x7B08_BBAD),
    (r"meshes\i\in_om_3way_01.nif", 0x5E41_7F3B, 0x7C08_BBAD),
    (r"meshes\i\in_om_aquaduct.nif", 0x5E41_7F3B, 0x9B84_88C6),
    (r"meshes\i\in_om_column15.nif", 0x5E41_7F3B, 0x9E5A_103C),
    (r"meshes\i\in_om_column11.nif", 0x5E41_7F3B, 0x9E5A_103E),
    (r"meshes\i\in_om_column13.nif", 0x5E41_7F3B, 0x9E5A_103F),
    (r"meshes\i\in_om_platform.nif", 0x5E41_7F3B, 0xA9FC_096D),
    (r"meshes\i\in_om_walkway.nif", 0x5E41_7F3B, 0xB6C7_2DA0),
    (r"meshes\i\in_om_rubble01.nif", 0x5E41_7F3B, 0xC1CD_8564),
    (r"meshes\i\in_om_amalexia.nif", 0x5E41_7F3B, 0xC441_02E8),
    (r"meshes\i\in_om_arch_end.nif", 0x5E41_7F3B, 0xC830_7524),
    (r"meshes\i\in_om_hall_03.nif", 0x5E41_7F3B, 0xD503_A3DA),
    (r"meshes\i\in_om_column09.nif", 0x5E41_7F3B, 0xE16D_B3D0),
    (r"meshes\i\in_om_column01.nif", 0x5E41_7F3B, 0xE16D_B3D4),
    (r"meshes\i\in_om_column03.nif", 0x5E41_7F3B, 0xE16D_B3D5),
    (r"meshes\i\in_om_column05.nif", 0x5E41_7F3B, 0xE16D_B3D6),
    (r"meshes\i\in_om_column07.nif", 0x5E41_7F3B, 0xE16D_B3D7),
    (r"meshes\i\in_om_4way_02.nif", 0x5E41_7F3B, 0xE8F3_3A33),
    (r"meshes\i\in_om_spike03.nif", 0x5E41_7F3B, 0xF7D6_F6FB),
    (r"meshes\i\in_om_arch03.nif", 0x5E41_7F54, 0x03D8_110C),
    (r"meshes\i\in_mh_cap_01.nif", 0x5E41_7F54, 0x102D_BBB9),
    (r"meshes\i\in_om_pillar.nif", 0x5E41_7F54, 0x4D89_7C6C),
    (r"meshes\i\in_om_arch02.nif", 0x5E41_7F54, 0xAD5E_EAD2),
    (r"meshes\i\in_om_casket.nif", 0x5E41_7F54, 0xB354_C98C),
    (r"meshes\i\in_db_ruin02.nif", 0x5E41_7F54, 0xE455_1872),
    (r"meshes\i\in_om_steps.nif", 0x5E41_7F54, 0xEE30_F89C),
    (r"meshes\i\in_om_arch01.nif", 0x5E41_7F54, 0xF053_1A6F),
    (r"meshes\i\in_om_center.nif", 0x5E41_7F54, 0xF1C0_A1F7),
    (r"meshes\i\in_db_front.nif", 0x5E41_7F54, 0xFC8F_DDCD),
    (r"icons\c\tx_mournhold_skirt.dds", 0x5F21_3201, 0x0DED_4E57),
    (r"icons\c\tx_mournhold_shoes.dds", 0x5F21_3201, 0x87A9_7783),
    (r"icons\w\tx_maceofslurring.dds", 0x5F47_240F, 0x5AE9_36D8),
    (r"icons\n\tx_meadow_rye_01.dds", 0x5F5E_260B, 0xC1AC_485D),
    (r"meshes\a\shield_amindoril.nif", 0x6047_0931, 0x7D2C_0E6C),
    (r"meshes\m\dwemer_satchel00.nif", 0x6058_1739, 0xE617_8F66),
    (r"meshes\a\a_helsethguard_fa.nif", 0x6103_1B31, 0x00FF_EE0B),
    (r"meshes\a\a_helsethguard_cl.nif", 0x6103_1B31, 0x14FF_EE3F),
    (r"meshes\a\a_helsethguard_ua.nif", 0x6103_1B31, 0x4CFF_EE0B),
    (r"meshes\a\a_helsethguard_ul.nif", 0x6103_1B31, 0x4CFF_EE3F),
    (r"meshes\n\ingred_raw_adam.nif", 0x6141_1A26, 0xFC57_46D9),
    (r"meshes\f\flora_tree_mh_01.nif", 0x6143_1126, 0xA613_4BF2),
    (r"meshes\f\flora_tree_mh_02.nif", 0x6143_1126, 0xA613_4BFE),
    (r"meshes\f\flora_grass_06.nif", 0x6143_7026, 0x14D9_3D48),
    (r"meshes\f\flora_grass_07.nif", 0x6143_7026, 0x94D9_3D48),
    (r"meshes\f\flora_grass_05.nif", 0x6143_7026, 0x94D9_3D49),
    (r"meshes\a\a_helsethguard_k.nif", 0x6170_1B31, 0x1D85_7F81),
    (r"meshes\a\a_helsethguard_a.nif", 0x6170_1B31, 0x1D85_7FA9),
    (r"meshes\a\a_helsethguard_g.nif", 0x6170_1B31, 0x1D85_7FB1),
    (r"meshes\a\a_helsethguard_f.nif", 0x6170_1B31, 0x1D85_7FB5),
    (r"textures\amel_summon_spark.dds", 0x6203_2931, 0x91BB_8430),
    (r"meshes\i\xact_dwe_cavein00.nif", 0x622A_3120, 0x4D75_EC2D),
    (r"meshes\i\xact_sotha_fabsteam.kf", 0x623D_3120, 0x640D_ABE6),
    (r"meshes\i\xact_sotha_steam00.kf", 0x623D_3120, 0x8361_E7F0),
    (r"meshes\i\xact_sotha_spikes.nif", 0x623D_3120, 0x9B93_3A18),
    (r"meshes\i\xact_sotha_steam00.nif", 0x623D_3120, 0xE56E_E2F0),
    (r"meshes\i\xact_sotha_pre_door.kf", 0x623D_3120, 0xF307_66D4),
    (r"meshes\i\xact_torch_lever.nif", 0x624E_3120, 0x050E_226C),
    (r"meshes\i\xact_rockslide01.kf", 0x624E_3120, 0x0C6F_39A1),
    (r"meshes\i\xact_rockslide01.nif", 0x624E_3120, 0x21FF_82F4),
    (r"meshes\i\xact_torch_lever.kf", 0x624E_3120, 0x2BE2_3D60),
    (r"meshes\i\xact_sotha_spikes.kf", 0x624E_3120, 0x306E_151D),
    (r"meshes\i\xact_sotha_door.nif", 0x624E_3120, 0x6DEF_AEE2),
    (r"meshes\i\xact_dwe_cavein00.kf", 0x624E_3120, 0x8D41_A04C),
    (r"meshes\i\xact_dwe_gyro00.nif", 0x624E_3120, 0x92EE_9E4E),
    (r"meshes\i\xact_dwe_lever00.kf", 0x624E_3120, 0x93D9_392E),
    (r"meshes\i\xact_sotha_lever.kf", 0x624E_3120, 0xC5CD_042F),
    (r"meshes\i\xact_dwe_lever00.nif", 0x624E_3120, 0xD209_42E5),
    (r"meshes\i\xact_sotha_lever.nif", 0x624E_3120, 0xF8CB_C545),
    (r"meshes\i\xact_dwe_gyro00.kf", 0x624E_6E20, 0x288E_0B68),
    (r"meshes\i\xact_sotha_door.kf", 0x624E_6E20, 0x67A6_2F61),
    (r"textures\amel_summon_glow.dds", 0x6270_2931, 0xF63E_5F77),
    (r"meshes\l\light_sotha_sparks.nif", 0x6319_0E3C, 0x1F73_2B31),
    (r"meshes\d\door_sotha_load.nif", 0x6340_2D26, 0x00C1_A564),
    (r"meshes\d\door_dwe_00_exp.nif", 0x6340_2D26, 0xBD83_E6B6),
    (r"meshes\l\light_om_censure.nif", 0x6346_0E3C, 0x12CE_A984),
    (r"meshes\l\light_dwe_bulb00.nif", 0x6346_0E3C, 0x6A7E_775B),
    (r"meshes\l\light_om_brazier.nif", 0x6346_0E3C, 0xE18D_EC12),
    (r"meshes\l\light_logpile.nif", 0x6346_7A3C, 0x52D1_EE4D),
    (r"meshes\c\c_m_robe_liche.1st.nif", 0x661F_070B, 0x7B34_7601),
    (r"meshes\c\c_m_robe_liche_gnd.nif", 0x661F_070B, 0x9DBE_134B),
    (r"meshes\c\c_m_mournhold_skin.nif", 0x661F_180B, 0xBF0D_89F1),
    (r"textures\amalexia_statue.dds", 0x6670_1331, 0x61CD_59FD),
    (r"meshes\c\c_m_helseth_robe.nif", 0x6670_1D0B, 0xAD1E_3557),
    (r"meshes\c\c_m_robe_liche.nif", 0x6670_750B, 0xEDDC_25F8),
    (r"meshes\a\a_netch_f_cuirass.nif", 0x6713_0331, 0xB0C4_F9C6),
    (r"meshes\a\a_almindoril_skins.nif", 0x6819_1A38, 0x3193_4F1A),
    (r"meshes\a\a_adamantium_helm.nif", 0x681D_1630, 0x199B_09D0),
    (r"meshes\o\flora_plant_01.nif", 0x6843_7026, 0x1297_BD4C),
    (r"meshes\o\flora_plant_03.nif", 0x6843_7026, 0x1297_BD4D),
    (r"meshes\o\flora_plant_05.nif", 0x6843_7026, 0x1297_BD4E),
    (r"meshes\o\flora_plant_07.nif", 0x6843_7026, 0x1297_BD4F),
    (r"meshes\o\flora_sedge_01.nif", 0x6843_7026, 0x2D9E_1390),
    (r"meshes\o\flora_plant_08.nif", 0x6843_7026, 0x9297_BD48),
    (r"meshes\o\flora_plant_02.nif", 0x6843_7026, 0x9297_BD4D),
    (r"meshes\o\flora_plant_04.nif", 0x6843_7026, 0x9297_BD4E),
    (r"meshes\o\flora_plant_06.nif", 0x6843_7026, 0x9297_BD4F),
    (r"meshes\o\flora_sedge_02.nif", 0x6843_7026, 0xAD9E_1391),
    (r"meshes\r\durzog_collar.nif", 0x685A_722E, 0x2B0E_C816),
    (r"meshes\r\xspherearcher.nif", 0x6A5C_6E3C, 0x6D94_9380),
    (r"meshes\r\xspherearcher.kf", 0x6A5C_6E54, 0x8311_6281),
    (r"meshes\in_om_shrinefx.nif", 0x6C40_4966, 0xAED4_D1BF),
    (r"meshes\amalexia_summon.nif", 0x6C43_771D, 0xF5D0_B1FF),
    (r"meshes\w\w_stendarshammer.nif", 0x6C70_0420, 0xA83E_1201),
    (r"meshes\i\door_dwe_00_exp.nif", 0x6E40_2D26, 0xBD83_E6B6),
    (r"meshes\i\broken_imperfect.nif", 0x6E5D_113F, 0xCCE8_57F1),
    (r"icons\map_marker_yellow.dds", 0x6E6F_6018, 0x9D7A_58DD),
    (r"icons\map_marker_green.dds", 0x6E6F_6018, 0xD02E_C7DE),
    (r"icons\map_marker_blue.dds", 0x6E6F_606A, 0x1A7A_B71D),
    (r"icons\map_marker_red.dds", 0x6E6F_606A, 0xE126_665A),
    (r"meshes\i\contain_rock_am_19.nif", 0x6F29_1420, 0x8A15_9AE4),
    (r"meshes\i\contain_rock_am_18.nif", 0x6F29_1420, 0x8A15_9EE4),
    (r"meshes\i\contain_rock_am_17.nif", 0x6F29_1420, 0x8A15_A2E4),
    (r"meshes\i\contain_rock_am_16.nif", 0x6F29_1420, 0x8A15_A6E4),
    (r"meshes\i\contain_rock_am_15.nif", 0x6F29_1420, 0x8A15_AAE4),
    (r"meshes\i\contain_rock_am_21.nif", 0x6F29_1420, 0x8A15_BAE8),
    (r"meshes\i\contain_rock_am_20.nif", 0x6F29_1420, 0x8A15_BEE8),
    (r"meshes\i\xin_sotha_sil00.nif", 0x6F46_1D0B, 0xB67A_B64F),
    (r"meshes\i\xin_sotha_sil00.kf", 0x6F46_6E0B, 0x91D4_19BC),
    (r"meshes\r\xdurzog_collar.kf", 0x6F4B_6E26, 0x23A3_B8CB),
    (r"meshes\r\xdurzog_collar.nif", 0x6F4B_6E26, 0x63F6_9119),
    (r"textures\mehrunesdagon.dds", 0x6F78_7A2F, 0x91E6_EA08),
    (r"meshes\w\w_nerevarbladeleft.nif", 0x7115_1331, 0x1A41_2A65),
    (r"meshes\r\spherearcher.nif", 0x725F_6554, 0x6D94_9380),
    (r"meshes\r\xliche_king.nif", 0x7343_6E54, 0x7064_C026),
    (r"textures\darkbrotherhood_g.dds", 0x750E_1136, 0x4B67_6207),
    (r"meshes\i\act_sotha_steam00.nif", 0x7523_040B, 0x4CBD_21F4),
    (r"meshes\i\act_sotha_fabsteam.nif", 0x7523_040B, 0x8857_25F0),
    (r"meshes\i\act_sotha_pre_door.nif", 0x7523_040B, 0x9190_3A78),
    (r"meshes\i\act_sotha_oilcrane.nif", 0x7523_040B, 0xD162_2C07),
    (r"meshes\i\act_dwe_weather00.nif", 0x753B_130B, 0x820D_0A03),
    (r"meshes\i\act_dwe_powerbox00.nif", 0x753B_130B, 0x90B5_C1CD),
    (r"meshes\i\act_torch_lever.nif", 0x754C_030B, 0x17D9_ED47),
    (r"meshes\i\act_sotha_dicer.nif", 0x754C_040B, 0x07D9_F12F),
    (r"meshes\i\act_sotha_green.nif", 0x754C_040B, 0x0BD9_E94D),
    (r"meshes\i\act_sotha_lever.nif", 0x754C_040B, 0x27D9_A51F),
    (r"meshes\i\act_sotha_gear03.nif", 0x754C_040B, 0x63D7_5E00),
    (r"meshes\i\act_sotha_gear02.nif", 0x754C_040B, 0x63D7_5E04),
    (r"meshes\i\act_sotha_gear01.nif", 0x754C_040B, 0x63D7_5E08),
    (r"meshes\i\act_sotha_gear00.nif", 0x754C_040B, 0x63D7_5E0C),
    (r"meshes\i\act_sotha_spikes.nif", 0x754C_040B, 0x9B93_3A18),
    (r"meshes\i\act_rockslide01.nif", 0x754C_050B, 0x651E_4231),
    (r"meshes\i\act_poison_steam.nif", 0x754C_070B, 0xD9E4_CA8C),
    (r"meshes\i\act_dwe_cavein00.nif", 0x754C_130B, 0x4D75_EC2D),
    (r"meshes\i\act_dwe_lever00.nif", 0x754C_130B, 0xB772_44B4),
    (r"meshes\i\act_hot_oil_512.nif", 0x754C_1F0B, 0x4E9C_53D9),
    (r"meshes\i\act_sotha_door.nif", 0x754C_770B, 0x6DEF_AEE2),
    (r"meshes\i\act_dwe_gyro00.nif", 0x754C_770B, 0x92EE_9E4E),
    (r"meshes\i\act_sotha_red.nif", 0x754C_770B, 0xAC91_EB6F),
    (r"meshes\i\act_dwe_fan00.nif", 0x754C_770B, 0xD676_0E79),
    (r"meshes\r\xalmelexia_warrior.nif", 0x7622_0B39, 0x2263_2077),
    (r"meshes\r\xalmelexia_warrior.kf", 0x7622_0B39, 0x446C_2577),
    (r"meshes\r\almelexia_warrior.nif", 0x7726_1B31, 0x1CC1_7FA9),
    (r"meshes\c\c_skirt_mournhold.nif", 0x7802_1C3F, 0x7570_1830),
    (r"meshes\c\c_shoes_mournhold.nif", 0x7815_1A3C, 0x3D70_1832),
    (r"meshes\r\fabricant_hulking.nif", 0x782D_1926, 0xDFDC_DEFA),
    (r"meshes\w\w_goblin_shield.nif", 0x7870_033B, 0x0CAD_BC70),
    (r"meshes\c\c_shoes_common2.nif", 0x7870_1A3C, 0x5F40_D00A),
    (r"meshes\c\c_shoes_common1.nif", 0x7870_1A3C, 0xDF40_D00B),
    (r"meshes\c\c_skirt_common2.nif", 0x7870_1C3F, 0x53E0_A216),
    (r"meshes\c\c_skirt_common1.nif", 0x7870_1C3F, 0xD3E0_A217),
    (r"meshes\w\w_goblin_sword.nif", 0x7870_613B, 0x4002_0E84),
    (r"meshes\w\w_goblin_club.nif", 0x7870_613B, 0x740C_0602),
    (r"meshes\c\c_robe_white_gnd.nif", 0x7970_173B, 0x93A0_97C3),
    (r"meshes\c\c_robe_white.1st.nif", 0x7970_173B, 0xFB54_4FEC),
    (r"meshes\c\c_robe_white.nif", 0x7970_7554, 0x42E5_ED09),
    (r"meshes\w\w_ebony_scimitar.nif", 0x7A70_0E36, 0x8412_B15F),
    (r"meshes\r\xfabricant_hulking.nif", 0x7B20_1C36, 0x9605_951B),
    (r"meshes\r\xfabricant_hulking.kf", 0x7B20_1C36, 0xF00A_901B),
    (r"meshes\f\furn_planter_mh_01.nif", 0x7C2A_2F3A, 0x32D4_27DA),
    (r"meshes\f\furn_planter_mh_02.nif", 0x7C2A_2F3A, 0x32D4_2BDA),
    (r"meshes\f\furn_planter_mh_03.nif", 0x7C2A_2F3A, 0x32D4_2FDA),
    (r"meshes\f\furn_planter_mh_04.nif", 0x7C2A_2F3A, 0x32D4_33DA),
    (r"meshes\f\furn_planter_mh_05.nif", 0x7C2A_2F3A, 0x32D4_37DA),
    (r"meshes\f\furn_banner_imp_01.nif", 0x7C38_2F3A, 0xC136_326E),
    (r"meshes\x\collision_mh_01.nif", 0x7C40_1C38, 0x6188_B659),
    (r"meshes\f\furn_throne_01.nif", 0x7C5A_703A, 0xD772_0143),
    (r"meshes\w\w_adamantium_mace.nif", 0x7E1D_0030, 0x098B_4CCF),
    (r"meshes\w\w_adamantium_spear.nif", 0x7E1D_0030, 0xB265_AF6A),
    (r"meshes\w\w_adamantium_axe.nif", 0x7E70_0030, 0x0D7D_0738),
    (r"textures\vfx_restore_glow02.dds", 0x7F1E_1302, 0x907E_12A3),
    (r"textures\vfx_restore_light.dds", 0x7F1E_1302, 0xBA1C_7D6C),
    (r"meshes\xin_om_shrinefx.nif", 0x7F70_780C, 0xAED4_D1BF),
    (r"meshes\xin_om_shrinefx.kf", 0x7F70_7861, 0xA3A7_92CE),
    (r"textures\vfx_omshrine.dds", 0x7F7B_615D, 0x9FD1_6634),
];
