var searchIndex = JSON.parse('{\
"browser_window":{"doc":"Browser Window is a Rust crate that allows you to utilize…","i":[[3,"DelegateFuture","browser_window","This future executes a closure on the GUI thread and…",null,null],[3,"DelegateFutureFuture","","This future runs a future on the GUI thread and returns…",null,null],[4,"DelegateError","","The error that occurs when you\'re delegating work to the…",null,null],[13,"RuntimeNotAvailable","","The runtime has either not yet started or already ended.…",0,null],[13,"ClosurePanicked","","The delegated closure has panicked.",0,null],[0,"application","","This module contains runtime and application related…",null,null],[3,"ApplicationSettings","browser_window::application","",null,null],[3,"Application","","Use this to initialize and start your application with.",null,null],[3,"ApplicationHandleThreaded","","Note: Only available with feature `threadsafe` enabled.",null,null],[3,"ApplicationHandle","","A thread-unsafe application handle. Often provided by for…",null,null],[3,"Runtime","","The runtime to run the application with.",null,null],[6,"ApplicationDelegateFuture","","The future that dispatches a closure onto the GUI thread",null,null],[8,"HasAppHandle","","",null,null],[10,"app_handle","","",1,[[],["applicationhandle",3]]],[11,"finish","","Shuts down other processes and performs any necessary…",2,[[]]],[11,"initialize","","In order to use the Browser Window API, you need to…",2,[[["applicationsettings",3]],["application",3]]],[11,"start","","Creates a `Runtime` from which you can run the application.",2,[[],["runtime",3]]],[11,"run","","Run the main loop and executes the given closure on it.",3,[[]]],[11,"run_async","","Runs the main loop and executes the given future within…",3,[[]]],[11,"spawn","","Use `run_async` instead.",3,[[]]],[11,"exit","","Causes the `Runtime` to terminate. The `Runtime`\'s…",4,[[]]],[11,"into_threaded","","Note: Only available with feature `threadsafe` enabled.",4,[[],["applicationhandlethreaded",3]]],[11,"spawn","","Spawns the given future, executing it on the GUI thread…",4,[[]]],[11,"delegate","","Executes the given closure `func` on the GUI thread, and…",5,[[],["applicationdelegatefuture",6]]],[11,"delegate_future","","Executes the given `future` on the GUI thread, and gives…",5,[[],["delegatefuturefuture",3]]],[11,"delegate_async","","Executes the given async closure `func` on the GUI thread,…",5,[[],["delegatefuturefuture",3]]],[11,"dispatch","","Queues the given closure `func` to be executed on the GUI…",5,[[]]],[11,"dispatch_async","","Queues the given async closure `func` to be executed on…",5,[[]]],[11,"exit","","Signals the runtime to exit. This will cause…",5,[[]]],[11,"spawn","","Executes the given future on the GUI thread somewhere in…",5,[[]]],[0,"browser","browser_window","This module contains all browser related handles and stuff.",null,null],[3,"BrowserWindowBuilder","browser_window::browser","Used to create a [`BrowserWindow`] or…",null,null],[3,"BrowserWindow","","An owned browser window handle. When this handle goes out…",null,null],[3,"BrowserWindowThreaded","","Note: Only available with feature `threadsafe` enabled.",null,null],[3,"BrowserWindowHandle","","This is a handle to an existing browser window.",null,null],[4,"Source","","The type of content to display in a browser window",null,null],[13,"Html","","Displays the given HTML code in the browser.",6,null],[13,"File","","Displays the local file for the given path.",6,null],[13,"Url","","Displays the given URL in the browser.",6,null],[11,"async_handler","","Configure a closure that can be invoked from within…",7,[[]]],[11,"dev_tools","","Sets whether or not an extra window with developer tools…",7,[[]]],[11,"new","","Creates an instance of a browser window builder.",7,[[["source",4]]]],[11,"build","","Creates the browser window.",7,[[["applicationhandlethreaded",3]]]],[6,"BrowserDelegateFuture","","The future that dispatches a closure on the GUI thread.",null,null],[8,"OwnedBrowserWindow","","",null,null],[10,"browser_handle","","",8,[[],["browserwindowhandle",3]]],[11,"app","","Returns the application handle associated with this…",9,[[],["applicationhandle",3]]],[11,"eval_js","","Executes the given javascript code and returns the output…",9,[[]]],[11,"exec_js","","Executes the given javascript code without waiting on it…",9,[[]]],[11,"navigate","","Causes the browser to navigate to the given url.",9,[[]]],[11,"window","","",9,[[],["windowhandle",3]]],[11,"app","","The thread-safe application handle associated with this…",10,[[],["applicationhandlethreaded",3]]],[11,"close","","Closes the browser.",10,[[]]],[11,"delegate","","Executes the given closure within the GUI thread, and…",10,[[],["browserdelegatefuture",6]]],[11,"delegate_async","","Executes the given async closure `func` on the GUI thread,…",10,[[],["delegatefuturefuture",3]]],[11,"delegate_future","","Executes the given future on the GUI thread, and gives…",10,[[],["delegatefuturefuture",3]]],[11,"dispatch","","Executes the given close on the GUI thread. See also…",10,[[]]],[11,"dispatch_async","","Executes the given closure on the GUI thread. See also…",10,[[]]],[0,"event","browser_window","This module contains all event related types.",null,null],[3,"Event","browser_window::event","",null,null],[11,"register","","Register a closure to be invoked for this event.",11,[[]]],[11,"register_async","","Register an \'async closure\' to be invoked for this event.",11,[[]]],[0,"prelude","browser_window","Some common traits that need to be often available.",null,null],[8,"Property","browser_window::prelude","A property is something that has a setter and a getter.",null,null],[10,"get","","",12,[[]]],[10,"set","","",12,[[]]],[0,"window","browser_window","This module contains all window related functionality.",null,null],[3,"WindowBuilder","browser_window::window","Exposes functionality related to constructing a window.",null,null],[3,"WindowHandle","","A handle that exposes all windowing functionality.",null,null],[3,"WindowResizeEventArgs","","",null,null],[3,"ContentDimensions","","Gets or sets the width and height of the content of the…",null,null],[3,"Opacity","","Gets or sets the opacity of the window. An opacity of 255…",null,null],[3,"Position","","Gets or sets the current position of the window.",null,null],[3,"Title","","Gets or sets the title of the window.",null,null],[3,"WindowDimensions","","Gets or sets the current window size including its border…",null,null],[11,"borders","","Sets whether or not the window has borders. Default is true.",13,[[]]],[11,"height","","Sets the height that the browser window will be created…",13,[[]]],[11,"minimizable","","Sets whether or not the window has a minimize button on…",13,[[]]],[11,"parent","","Sets the opacity of the window. An opacity of 255 is the…",13,[[]]],[11,"new","","",13,[[]]],[11,"size","","Sets the width and height of the browser window",13,[[]]],[11,"title","","Sets the title of the window.",13,[[["into",8],["string",3]]]],[11,"width","","Sets the width that the browser window will be created…",13,[[]]],[11,"resizable","","Sets whether or not the window will be resizable. Default…",13,[[]]],[6,"StandardWindowEvent","","",null,null],[8,"OwnedWindow","","",null,null],[10,"window_handle","","",14,[[],["windowhandle",3]]],[11,"content_dimensions","","",15,[[],["contentdimensions",3]]],[11,"opacity","","",15,[[],["opacity",3]]],[11,"position","","",15,[[],["position",3]]],[11,"title","","",15,[[],["title",3]]],[11,"window_dimensions","","",15,[[],["windowdimensions",3]]],[11,"close","","Destroys the window.",15,[[]]],[11,"hide","","Make the window invisible to the user.",15,[[]]],[11,"show","","Make the window visible to the user.",15,[[]]],[8,"Property","browser_window","A property is something that has a setter and a getter.",null,null],[10,"get","","",12,[[]]],[10,"set","","",12,[[]]],[11,"from","","",16,[[]]],[11,"into","","",16,[[]]],[11,"borrow","","",16,[[]]],[11,"borrow_mut","","",16,[[]]],[11,"try_from","","",16,[[],["result",4]]],[11,"try_into","","",16,[[],["result",4]]],[11,"type_id","","",16,[[],["typeid",3]]],[11,"into_future","","",16,[[]]],[11,"try_poll","","",16,[[["pin",3],["context",3]],["poll",4]]],[11,"from","","",17,[[]]],[11,"into","","",17,[[]]],[11,"borrow","","",17,[[]]],[11,"borrow_mut","","",17,[[]]],[11,"try_from","","",17,[[],["result",4]]],[11,"try_into","","",17,[[],["result",4]]],[11,"type_id","","",17,[[],["typeid",3]]],[11,"into_future","","",17,[[]]],[11,"try_poll","","",17,[[["pin",3],["context",3]],["poll",4]]],[11,"from","","",0,[[]]],[11,"into","","",0,[[]]],[11,"borrow","","",0,[[]]],[11,"borrow_mut","","",0,[[]]],[11,"try_from","","",0,[[],["result",4]]],[11,"try_into","","",0,[[],["result",4]]],[11,"type_id","","",0,[[],["typeid",3]]],[11,"from","browser_window::application","",18,[[]]],[11,"into","","",18,[[]]],[11,"borrow","","",18,[[]]],[11,"borrow_mut","","",18,[[]]],[11,"try_from","","",18,[[],["result",4]]],[11,"try_into","","",18,[[],["result",4]]],[11,"type_id","","",18,[[],["typeid",3]]],[11,"from","","",2,[[]]],[11,"into","","",2,[[]]],[11,"borrow","","",2,[[]]],[11,"borrow_mut","","",2,[[]]],[11,"try_from","","",2,[[],["result",4]]],[11,"try_into","","",2,[[],["result",4]]],[11,"type_id","","",2,[[],["typeid",3]]],[11,"from","","",5,[[]]],[11,"into","","",5,[[]]],[11,"to_owned","","",5,[[]]],[11,"clone_into","","",5,[[]]],[11,"borrow","","",5,[[]]],[11,"borrow_mut","","",5,[[]]],[11,"try_from","","",5,[[],["result",4]]],[11,"try_into","","",5,[[],["result",4]]],[11,"type_id","","",5,[[],["typeid",3]]],[11,"from","","",4,[[]]],[11,"into","","",4,[[]]],[11,"to_owned","","",4,[[]]],[11,"clone_into","","",4,[[]]],[11,"borrow","","",4,[[]]],[11,"borrow_mut","","",4,[[]]],[11,"try_from","","",4,[[],["result",4]]],[11,"try_into","","",4,[[],["result",4]]],[11,"type_id","","",4,[[],["typeid",3]]],[11,"from","","",3,[[]]],[11,"into","","",3,[[]]],[11,"borrow","","",3,[[]]],[11,"borrow_mut","","",3,[[]]],[11,"try_from","","",3,[[],["result",4]]],[11,"try_into","","",3,[[],["result",4]]],[11,"type_id","","",3,[[],["typeid",3]]],[11,"from","browser_window::browser","",7,[[]]],[11,"into","","",7,[[]]],[11,"borrow","","",7,[[]]],[11,"borrow_mut","","",7,[[]]],[11,"try_from","","",7,[[],["result",4]]],[11,"try_into","","",7,[[],["result",4]]],[11,"type_id","","",7,[[],["typeid",3]]],[11,"from","","",19,[[]]],[11,"into","","",19,[[]]],[11,"borrow","","",19,[[]]],[11,"borrow_mut","","",19,[[]]],[11,"try_from","","",19,[[],["result",4]]],[11,"try_into","","",19,[[],["result",4]]],[11,"type_id","","",19,[[],["typeid",3]]],[11,"from","","",10,[[]]],[11,"into","","",10,[[]]],[11,"borrow","","",10,[[]]],[11,"borrow_mut","","",10,[[]]],[11,"try_from","","",10,[[],["result",4]]],[11,"try_into","","",10,[[],["result",4]]],[11,"type_id","","",10,[[],["typeid",3]]],[11,"from","","",9,[[]]],[11,"into","","",9,[[]]],[11,"to_owned","","",9,[[]]],[11,"clone_into","","",9,[[]]],[11,"borrow","","",9,[[]]],[11,"borrow_mut","","",9,[[]]],[11,"try_from","","",9,[[],["result",4]]],[11,"try_into","","",9,[[],["result",4]]],[11,"type_id","","",9,[[],["typeid",3]]],[11,"from","","",6,[[]]],[11,"into","","",6,[[]]],[11,"borrow","","",6,[[]]],[11,"borrow_mut","","",6,[[]]],[11,"try_from","","",6,[[],["result",4]]],[11,"try_into","","",6,[[],["result",4]]],[11,"type_id","","",6,[[],["typeid",3]]],[11,"from","browser_window::event","",11,[[]]],[11,"into","","",11,[[]]],[11,"borrow","","",11,[[]]],[11,"borrow_mut","","",11,[[]]],[11,"try_from","","",11,[[],["result",4]]],[11,"try_into","","",11,[[],["result",4]]],[11,"type_id","","",11,[[],["typeid",3]]],[11,"from","browser_window::window","",13,[[]]],[11,"into","","",13,[[]]],[11,"borrow","","",13,[[]]],[11,"borrow_mut","","",13,[[]]],[11,"try_from","","",13,[[],["result",4]]],[11,"try_into","","",13,[[],["result",4]]],[11,"type_id","","",13,[[],["typeid",3]]],[11,"from","","",15,[[]]],[11,"into","","",15,[[]]],[11,"to_owned","","",15,[[]]],[11,"clone_into","","",15,[[]]],[11,"borrow","","",15,[[]]],[11,"borrow_mut","","",15,[[]]],[11,"try_from","","",15,[[],["result",4]]],[11,"try_into","","",15,[[],["result",4]]],[11,"type_id","","",15,[[],["typeid",3]]],[11,"from","","",20,[[]]],[11,"into","","",20,[[]]],[11,"borrow","","",20,[[]]],[11,"borrow_mut","","",20,[[]]],[11,"try_from","","",20,[[],["result",4]]],[11,"try_into","","",20,[[],["result",4]]],[11,"type_id","","",20,[[],["typeid",3]]],[11,"from","","",21,[[]]],[11,"into","","",21,[[]]],[11,"borrow","","",21,[[]]],[11,"borrow_mut","","",21,[[]]],[11,"try_from","","",21,[[],["result",4]]],[11,"try_into","","",21,[[],["result",4]]],[11,"type_id","","",21,[[],["typeid",3]]],[11,"from","","",22,[[]]],[11,"into","","",22,[[]]],[11,"borrow","","",22,[[]]],[11,"borrow_mut","","",22,[[]]],[11,"try_from","","",22,[[],["result",4]]],[11,"try_into","","",22,[[],["result",4]]],[11,"type_id","","",22,[[],["typeid",3]]],[11,"from","","",23,[[]]],[11,"into","","",23,[[]]],[11,"borrow","","",23,[[]]],[11,"borrow_mut","","",23,[[]]],[11,"try_from","","",23,[[],["result",4]]],[11,"try_into","","",23,[[],["result",4]]],[11,"type_id","","",23,[[],["typeid",3]]],[11,"from","","",24,[[]]],[11,"into","","",24,[[]]],[11,"borrow","","",24,[[]]],[11,"borrow_mut","","",24,[[]]],[11,"try_from","","",24,[[],["result",4]]],[11,"try_into","","",24,[[],["result",4]]],[11,"type_id","","",24,[[],["typeid",3]]],[11,"from","","",25,[[]]],[11,"into","","",25,[[]]],[11,"borrow","","",25,[[]]],[11,"borrow_mut","","",25,[[]]],[11,"try_from","","",25,[[],["result",4]]],[11,"try_into","","",25,[[],["result",4]]],[11,"type_id","","",25,[[],["typeid",3]]],[11,"default","browser_window::application","",18,[[],["applicationsettings",3]]],[11,"get","browser_window::window","",21,[[],["dims2d",6]]],[11,"set","","",21,[[["dims2d",6]]]],[11,"get","","",22,[[]]],[11,"set","","",22,[[]]],[11,"get","","",23,[[],["pos2d",6]]],[11,"set","","",23,[[["pos2d",6]]]],[11,"get","","",24,[[],["string",3]]],[11,"set","","",24,[[]]],[11,"get","","",25,[[],["dims2d",6]]],[11,"set","","",25,[[["dims2d",6]]]],[11,"app_handle","browser_window::application","",4,[[],["applicationhandle",3]]],[11,"app_handle","browser_window::browser","",19,[[],["applicationhandle",3]]],[11,"app_handle","","",10,[[],["applicationhandle",3]]],[11,"app_handle","","",9,[[],["applicationhandle",3]]],[11,"browser_handle","","",19,[[],["browserwindowhandle",3]]],[11,"browser_handle","","",10,[[],["browserwindowhandle",3]]],[11,"window_handle","","",19,[[],["windowhandle",3]]],[11,"window_handle","","",10,[[],["windowhandle",3]]],[11,"drop","browser_window::application","",2,[[]]],[11,"drop","browser_window::browser","",19,[[]]],[11,"from","browser_window::application","",2,[[["applicationhandle",3]]]],[11,"from","","",5,[[["applicationhandle",3]]]],[11,"clone","","",5,[[],["applicationhandlethreaded",3]]],[11,"clone","","",4,[[],["applicationhandle",3]]],[11,"clone","browser_window::browser","",9,[[],["browserwindowhandle",3]]],[11,"clone","browser_window::window","",15,[[],["windowhandle",3]]],[11,"default","browser_window::event","",11,[[]]],[11,"deref","browser_window::browser","",7,[[]]],[11,"deref","","",19,[[]]],[11,"deref","","",9,[[]]],[11,"deref_mut","","",7,[[]]],[11,"fmt","browser_window","",0,[[["formatter",3]],["result",6]]],[11,"poll","","",16,[[["context",3],["pin",3]],["poll",4]]],[11,"poll","","",17,[[["context",3],["pin",3]],["poll",4]]]],"p":[[4,"DelegateError"],[8,"HasAppHandle"],[3,"Application"],[3,"Runtime"],[3,"ApplicationHandle"],[3,"ApplicationHandleThreaded"],[4,"Source"],[3,"BrowserWindowBuilder"],[8,"OwnedBrowserWindow"],[3,"BrowserWindowHandle"],[3,"BrowserWindowThreaded"],[3,"Event"],[8,"Property"],[3,"WindowBuilder"],[8,"OwnedWindow"],[3,"WindowHandle"],[3,"DelegateFuture"],[3,"DelegateFutureFuture"],[3,"ApplicationSettings"],[3,"BrowserWindow"],[3,"WindowResizeEventArgs"],[3,"ContentDimensions"],[3,"Opacity"],[3,"Position"],[3,"Title"],[3,"WindowDimensions"]]},\
"browser_window_c":{"doc":"","i":[[3,"cmax_align_t","browser_window_c","",null,null],[12,"__clang_max_align_nonce1","","",0,null],[12,"__bindgen_padding_0","","",0,null],[12,"__clang_max_align_nonce2","","",0,null],[3,"cbw_StrSlice","","A \'string slice\' Points to a mutable, non-zero-terminated,…",null,null],[12,"len","","",1,null],[12,"data","","",1,null],[3,"cbw_CStrSlice","","A \'const string slice\' Points to a immutable,…",null,null],[12,"len","","",2,null],[12,"data","","",2,null],[3,"cbw_ApplicationImpl","","",null,null],[3,"cbw_ApplicationEngineImpl","","",null,null],[3,"cbw_Application","","",null,null],[12,"windows_alive","","",3,null],[12,"impl_","","",3,null],[12,"engine_impl","","",3,null],[3,"cbw_ApplicationEngineData","","",null,null],[3,"cbw_ApplicationDispatchData","","",null,null],[12,"func","","",4,null],[12,"data","","",4,null],[3,"cbw_ApplicationSettings","","",null,null],[12,"resource_dir","","",5,null],[3,"cbw_BrowserWindowImpl","","",null,null],[12,"cef_ptr","","",6,null],[12,"resource_path","","",6,null],[3,"cdiv_t","","",null,null],[12,"quot","","",7,null],[12,"rem","","",7,null],[3,"cldiv_t","","",null,null],[12,"quot","","",8,null],[12,"rem","","",8,null],[3,"clldiv_t","","",null,null],[12,"quot","","",9,null],[12,"rem","","",9,null],[3,"c__fsid_t","","",null,null],[12,"__val","","",10,null],[3,"c__sigset_t","","",null,null],[12,"__val","","",11,null],[3,"ctimeval","","",null,null],[12,"tv_sec","","",12,null],[12,"tv_usec","","",12,null],[3,"ctimespec","","",null,null],[12,"tv_sec","","",13,null],[12,"tv_nsec","","",13,null],[3,"cfd_set","","",null,null],[12,"__fds_bits","","",14,null],[3,"c__pthread_internal_list","","",null,null],[12,"__prev","","",15,null],[12,"__next","","",15,null],[3,"c__pthread_internal_slist","","",null,null],[12,"__next","","",16,null],[3,"c__pthread_mutex_s","","",null,null],[12,"__lock","","",17,null],[12,"__count","","",17,null],[12,"__owner","","",17,null],[12,"__nusers","","",17,null],[12,"__kind","","",17,null],[12,"__spins","","",17,null],[12,"__elision","","",17,null],[12,"__list","","",17,null],[3,"c__pthread_rwlock_arch_t","","",null,null],[12,"__readers","","",18,null],[12,"__writers","","",18,null],[12,"__wrphase_futex","","",18,null],[12,"__writers_futex","","",18,null],[12,"__pad3","","",18,null],[12,"__pad4","","",18,null],[12,"__cur_writer","","",18,null],[12,"__shared","","",18,null],[12,"__rwelision","","",18,null],[12,"__pad1","","",18,null],[12,"__pad2","","",18,null],[12,"__flags","","",18,null],[3,"c__pthread_cond_s","","",null,null],[12,"__bindgen_anon_1","","",19,null],[12,"__bindgen_anon_2","","",19,null],[12,"__g_refs","","",19,null],[12,"__g_size","","",19,null],[12,"__g1_orig_size","","",19,null],[12,"__wrefs","","",19,null],[12,"__g_signals","","",19,null],[3,"c__pthread_cond_s__bindgen_ty_1__bindgen_ty_1","","",null,null],[12,"__low","","",20,null],[12,"__high","","",20,null],[3,"c__pthread_cond_s__bindgen_ty_2__bindgen_ty_1","","",null,null],[12,"__low","","",21,null],[12,"__high","","",21,null],[3,"crandom_data","","",null,null],[12,"fptr","","",22,null],[12,"rptr","","",22,null],[12,"state","","",22,null],[12,"rand_type","","",22,null],[12,"rand_deg","","",22,null],[12,"rand_sep","","",22,null],[12,"end_ptr","","",22,null],[3,"cdrand48_data","","",null,null],[12,"__x","","",23,null],[12,"__old_x","","",23,null],[12,"__c","","",23,null],[12,"__init","","",23,null],[12,"__a","","",23,null],[3,"c__locale_struct","","",null,null],[12,"__locales","","",24,null],[12,"__ctype_b","","",24,null],[12,"__ctype_tolower","","",24,null],[12,"__ctype_toupper","","",24,null],[12,"__names","","",24,null],[3,"cbw_Err","","",null,null],[12,"code","","",25,null],[12,"data","","",25,null],[12,"alloc_message","","",25,null],[3,"c__mbstate_t","","",null,null],[12,"__count","","",26,null],[12,"__value","","",26,null],[3,"c_G_fpos_t","","",null,null],[12,"__pos","","",27,null],[12,"__state","","",27,null],[3,"c_G_fpos64_t","","",null,null],[12,"__pos","","",28,null],[12,"__state","","",28,null],[3,"c_IO_marker","","",null,null],[3,"c_IO_codecvt","","",null,null],[3,"c_IO_wide_data","","",null,null],[3,"c_IO_FILE","","",null,null],[12,"_flags","","",29,null],[12,"_IO_read_ptr","","",29,null],[12,"_IO_read_end","","",29,null],[12,"_IO_read_base","","",29,null],[12,"_IO_write_base","","",29,null],[12,"_IO_write_ptr","","",29,null],[12,"_IO_write_end","","",29,null],[12,"_IO_buf_base","","",29,null],[12,"_IO_buf_end","","",29,null],[12,"_IO_save_base","","",29,null],[12,"_IO_backup_base","","",29,null],[12,"_IO_save_end","","",29,null],[12,"_markers","","",29,null],[12,"_chain","","",29,null],[12,"_fileno","","",29,null],[12,"_flags2","","",29,null],[12,"_old_offset","","",29,null],[12,"_cur_column","","",29,null],[12,"_vtable_offset","","",29,null],[12,"_shortbuf","","",29,null],[12,"_lock","","",29,null],[12,"_offset","","",29,null],[12,"_codecvt","","",29,null],[12,"_wide_data","","",29,null],[12,"_freeres_list","","",29,null],[12,"_freeres_buf","","",29,null],[12,"__pad5","","",29,null],[12,"_mode","","",29,null],[12,"_unused2","","",29,null],[3,"cbw_Dims2D","","",null,null],[12,"width","","",30,null],[12,"height","","",30,null],[3,"cbw_Pos2D","","",null,null],[12,"x","","",31,null],[12,"y","","",31,null],[3,"cbw_WindowImpl","","",null,null],[3,"cbw_WindowCallbacks","","",null,null],[12,"do_cleanup","","Fired just before the window gets destroyed and freed from…",32,null],[12,"on_close","","Fired when the window has been closed, either by the user…",32,null],[12,"on_loaded","","Fired when a window has finished loading",32,null],[12,"on_resize","","Fired when a window is resizing",32,null],[3,"cbw_WindowOptions","","",null,null],[12,"borders","","",33,null],[12,"minimizable","","",33,null],[12,"resizable","","",33,null],[3,"cbw_WindowDispatchData","","",null,null],[3,"cbw_Window","","",null,null],[12,"app","","",34,null],[12,"parent","","",34,null],[12,"closed","","",34,null],[12,"dropped","","",34,null],[12,"callbacks","","",34,null],[12,"user_data","","",34,null],[12,"impl_","","",34,null],[3,"cbw_BrowserWindowOptions","","",null,null],[12,"dev_tools","","",35,null],[12,"resource_path","","",35,null],[3,"cbw_BrowserWindowSource","","",null,null],[12,"data","","",36,null],[12,"is_html","","",36,null],[3,"cbw_BrowserWindow","","",null,null],[12,"window","","",37,null],[12,"external_handler","","",37,null],[12,"user_data","","",37,null],[12,"impl_","","",37,null],[3,"c__locale_data","","",null,null],[12,"_address","","",38,null],[3,"c__va_list_tag","","",null,null],[12,"gp_offset","","",39,null],[12,"fp_offset","","",39,null],[12,"overflow_arg_area","","",39,null],[12,"reg_save_area","","",39,null],[19,"c__pthread_cond_s__bindgen_ty_1","","",null,null],[12,"__wseq","","",40,null],[12,"__wseq32","","",40,null],[19,"c__pthread_cond_s__bindgen_ty_2","","",null,null],[12,"__g1_start","","",41,null],[12,"__g1_start32","","",41,null],[19,"cpthread_mutexattr_t","","",null,null],[12,"__size","","",42,null],[12,"__align","","",42,null],[19,"cpthread_condattr_t","","",null,null],[12,"__size","","",43,null],[12,"__align","","",43,null],[19,"cpthread_attr_t","","",null,null],[12,"__size","","",44,null],[12,"__align","","",44,null],[19,"cpthread_mutex_t","","",null,null],[12,"__data","","",45,null],[12,"__size","","",45,null],[12,"__align","","",45,null],[19,"cpthread_cond_t","","",null,null],[12,"__data","","",46,null],[12,"__size","","",46,null],[12,"__align","","",46,null],[19,"cpthread_rwlock_t","","",null,null],[12,"__data","","",47,null],[12,"__size","","",47,null],[12,"__align","","",47,null],[19,"cpthread_rwlockattr_t","","",null,null],[12,"__size","","",48,null],[12,"__align","","",48,null],[19,"cpthread_barrier_t","","",null,null],[12,"__size","","",49,null],[12,"__align","","",49,null],[19,"cpthread_barrierattr_t","","",null,null],[12,"__size","","",50,null],[12,"__align","","",50,null],[19,"c__mbstate_t__bindgen_ty_1","","",null,null],[12,"__wch","","",51,null],[12,"__wchb","","",51,null],[5,"cbw_string_copyAsNewCstr","","Copies the string from the given `bw_CStrSlice` to a C…",null,null],[5,"cbw_string_freeCstr","","Frees the string allocated with any of the functions of…",null,null],[5,"cbw_Application_assertCorrectThread","","Safety check that makes sure the given application handle…",null,null],[5,"cbw_Application_exit","","Exits the main loop, returning execution to the function…",null,null],[5,"cbw_Application_exitAsync","","Same as bw_Application_exit, but guaranteed to be…",null,null],[5,"cbw_Application_dispatch","","Dispatches the given function to be executed on the thread…",null,null],[5,"cbw_Application_finish","","Shuts down all application processes and performs…",null,null],[5,"cbw_Application_free","","Frees memory for the application handle. Call…",null,null],[5,"cbw_Application_initialize","","Initializes browser window. Starts up browser engine…",null,null],[5,"cbw_Application_isRunning","","",null,null],[5,"cbw_Application_run","","Runs the event loop. Calls the `on_ready` callback when…",null,null],[5,"c__ctype_get_mb_cur_max","","",null,null],[5,"catof","","",null,null],[5,"catoi","","",null,null],[5,"catol","","",null,null],[5,"catoll","","",null,null],[5,"cstrtod","","",null,null],[5,"cstrtof","","",null,null],[5,"cstrtold","","",null,null],[5,"cstrtol","","",null,null],[5,"cstrtoul","","",null,null],[5,"cstrtoq","","",null,null],[5,"cstrtouq","","",null,null],[5,"cstrtoll","","",null,null],[5,"cstrtoull","","",null,null],[5,"cl64a","","",null,null],[5,"ca64l","","",null,null],[5,"cselect","","",null,null],[5,"cpselect","","",null,null],[5,"crandom","","",null,null],[5,"csrandom","","",null,null],[5,"cinitstate","","",null,null],[5,"csetstate","","",null,null],[5,"crandom_r","","",null,null],[5,"csrandom_r","","",null,null],[5,"cinitstate_r","","",null,null],[5,"csetstate_r","","",null,null],[5,"crand","","",null,null],[5,"csrand","","",null,null],[5,"crand_r","","",null,null],[5,"cdrand48","","",null,null],[5,"cerand48","","",null,null],[5,"clrand48","","",null,null],[5,"cnrand48","","",null,null],[5,"cmrand48","","",null,null],[5,"cjrand48","","",null,null],[5,"csrand48","","",null,null],[5,"cseed48","","",null,null],[5,"clcong48","","",null,null],[5,"cdrand48_r","","",null,null],[5,"cerand48_r","","",null,null],[5,"clrand48_r","","",null,null],[5,"cnrand48_r","","",null,null],[5,"cmrand48_r","","",null,null],[5,"cjrand48_r","","",null,null],[5,"csrand48_r","","",null,null],[5,"cseed48_r","","",null,null],[5,"clcong48_r","","",null,null],[5,"cmalloc","","",null,null],[5,"ccalloc","","",null,null],[5,"crealloc","","",null,null],[5,"creallocarray","","",null,null],[5,"cfree","","",null,null],[5,"calloca","","",null,null],[5,"cvalloc","","",null,null],[5,"cposix_memalign","","",null,null],[5,"caligned_alloc","","",null,null],[5,"cabort","","",null,null],[5,"catexit","","",null,null],[5,"cat_quick_exit","","",null,null],[5,"con_exit","","",null,null],[5,"cexit","","",null,null],[5,"cquick_exit","","",null,null],[5,"c_Exit","","",null,null],[5,"cgetenv","","",null,null],[5,"cputenv","","",null,null],[5,"csetenv","","",null,null],[5,"cunsetenv","","",null,null],[5,"cclearenv","","",null,null],[5,"cmktemp","","",null,null],[5,"cmkstemp","","",null,null],[5,"cmkstemps","","",null,null],[5,"cmkdtemp","","",null,null],[5,"csystem","","",null,null],[5,"crealpath","","",null,null],[5,"cbsearch","","",null,null],[5,"cqsort","","",null,null],[5,"cabs","","",null,null],[5,"clabs","","",null,null],[5,"cllabs","","",null,null],[5,"cdiv","","",null,null],[5,"cldiv","","",null,null],[5,"clldiv","","",null,null],[5,"cecvt","","",null,null],[5,"cfcvt","","",null,null],[5,"cgcvt","","",null,null],[5,"cqecvt","","",null,null],[5,"cqfcvt","","",null,null],[5,"cqgcvt","","",null,null],[5,"cecvt_r","","",null,null],[5,"cfcvt_r","","",null,null],[5,"cqecvt_r","","",null,null],[5,"cqfcvt_r","","",null,null],[5,"cmblen","","",null,null],[5,"cmbtowc","","",null,null],[5,"cwctomb","","",null,null],[5,"cmbstowcs","","",null,null],[5,"cwcstombs","","",null,null],[5,"crpmatch","","",null,null],[5,"cgetsubopt","","",null,null],[5,"cgetloadavg","","",null,null],[5,"cmemcpy","","",null,null],[5,"cmemmove","","",null,null],[5,"cmemccpy","","",null,null],[5,"cmemset","","",null,null],[5,"cmemcmp","","",null,null],[5,"cmemchr","","",null,null],[5,"cstrcpy","","",null,null],[5,"cstrncpy","","",null,null],[5,"cstrcat","","",null,null],[5,"cstrncat","","",null,null],[5,"cstrcmp","","",null,null],[5,"cstrncmp","","",null,null],[5,"cstrcoll","","",null,null],[5,"cstrxfrm","","",null,null],[5,"cstrcoll_l","","",null,null],[5,"cstrxfrm_l","","",null,null],[5,"cstrdup","","",null,null],[5,"cstrndup","","",null,null],[5,"cstrchr","","",null,null],[5,"cstrrchr","","",null,null],[5,"cstrcspn","","",null,null],[5,"cstrspn","","",null,null],[5,"cstrpbrk","","",null,null],[5,"cstrstr","","",null,null],[5,"cstrtok","","",null,null],[5,"c__strtok_r","","",null,null],[5,"cstrtok_r","","",null,null],[5,"cstrlen","","",null,null],[5,"cstrnlen","","",null,null],[5,"cstrerror","","",null,null],[5,"cstrerror_r","","",null,null],[5,"cstrerror_l","","",null,null],[5,"cbcmp","","",null,null],[5,"cbcopy","","",null,null],[5,"cbzero","","",null,null],[5,"cindex","","",null,null],[5,"crindex","","",null,null],[5,"cffs","","",null,null],[5,"cffsl","","",null,null],[5,"cffsll","","",null,null],[5,"cstrcasecmp","","",null,null],[5,"cstrncasecmp","","",null,null],[5,"cstrcasecmp_l","","",null,null],[5,"cstrncasecmp_l","","",null,null],[5,"cexplicit_bzero","","",null,null],[5,"cstrsep","","",null,null],[5,"cstrsignal","","",null,null],[5,"c__stpcpy","","",null,null],[5,"cstpcpy","","",null,null],[5,"c__stpncpy","","",null,null],[5,"cstpncpy","","",null,null],[5,"cbw_Err_msg_success","","",null,null],[5,"cbw_Err_msg_string","","",null,null],[5,"cbw_Err_free","","",null,null],[5,"cbw_Err_new_with_msg","","",null,null],[5,"c__assert_fail","","",null,null],[5,"c__assert_perror_fail","","",null,null],[5,"c__assert","","",null,null],[7,"cstdin","","",null,null],[7,"cstdout","","",null,null],[7,"cstderr","","",null,null],[5,"cremove","","",null,null],[5,"crename","","",null,null],[5,"crenameat","","",null,null],[5,"ctmpfile","","",null,null],[5,"ctmpnam","","",null,null],[5,"ctmpnam_r","","",null,null],[5,"ctempnam","","",null,null],[5,"cfclose","","",null,null],[5,"cfflush","","",null,null],[5,"cfflush_unlocked","","",null,null],[5,"cfopen","","",null,null],[5,"cfreopen","","",null,null],[5,"cfdopen","","",null,null],[5,"cfmemopen","","",null,null],[5,"copen_memstream","","",null,null],[5,"csetbuf","","",null,null],[5,"csetvbuf","","",null,null],[5,"csetbuffer","","",null,null],[5,"csetlinebuf","","",null,null],[5,"cfprintf","","",null,null],[5,"cprintf","","",null,null],[5,"csprintf","","",null,null],[5,"cvfprintf","","",null,null],[5,"cvprintf","","",null,null],[5,"cvsprintf","","",null,null],[5,"csnprintf","","",null,null],[5,"cvsnprintf","","",null,null],[5,"cvdprintf","","",null,null],[5,"cdprintf","","",null,null],[5,"cfscanf","","",null,null],[5,"cscanf","","",null,null],[5,"csscanf","","",null,null],[5,"cfscanf1","","",null,null],[5,"cscanf1","","",null,null],[5,"csscanf1","","",null,null],[5,"cvfscanf","","",null,null],[5,"cvscanf","","",null,null],[5,"cvsscanf","","",null,null],[5,"cvfscanf1","","",null,null],[5,"cvscanf1","","",null,null],[5,"cvsscanf1","","",null,null],[5,"cfgetc","","",null,null],[5,"cgetc","","",null,null],[5,"cgetchar","","",null,null],[5,"cgetc_unlocked","","",null,null],[5,"cgetchar_unlocked","","",null,null],[5,"cfgetc_unlocked","","",null,null],[5,"cfputc","","",null,null],[5,"cputc","","",null,null],[5,"cputchar","","",null,null],[5,"cfputc_unlocked","","",null,null],[5,"cputc_unlocked","","",null,null],[5,"cputchar_unlocked","","",null,null],[5,"cgetw","","",null,null],[5,"cputw","","",null,null],[5,"cfgets","","",null,null],[5,"c__getdelim","","",null,null],[5,"cgetdelim","","",null,null],[5,"cgetline","","",null,null],[5,"cfputs","","",null,null],[5,"cputs","","",null,null],[5,"cungetc","","",null,null],[5,"cfread","","",null,null],[5,"cfwrite","","",null,null],[5,"cfread_unlocked","","",null,null],[5,"cfwrite_unlocked","","",null,null],[5,"cfseek","","",null,null],[5,"cftell","","",null,null],[5,"crewind","","",null,null],[5,"cfseeko","","",null,null],[5,"cftello","","",null,null],[5,"cfgetpos","","",null,null],[5,"cfsetpos","","",null,null],[5,"cclearerr","","",null,null],[5,"cfeof","","",null,null],[5,"cferror","","",null,null],[5,"cclearerr_unlocked","","",null,null],[5,"cfeof_unlocked","","",null,null],[5,"cferror_unlocked","","",null,null],[5,"cperror","","",null,null],[7,"csys_nerr","","",null,null],[7,"csys_errlist","","",null,null],[5,"cfileno","","",null,null],[5,"cfileno_unlocked","","",null,null],[5,"cpopen","","",null,null],[5,"cpclose","","",null,null],[5,"cctermid","","",null,null],[5,"cflockfile","","",null,null],[5,"cftrylockfile","","",null,null],[5,"cfunlockfile","","",null,null],[5,"c__uflow","","",null,null],[5,"c__overflow","","",null,null],[5,"c__errno_location","","",null,null],[5,"cbw_Window_destroy","","Destroy the window, releasing all resources it holds.…",null,null],[5,"cbw_Window_drop","","Invalidates the window handle. The window will get…",null,null],[5,"cbw_Window_getContentDimensions","","Gets the width and height of the usable area inside the…",null,null],[5,"cbw_Window_getOpacity","","Gets the opacity of the window as a value from 0 to 255.",null,null],[5,"cbw_Window_getPosition","","Gets the X and Y coordinates of the window position…",null,null],[5,"cbw_Window_getTitle","","Copies as many bytes into `title` that fit in there.…",null,null],[5,"cbw_Window_getWindowDimensions","","Gets the width and height of the window including the…",null,null],[5,"cbw_Window_hide","","",null,null],[5,"cbw_Window_isVisible","","Returns whether or not the window is not hidden.…",null,null],[5,"cbw_Window_new","","Creates a new (empty) window The returned pointer is a…",null,null],[5,"cbw_Window_setContentDimensions","","",null,null],[5,"cbw_Window_setOpacity","","",null,null],[5,"cbw_Window_setPosition","","",null,null],[5,"cbw_Window_setTitle","","Applies the given title;",null,null],[5,"cbw_Window_setWindowDimensions","","",null,null],[5,"cbw_Window_show","","Shows the window if it was previously hidden Is generally…",null,null],[5,"cbw_Window_triggerClose","","",null,null],[5,"c_bw_Window_onResize","","",null,null],[5,"cbw_BrowserWindow_destroy","","",null,null],[5,"cbw_BrowserWindow_drop","","Marks the browser window handle as not being used anymore.…",null,null],[5,"cbw_BrowserWindow_evalJs","","Executes the given JavaScript and calls the given callback…",null,null],[5,"cbw_BrowserWindow_evalJsThreaded","","",null,null],[5,"cbw_BrowserWindow_getApp","","",null,null],[5,"cbw_BrowserWindow_getUserData","","",null,null],[5,"cbw_BrowserWindow_getWindow","","",null,null],[5,"cbw_BrowserWindow_navigate","","",null,null],[5,"cbw_BrowserWindow_new","","Creates a new browser window",null,null],[6,"cBOOL","","",null,null],[6,"csize_t","","",null,null],[6,"cwchar_t","","",null,null],[6,"cbw_ApplicationDispatchFn","","",null,null],[6,"cbw_ApplicationReadyFn","","",null,null],[6,"cidtype_t","","",null,null],[6,"c_Float32","","",null,null],[6,"c_Float64","","",null,null],[6,"c_Float32x","","",null,null],[6,"c_Float64x","","",null,null],[6,"c__u_char","","",null,null],[6,"c__u_short","","",null,null],[6,"c__u_int","","",null,null],[6,"c__u_long","","",null,null],[6,"c__int8_t","","",null,null],[6,"c__uint8_t","","",null,null],[6,"c__int16_t","","",null,null],[6,"c__uint16_t","","",null,null],[6,"c__int32_t","","",null,null],[6,"c__uint32_t","","",null,null],[6,"c__int64_t","","",null,null],[6,"c__uint64_t","","",null,null],[6,"c__int_least8_t","","",null,null],[6,"c__uint_least8_t","","",null,null],[6,"c__int_least16_t","","",null,null],[6,"c__uint_least16_t","","",null,null],[6,"c__int_least32_t","","",null,null],[6,"c__uint_least32_t","","",null,null],[6,"c__int_least64_t","","",null,null],[6,"c__uint_least64_t","","",null,null],[6,"c__quad_t","","",null,null],[6,"c__u_quad_t","","",null,null],[6,"c__intmax_t","","",null,null],[6,"c__uintmax_t","","",null,null],[6,"c__dev_t","","",null,null],[6,"c__uid_t","","",null,null],[6,"c__gid_t","","",null,null],[6,"c__ino_t","","",null,null],[6,"c__ino64_t","","",null,null],[6,"c__mode_t","","",null,null],[6,"c__nlink_t","","",null,null],[6,"c__off_t","","",null,null],[6,"c__off64_t","","",null,null],[6,"c__pid_t","","",null,null],[6,"c__clock_t","","",null,null],[6,"c__rlim_t","","",null,null],[6,"c__rlim64_t","","",null,null],[6,"c__id_t","","",null,null],[6,"c__time_t","","",null,null],[6,"c__useconds_t","","",null,null],[6,"c__suseconds_t","","",null,null],[6,"c__daddr_t","","",null,null],[6,"c__key_t","","",null,null],[6,"c__clockid_t","","",null,null],[6,"c__timer_t","","",null,null],[6,"c__blksize_t","","",null,null],[6,"c__blkcnt_t","","",null,null],[6,"c__blkcnt64_t","","",null,null],[6,"c__fsblkcnt_t","","",null,null],[6,"c__fsblkcnt64_t","","",null,null],[6,"c__fsfilcnt_t","","",null,null],[6,"c__fsfilcnt64_t","","",null,null],[6,"c__fsword_t","","",null,null],[6,"c__ssize_t","","",null,null],[6,"c__syscall_slong_t","","",null,null],[6,"c__syscall_ulong_t","","",null,null],[6,"c__loff_t","","",null,null],[6,"c__caddr_t","","",null,null],[6,"c__intptr_t","","",null,null],[6,"c__socklen_t","","",null,null],[6,"c__sig_atomic_t","","",null,null],[6,"cu_char","","",null,null],[6,"cu_short","","",null,null],[6,"cu_int","","",null,null],[6,"cu_long","","",null,null],[6,"cquad_t","","",null,null],[6,"cu_quad_t","","",null,null],[6,"cfsid_t","","",null,null],[6,"cloff_t","","",null,null],[6,"cino_t","","",null,null],[6,"cdev_t","","",null,null],[6,"cgid_t","","",null,null],[6,"cmode_t","","",null,null],[6,"cnlink_t","","",null,null],[6,"cuid_t","","",null,null],[6,"coff_t","","",null,null],[6,"cpid_t","","",null,null],[6,"cid_t","","",null,null],[6,"cssize_t","","",null,null],[6,"cdaddr_t","","",null,null],[6,"ccaddr_t","","",null,null],[6,"ckey_t","","",null,null],[6,"cclock_t","","",null,null],[6,"cclockid_t","","",null,null],[6,"ctime_t","","",null,null],[6,"ctimer_t","","",null,null],[6,"culong","","",null,null],[6,"cushort","","",null,null],[6,"cuint","","",null,null],[6,"cu_int8_t","","",null,null],[6,"cu_int16_t","","",null,null],[6,"cu_int32_t","","",null,null],[6,"cu_int64_t","","",null,null],[6,"cregister_t","","",null,null],[6,"csigset_t","","",null,null],[6,"csuseconds_t","","",null,null],[6,"c__fd_mask","","",null,null],[6,"cfd_mask","","",null,null],[6,"cblksize_t","","",null,null],[6,"cblkcnt_t","","",null,null],[6,"cfsblkcnt_t","","",null,null],[6,"cfsfilcnt_t","","",null,null],[6,"c__pthread_list_t","","",null,null],[6,"c__pthread_slist_t","","",null,null],[6,"cpthread_t","","",null,null],[6,"cpthread_key_t","","",null,null],[6,"cpthread_once_t","","",null,null],[6,"cpthread_spinlock_t","","",null,null],[6,"c__compar_fn_t","","",null,null],[6,"c__locale_t","","",null,null],[6,"clocale_t","","",null,null],[6,"cbw_ErrCode","","",null,null],[6,"cva_list","","",null,null],[6,"c__gnuc_va_list","","",null,null],[6,"c__fpos_t","","",null,null],[6,"c__fpos64_t","","",null,null],[6,"c__FILE","","",null,null],[6,"cFILE","","",null,null],[6,"c_IO_lock_t","","",null,null],[6,"cfpos_t","","",null,null],[6,"cint_least8_t","","",null,null],[6,"cint_least16_t","","",null,null],[6,"cint_least32_t","","",null,null],[6,"cint_least64_t","","",null,null],[6,"cuint_least8_t","","",null,null],[6,"cuint_least16_t","","",null,null],[6,"cuint_least32_t","","",null,null],[6,"cuint_least64_t","","",null,null],[6,"cint_fast8_t","","",null,null],[6,"cint_fast16_t","","",null,null],[6,"cint_fast32_t","","",null,null],[6,"cint_fast64_t","","",null,null],[6,"cuint_fast8_t","","",null,null],[6,"cuint_fast16_t","","",null,null],[6,"cuint_fast32_t","","",null,null],[6,"cuint_fast64_t","","",null,null],[6,"cintmax_t","","",null,null],[6,"cuintmax_t","","",null,null],[6,"cbw_WindowDispatchFn","","",null,null],[6,"cbw_BrowserWindowCreationCallbackFn","","",null,null],[6,"cbw_BrowserWindowHandlerFn","","",null,null],[6,"cbw_BrowserWindowJsCallbackFn","","",null,null],[6,"c__builtin_va_list","","",null,null],[17,"cTRUE","","",null,null],[17,"cFALSE","","",null,null],[17,"c_FEATURES_H","","",null,null],[17,"c_DEFAULT_SOURCE","","",null,null],[17,"c__GLIBC_USE_ISOC2X","","",null,null],[17,"c__USE_ISOC11","","",null,null],[17,"c__USE_ISOC99","","",null,null],[17,"c__USE_ISOC95","","",null,null],[17,"c__USE_POSIX_IMPLICITLY","","",null,null],[17,"c_POSIX_SOURCE","","",null,null],[17,"c_POSIX_C_SOURCE","","",null,null],[17,"c__USE_POSIX","","",null,null],[17,"c__USE_POSIX2","","",null,null],[17,"c__USE_POSIX199309","","",null,null],[17,"c__USE_POSIX199506","","",null,null],[17,"c__USE_XOPEN2K","","",null,null],[17,"c__USE_XOPEN2K8","","",null,null],[17,"c_ATFILE_SOURCE","","",null,null],[17,"c__USE_MISC","","",null,null],[17,"c__USE_ATFILE","","",null,null],[17,"c__USE_FORTIFY_LEVEL","","",null,null],[17,"c__GLIBC_USE_DEPRECATED_GETS","","",null,null],[17,"c__GLIBC_USE_DEPRECATED_SCANF","","",null,null],[17,"c_STDC_PREDEF_H","","",null,null],[17,"c__STDC_IEC_559__","","",null,null],[17,"c__STDC_IEC_559_COMPLEX__","","",null,null],[17,"c__STDC_ISO_10646__","","",null,null],[17,"c__GNU_LIBRARY__","","",null,null],[17,"c__GLIBC__","","",null,null],[17,"c__GLIBC_MINOR__","","",null,null],[17,"c_SYS_CDEFS_H","","",null,null],[17,"c__glibc_c99_flexarr_available","","",null,null],[17,"c__WORDSIZE","","",null,null],[17,"c__WORDSIZE_TIME64_COMPAT32","","",null,null],[17,"c__SYSCALL_WORDSIZE","","",null,null],[17,"c__LONG_DOUBLE_USES_FLOAT128","","",null,null],[17,"c__HAVE_GENERIC_SELECTION","","",null,null],[17,"c__GLIBC_USE_LIB_EXT2","","",null,null],[17,"c__GLIBC_USE_IEC_60559_BFP_EXT","","",null,null],[17,"c__GLIBC_USE_IEC_60559_BFP_EXT_C2X","","",null,null],[17,"c__GLIBC_USE_IEC_60559_FUNCS_EXT","","",null,null],[17,"c__GLIBC_USE_IEC_60559_FUNCS_EXT_C2X","","",null,null],[17,"c__GLIBC_USE_IEC_60559_TYPES_EXT","","",null,null],[17,"c_STDLIB_H","","",null,null],[17,"cWNOHANG","","",null,null],[17,"cWUNTRACED","","",null,null],[17,"cWSTOPPED","","",null,null],[17,"cWEXITED","","",null,null],[17,"cWCONTINUED","","",null,null],[17,"cWNOWAIT","","",null,null],[17,"c__WNOTHREAD","","",null,null],[17,"c__WALL","","",null,null],[17,"c__WCLONE","","",null,null],[17,"c__ENUM_IDTYPE_T","","",null,null],[17,"c__W_CONTINUED","","",null,null],[17,"c__WCOREFLAG","","",null,null],[17,"c__HAVE_FLOAT128","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT128","","",null,null],[17,"c__HAVE_FLOAT64X","","",null,null],[17,"c__HAVE_FLOAT64X_LONG_DOUBLE","","",null,null],[17,"c__HAVE_FLOAT16","","",null,null],[17,"c__HAVE_FLOAT32","","",null,null],[17,"c__HAVE_FLOAT64","","",null,null],[17,"c__HAVE_FLOAT32X","","",null,null],[17,"c__HAVE_FLOAT128X","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT16","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT32","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT64","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT32X","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT64X","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT128X","","",null,null],[17,"c__HAVE_FLOATN_NOT_TYPEDEF","","",null,null],[17,"c__ldiv_t_defined","","",null,null],[17,"c__lldiv_t_defined","","",null,null],[17,"cRAND_MAX","","",null,null],[17,"cEXIT_FAILURE","","",null,null],[17,"cEXIT_SUCCESS","","",null,null],[17,"c_SYS_TYPES_H","","",null,null],[17,"c_BITS_TYPES_H","","",null,null],[17,"c__TIMESIZE","","",null,null],[17,"c_BITS_TYPESIZES_H","","",null,null],[17,"c__OFF_T_MATCHES_OFF64_T","","",null,null],[17,"c__INO_T_MATCHES_INO64_T","","",null,null],[17,"c__RLIM_T_MATCHES_RLIM64_T","","",null,null],[17,"c__STATFS_MATCHES_STATFS64","","",null,null],[17,"c__FD_SETSIZE","","",null,null],[17,"c_BITS_TIME64_H","","",null,null],[17,"c__clock_t_defined","","",null,null],[17,"c__clockid_t_defined","","",null,null],[17,"c__time_t_defined","","",null,null],[17,"c__timer_t_defined","","",null,null],[17,"c_BITS_STDINT_INTN_H","","",null,null],[17,"c__BIT_TYPES_DEFINED__","","",null,null],[17,"c_ENDIAN_H","","",null,null],[17,"c_BITS_ENDIAN_H","","",null,null],[17,"c__LITTLE_ENDIAN","","",null,null],[17,"c__BIG_ENDIAN","","",null,null],[17,"c__PDP_ENDIAN","","",null,null],[17,"c_BITS_ENDIANNESS_H","","",null,null],[17,"c__BYTE_ORDER","","",null,null],[17,"c__FLOAT_WORD_ORDER","","",null,null],[17,"cLITTLE_ENDIAN","","",null,null],[17,"cBIG_ENDIAN","","",null,null],[17,"cPDP_ENDIAN","","",null,null],[17,"cBYTE_ORDER","","",null,null],[17,"c_BITS_BYTESWAP_H","","",null,null],[17,"c_BITS_UINTN_IDENTITY_H","","",null,null],[17,"c_SYS_SELECT_H","","",null,null],[17,"c__FD_ZERO_STOS","","",null,null],[17,"c__sigset_t_defined","","",null,null],[17,"c__timeval_defined","","",null,null],[17,"c_STRUCT_TIMESPEC","","",null,null],[17,"cFD_SETSIZE","","",null,null],[17,"c_BITS_PTHREADTYPES_COMMON_H","","",null,null],[17,"c_THREAD_SHARED_TYPES_H","","",null,null],[17,"c_BITS_PTHREADTYPES_ARCH_H","","",null,null],[17,"c__SIZEOF_PTHREAD_MUTEX_T","","",null,null],[17,"c__SIZEOF_PTHREAD_ATTR_T","","",null,null],[17,"c__SIZEOF_PTHREAD_RWLOCK_T","","",null,null],[17,"c__SIZEOF_PTHREAD_BARRIER_T","","",null,null],[17,"c__SIZEOF_PTHREAD_MUTEXATTR_T","","",null,null],[17,"c__SIZEOF_PTHREAD_COND_T","","",null,null],[17,"c__SIZEOF_PTHREAD_CONDATTR_T","","",null,null],[17,"c__SIZEOF_PTHREAD_RWLOCKATTR_T","","",null,null],[17,"c__SIZEOF_PTHREAD_BARRIERATTR_T","","",null,null],[17,"c_THREAD_MUTEX_INTERNAL_H","","",null,null],[17,"c__PTHREAD_MUTEX_HAVE_PREV","","",null,null],[17,"c__have_pthread_attr_t","","",null,null],[17,"c_ALLOCA_H","","",null,null],[17,"c_STRING_H","","",null,null],[17,"c_BITS_TYPES_LOCALE_T_H","","",null,null],[17,"c_BITS_TYPES___LOCALE_T_H","","",null,null],[17,"c_STRINGS_H","","",null,null],[17,"cBW_ERR_CODE_SUCCESS","","",null,null],[17,"c_ASSERT_H","","",null,null],[17,"c_STDIO_H","","",null,null],[17,"c__GNUC_VA_LIST","","",null,null],[17,"c_____fpos_t_defined","","",null,null],[17,"c____mbstate_t_defined","","",null,null],[17,"c_____fpos64_t_defined","","",null,null],[17,"c____FILE_defined","","",null,null],[17,"c__FILE_defined","","",null,null],[17,"c__struct_FILE_defined","","",null,null],[17,"c_IO_EOF_SEEN","","",null,null],[17,"c_IO_ERR_SEEN","","",null,null],[17,"c_IO_USER_LOCK","","",null,null],[17,"c_IOFBF","","",null,null],[17,"c_IOLBF","","",null,null],[17,"c_IONBF","","",null,null],[17,"cBUFSIZ","","",null,null],[17,"cEOF","","",null,null],[17,"cSEEK_SET","","",null,null],[17,"cSEEK_CUR","","",null,null],[17,"cSEEK_END","","",null,null],[17,"cP_tmpdir","","",null,null],[17,"c_BITS_STDIO_LIM_H","","",null,null],[17,"cL_tmpnam","","",null,null],[17,"cTMP_MAX","","",null,null],[17,"cFILENAME_MAX","","",null,null],[17,"cL_ctermid","","",null,null],[17,"cFOPEN_MAX","","",null,null],[17,"c_ERRNO_H","","",null,null],[17,"c_BITS_ERRNO_H","","",null,null],[17,"cEPERM","","",null,null],[17,"cENOENT","","",null,null],[17,"cESRCH","","",null,null],[17,"cEINTR","","",null,null],[17,"cEIO","","",null,null],[17,"cENXIO","","",null,null],[17,"cE2BIG","","",null,null],[17,"cENOEXEC","","",null,null],[17,"cEBADF","","",null,null],[17,"cECHILD","","",null,null],[17,"cEAGAIN","","",null,null],[17,"cENOMEM","","",null,null],[17,"cEACCES","","",null,null],[17,"cEFAULT","","",null,null],[17,"cENOTBLK","","",null,null],[17,"cEBUSY","","",null,null],[17,"cEEXIST","","",null,null],[17,"cEXDEV","","",null,null],[17,"cENODEV","","",null,null],[17,"cENOTDIR","","",null,null],[17,"cEISDIR","","",null,null],[17,"cEINVAL","","",null,null],[17,"cENFILE","","",null,null],[17,"cEMFILE","","",null,null],[17,"cENOTTY","","",null,null],[17,"cETXTBSY","","",null,null],[17,"cEFBIG","","",null,null],[17,"cENOSPC","","",null,null],[17,"cESPIPE","","",null,null],[17,"cEROFS","","",null,null],[17,"cEMLINK","","",null,null],[17,"cEPIPE","","",null,null],[17,"cEDOM","","",null,null],[17,"cERANGE","","",null,null],[17,"cEDEADLK","","",null,null],[17,"cENAMETOOLONG","","",null,null],[17,"cENOLCK","","",null,null],[17,"cENOSYS","","",null,null],[17,"cENOTEMPTY","","",null,null],[17,"cELOOP","","",null,null],[17,"cEWOULDBLOCK","","",null,null],[17,"cENOMSG","","",null,null],[17,"cEIDRM","","",null,null],[17,"cECHRNG","","",null,null],[17,"cEL2NSYNC","","",null,null],[17,"cEL3HLT","","",null,null],[17,"cEL3RST","","",null,null],[17,"cELNRNG","","",null,null],[17,"cEUNATCH","","",null,null],[17,"cENOCSI","","",null,null],[17,"cEL2HLT","","",null,null],[17,"cEBADE","","",null,null],[17,"cEBADR","","",null,null],[17,"cEXFULL","","",null,null],[17,"cENOANO","","",null,null],[17,"cEBADRQC","","",null,null],[17,"cEBADSLT","","",null,null],[17,"cEDEADLOCK","","",null,null],[17,"cEBFONT","","",null,null],[17,"cENOSTR","","",null,null],[17,"cENODATA","","",null,null],[17,"cETIME","","",null,null],[17,"cENOSR","","",null,null],[17,"cENONET","","",null,null],[17,"cENOPKG","","",null,null],[17,"cEREMOTE","","",null,null],[17,"cENOLINK","","",null,null],[17,"cEADV","","",null,null],[17,"cESRMNT","","",null,null],[17,"cECOMM","","",null,null],[17,"cEPROTO","","",null,null],[17,"cEMULTIHOP","","",null,null],[17,"cEDOTDOT","","",null,null],[17,"cEBADMSG","","",null,null],[17,"cEOVERFLOW","","",null,null],[17,"cENOTUNIQ","","",null,null],[17,"cEBADFD","","",null,null],[17,"cEREMCHG","","",null,null],[17,"cELIBACC","","",null,null],[17,"cELIBBAD","","",null,null],[17,"cELIBSCN","","",null,null],[17,"cELIBMAX","","",null,null],[17,"cELIBEXEC","","",null,null],[17,"cEILSEQ","","",null,null],[17,"cERESTART","","",null,null],[17,"cESTRPIPE","","",null,null],[17,"cEUSERS","","",null,null],[17,"cENOTSOCK","","",null,null],[17,"cEDESTADDRREQ","","",null,null],[17,"cEMSGSIZE","","",null,null],[17,"cEPROTOTYPE","","",null,null],[17,"cENOPROTOOPT","","",null,null],[17,"cEPROTONOSUPPORT","","",null,null],[17,"cESOCKTNOSUPPORT","","",null,null],[17,"cEOPNOTSUPP","","",null,null],[17,"cEPFNOSUPPORT","","",null,null],[17,"cEAFNOSUPPORT","","",null,null],[17,"cEADDRINUSE","","",null,null],[17,"cEADDRNOTAVAIL","","",null,null],[17,"cENETDOWN","","",null,null],[17,"cENETUNREACH","","",null,null],[17,"cENETRESET","","",null,null],[17,"cECONNABORTED","","",null,null],[17,"cECONNRESET","","",null,null],[17,"cENOBUFS","","",null,null],[17,"cEISCONN","","",null,null],[17,"cENOTCONN","","",null,null],[17,"cESHUTDOWN","","",null,null],[17,"cETOOMANYREFS","","",null,null],[17,"cETIMEDOUT","","",null,null],[17,"cECONNREFUSED","","",null,null],[17,"cEHOSTDOWN","","",null,null],[17,"cEHOSTUNREACH","","",null,null],[17,"cEALREADY","","",null,null],[17,"cEINPROGRESS","","",null,null],[17,"cESTALE","","",null,null],[17,"cEUCLEAN","","",null,null],[17,"cENOTNAM","","",null,null],[17,"cENAVAIL","","",null,null],[17,"cEISNAM","","",null,null],[17,"cEREMOTEIO","","",null,null],[17,"cEDQUOT","","",null,null],[17,"cENOMEDIUM","","",null,null],[17,"cEMEDIUMTYPE","","",null,null],[17,"cECANCELED","","",null,null],[17,"cENOKEY","","",null,null],[17,"cEKEYEXPIRED","","",null,null],[17,"cEKEYREVOKED","","",null,null],[17,"cEKEYREJECTED","","",null,null],[17,"cEOWNERDEAD","","",null,null],[17,"cENOTRECOVERABLE","","",null,null],[17,"cERFKILL","","",null,null],[17,"cEHWPOISON","","",null,null],[17,"cENOTSUP","","",null,null],[17,"c_STDINT_H","","",null,null],[17,"c_BITS_WCHAR_H","","",null,null],[17,"c_BITS_STDINT_UINTN_H","","",null,null],[17,"cINT8_MIN","","",null,null],[17,"cINT16_MIN","","",null,null],[17,"cINT32_MIN","","",null,null],[17,"cINT8_MAX","","",null,null],[17,"cINT16_MAX","","",null,null],[17,"cINT32_MAX","","",null,null],[17,"cUINT8_MAX","","",null,null],[17,"cUINT16_MAX","","",null,null],[17,"cUINT32_MAX","","",null,null],[17,"cINT_LEAST8_MIN","","",null,null],[17,"cINT_LEAST16_MIN","","",null,null],[17,"cINT_LEAST32_MIN","","",null,null],[17,"cINT_LEAST8_MAX","","",null,null],[17,"cINT_LEAST16_MAX","","",null,null],[17,"cINT_LEAST32_MAX","","",null,null],[17,"cUINT_LEAST8_MAX","","",null,null],[17,"cUINT_LEAST16_MAX","","",null,null],[17,"cUINT_LEAST32_MAX","","",null,null],[17,"cINT_FAST8_MIN","","",null,null],[17,"cINT_FAST16_MIN","","",null,null],[17,"cINT_FAST32_MIN","","",null,null],[17,"cINT_FAST8_MAX","","",null,null],[17,"cINT_FAST16_MAX","","",null,null],[17,"cINT_FAST32_MAX","","",null,null],[17,"cUINT_FAST8_MAX","","",null,null],[17,"cUINT_FAST16_MAX","","",null,null],[17,"cUINT_FAST32_MAX","","",null,null],[17,"cINTPTR_MIN","","",null,null],[17,"cINTPTR_MAX","","",null,null],[17,"cUINTPTR_MAX","","",null,null],[17,"cPTRDIFF_MIN","","",null,null],[17,"cPTRDIFF_MAX","","",null,null],[17,"cSIG_ATOMIC_MIN","","",null,null],[17,"cSIG_ATOMIC_MAX","","",null,null],[17,"cSIZE_MAX","","",null,null],[17,"cWINT_MIN","","",null,null],[17,"cWINT_MAX","","",null,null],[17,"ctrue","","",null,null],[17,"cfalse","","",null,null],[17,"c__bool_true_false_are_defined","","",null,null],[17,"cidtype_t_P_ALL","","",null,null],[17,"cidtype_t_P_PID","","",null,null],[17,"cidtype_t_P_PGID","","",null,null],[11,"empty","","",2,[[]]],[11,"empty","","",1,[[]]],[11,"from","","",0,[[]]],[11,"into","","",0,[[]]],[11,"to_owned","","",0,[[]]],[11,"clone_into","","",0,[[]]],[11,"borrow","","",0,[[]]],[11,"borrow_mut","","",0,[[]]],[11,"try_from","","",0,[[],["result",4]]],[11,"try_into","","",0,[[],["result",4]]],[11,"type_id","","",0,[[],["typeid",3]]],[11,"from","","",1,[[]]],[11,"into","","",1,[[]]],[11,"to_owned","","",1,[[]]],[11,"clone_into","","",1,[[]]],[11,"borrow","","",1,[[]]],[11,"borrow_mut","","",1,[[]]],[11,"try_from","","",1,[[],["result",4]]],[11,"try_into","","",1,[[],["result",4]]],[11,"type_id","","",1,[[],["typeid",3]]],[11,"from","","",2,[[]]],[11,"into","","",2,[[]]],[11,"to_owned","","",2,[[]]],[11,"clone_into","","",2,[[]]],[11,"borrow","","",2,[[]]],[11,"borrow_mut","","",2,[[]]],[11,"try_from","","",2,[[],["result",4]]],[11,"try_into","","",2,[[],["result",4]]],[11,"type_id","","",2,[[],["typeid",3]]],[11,"from","","",52,[[]]],[11,"into","","",52,[[]]],[11,"to_owned","","",52,[[]]],[11,"clone_into","","",52,[[]]],[11,"borrow","","",52,[[]]],[11,"borrow_mut","","",52,[[]]],[11,"try_from","","",52,[[],["result",4]]],[11,"try_into","","",52,[[],["result",4]]],[11,"type_id","","",52,[[],["typeid",3]]],[11,"from","","",53,[[]]],[11,"into","","",53,[[]]],[11,"to_owned","","",53,[[]]],[11,"clone_into","","",53,[[]]],[11,"borrow","","",53,[[]]],[11,"borrow_mut","","",53,[[]]],[11,"try_from","","",53,[[],["result",4]]],[11,"try_into","","",53,[[],["result",4]]],[11,"type_id","","",53,[[],["typeid",3]]],[11,"from","","",3,[[]]],[11,"into","","",3,[[]]],[11,"to_owned","","",3,[[]]],[11,"clone_into","","",3,[[]]],[11,"borrow","","",3,[[]]],[11,"borrow_mut","","",3,[[]]],[11,"try_from","","",3,[[],["result",4]]],[11,"try_into","","",3,[[],["result",4]]],[11,"type_id","","",3,[[],["typeid",3]]],[11,"from","","",54,[[]]],[11,"into","","",54,[[]]],[11,"to_owned","","",54,[[]]],[11,"clone_into","","",54,[[]]],[11,"borrow","","",54,[[]]],[11,"borrow_mut","","",54,[[]]],[11,"try_from","","",54,[[],["result",4]]],[11,"try_into","","",54,[[],["result",4]]],[11,"type_id","","",54,[[],["typeid",3]]],[11,"from","","",4,[[]]],[11,"into","","",4,[[]]],[11,"to_owned","","",4,[[]]],[11,"clone_into","","",4,[[]]],[11,"borrow","","",4,[[]]],[11,"borrow_mut","","",4,[[]]],[11,"try_from","","",4,[[],["result",4]]],[11,"try_into","","",4,[[],["result",4]]],[11,"type_id","","",4,[[],["typeid",3]]],[11,"from","","",5,[[]]],[11,"into","","",5,[[]]],[11,"to_owned","","",5,[[]]],[11,"clone_into","","",5,[[]]],[11,"borrow","","",5,[[]]],[11,"borrow_mut","","",5,[[]]],[11,"try_from","","",5,[[],["result",4]]],[11,"try_into","","",5,[[],["result",4]]],[11,"type_id","","",5,[[],["typeid",3]]],[11,"from","","",6,[[]]],[11,"into","","",6,[[]]],[11,"to_owned","","",6,[[]]],[11,"clone_into","","",6,[[]]],[11,"borrow","","",6,[[]]],[11,"borrow_mut","","",6,[[]]],[11,"try_from","","",6,[[],["result",4]]],[11,"try_into","","",6,[[],["result",4]]],[11,"type_id","","",6,[[],["typeid",3]]],[11,"from","","",7,[[]]],[11,"into","","",7,[[]]],[11,"to_owned","","",7,[[]]],[11,"clone_into","","",7,[[]]],[11,"borrow","","",7,[[]]],[11,"borrow_mut","","",7,[[]]],[11,"try_from","","",7,[[],["result",4]]],[11,"try_into","","",7,[[],["result",4]]],[11,"type_id","","",7,[[],["typeid",3]]],[11,"from","","",8,[[]]],[11,"into","","",8,[[]]],[11,"to_owned","","",8,[[]]],[11,"clone_into","","",8,[[]]],[11,"borrow","","",8,[[]]],[11,"borrow_mut","","",8,[[]]],[11,"try_from","","",8,[[],["result",4]]],[11,"try_into","","",8,[[],["result",4]]],[11,"type_id","","",8,[[],["typeid",3]]],[11,"from","","",9,[[]]],[11,"into","","",9,[[]]],[11,"to_owned","","",9,[[]]],[11,"clone_into","","",9,[[]]],[11,"borrow","","",9,[[]]],[11,"borrow_mut","","",9,[[]]],[11,"try_from","","",9,[[],["result",4]]],[11,"try_into","","",9,[[],["result",4]]],[11,"type_id","","",9,[[],["typeid",3]]],[11,"from","","",10,[[]]],[11,"into","","",10,[[]]],[11,"to_owned","","",10,[[]]],[11,"clone_into","","",10,[[]]],[11,"borrow","","",10,[[]]],[11,"borrow_mut","","",10,[[]]],[11,"try_from","","",10,[[],["result",4]]],[11,"try_into","","",10,[[],["result",4]]],[11,"type_id","","",10,[[],["typeid",3]]],[11,"from","","",11,[[]]],[11,"into","","",11,[[]]],[11,"to_owned","","",11,[[]]],[11,"clone_into","","",11,[[]]],[11,"borrow","","",11,[[]]],[11,"borrow_mut","","",11,[[]]],[11,"try_from","","",11,[[],["result",4]]],[11,"try_into","","",11,[[],["result",4]]],[11,"type_id","","",11,[[],["typeid",3]]],[11,"from","","",12,[[]]],[11,"into","","",12,[[]]],[11,"to_owned","","",12,[[]]],[11,"clone_into","","",12,[[]]],[11,"borrow","","",12,[[]]],[11,"borrow_mut","","",12,[[]]],[11,"try_from","","",12,[[],["result",4]]],[11,"try_into","","",12,[[],["result",4]]],[11,"type_id","","",12,[[],["typeid",3]]],[11,"from","","",13,[[]]],[11,"into","","",13,[[]]],[11,"to_owned","","",13,[[]]],[11,"clone_into","","",13,[[]]],[11,"borrow","","",13,[[]]],[11,"borrow_mut","","",13,[[]]],[11,"try_from","","",13,[[],["result",4]]],[11,"try_into","","",13,[[],["result",4]]],[11,"type_id","","",13,[[],["typeid",3]]],[11,"from","","",14,[[]]],[11,"into","","",14,[[]]],[11,"to_owned","","",14,[[]]],[11,"clone_into","","",14,[[]]],[11,"borrow","","",14,[[]]],[11,"borrow_mut","","",14,[[]]],[11,"try_from","","",14,[[],["result",4]]],[11,"try_into","","",14,[[],["result",4]]],[11,"type_id","","",14,[[],["typeid",3]]],[11,"from","","",15,[[]]],[11,"into","","",15,[[]]],[11,"to_owned","","",15,[[]]],[11,"clone_into","","",15,[[]]],[11,"borrow","","",15,[[]]],[11,"borrow_mut","","",15,[[]]],[11,"try_from","","",15,[[],["result",4]]],[11,"try_into","","",15,[[],["result",4]]],[11,"type_id","","",15,[[],["typeid",3]]],[11,"from","","",16,[[]]],[11,"into","","",16,[[]]],[11,"to_owned","","",16,[[]]],[11,"clone_into","","",16,[[]]],[11,"borrow","","",16,[[]]],[11,"borrow_mut","","",16,[[]]],[11,"try_from","","",16,[[],["result",4]]],[11,"try_into","","",16,[[],["result",4]]],[11,"type_id","","",16,[[],["typeid",3]]],[11,"from","","",17,[[]]],[11,"into","","",17,[[]]],[11,"to_owned","","",17,[[]]],[11,"clone_into","","",17,[[]]],[11,"borrow","","",17,[[]]],[11,"borrow_mut","","",17,[[]]],[11,"try_from","","",17,[[],["result",4]]],[11,"try_into","","",17,[[],["result",4]]],[11,"type_id","","",17,[[],["typeid",3]]],[11,"from","","",18,[[]]],[11,"into","","",18,[[]]],[11,"to_owned","","",18,[[]]],[11,"clone_into","","",18,[[]]],[11,"borrow","","",18,[[]]],[11,"borrow_mut","","",18,[[]]],[11,"try_from","","",18,[[],["result",4]]],[11,"try_into","","",18,[[],["result",4]]],[11,"type_id","","",18,[[],["typeid",3]]],[11,"from","","",19,[[]]],[11,"into","","",19,[[]]],[11,"to_owned","","",19,[[]]],[11,"clone_into","","",19,[[]]],[11,"borrow","","",19,[[]]],[11,"borrow_mut","","",19,[[]]],[11,"try_from","","",19,[[],["result",4]]],[11,"try_into","","",19,[[],["result",4]]],[11,"type_id","","",19,[[],["typeid",3]]],[11,"from","","",20,[[]]],[11,"into","","",20,[[]]],[11,"to_owned","","",20,[[]]],[11,"clone_into","","",20,[[]]],[11,"borrow","","",20,[[]]],[11,"borrow_mut","","",20,[[]]],[11,"try_from","","",20,[[],["result",4]]],[11,"try_into","","",20,[[],["result",4]]],[11,"type_id","","",20,[[],["typeid",3]]],[11,"from","","",21,[[]]],[11,"into","","",21,[[]]],[11,"to_owned","","",21,[[]]],[11,"clone_into","","",21,[[]]],[11,"borrow","","",21,[[]]],[11,"borrow_mut","","",21,[[]]],[11,"try_from","","",21,[[],["result",4]]],[11,"try_into","","",21,[[],["result",4]]],[11,"type_id","","",21,[[],["typeid",3]]],[11,"from","","",22,[[]]],[11,"into","","",22,[[]]],[11,"to_owned","","",22,[[]]],[11,"clone_into","","",22,[[]]],[11,"borrow","","",22,[[]]],[11,"borrow_mut","","",22,[[]]],[11,"try_from","","",22,[[],["result",4]]],[11,"try_into","","",22,[[],["result",4]]],[11,"type_id","","",22,[[],["typeid",3]]],[11,"from","","",23,[[]]],[11,"into","","",23,[[]]],[11,"to_owned","","",23,[[]]],[11,"clone_into","","",23,[[]]],[11,"borrow","","",23,[[]]],[11,"borrow_mut","","",23,[[]]],[11,"try_from","","",23,[[],["result",4]]],[11,"try_into","","",23,[[],["result",4]]],[11,"type_id","","",23,[[],["typeid",3]]],[11,"from","","",24,[[]]],[11,"into","","",24,[[]]],[11,"to_owned","","",24,[[]]],[11,"clone_into","","",24,[[]]],[11,"borrow","","",24,[[]]],[11,"borrow_mut","","",24,[[]]],[11,"try_from","","",24,[[],["result",4]]],[11,"try_into","","",24,[[],["result",4]]],[11,"type_id","","",24,[[],["typeid",3]]],[11,"from","","",25,[[]]],[11,"into","","",25,[[]]],[11,"to_owned","","",25,[[]]],[11,"clone_into","","",25,[[]]],[11,"to_string","","",25,[[],["string",3]]],[11,"borrow","","",25,[[]]],[11,"borrow_mut","","",25,[[]]],[11,"try_from","","",25,[[],["result",4]]],[11,"try_into","","",25,[[],["result",4]]],[11,"type_id","","",25,[[],["typeid",3]]],[11,"from","","",26,[[]]],[11,"into","","",26,[[]]],[11,"to_owned","","",26,[[]]],[11,"clone_into","","",26,[[]]],[11,"borrow","","",26,[[]]],[11,"borrow_mut","","",26,[[]]],[11,"try_from","","",26,[[],["result",4]]],[11,"try_into","","",26,[[],["result",4]]],[11,"type_id","","",26,[[],["typeid",3]]],[11,"from","","",27,[[]]],[11,"into","","",27,[[]]],[11,"to_owned","","",27,[[]]],[11,"clone_into","","",27,[[]]],[11,"borrow","","",27,[[]]],[11,"borrow_mut","","",27,[[]]],[11,"try_from","","",27,[[],["result",4]]],[11,"try_into","","",27,[[],["result",4]]],[11,"type_id","","",27,[[],["typeid",3]]],[11,"from","","",28,[[]]],[11,"into","","",28,[[]]],[11,"to_owned","","",28,[[]]],[11,"clone_into","","",28,[[]]],[11,"borrow","","",28,[[]]],[11,"borrow_mut","","",28,[[]]],[11,"try_from","","",28,[[],["result",4]]],[11,"try_into","","",28,[[],["result",4]]],[11,"type_id","","",28,[[],["typeid",3]]],[11,"from","","",55,[[]]],[11,"into","","",55,[[]]],[11,"to_owned","","",55,[[]]],[11,"clone_into","","",55,[[]]],[11,"borrow","","",55,[[]]],[11,"borrow_mut","","",55,[[]]],[11,"try_from","","",55,[[],["result",4]]],[11,"try_into","","",55,[[],["result",4]]],[11,"type_id","","",55,[[],["typeid",3]]],[11,"from","","",56,[[]]],[11,"into","","",56,[[]]],[11,"to_owned","","",56,[[]]],[11,"clone_into","","",56,[[]]],[11,"borrow","","",56,[[]]],[11,"borrow_mut","","",56,[[]]],[11,"try_from","","",56,[[],["result",4]]],[11,"try_into","","",56,[[],["result",4]]],[11,"type_id","","",56,[[],["typeid",3]]],[11,"from","","",57,[[]]],[11,"into","","",57,[[]]],[11,"to_owned","","",57,[[]]],[11,"clone_into","","",57,[[]]],[11,"borrow","","",57,[[]]],[11,"borrow_mut","","",57,[[]]],[11,"try_from","","",57,[[],["result",4]]],[11,"try_into","","",57,[[],["result",4]]],[11,"type_id","","",57,[[],["typeid",3]]],[11,"from","","",29,[[]]],[11,"into","","",29,[[]]],[11,"to_owned","","",29,[[]]],[11,"clone_into","","",29,[[]]],[11,"borrow","","",29,[[]]],[11,"borrow_mut","","",29,[[]]],[11,"try_from","","",29,[[],["result",4]]],[11,"try_into","","",29,[[],["result",4]]],[11,"type_id","","",29,[[],["typeid",3]]],[11,"from","","",30,[[]]],[11,"into","","",30,[[]]],[11,"to_owned","","",30,[[]]],[11,"clone_into","","",30,[[]]],[11,"borrow","","",30,[[]]],[11,"borrow_mut","","",30,[[]]],[11,"try_from","","",30,[[],["result",4]]],[11,"try_into","","",30,[[],["result",4]]],[11,"type_id","","",30,[[],["typeid",3]]],[11,"from","","",31,[[]]],[11,"into","","",31,[[]]],[11,"to_owned","","",31,[[]]],[11,"clone_into","","",31,[[]]],[11,"borrow","","",31,[[]]],[11,"borrow_mut","","",31,[[]]],[11,"try_from","","",31,[[],["result",4]]],[11,"try_into","","",31,[[],["result",4]]],[11,"type_id","","",31,[[],["typeid",3]]],[11,"from","","",58,[[]]],[11,"into","","",58,[[]]],[11,"to_owned","","",58,[[]]],[11,"clone_into","","",58,[[]]],[11,"borrow","","",58,[[]]],[11,"borrow_mut","","",58,[[]]],[11,"try_from","","",58,[[],["result",4]]],[11,"try_into","","",58,[[],["result",4]]],[11,"type_id","","",58,[[],["typeid",3]]],[11,"from","","",32,[[]]],[11,"into","","",32,[[]]],[11,"to_owned","","",32,[[]]],[11,"clone_into","","",32,[[]]],[11,"borrow","","",32,[[]]],[11,"borrow_mut","","",32,[[]]],[11,"try_from","","",32,[[],["result",4]]],[11,"try_into","","",32,[[],["result",4]]],[11,"type_id","","",32,[[],["typeid",3]]],[11,"from","","",33,[[]]],[11,"into","","",33,[[]]],[11,"to_owned","","",33,[[]]],[11,"clone_into","","",33,[[]]],[11,"borrow","","",33,[[]]],[11,"borrow_mut","","",33,[[]]],[11,"try_from","","",33,[[],["result",4]]],[11,"try_into","","",33,[[],["result",4]]],[11,"type_id","","",33,[[],["typeid",3]]],[11,"from","","",59,[[]]],[11,"into","","",59,[[]]],[11,"to_owned","","",59,[[]]],[11,"clone_into","","",59,[[]]],[11,"borrow","","",59,[[]]],[11,"borrow_mut","","",59,[[]]],[11,"try_from","","",59,[[],["result",4]]],[11,"try_into","","",59,[[],["result",4]]],[11,"type_id","","",59,[[],["typeid",3]]],[11,"from","","",34,[[]]],[11,"into","","",34,[[]]],[11,"to_owned","","",34,[[]]],[11,"clone_into","","",34,[[]]],[11,"borrow","","",34,[[]]],[11,"borrow_mut","","",34,[[]]],[11,"try_from","","",34,[[],["result",4]]],[11,"try_into","","",34,[[],["result",4]]],[11,"type_id","","",34,[[],["typeid",3]]],[11,"from","","",35,[[]]],[11,"into","","",35,[[]]],[11,"to_owned","","",35,[[]]],[11,"clone_into","","",35,[[]]],[11,"borrow","","",35,[[]]],[11,"borrow_mut","","",35,[[]]],[11,"try_from","","",35,[[],["result",4]]],[11,"try_into","","",35,[[],["result",4]]],[11,"type_id","","",35,[[],["typeid",3]]],[11,"from","","",36,[[]]],[11,"into","","",36,[[]]],[11,"to_owned","","",36,[[]]],[11,"clone_into","","",36,[[]]],[11,"borrow","","",36,[[]]],[11,"borrow_mut","","",36,[[]]],[11,"try_from","","",36,[[],["result",4]]],[11,"try_into","","",36,[[],["result",4]]],[11,"type_id","","",36,[[],["typeid",3]]],[11,"from","","",37,[[]]],[11,"into","","",37,[[]]],[11,"to_owned","","",37,[[]]],[11,"clone_into","","",37,[[]]],[11,"borrow","","",37,[[]]],[11,"borrow_mut","","",37,[[]]],[11,"try_from","","",37,[[],["result",4]]],[11,"try_into","","",37,[[],["result",4]]],[11,"type_id","","",37,[[],["typeid",3]]],[11,"from","","",38,[[]]],[11,"into","","",38,[[]]],[11,"to_owned","","",38,[[]]],[11,"clone_into","","",38,[[]]],[11,"borrow","","",38,[[]]],[11,"borrow_mut","","",38,[[]]],[11,"try_from","","",38,[[],["result",4]]],[11,"try_into","","",38,[[],["result",4]]],[11,"type_id","","",38,[[],["typeid",3]]],[11,"from","","",39,[[]]],[11,"into","","",39,[[]]],[11,"to_owned","","",39,[[]]],[11,"clone_into","","",39,[[]]],[11,"borrow","","",39,[[]]],[11,"borrow_mut","","",39,[[]]],[11,"try_from","","",39,[[],["result",4]]],[11,"try_into","","",39,[[],["result",4]]],[11,"type_id","","",39,[[],["typeid",3]]],[11,"from","","",40,[[]]],[11,"into","","",40,[[]]],[11,"to_owned","","",40,[[]]],[11,"clone_into","","",40,[[]]],[11,"borrow","","",40,[[]]],[11,"borrow_mut","","",40,[[]]],[11,"try_from","","",40,[[],["result",4]]],[11,"try_into","","",40,[[],["result",4]]],[11,"type_id","","",40,[[],["typeid",3]]],[11,"from","","",41,[[]]],[11,"into","","",41,[[]]],[11,"to_owned","","",41,[[]]],[11,"clone_into","","",41,[[]]],[11,"borrow","","",41,[[]]],[11,"borrow_mut","","",41,[[]]],[11,"try_from","","",41,[[],["result",4]]],[11,"try_into","","",41,[[],["result",4]]],[11,"type_id","","",41,[[],["typeid",3]]],[11,"from","","",42,[[]]],[11,"into","","",42,[[]]],[11,"to_owned","","",42,[[]]],[11,"clone_into","","",42,[[]]],[11,"borrow","","",42,[[]]],[11,"borrow_mut","","",42,[[]]],[11,"try_from","","",42,[[],["result",4]]],[11,"try_into","","",42,[[],["result",4]]],[11,"type_id","","",42,[[],["typeid",3]]],[11,"from","","",43,[[]]],[11,"into","","",43,[[]]],[11,"to_owned","","",43,[[]]],[11,"clone_into","","",43,[[]]],[11,"borrow","","",43,[[]]],[11,"borrow_mut","","",43,[[]]],[11,"try_from","","",43,[[],["result",4]]],[11,"try_into","","",43,[[],["result",4]]],[11,"type_id","","",43,[[],["typeid",3]]],[11,"from","","",44,[[]]],[11,"into","","",44,[[]]],[11,"to_owned","","",44,[[]]],[11,"clone_into","","",44,[[]]],[11,"borrow","","",44,[[]]],[11,"borrow_mut","","",44,[[]]],[11,"try_from","","",44,[[],["result",4]]],[11,"try_into","","",44,[[],["result",4]]],[11,"type_id","","",44,[[],["typeid",3]]],[11,"from","","",45,[[]]],[11,"into","","",45,[[]]],[11,"to_owned","","",45,[[]]],[11,"clone_into","","",45,[[]]],[11,"borrow","","",45,[[]]],[11,"borrow_mut","","",45,[[]]],[11,"try_from","","",45,[[],["result",4]]],[11,"try_into","","",45,[[],["result",4]]],[11,"type_id","","",45,[[],["typeid",3]]],[11,"from","","",46,[[]]],[11,"into","","",46,[[]]],[11,"to_owned","","",46,[[]]],[11,"clone_into","","",46,[[]]],[11,"borrow","","",46,[[]]],[11,"borrow_mut","","",46,[[]]],[11,"try_from","","",46,[[],["result",4]]],[11,"try_into","","",46,[[],["result",4]]],[11,"type_id","","",46,[[],["typeid",3]]],[11,"from","","",47,[[]]],[11,"into","","",47,[[]]],[11,"to_owned","","",47,[[]]],[11,"clone_into","","",47,[[]]],[11,"borrow","","",47,[[]]],[11,"borrow_mut","","",47,[[]]],[11,"try_from","","",47,[[],["result",4]]],[11,"try_into","","",47,[[],["result",4]]],[11,"type_id","","",47,[[],["typeid",3]]],[11,"from","","",48,[[]]],[11,"into","","",48,[[]]],[11,"to_owned","","",48,[[]]],[11,"clone_into","","",48,[[]]],[11,"borrow","","",48,[[]]],[11,"borrow_mut","","",48,[[]]],[11,"try_from","","",48,[[],["result",4]]],[11,"try_into","","",48,[[],["result",4]]],[11,"type_id","","",48,[[],["typeid",3]]],[11,"from","","",49,[[]]],[11,"into","","",49,[[]]],[11,"to_owned","","",49,[[]]],[11,"clone_into","","",49,[[]]],[11,"borrow","","",49,[[]]],[11,"borrow_mut","","",49,[[]]],[11,"try_from","","",49,[[],["result",4]]],[11,"try_into","","",49,[[],["result",4]]],[11,"type_id","","",49,[[],["typeid",3]]],[11,"from","","",50,[[]]],[11,"into","","",50,[[]]],[11,"to_owned","","",50,[[]]],[11,"clone_into","","",50,[[]]],[11,"borrow","","",50,[[]]],[11,"borrow_mut","","",50,[[]]],[11,"try_from","","",50,[[],["result",4]]],[11,"try_into","","",50,[[],["result",4]]],[11,"type_id","","",50,[[],["typeid",3]]],[11,"from","","",51,[[]]],[11,"into","","",51,[[]]],[11,"to_owned","","",51,[[]]],[11,"clone_into","","",51,[[]]],[11,"borrow","","",51,[[]]],[11,"borrow_mut","","",51,[[]]],[11,"try_from","","",51,[[],["result",4]]],[11,"try_into","","",51,[[],["result",4]]],[11,"type_id","","",51,[[],["typeid",3]]],[11,"from","","",2,[[]]],[11,"into","","",2,[[]]],[11,"into","","",2,[[],["string",3]]],[11,"into","","",1,[[]]],[11,"into","","",1,[[],["string",3]]],[11,"clone","","",0,[[],["cmax_align_t",3]]],[11,"clone","","",1,[[],["cbw_strslice",3]]],[11,"clone","","",2,[[],["cbw_cstrslice",3]]],[11,"clone","","",52,[[],["cbw_applicationimpl",3]]],[11,"clone","","",53,[[],["cbw_applicationengineimpl",3]]],[11,"clone","","",3,[[],["cbw_application",3]]],[11,"clone","","",54,[[],["cbw_applicationenginedata",3]]],[11,"clone","","",4,[[],["cbw_applicationdispatchdata",3]]],[11,"clone","","",5,[[],["cbw_applicationsettings",3]]],[11,"clone","","",6,[[],["cbw_browserwindowimpl",3]]],[11,"clone","","",7,[[],["cdiv_t",3]]],[11,"clone","","",8,[[],["cldiv_t",3]]],[11,"clone","","",9,[[],["clldiv_t",3]]],[11,"clone","","",10,[[],["c__fsid_t",3]]],[11,"clone","","",11,[[],["c__sigset_t",3]]],[11,"clone","","",12,[[],["ctimeval",3]]],[11,"clone","","",13,[[],["ctimespec",3]]],[11,"clone","","",14,[[],["cfd_set",3]]],[11,"clone","","",15,[[],["c__pthread_internal_list",3]]],[11,"clone","","",16,[[],["c__pthread_internal_slist",3]]],[11,"clone","","",17,[[],["c__pthread_mutex_s",3]]],[11,"clone","","",18,[[],["c__pthread_rwlock_arch_t",3]]],[11,"clone","","",19,[[],["c__pthread_cond_s",3]]],[11,"clone","","",40,[[],["c__pthread_cond_s__bindgen_ty_1",19]]],[11,"clone","","",20,[[],["c__pthread_cond_s__bindgen_ty_1__bindgen_ty_1",3]]],[11,"clone","","",41,[[],["c__pthread_cond_s__bindgen_ty_2",19]]],[11,"clone","","",21,[[],["c__pthread_cond_s__bindgen_ty_2__bindgen_ty_1",3]]],[11,"clone","","",42,[[],["cpthread_mutexattr_t",19]]],[11,"clone","","",43,[[],["cpthread_condattr_t",19]]],[11,"clone","","",44,[[],["cpthread_attr_t",19]]],[11,"clone","","",45,[[],["cpthread_mutex_t",19]]],[11,"clone","","",46,[[],["cpthread_cond_t",19]]],[11,"clone","","",47,[[],["cpthread_rwlock_t",19]]],[11,"clone","","",48,[[],["cpthread_rwlockattr_t",19]]],[11,"clone","","",49,[[],["cpthread_barrier_t",19]]],[11,"clone","","",50,[[],["cpthread_barrierattr_t",19]]],[11,"clone","","",22,[[],["crandom_data",3]]],[11,"clone","","",23,[[],["cdrand48_data",3]]],[11,"clone","","",24,[[],["c__locale_struct",3]]],[11,"clone","","",25,[[],["cbw_err",3]]],[11,"clone","","",26,[[],["c__mbstate_t",3]]],[11,"clone","","",51,[[],["c__mbstate_t__bindgen_ty_1",19]]],[11,"clone","","",27,[[],["c_g_fpos_t",3]]],[11,"clone","","",28,[[],["c_g_fpos64_t",3]]],[11,"clone","","",55,[[],["c_io_marker",3]]],[11,"clone","","",56,[[],["c_io_codecvt",3]]],[11,"clone","","",57,[[],["c_io_wide_data",3]]],[11,"clone","","",29,[[],["c_io_file",3]]],[11,"clone","","",30,[[],["cbw_dims2d",3]]],[11,"clone","","",31,[[],["cbw_pos2d",3]]],[11,"clone","","",58,[[],["cbw_windowimpl",3]]],[11,"clone","","",32,[[],["cbw_windowcallbacks",3]]],[11,"clone","","",33,[[],["cbw_windowoptions",3]]],[11,"clone","","",59,[[],["cbw_windowdispatchdata",3]]],[11,"clone","","",34,[[],["cbw_window",3]]],[11,"clone","","",35,[[],["cbw_browserwindowoptions",3]]],[11,"clone","","",36,[[],["cbw_browserwindowsource",3]]],[11,"clone","","",37,[[],["cbw_browserwindow",3]]],[11,"clone","","",38,[[],["c__locale_data",3]]],[11,"clone","","",39,[[],["c__va_list_tag",3]]],[11,"fmt","","",0,[[["formatter",3]],["result",6]]],[11,"fmt","","",1,[[["formatter",3]],["result",6]]],[11,"fmt","","",2,[[["formatter",3]],["result",6]]],[11,"fmt","","",52,[[["formatter",3]],["result",6]]],[11,"fmt","","",53,[[["formatter",3]],["result",6]]],[11,"fmt","","",3,[[["formatter",3]],["result",6]]],[11,"fmt","","",54,[[["formatter",3]],["result",6]]],[11,"fmt","","",4,[[["formatter",3]],["result",6]]],[11,"fmt","","",5,[[["formatter",3]],["result",6]]],[11,"fmt","","",6,[[["formatter",3]],["result",6]]],[11,"fmt","","",7,[[["formatter",3]],["result",6]]],[11,"fmt","","",8,[[["formatter",3]],["result",6]]],[11,"fmt","","",9,[[["formatter",3]],["result",6]]],[11,"fmt","","",10,[[["formatter",3]],["result",6]]],[11,"fmt","","",11,[[["formatter",3]],["result",6]]],[11,"fmt","","",12,[[["formatter",3]],["result",6]]],[11,"fmt","","",13,[[["formatter",3]],["result",6]]],[11,"fmt","","",14,[[["formatter",3]],["result",6]]],[11,"fmt","","",15,[[["formatter",3]],["result",6]]],[11,"fmt","","",16,[[["formatter",3]],["result",6]]],[11,"fmt","","",17,[[["formatter",3]],["result",6]]],[11,"fmt","","",18,[[["formatter",3]],["result",6]]],[11,"fmt","","",20,[[["formatter",3]],["result",6]]],[11,"fmt","","",21,[[["formatter",3]],["result",6]]],[11,"fmt","","",22,[[["formatter",3]],["result",6]]],[11,"fmt","","",23,[[["formatter",3]],["result",6]]],[11,"fmt","","",24,[[["formatter",3]],["result",6]]],[11,"fmt","","",25,[[["formatter",3]],["result",6]]],[11,"fmt","","",55,[[["formatter",3]],["result",6]]],[11,"fmt","","",56,[[["formatter",3]],["result",6]]],[11,"fmt","","",57,[[["formatter",3]],["result",6]]],[11,"fmt","","",29,[[["formatter",3]],["result",6]]],[11,"fmt","","",30,[[["formatter",3]],["result",6]]],[11,"fmt","","",31,[[["formatter",3]],["result",6]]],[11,"fmt","","",58,[[["formatter",3]],["result",6]]],[11,"fmt","","",32,[[["formatter",3]],["result",6]]],[11,"fmt","","",33,[[["formatter",3]],["result",6]]],[11,"fmt","","",59,[[["formatter",3]],["result",6]]],[11,"fmt","","",34,[[["formatter",3]],["result",6]]],[11,"fmt","","",35,[[["formatter",3]],["result",6]]],[11,"fmt","","",36,[[["formatter",3]],["result",6]]],[11,"fmt","","",37,[[["formatter",3]],["result",6]]],[11,"fmt","","",38,[[["formatter",3]],["result",6]]],[11,"fmt","","",39,[[["formatter",3]],["result",6]]],[11,"fmt","","",25,[[["formatter",3]],["result",6]]],[11,"source","","",25,[[],[["option",4],["error",8]]]]],"p":[[3,"cmax_align_t"],[3,"cbw_StrSlice"],[3,"cbw_CStrSlice"],[3,"cbw_Application"],[3,"cbw_ApplicationDispatchData"],[3,"cbw_ApplicationSettings"],[3,"cbw_BrowserWindowImpl"],[3,"cdiv_t"],[3,"cldiv_t"],[3,"clldiv_t"],[3,"c__fsid_t"],[3,"c__sigset_t"],[3,"ctimeval"],[3,"ctimespec"],[3,"cfd_set"],[3,"c__pthread_internal_list"],[3,"c__pthread_internal_slist"],[3,"c__pthread_mutex_s"],[3,"c__pthread_rwlock_arch_t"],[3,"c__pthread_cond_s"],[3,"c__pthread_cond_s__bindgen_ty_1__bindgen_ty_1"],[3,"c__pthread_cond_s__bindgen_ty_2__bindgen_ty_1"],[3,"crandom_data"],[3,"cdrand48_data"],[3,"c__locale_struct"],[3,"cbw_Err"],[3,"c__mbstate_t"],[3,"c_G_fpos_t"],[3,"c_G_fpos64_t"],[3,"c_IO_FILE"],[3,"cbw_Dims2D"],[3,"cbw_Pos2D"],[3,"cbw_WindowCallbacks"],[3,"cbw_WindowOptions"],[3,"cbw_Window"],[3,"cbw_BrowserWindowOptions"],[3,"cbw_BrowserWindowSource"],[3,"cbw_BrowserWindow"],[3,"c__locale_data"],[3,"c__va_list_tag"],[19,"c__pthread_cond_s__bindgen_ty_1"],[19,"c__pthread_cond_s__bindgen_ty_2"],[19,"cpthread_mutexattr_t"],[19,"cpthread_condattr_t"],[19,"cpthread_attr_t"],[19,"cpthread_mutex_t"],[19,"cpthread_cond_t"],[19,"cpthread_rwlock_t"],[19,"cpthread_rwlockattr_t"],[19,"cpthread_barrier_t"],[19,"cpthread_barrierattr_t"],[19,"c__mbstate_t__bindgen_ty_1"],[3,"cbw_ApplicationImpl"],[3,"cbw_ApplicationEngineImpl"],[3,"cbw_ApplicationEngineData"],[3,"c_IO_marker"],[3,"c_IO_codecvt"],[3,"c_IO_wide_data"],[3,"cbw_WindowImpl"],[3,"cbw_WindowDispatchData"]]},\
"browser_window_core":{"doc":"","i":[[0,"application","browser_window_core","",null,null],[3,"ApplicationSettings","browser_window_core::application","",null,null],[0,"c","","This module implements the `Application` trait with the…",null,null],[3,"ApplicationImpl","browser_window_core::application::c","",null,null],[8,"ApplicationExt","browser_window_core::application","",null,null],[10,"assert_correct_thread","","Asserts if not on the GUI thread",0,[[]]],[10,"dispatch","","Dispatches work to be executed on the GUI thread.",0,[[]]],[10,"exit","","Causes the main loop to exit and lets it return the given…",0,[[]]],[10,"exit_threadsafe","","Same as `exit`, but is thread-safe.",0,[[]]],[11,"finish","","Shuts down all application processes and performs…",0,[[]]],[10,"initialize","","",0,[[["applicationsettings",3],["c_int",6]],["applicationimpl",3]]],[10,"run","","Runs the main loop. This blocks until the application is…",0,[[]]],[0,"browser_window","browser_window_core","",null,null],[0,"c","browser_window_core::browser_window","",null,null],[3,"BrowserWindowImpl","browser_window_core::browser_window::c","",null,null],[3,"JsEvaluationError","","An error that may occur when evaluating or executing…",null,null],[6,"BrowserWindowOptions","browser_window_core::browser_window","",null,null],[6,"Source","","",null,null],[6,"CreationCallbackFn","","",null,null],[6,"EvalJsCallbackFn","","",null,null],[6,"ExternalInvocationHandlerFn","","",null,null],[8,"BrowserWindowExt","","",null,null],[10,"eval_js","","Executes the given JavaScript string. The result will be…",1,[[["evaljscallbackfn",6]]]],[10,"eval_js_threadsafe","","Like `eval_js`, except it can be called from any thread.",1,[[["evaljscallbackfn",6]]]],[10,"navigate","","Causes the browser to navigate to the given URI.",1,[[]]],[10,"new","","Creates a new browser window asynchronously. The…",1,[[["source",6],["creationcallbackfn",6],["applicationimpl",3],["windowimpl",3],["option",4],["windowoptions",6],["browserwindowoptions",6],["externalinvocationhandlerfn",6]]]],[10,"user_data","","",1,[[]]],[10,"window","","Gives a handle to the underlying window.",1,[[],["windowimpl",3]]],[0,"prelude","browser_window_core","",null,null],[17,"cTRUE","browser_window_core::prelude","",null,null],[17,"cFALSE","","",null,null],[17,"c_FEATURES_H","","",null,null],[17,"c_DEFAULT_SOURCE","","",null,null],[17,"c__GLIBC_USE_ISOC2X","","",null,null],[17,"c__USE_ISOC11","","",null,null],[17,"c__USE_ISOC99","","",null,null],[17,"c__USE_ISOC95","","",null,null],[17,"c__USE_POSIX_IMPLICITLY","","",null,null],[17,"c_POSIX_SOURCE","","",null,null],[17,"c_POSIX_C_SOURCE","","",null,null],[17,"c__USE_POSIX","","",null,null],[17,"c__USE_POSIX2","","",null,null],[17,"c__USE_POSIX199309","","",null,null],[17,"c__USE_POSIX199506","","",null,null],[17,"c__USE_XOPEN2K","","",null,null],[17,"c__USE_XOPEN2K8","","",null,null],[17,"c_ATFILE_SOURCE","","",null,null],[17,"c__USE_MISC","","",null,null],[17,"c__USE_ATFILE","","",null,null],[17,"c__USE_FORTIFY_LEVEL","","",null,null],[17,"c__GLIBC_USE_DEPRECATED_GETS","","",null,null],[17,"c__GLIBC_USE_DEPRECATED_SCANF","","",null,null],[17,"c_STDC_PREDEF_H","","",null,null],[17,"c__STDC_IEC_559__","","",null,null],[17,"c__STDC_IEC_559_COMPLEX__","","",null,null],[17,"c__STDC_ISO_10646__","","",null,null],[17,"c__GNU_LIBRARY__","","",null,null],[17,"c__GLIBC__","","",null,null],[17,"c__GLIBC_MINOR__","","",null,null],[17,"c_SYS_CDEFS_H","","",null,null],[17,"c__glibc_c99_flexarr_available","","",null,null],[17,"c__WORDSIZE","","",null,null],[17,"c__WORDSIZE_TIME64_COMPAT32","","",null,null],[17,"c__SYSCALL_WORDSIZE","","",null,null],[17,"c__LONG_DOUBLE_USES_FLOAT128","","",null,null],[17,"c__HAVE_GENERIC_SELECTION","","",null,null],[17,"c__GLIBC_USE_LIB_EXT2","","",null,null],[17,"c__GLIBC_USE_IEC_60559_BFP_EXT","","",null,null],[17,"c__GLIBC_USE_IEC_60559_BFP_EXT_C2X","","",null,null],[17,"c__GLIBC_USE_IEC_60559_FUNCS_EXT","","",null,null],[17,"c__GLIBC_USE_IEC_60559_FUNCS_EXT_C2X","","",null,null],[17,"c__GLIBC_USE_IEC_60559_TYPES_EXT","","",null,null],[17,"c_STDLIB_H","","",null,null],[17,"cWNOHANG","","",null,null],[17,"cWUNTRACED","","",null,null],[17,"cWSTOPPED","","",null,null],[17,"cWEXITED","","",null,null],[17,"cWCONTINUED","","",null,null],[17,"cWNOWAIT","","",null,null],[17,"c__WNOTHREAD","","",null,null],[17,"c__WALL","","",null,null],[17,"c__WCLONE","","",null,null],[17,"c__ENUM_IDTYPE_T","","",null,null],[17,"c__W_CONTINUED","","",null,null],[17,"c__WCOREFLAG","","",null,null],[17,"c__HAVE_FLOAT128","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT128","","",null,null],[17,"c__HAVE_FLOAT64X","","",null,null],[17,"c__HAVE_FLOAT64X_LONG_DOUBLE","","",null,null],[17,"c__HAVE_FLOAT16","","",null,null],[17,"c__HAVE_FLOAT32","","",null,null],[17,"c__HAVE_FLOAT64","","",null,null],[17,"c__HAVE_FLOAT32X","","",null,null],[17,"c__HAVE_FLOAT128X","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT16","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT32","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT64","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT32X","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT64X","","",null,null],[17,"c__HAVE_DISTINCT_FLOAT128X","","",null,null],[17,"c__HAVE_FLOATN_NOT_TYPEDEF","","",null,null],[17,"c__ldiv_t_defined","","",null,null],[17,"c__lldiv_t_defined","","",null,null],[17,"cRAND_MAX","","",null,null],[17,"cEXIT_FAILURE","","",null,null],[17,"cEXIT_SUCCESS","","",null,null],[17,"c_SYS_TYPES_H","","",null,null],[17,"c_BITS_TYPES_H","","",null,null],[17,"c__TIMESIZE","","",null,null],[17,"c_BITS_TYPESIZES_H","","",null,null],[17,"c__OFF_T_MATCHES_OFF64_T","","",null,null],[17,"c__INO_T_MATCHES_INO64_T","","",null,null],[17,"c__RLIM_T_MATCHES_RLIM64_T","","",null,null],[17,"c__STATFS_MATCHES_STATFS64","","",null,null],[17,"c__FD_SETSIZE","","",null,null],[17,"c_BITS_TIME64_H","","",null,null],[17,"c__clock_t_defined","","",null,null],[17,"c__clockid_t_defined","","",null,null],[17,"c__time_t_defined","","",null,null],[17,"c__timer_t_defined","","",null,null],[17,"c_BITS_STDINT_INTN_H","","",null,null],[17,"c__BIT_TYPES_DEFINED__","","",null,null],[17,"c_ENDIAN_H","","",null,null],[17,"c_BITS_ENDIAN_H","","",null,null],[17,"c__LITTLE_ENDIAN","","",null,null],[17,"c__BIG_ENDIAN","","",null,null],[17,"c__PDP_ENDIAN","","",null,null],[17,"c_BITS_ENDIANNESS_H","","",null,null],[17,"c__BYTE_ORDER","","",null,null],[17,"c__FLOAT_WORD_ORDER","","",null,null],[17,"cLITTLE_ENDIAN","","",null,null],[17,"cBIG_ENDIAN","","",null,null],[17,"cPDP_ENDIAN","","",null,null],[17,"cBYTE_ORDER","","",null,null],[17,"c_BITS_BYTESWAP_H","","",null,null],[17,"c_BITS_UINTN_IDENTITY_H","","",null,null],[17,"c_SYS_SELECT_H","","",null,null],[17,"c__FD_ZERO_STOS","","",null,null],[17,"c__sigset_t_defined","","",null,null],[17,"c__timeval_defined","","",null,null],[17,"c_STRUCT_TIMESPEC","","",null,null],[17,"cFD_SETSIZE","","",null,null],[17,"c_BITS_PTHREADTYPES_COMMON_H","","",null,null],[17,"c_THREAD_SHARED_TYPES_H","","",null,null],[17,"c_BITS_PTHREADTYPES_ARCH_H","","",null,null],[17,"c__SIZEOF_PTHREAD_MUTEX_T","","",null,null],[17,"c__SIZEOF_PTHREAD_ATTR_T","","",null,null],[17,"c__SIZEOF_PTHREAD_RWLOCK_T","","",null,null],[17,"c__SIZEOF_PTHREAD_BARRIER_T","","",null,null],[17,"c__SIZEOF_PTHREAD_MUTEXATTR_T","","",null,null],[17,"c__SIZEOF_PTHREAD_COND_T","","",null,null],[17,"c__SIZEOF_PTHREAD_CONDATTR_T","","",null,null],[17,"c__SIZEOF_PTHREAD_RWLOCKATTR_T","","",null,null],[17,"c__SIZEOF_PTHREAD_BARRIERATTR_T","","",null,null],[17,"c_THREAD_MUTEX_INTERNAL_H","","",null,null],[17,"c__PTHREAD_MUTEX_HAVE_PREV","","",null,null],[17,"c__have_pthread_attr_t","","",null,null],[17,"c_ALLOCA_H","","",null,null],[17,"c_STRING_H","","",null,null],[17,"c_BITS_TYPES_LOCALE_T_H","","",null,null],[17,"c_BITS_TYPES___LOCALE_T_H","","",null,null],[17,"c_STRINGS_H","","",null,null],[17,"cBW_ERR_CODE_SUCCESS","","",null,null],[17,"c_ASSERT_H","","",null,null],[17,"c_STDIO_H","","",null,null],[17,"c__GNUC_VA_LIST","","",null,null],[17,"c_____fpos_t_defined","","",null,null],[17,"c____mbstate_t_defined","","",null,null],[17,"c_____fpos64_t_defined","","",null,null],[17,"c____FILE_defined","","",null,null],[17,"c__FILE_defined","","",null,null],[17,"c__struct_FILE_defined","","",null,null],[17,"c_IO_EOF_SEEN","","",null,null],[17,"c_IO_ERR_SEEN","","",null,null],[17,"c_IO_USER_LOCK","","",null,null],[17,"c_IOFBF","","",null,null],[17,"c_IOLBF","","",null,null],[17,"c_IONBF","","",null,null],[17,"cBUFSIZ","","",null,null],[17,"cEOF","","",null,null],[17,"cSEEK_SET","","",null,null],[17,"cSEEK_CUR","","",null,null],[17,"cSEEK_END","","",null,null],[17,"cP_tmpdir","","",null,null],[17,"c_BITS_STDIO_LIM_H","","",null,null],[17,"cL_tmpnam","","",null,null],[17,"cTMP_MAX","","",null,null],[17,"cFILENAME_MAX","","",null,null],[17,"cL_ctermid","","",null,null],[17,"cFOPEN_MAX","","",null,null],[17,"c_ERRNO_H","","",null,null],[17,"c_BITS_ERRNO_H","","",null,null],[17,"cEPERM","","",null,null],[17,"cENOENT","","",null,null],[17,"cESRCH","","",null,null],[17,"cEINTR","","",null,null],[17,"cEIO","","",null,null],[17,"cENXIO","","",null,null],[17,"cE2BIG","","",null,null],[17,"cENOEXEC","","",null,null],[17,"cEBADF","","",null,null],[17,"cECHILD","","",null,null],[17,"cEAGAIN","","",null,null],[17,"cENOMEM","","",null,null],[17,"cEACCES","","",null,null],[17,"cEFAULT","","",null,null],[17,"cENOTBLK","","",null,null],[17,"cEBUSY","","",null,null],[17,"cEEXIST","","",null,null],[17,"cEXDEV","","",null,null],[17,"cENODEV","","",null,null],[17,"cENOTDIR","","",null,null],[17,"cEISDIR","","",null,null],[17,"cEINVAL","","",null,null],[17,"cENFILE","","",null,null],[17,"cEMFILE","","",null,null],[17,"cENOTTY","","",null,null],[17,"cETXTBSY","","",null,null],[17,"cEFBIG","","",null,null],[17,"cENOSPC","","",null,null],[17,"cESPIPE","","",null,null],[17,"cEROFS","","",null,null],[17,"cEMLINK","","",null,null],[17,"cEPIPE","","",null,null],[17,"cEDOM","","",null,null],[17,"cERANGE","","",null,null],[17,"cEDEADLK","","",null,null],[17,"cENAMETOOLONG","","",null,null],[17,"cENOLCK","","",null,null],[17,"cENOSYS","","",null,null],[17,"cENOTEMPTY","","",null,null],[17,"cELOOP","","",null,null],[17,"cEWOULDBLOCK","","",null,null],[17,"cENOMSG","","",null,null],[17,"cEIDRM","","",null,null],[17,"cECHRNG","","",null,null],[17,"cEL2NSYNC","","",null,null],[17,"cEL3HLT","","",null,null],[17,"cEL3RST","","",null,null],[17,"cELNRNG","","",null,null],[17,"cEUNATCH","","",null,null],[17,"cENOCSI","","",null,null],[17,"cEL2HLT","","",null,null],[17,"cEBADE","","",null,null],[17,"cEBADR","","",null,null],[17,"cEXFULL","","",null,null],[17,"cENOANO","","",null,null],[17,"cEBADRQC","","",null,null],[17,"cEBADSLT","","",null,null],[17,"cEDEADLOCK","","",null,null],[17,"cEBFONT","","",null,null],[17,"cENOSTR","","",null,null],[17,"cENODATA","","",null,null],[17,"cETIME","","",null,null],[17,"cENOSR","","",null,null],[17,"cENONET","","",null,null],[17,"cENOPKG","","",null,null],[17,"cEREMOTE","","",null,null],[17,"cENOLINK","","",null,null],[17,"cEADV","","",null,null],[17,"cESRMNT","","",null,null],[17,"cECOMM","","",null,null],[17,"cEPROTO","","",null,null],[17,"cEMULTIHOP","","",null,null],[17,"cEDOTDOT","","",null,null],[17,"cEBADMSG","","",null,null],[17,"cEOVERFLOW","","",null,null],[17,"cENOTUNIQ","","",null,null],[17,"cEBADFD","","",null,null],[17,"cEREMCHG","","",null,null],[17,"cELIBACC","","",null,null],[17,"cELIBBAD","","",null,null],[17,"cELIBSCN","","",null,null],[17,"cELIBMAX","","",null,null],[17,"cELIBEXEC","","",null,null],[17,"cEILSEQ","","",null,null],[17,"cERESTART","","",null,null],[17,"cESTRPIPE","","",null,null],[17,"cEUSERS","","",null,null],[17,"cENOTSOCK","","",null,null],[17,"cEDESTADDRREQ","","",null,null],[17,"cEMSGSIZE","","",null,null],[17,"cEPROTOTYPE","","",null,null],[17,"cENOPROTOOPT","","",null,null],[17,"cEPROTONOSUPPORT","","",null,null],[17,"cESOCKTNOSUPPORT","","",null,null],[17,"cEOPNOTSUPP","","",null,null],[17,"cEPFNOSUPPORT","","",null,null],[17,"cEAFNOSUPPORT","","",null,null],[17,"cEADDRINUSE","","",null,null],[17,"cEADDRNOTAVAIL","","",null,null],[17,"cENETDOWN","","",null,null],[17,"cENETUNREACH","","",null,null],[17,"cENETRESET","","",null,null],[17,"cECONNABORTED","","",null,null],[17,"cECONNRESET","","",null,null],[17,"cENOBUFS","","",null,null],[17,"cEISCONN","","",null,null],[17,"cENOTCONN","","",null,null],[17,"cESHUTDOWN","","",null,null],[17,"cETOOMANYREFS","","",null,null],[17,"cETIMEDOUT","","",null,null],[17,"cECONNREFUSED","","",null,null],[17,"cEHOSTDOWN","","",null,null],[17,"cEHOSTUNREACH","","",null,null],[17,"cEALREADY","","",null,null],[17,"cEINPROGRESS","","",null,null],[17,"cESTALE","","",null,null],[17,"cEUCLEAN","","",null,null],[17,"cENOTNAM","","",null,null],[17,"cENAVAIL","","",null,null],[17,"cEISNAM","","",null,null],[17,"cEREMOTEIO","","",null,null],[17,"cEDQUOT","","",null,null],[17,"cENOMEDIUM","","",null,null],[17,"cEMEDIUMTYPE","","",null,null],[17,"cECANCELED","","",null,null],[17,"cENOKEY","","",null,null],[17,"cEKEYEXPIRED","","",null,null],[17,"cEKEYREVOKED","","",null,null],[17,"cEKEYREJECTED","","",null,null],[17,"cEOWNERDEAD","","",null,null],[17,"cENOTRECOVERABLE","","",null,null],[17,"cERFKILL","","",null,null],[17,"cEHWPOISON","","",null,null],[17,"cENOTSUP","","",null,null],[17,"c_STDINT_H","","",null,null],[17,"c_BITS_WCHAR_H","","",null,null],[17,"c_BITS_STDINT_UINTN_H","","",null,null],[17,"cINT8_MIN","","",null,null],[17,"cINT16_MIN","","",null,null],[17,"cINT32_MIN","","",null,null],[17,"cINT8_MAX","","",null,null],[17,"cINT16_MAX","","",null,null],[17,"cINT32_MAX","","",null,null],[17,"cUINT8_MAX","","",null,null],[17,"cUINT16_MAX","","",null,null],[17,"cUINT32_MAX","","",null,null],[17,"cINT_LEAST8_MIN","","",null,null],[17,"cINT_LEAST16_MIN","","",null,null],[17,"cINT_LEAST32_MIN","","",null,null],[17,"cINT_LEAST8_MAX","","",null,null],[17,"cINT_LEAST16_MAX","","",null,null],[17,"cINT_LEAST32_MAX","","",null,null],[17,"cUINT_LEAST8_MAX","","",null,null],[17,"cUINT_LEAST16_MAX","","",null,null],[17,"cUINT_LEAST32_MAX","","",null,null],[17,"cINT_FAST8_MIN","","",null,null],[17,"cINT_FAST16_MIN","","",null,null],[17,"cINT_FAST32_MIN","","",null,null],[17,"cINT_FAST8_MAX","","",null,null],[17,"cINT_FAST16_MAX","","",null,null],[17,"cINT_FAST32_MAX","","",null,null],[17,"cUINT_FAST8_MAX","","",null,null],[17,"cUINT_FAST16_MAX","","",null,null],[17,"cUINT_FAST32_MAX","","",null,null],[17,"cINTPTR_MIN","","",null,null],[17,"cINTPTR_MAX","","",null,null],[17,"cUINTPTR_MAX","","",null,null],[17,"cPTRDIFF_MIN","","",null,null],[17,"cPTRDIFF_MAX","","",null,null],[17,"cSIG_ATOMIC_MIN","","",null,null],[17,"cSIG_ATOMIC_MAX","","",null,null],[17,"cSIZE_MAX","","",null,null],[17,"cWINT_MIN","","",null,null],[17,"cWINT_MAX","","",null,null],[17,"ctrue","","",null,null],[17,"cfalse","","",null,null],[17,"c__bool_true_false_are_defined","","",null,null],[6,"cBOOL","","",null,null],[6,"csize_t","","",null,null],[6,"cwchar_t","","",null,null],[5,"cbw_string_copyAsNewCstr","","Copies the string from the given `bw_CStrSlice` to a C…",null,[[["cbw_cstrslice",3]]]],[5,"cbw_string_freeCstr","","Frees the string allocated with any of the functions of…",null,[[]]],[6,"cbw_ApplicationDispatchFn","","",null,null],[6,"cbw_ApplicationReadyFn","","",null,null],[5,"cbw_Application_assertCorrectThread","","Safety check that makes sure the given application handle…",null,[[]]],[5,"cbw_Application_exit","","Exits the main loop, returning execution to the function…",null,[[]]],[5,"cbw_Application_exitAsync","","Same as bw_Application_exit, but guaranteed to be…",null,[[]]],[5,"cbw_Application_dispatch","","Dispatches the given function to be executed on the thread…",null,[[["option",4]]]],[5,"cbw_Application_finish","","Shuts down all application processes and performs…",null,[[]]],[5,"cbw_Application_free","","Frees memory for the application handle. Call…",null,[[]]],[5,"cbw_Application_initialize","","Initializes browser window. Starts up browser engine…",null,[[]]],[5,"cbw_Application_isRunning","","",null,[[]]],[5,"cbw_Application_run","","Runs the event loop. Calls the `on_ready` callback when…",null,[[["option",4]]]],[17,"cidtype_t_P_ALL","","",null,null],[17,"cidtype_t_P_PID","","",null,null],[17,"cidtype_t_P_PGID","","",null,null],[6,"cidtype_t","","",null,null],[6,"c_Float32","","",null,null],[6,"c_Float64","","",null,null],[6,"c_Float32x","","",null,null],[6,"c_Float64x","","",null,null],[5,"c__ctype_get_mb_cur_max","","",null,[[]]],[5,"catof","","",null,[[]]],[5,"catoi","","",null,[[]]],[5,"catol","","",null,[[]]],[5,"catoll","","",null,[[]]],[5,"cstrtod","","",null,[[]]],[5,"cstrtof","","",null,[[]]],[5,"cstrtold","","",null,[[]]],[5,"cstrtol","","",null,[[]]],[5,"cstrtoul","","",null,[[]]],[5,"cstrtoq","","",null,[[]]],[5,"cstrtouq","","",null,[[]]],[5,"cstrtoll","","",null,[[]]],[5,"cstrtoull","","",null,[[]]],[5,"cl64a","","",null,[[]]],[5,"ca64l","","",null,[[]]],[6,"c__u_char","","",null,null],[6,"c__u_short","","",null,null],[6,"c__u_int","","",null,null],[6,"c__u_long","","",null,null],[6,"c__int8_t","","",null,null],[6,"c__uint8_t","","",null,null],[6,"c__int16_t","","",null,null],[6,"c__uint16_t","","",null,null],[6,"c__int32_t","","",null,null],[6,"c__uint32_t","","",null,null],[6,"c__int64_t","","",null,null],[6,"c__uint64_t","","",null,null],[6,"c__int_least8_t","","",null,null],[6,"c__uint_least8_t","","",null,null],[6,"c__int_least16_t","","",null,null],[6,"c__uint_least16_t","","",null,null],[6,"c__int_least32_t","","",null,null],[6,"c__uint_least32_t","","",null,null],[6,"c__int_least64_t","","",null,null],[6,"c__uint_least64_t","","",null,null],[6,"c__quad_t","","",null,null],[6,"c__u_quad_t","","",null,null],[6,"c__intmax_t","","",null,null],[6,"c__uintmax_t","","",null,null],[6,"c__dev_t","","",null,null],[6,"c__uid_t","","",null,null],[6,"c__gid_t","","",null,null],[6,"c__ino_t","","",null,null],[6,"c__ino64_t","","",null,null],[6,"c__mode_t","","",null,null],[6,"c__nlink_t","","",null,null],[6,"c__off_t","","",null,null],[6,"c__off64_t","","",null,null],[6,"c__pid_t","","",null,null],[6,"c__clock_t","","",null,null],[6,"c__rlim_t","","",null,null],[6,"c__rlim64_t","","",null,null],[6,"c__id_t","","",null,null],[6,"c__time_t","","",null,null],[6,"c__useconds_t","","",null,null],[6,"c__suseconds_t","","",null,null],[6,"c__daddr_t","","",null,null],[6,"c__key_t","","",null,null],[6,"c__clockid_t","","",null,null],[6,"c__timer_t","","",null,null],[6,"c__blksize_t","","",null,null],[6,"c__blkcnt_t","","",null,null],[6,"c__blkcnt64_t","","",null,null],[6,"c__fsblkcnt_t","","",null,null],[6,"c__fsblkcnt64_t","","",null,null],[6,"c__fsfilcnt_t","","",null,null],[6,"c__fsfilcnt64_t","","",null,null],[6,"c__fsword_t","","",null,null],[6,"c__ssize_t","","",null,null],[6,"c__syscall_slong_t","","",null,null],[6,"c__syscall_ulong_t","","",null,null],[6,"c__loff_t","","",null,null],[6,"c__caddr_t","","",null,null],[6,"c__intptr_t","","",null,null],[6,"c__socklen_t","","",null,null],[6,"c__sig_atomic_t","","",null,null],[6,"cu_char","","",null,null],[6,"cu_short","","",null,null],[6,"cu_int","","",null,null],[6,"cu_long","","",null,null],[6,"cquad_t","","",null,null],[6,"cu_quad_t","","",null,null],[6,"cfsid_t","","",null,null],[6,"cloff_t","","",null,null],[6,"cino_t","","",null,null],[6,"cdev_t","","",null,null],[6,"cgid_t","","",null,null],[6,"cmode_t","","",null,null],[6,"cnlink_t","","",null,null],[6,"cuid_t","","",null,null],[6,"coff_t","","",null,null],[6,"cpid_t","","",null,null],[6,"cid_t","","",null,null],[6,"cssize_t","","",null,null],[6,"cdaddr_t","","",null,null],[6,"ccaddr_t","","",null,null],[6,"ckey_t","","",null,null],[6,"cclock_t","","",null,null],[6,"cclockid_t","","",null,null],[6,"ctime_t","","",null,null],[6,"ctimer_t","","",null,null],[6,"culong","","",null,null],[6,"cushort","","",null,null],[6,"cuint","","",null,null],[6,"cu_int8_t","","",null,null],[6,"cu_int16_t","","",null,null],[6,"cu_int32_t","","",null,null],[6,"cu_int64_t","","",null,null],[6,"cregister_t","","",null,null],[6,"csigset_t","","",null,null],[6,"csuseconds_t","","",null,null],[6,"c__fd_mask","","",null,null],[6,"cfd_mask","","",null,null],[5,"cselect","","",null,[[]]],[5,"cpselect","","",null,[[]]],[6,"cblksize_t","","",null,null],[6,"cblkcnt_t","","",null,null],[6,"cfsblkcnt_t","","",null,null],[6,"cfsfilcnt_t","","",null,null],[6,"c__pthread_list_t","","",null,null],[6,"c__pthread_slist_t","","",null,null],[6,"cpthread_t","","",null,null],[6,"cpthread_key_t","","",null,null],[6,"cpthread_once_t","","",null,null],[6,"cpthread_spinlock_t","","",null,null],[5,"crandom","","",null,[[]]],[5,"csrandom","","",null,[[]]],[5,"cinitstate","","",null,[[]]],[5,"csetstate","","",null,[[]]],[5,"crandom_r","","",null,[[]]],[5,"csrandom_r","","",null,[[]]],[5,"cinitstate_r","","",null,[[]]],[5,"csetstate_r","","",null,[[]]],[5,"crand","","",null,[[]]],[5,"csrand","","",null,[[]]],[5,"crand_r","","",null,[[]]],[5,"cdrand48","","",null,[[]]],[5,"cerand48","","",null,[[]]],[5,"clrand48","","",null,[[]]],[5,"cnrand48","","",null,[[]]],[5,"cmrand48","","",null,[[]]],[5,"cjrand48","","",null,[[]]],[5,"csrand48","","",null,[[]]],[5,"cseed48","","",null,[[]]],[5,"clcong48","","",null,[[]]],[5,"cdrand48_r","","",null,[[]]],[5,"cerand48_r","","",null,[[]]],[5,"clrand48_r","","",null,[[]]],[5,"cnrand48_r","","",null,[[]]],[5,"cmrand48_r","","",null,[[]]],[5,"cjrand48_r","","",null,[[]]],[5,"csrand48_r","","",null,[[]]],[5,"cseed48_r","","",null,[[]]],[5,"clcong48_r","","",null,[[]]],[5,"cmalloc","","",null,[[]]],[5,"ccalloc","","",null,[[]]],[5,"crealloc","","",null,[[]]],[5,"creallocarray","","",null,[[]]],[5,"cfree","","",null,[[]]],[5,"calloca","","",null,[[]]],[5,"cvalloc","","",null,[[]]],[5,"cposix_memalign","","",null,[[]]],[5,"caligned_alloc","","",null,[[]]],[5,"cabort","","",null,[[]]],[5,"catexit","","",null,[[["option",4]]]],[5,"cat_quick_exit","","",null,[[["option",4]]]],[5,"con_exit","","",null,[[["option",4]]]],[5,"cexit","","",null,[[]]],[5,"cquick_exit","","",null,[[]]],[5,"c_Exit","","",null,[[]]],[5,"cgetenv","","",null,[[]]],[5,"cputenv","","",null,[[]]],[5,"csetenv","","",null,[[]]],[5,"cunsetenv","","",null,[[]]],[5,"cclearenv","","",null,[[]]],[5,"cmktemp","","",null,[[]]],[5,"cmkstemp","","",null,[[]]],[5,"cmkstemps","","",null,[[]]],[5,"cmkdtemp","","",null,[[]]],[5,"csystem","","",null,[[]]],[5,"crealpath","","",null,[[]]],[6,"c__compar_fn_t","","",null,null],[5,"cbsearch","","",null,[[["option",4]]]],[5,"cqsort","","",null,[[["option",4]]]],[5,"cabs","","",null,[[]]],[5,"clabs","","",null,[[]]],[5,"cllabs","","",null,[[]]],[5,"cdiv","","",null,[[],["cdiv_t",3]]],[5,"cldiv","","",null,[[],["cldiv_t",3]]],[5,"clldiv","","",null,[[],["clldiv_t",3]]],[5,"cecvt","","",null,[[]]],[5,"cfcvt","","",null,[[]]],[5,"cgcvt","","",null,[[]]],[5,"cqecvt","","",null,[[]]],[5,"cqfcvt","","",null,[[]]],[5,"cqgcvt","","",null,[[]]],[5,"cecvt_r","","",null,[[]]],[5,"cfcvt_r","","",null,[[]]],[5,"cqecvt_r","","",null,[[]]],[5,"cqfcvt_r","","",null,[[]]],[5,"cmblen","","",null,[[]]],[5,"cmbtowc","","",null,[[]]],[5,"cwctomb","","",null,[[]]],[5,"cmbstowcs","","",null,[[]]],[5,"cwcstombs","","",null,[[]]],[5,"crpmatch","","",null,[[]]],[5,"cgetsubopt","","",null,[[]]],[5,"cgetloadavg","","",null,[[]]],[5,"cmemcpy","","",null,[[]]],[5,"cmemmove","","",null,[[]]],[5,"cmemccpy","","",null,[[]]],[5,"cmemset","","",null,[[]]],[5,"cmemcmp","","",null,[[]]],[5,"cmemchr","","",null,[[]]],[5,"cstrcpy","","",null,[[]]],[5,"cstrncpy","","",null,[[]]],[5,"cstrcat","","",null,[[]]],[5,"cstrncat","","",null,[[]]],[5,"cstrcmp","","",null,[[]]],[5,"cstrncmp","","",null,[[]]],[5,"cstrcoll","","",null,[[]]],[5,"cstrxfrm","","",null,[[]]],[6,"c__locale_t","","",null,null],[6,"clocale_t","","",null,null],[5,"cstrcoll_l","","",null,[[]]],[5,"cstrxfrm_l","","",null,[[]]],[5,"cstrdup","","",null,[[]]],[5,"cstrndup","","",null,[[]]],[5,"cstrchr","","",null,[[]]],[5,"cstrrchr","","",null,[[]]],[5,"cstrcspn","","",null,[[]]],[5,"cstrspn","","",null,[[]]],[5,"cstrpbrk","","",null,[[]]],[5,"cstrstr","","",null,[[]]],[5,"cstrtok","","",null,[[]]],[5,"c__strtok_r","","",null,[[]]],[5,"cstrtok_r","","",null,[[]]],[5,"cstrlen","","",null,[[]]],[5,"cstrnlen","","",null,[[]]],[5,"cstrerror","","",null,[[]]],[5,"cstrerror_r","","",null,[[]]],[5,"cstrerror_l","","",null,[[]]],[5,"cbcmp","","",null,[[]]],[5,"cbcopy","","",null,[[]]],[5,"cbzero","","",null,[[]]],[5,"cindex","","",null,[[]]],[5,"crindex","","",null,[[]]],[5,"cffs","","",null,[[]]],[5,"cffsl","","",null,[[]]],[5,"cffsll","","",null,[[]]],[5,"cstrcasecmp","","",null,[[]]],[5,"cstrncasecmp","","",null,[[]]],[5,"cstrcasecmp_l","","",null,[[]]],[5,"cstrncasecmp_l","","",null,[[]]],[5,"cexplicit_bzero","","",null,[[]]],[5,"cstrsep","","",null,[[]]],[5,"cstrsignal","","",null,[[]]],[5,"c__stpcpy","","",null,[[]]],[5,"cstpcpy","","",null,[[]]],[5,"c__stpncpy","","",null,[[]]],[5,"cstpncpy","","",null,[[]]],[6,"cbw_ErrCode","","",null,null],[5,"cbw_Err_msg_success","","",null,[[]]],[5,"cbw_Err_msg_string","","",null,[[]]],[5,"cbw_Err_free","","",null,[[]]],[5,"cbw_Err_new_with_msg","","",null,[[],["cbw_err",3]]],[5,"c__assert_fail","","",null,[[]]],[5,"c__assert_perror_fail","","",null,[[]]],[5,"c__assert","","",null,[[]]],[6,"cva_list","","",null,null],[6,"c__gnuc_va_list","","",null,null],[6,"c__fpos_t","","",null,null],[6,"c__fpos64_t","","",null,null],[6,"c__FILE","","",null,null],[6,"cFILE","","",null,null],[6,"c_IO_lock_t","","",null,null],[6,"cfpos_t","","",null,null],[7,"cstdin","","",null,null],[7,"cstdout","","",null,null],[7,"cstderr","","",null,null],[5,"cremove","","",null,[[]]],[5,"crename","","",null,[[]]],[5,"crenameat","","",null,[[]]],[5,"ctmpfile","","",null,[[]]],[5,"ctmpnam","","",null,[[]]],[5,"ctmpnam_r","","",null,[[]]],[5,"ctempnam","","",null,[[]]],[5,"cfclose","","",null,[[]]],[5,"cfflush","","",null,[[]]],[5,"cfflush_unlocked","","",null,[[]]],[5,"cfopen","","",null,[[]]],[5,"cfreopen","","",null,[[]]],[5,"cfdopen","","",null,[[]]],[5,"cfmemopen","","",null,[[]]],[5,"copen_memstream","","",null,[[]]],[5,"csetbuf","","",null,[[]]],[5,"csetvbuf","","",null,[[]]],[5,"csetbuffer","","",null,[[]]],[5,"csetlinebuf","","",null,[[]]],[5,"cfprintf","","",null,[[]]],[5,"cprintf","","",null,[[]]],[5,"csprintf","","",null,[[]]],[5,"cvfprintf","","",null,[[]]],[5,"cvprintf","","",null,[[]]],[5,"cvsprintf","","",null,[[]]],[5,"csnprintf","","",null,[[]]],[5,"cvsnprintf","","",null,[[]]],[5,"cvdprintf","","",null,[[]]],[5,"cdprintf","","",null,[[]]],[5,"cfscanf","","",null,[[]]],[5,"cscanf","","",null,[[]]],[5,"csscanf","","",null,[[]]],[5,"cfscanf1","","",null,[[]]],[5,"cscanf1","","",null,[[]]],[5,"csscanf1","","",null,[[]]],[5,"cvfscanf","","",null,[[]]],[5,"cvscanf","","",null,[[]]],[5,"cvsscanf","","",null,[[]]],[5,"cvfscanf1","","",null,[[]]],[5,"cvscanf1","","",null,[[]]],[5,"cvsscanf1","","",null,[[]]],[5,"cfgetc","","",null,[[]]],[5,"cgetc","","",null,[[]]],[5,"cgetchar","","",null,[[]]],[5,"cgetc_unlocked","","",null,[[]]],[5,"cgetchar_unlocked","","",null,[[]]],[5,"cfgetc_unlocked","","",null,[[]]],[5,"cfputc","","",null,[[]]],[5,"cputc","","",null,[[]]],[5,"cputchar","","",null,[[]]],[5,"cfputc_unlocked","","",null,[[]]],[5,"cputc_unlocked","","",null,[[]]],[5,"cputchar_unlocked","","",null,[[]]],[5,"cgetw","","",null,[[]]],[5,"cputw","","",null,[[]]],[5,"cfgets","","",null,[[]]],[5,"c__getdelim","","",null,[[]]],[5,"cgetdelim","","",null,[[]]],[5,"cgetline","","",null,[[]]],[5,"cfputs","","",null,[[]]],[5,"cputs","","",null,[[]]],[5,"cungetc","","",null,[[]]],[5,"cfread","","",null,[[]]],[5,"cfwrite","","",null,[[]]],[5,"cfread_unlocked","","",null,[[]]],[5,"cfwrite_unlocked","","",null,[[]]],[5,"cfseek","","",null,[[]]],[5,"cftell","","",null,[[]]],[5,"crewind","","",null,[[]]],[5,"cfseeko","","",null,[[]]],[5,"cftello","","",null,[[]]],[5,"cfgetpos","","",null,[[]]],[5,"cfsetpos","","",null,[[]]],[5,"cclearerr","","",null,[[]]],[5,"cfeof","","",null,[[]]],[5,"cferror","","",null,[[]]],[5,"cclearerr_unlocked","","",null,[[]]],[5,"cfeof_unlocked","","",null,[[]]],[5,"cferror_unlocked","","",null,[[]]],[5,"cperror","","",null,[[]]],[7,"csys_nerr","","",null,null],[7,"csys_errlist","","",null,null],[5,"cfileno","","",null,[[]]],[5,"cfileno_unlocked","","",null,[[]]],[5,"cpopen","","",null,[[]]],[5,"cpclose","","",null,[[]]],[5,"cctermid","","",null,[[]]],[5,"cflockfile","","",null,[[]]],[5,"cftrylockfile","","",null,[[]]],[5,"cfunlockfile","","",null,[[]]],[5,"c__uflow","","",null,[[]]],[5,"c__overflow","","",null,[[]]],[5,"c__errno_location","","",null,[[]]],[6,"cint_least8_t","","",null,null],[6,"cint_least16_t","","",null,null],[6,"cint_least32_t","","",null,null],[6,"cint_least64_t","","",null,null],[6,"cuint_least8_t","","",null,null],[6,"cuint_least16_t","","",null,null],[6,"cuint_least32_t","","",null,null],[6,"cuint_least64_t","","",null,null],[6,"cint_fast8_t","","",null,null],[6,"cint_fast16_t","","",null,null],[6,"cint_fast32_t","","",null,null],[6,"cint_fast64_t","","",null,null],[6,"cuint_fast8_t","","",null,null],[6,"cuint_fast16_t","","",null,null],[6,"cuint_fast32_t","","",null,null],[6,"cuint_fast64_t","","",null,null],[6,"cintmax_t","","",null,null],[6,"cuintmax_t","","",null,null],[6,"cbw_WindowDispatchFn","","",null,null],[5,"cbw_Window_destroy","","Destroy the window, releasing all resources it holds.…",null,[[]]],[5,"cbw_Window_drop","","Invalidates the window handle. The window will get…",null,[[]]],[5,"cbw_Window_getContentDimensions","","Gets the width and height of the usable area inside the…",null,[[],["cbw_dims2d",3]]],[5,"cbw_Window_getOpacity","","Gets the opacity of the window as a value from 0 to 255.",null,[[]]],[5,"cbw_Window_getPosition","","Gets the X and Y coordinates of the window position…",null,[[],["cbw_pos2d",3]]],[5,"cbw_Window_getTitle","","Copies as many bytes into `title` that fit in there.…",null,[[["cbw_strslice",3]]]],[5,"cbw_Window_getWindowDimensions","","Gets the width and height of the window including the…",null,[[],["cbw_dims2d",3]]],[5,"cbw_Window_hide","","",null,[[]]],[5,"cbw_Window_isVisible","","Returns whether or not the window is not hidden.…",null,[[]]],[5,"cbw_Window_new","","Creates a new (empty) window The returned pointer is a…",null,[[["cbw_cstrslice",3]]]],[5,"cbw_Window_setContentDimensions","","",null,[[["cbw_dims2d",3]]]],[5,"cbw_Window_setOpacity","","",null,[[]]],[5,"cbw_Window_setPosition","","",null,[[["cbw_pos2d",3]]]],[5,"cbw_Window_setTitle","","Applies the given title;",null,[[["cbw_cstrslice",3]]]],[5,"cbw_Window_setWindowDimensions","","",null,[[["cbw_dims2d",3]]]],[5,"cbw_Window_show","","Shows the window if it was previously hidden Is generally…",null,[[]]],[5,"cbw_Window_triggerClose","","",null,[[]]],[5,"c_bw_Window_onResize","","",null,[[]]],[6,"cbw_BrowserWindowCreationCallbackFn","","",null,null],[6,"cbw_BrowserWindowHandlerFn","","",null,null],[6,"cbw_BrowserWindowJsCallbackFn","","",null,null],[5,"cbw_BrowserWindow_destroy","","",null,[[]]],[5,"cbw_BrowserWindow_drop","","Marks the browser window handle as not being used anymore.…",null,[[]]],[5,"cbw_BrowserWindow_evalJs","","Executes the given JavaScript and calls the given callback…",null,[[["cbw_cstrslice",3],["option",4]]]],[5,"cbw_BrowserWindow_evalJsThreaded","","",null,[[["cbw_cstrslice",3],["option",4]]]],[5,"cbw_BrowserWindow_getApp","","",null,[[]]],[5,"cbw_BrowserWindow_getUserData","","",null,[[]]],[5,"cbw_BrowserWindow_getWindow","","",null,[[]]],[5,"cbw_BrowserWindow_navigate","","",null,[[["cbw_cstrslice",3]],["cbw_err",3]]],[5,"cbw_BrowserWindow_new","","Creates a new browser window",null,[[["option",4],["cbw_browserwindowsource",3],["option",4],["cbw_cstrslice",3]]]],[6,"c__builtin_va_list","","",null,null],[3,"cmax_align_t","","",null,null],[12,"__clang_max_align_nonce1","","",2,null],[12,"__bindgen_padding_0","","",2,null],[12,"__clang_max_align_nonce2","","",2,null],[3,"cbw_StrSlice","","A \'string slice\' Points to a mutable, non-zero-terminated,…",null,null],[12,"len","","",3,null],[12,"data","","",3,null],[3,"cbw_CStrSlice","","A \'const string slice\' Points to a immutable,…",null,null],[12,"len","","",4,null],[12,"data","","",4,null],[3,"cbw_ApplicationImpl","","",null,null],[3,"cbw_ApplicationEngineImpl","","",null,null],[3,"cbw_Application","","",null,null],[12,"windows_alive","","",5,null],[12,"impl_","","",5,null],[12,"engine_impl","","",5,null],[3,"cbw_ApplicationEngineData","","",null,null],[3,"cbw_ApplicationDispatchData","","",null,null],[12,"func","","",6,null],[12,"data","","",6,null],[3,"cbw_ApplicationSettings","","",null,null],[12,"resource_dir","","",7,null],[3,"cbw_BrowserWindowImpl","","",null,null],[12,"cef_ptr","","",8,null],[12,"resource_path","","",8,null],[3,"cdiv_t","","",null,null],[12,"quot","","",9,null],[12,"rem","","",9,null],[3,"cldiv_t","","",null,null],[12,"quot","","",10,null],[12,"rem","","",10,null],[3,"clldiv_t","","",null,null],[12,"quot","","",11,null],[12,"rem","","",11,null],[3,"c__fsid_t","","",null,null],[12,"__val","","",12,null],[3,"c__sigset_t","","",null,null],[12,"__val","","",13,null],[3,"ctimeval","","",null,null],[12,"tv_sec","","",14,null],[12,"tv_usec","","",14,null],[3,"ctimespec","","",null,null],[12,"tv_sec","","",15,null],[12,"tv_nsec","","",15,null],[3,"cfd_set","","",null,null],[12,"__fds_bits","","",16,null],[3,"c__pthread_internal_list","","",null,null],[12,"__prev","","",17,null],[12,"__next","","",17,null],[3,"c__pthread_internal_slist","","",null,null],[12,"__next","","",18,null],[3,"c__pthread_mutex_s","","",null,null],[12,"__lock","","",19,null],[12,"__count","","",19,null],[12,"__owner","","",19,null],[12,"__nusers","","",19,null],[12,"__kind","","",19,null],[12,"__spins","","",19,null],[12,"__elision","","",19,null],[12,"__list","","",19,null],[3,"c__pthread_rwlock_arch_t","","",null,null],[12,"__readers","","",20,null],[12,"__writers","","",20,null],[12,"__wrphase_futex","","",20,null],[12,"__writers_futex","","",20,null],[12,"__pad3","","",20,null],[12,"__pad4","","",20,null],[12,"__cur_writer","","",20,null],[12,"__shared","","",20,null],[12,"__rwelision","","",20,null],[12,"__pad1","","",20,null],[12,"__pad2","","",20,null],[12,"__flags","","",20,null],[3,"c__pthread_cond_s","","",null,null],[12,"__bindgen_anon_1","","",21,null],[12,"__bindgen_anon_2","","",21,null],[12,"__g_refs","","",21,null],[12,"__g_size","","",21,null],[12,"__g1_orig_size","","",21,null],[12,"__wrefs","","",21,null],[12,"__g_signals","","",21,null],[19,"c__pthread_cond_s__bindgen_ty_1","","",null,null],[12,"__wseq","","",22,null],[12,"__wseq32","","",22,null],[3,"c__pthread_cond_s__bindgen_ty_1__bindgen_ty_1","","",null,null],[12,"__low","","",23,null],[12,"__high","","",23,null],[19,"c__pthread_cond_s__bindgen_ty_2","","",null,null],[12,"__g1_start","","",24,null],[12,"__g1_start32","","",24,null],[3,"c__pthread_cond_s__bindgen_ty_2__bindgen_ty_1","","",null,null],[12,"__low","","",25,null],[12,"__high","","",25,null],[19,"cpthread_mutexattr_t","","",null,null],[12,"__size","","",26,null],[12,"__align","","",26,null],[19,"cpthread_condattr_t","","",null,null],[12,"__size","","",27,null],[12,"__align","","",27,null],[19,"cpthread_attr_t","","",null,null],[12,"__size","","",28,null],[12,"__align","","",28,null],[19,"cpthread_mutex_t","","",null,null],[12,"__data","","",29,null],[12,"__size","","",29,null],[12,"__align","","",29,null],[19,"cpthread_cond_t","","",null,null],[12,"__data","","",30,null],[12,"__size","","",30,null],[12,"__align","","",30,null],[19,"cpthread_rwlock_t","","",null,null],[12,"__data","","",31,null],[12,"__size","","",31,null],[12,"__align","","",31,null],[19,"cpthread_rwlockattr_t","","",null,null],[12,"__size","","",32,null],[12,"__align","","",32,null],[19,"cpthread_barrier_t","","",null,null],[12,"__size","","",33,null],[12,"__align","","",33,null],[19,"cpthread_barrierattr_t","","",null,null],[12,"__size","","",34,null],[12,"__align","","",34,null],[3,"crandom_data","","",null,null],[12,"fptr","","",35,null],[12,"rptr","","",35,null],[12,"state","","",35,null],[12,"rand_type","","",35,null],[12,"rand_deg","","",35,null],[12,"rand_sep","","",35,null],[12,"end_ptr","","",35,null],[3,"cdrand48_data","","",null,null],[12,"__x","","",36,null],[12,"__old_x","","",36,null],[12,"__c","","",36,null],[12,"__init","","",36,null],[12,"__a","","",36,null],[3,"c__locale_struct","","",null,null],[12,"__locales","","",37,null],[12,"__ctype_b","","",37,null],[12,"__ctype_tolower","","",37,null],[12,"__ctype_toupper","","",37,null],[12,"__names","","",37,null],[3,"cbw_Err","","",null,null],[12,"code","","",38,null],[12,"data","","",38,null],[12,"alloc_message","","",38,null],[3,"c__mbstate_t","","",null,null],[12,"__count","","",39,null],[12,"__value","","",39,null],[19,"c__mbstate_t__bindgen_ty_1","","",null,null],[12,"__wch","","",40,null],[12,"__wchb","","",40,null],[3,"c_G_fpos_t","","",null,null],[12,"__pos","","",41,null],[12,"__state","","",41,null],[3,"c_G_fpos64_t","","",null,null],[12,"__pos","","",42,null],[12,"__state","","",42,null],[3,"c_IO_marker","","",null,null],[3,"c_IO_codecvt","","",null,null],[3,"c_IO_wide_data","","",null,null],[3,"c_IO_FILE","","",null,null],[12,"_flags","","",43,null],[12,"_IO_read_ptr","","",43,null],[12,"_IO_read_end","","",43,null],[12,"_IO_read_base","","",43,null],[12,"_IO_write_base","","",43,null],[12,"_IO_write_ptr","","",43,null],[12,"_IO_write_end","","",43,null],[12,"_IO_buf_base","","",43,null],[12,"_IO_buf_end","","",43,null],[12,"_IO_save_base","","",43,null],[12,"_IO_backup_base","","",43,null],[12,"_IO_save_end","","",43,null],[12,"_markers","","",43,null],[12,"_chain","","",43,null],[12,"_fileno","","",43,null],[12,"_flags2","","",43,null],[12,"_old_offset","","",43,null],[12,"_cur_column","","",43,null],[12,"_vtable_offset","","",43,null],[12,"_shortbuf","","",43,null],[12,"_lock","","",43,null],[12,"_offset","","",43,null],[12,"_codecvt","","",43,null],[12,"_wide_data","","",43,null],[12,"_freeres_list","","",43,null],[12,"_freeres_buf","","",43,null],[12,"__pad5","","",43,null],[12,"_mode","","",43,null],[12,"_unused2","","",43,null],[3,"cbw_Dims2D","","",null,null],[12,"width","","",44,null],[12,"height","","",44,null],[3,"cbw_Pos2D","","",null,null],[12,"x","","",45,null],[12,"y","","",45,null],[3,"cbw_WindowImpl","","",null,null],[3,"cbw_WindowCallbacks","","",null,null],[12,"do_cleanup","","Fired just before the window gets destroyed and freed from…",46,null],[12,"on_close","","Fired when the window has been closed, either by the user…",46,null],[12,"on_loaded","","Fired when a window has finished loading",46,null],[12,"on_resize","","Fired when a window is resizing",46,null],[3,"cbw_WindowOptions","","",null,null],[12,"borders","","",47,null],[12,"minimizable","","",47,null],[12,"resizable","","",47,null],[3,"cbw_WindowDispatchData","","",null,null],[3,"cbw_Window","","",null,null],[12,"app","","",48,null],[12,"parent","","",48,null],[12,"closed","","",48,null],[12,"dropped","","",48,null],[12,"callbacks","","",48,null],[12,"user_data","","",48,null],[12,"impl_","","",48,null],[3,"cbw_BrowserWindowOptions","","",null,null],[12,"dev_tools","","",49,null],[12,"resource_path","","",49,null],[3,"cbw_BrowserWindowSource","","",null,null],[12,"data","","",50,null],[12,"is_html","","",50,null],[3,"cbw_BrowserWindow","","",null,null],[12,"window","","",51,null],[12,"external_handler","","",51,null],[12,"user_data","","",51,null],[12,"impl_","","",51,null],[3,"c__locale_data","","",null,null],[12,"_address","","",52,null],[3,"c__va_list_tag","","",null,null],[12,"gp_offset","","",53,null],[12,"fp_offset","","",53,null],[12,"overflow_arg_area","","",53,null],[12,"reg_save_area","","",53,null],[6,"Dims2D","","",null,null],[6,"Pos2D","","",null,null],[0,"window","browser_window_core","",null,null],[0,"c","browser_window_core::window","This module implements the `Window` trait with the…",null,null],[3,"WindowImpl","browser_window_core::window::c","",null,null],[11,"new","","",54,[[["windowoptions",6],["applicationimpl",3],["option",4]]]],[6,"WindowOptions","browser_window_core::window","",null,null],[8,"WindowExt","","",null,null],[10,"app","","",55,[[],["applicationimpl",3]]],[10,"destroy","","",55,[[]]],[10,"drop","","",55,[[]]],[10,"get_content_dimensions","","",55,[[],["dims2d",6]]],[10,"get_opacity","","",55,[[]]],[10,"get_position","","",55,[[],["pos2d",6]]],[10,"get_title","","",55,[[],["string",3]]],[10,"get_window_dimensions","","",55,[[],["dims2d",6]]],[10,"hide","","",55,[[]]],[10,"set_content_dimensions","","",55,[[["dims2d",6]]]],[10,"set_opacity","","",55,[[]]],[10,"set_position","","",55,[[["pos2d",6]]]],[10,"set_title","","",55,[[]]],[10,"set_window_dimensions","","",55,[[["dims2d",6]]]],[10,"show","","",55,[[]]],[11,"from","browser_window_core::application","",56,[[]]],[11,"into","","",56,[[]]],[11,"borrow","","",56,[[]]],[11,"borrow_mut","","",56,[[]]],[11,"try_from","","",56,[[],["result",4]]],[11,"try_into","","",56,[[],["result",4]]],[11,"type_id","","",56,[[],["typeid",3]]],[11,"from","browser_window_core::application::c","",57,[[]]],[11,"into","","",57,[[]]],[11,"to_owned","","",57,[[]]],[11,"clone_into","","",57,[[]]],[11,"borrow","","",57,[[]]],[11,"borrow_mut","","",57,[[]]],[11,"try_from","","",57,[[],["result",4]]],[11,"try_into","","",57,[[],["result",4]]],[11,"type_id","","",57,[[],["typeid",3]]],[11,"from","browser_window_core::browser_window::c","",58,[[]]],[11,"into","","",58,[[]]],[11,"to_owned","","",58,[[]]],[11,"clone_into","","",58,[[]]],[11,"borrow","","",58,[[]]],[11,"borrow_mut","","",58,[[]]],[11,"try_from","","",58,[[],["result",4]]],[11,"try_into","","",58,[[],["result",4]]],[11,"type_id","","",58,[[],["typeid",3]]],[11,"from","","",59,[[]]],[11,"into","","",59,[[]]],[11,"to_string","","",59,[[],["string",3]]],[11,"borrow","","",59,[[]]],[11,"borrow_mut","","",59,[[]]],[11,"try_from","","",59,[[],["result",4]]],[11,"try_into","","",59,[[],["result",4]]],[11,"type_id","","",59,[[],["typeid",3]]],[11,"from","browser_window_core::prelude","",2,[[]]],[11,"into","","",2,[[]]],[11,"to_owned","","",2,[[]]],[11,"clone_into","","",2,[[]]],[11,"borrow","","",2,[[]]],[11,"borrow_mut","","",2,[[]]],[11,"try_from","","",2,[[],["result",4]]],[11,"try_into","","",2,[[],["result",4]]],[11,"type_id","","",2,[[],["typeid",3]]],[11,"from","","",3,[[]]],[11,"into","","",3,[[]]],[11,"to_owned","","",3,[[]]],[11,"clone_into","","",3,[[]]],[11,"borrow","","",3,[[]]],[11,"borrow_mut","","",3,[[]]],[11,"try_from","","",3,[[],["result",4]]],[11,"try_into","","",3,[[],["result",4]]],[11,"type_id","","",3,[[],["typeid",3]]],[11,"from","","",4,[[]]],[11,"into","","",4,[[]]],[11,"to_owned","","",4,[[]]],[11,"clone_into","","",4,[[]]],[11,"borrow","","",4,[[]]],[11,"borrow_mut","","",4,[[]]],[11,"try_from","","",4,[[],["result",4]]],[11,"try_into","","",4,[[],["result",4]]],[11,"type_id","","",4,[[],["typeid",3]]],[11,"from","","",60,[[]]],[11,"into","","",60,[[]]],[11,"to_owned","","",60,[[]]],[11,"clone_into","","",60,[[]]],[11,"borrow","","",60,[[]]],[11,"borrow_mut","","",60,[[]]],[11,"try_from","","",60,[[],["result",4]]],[11,"try_into","","",60,[[],["result",4]]],[11,"type_id","","",60,[[],["typeid",3]]],[11,"from","","",61,[[]]],[11,"into","","",61,[[]]],[11,"to_owned","","",61,[[]]],[11,"clone_into","","",61,[[]]],[11,"borrow","","",61,[[]]],[11,"borrow_mut","","",61,[[]]],[11,"try_from","","",61,[[],["result",4]]],[11,"try_into","","",61,[[],["result",4]]],[11,"type_id","","",61,[[],["typeid",3]]],[11,"from","","",5,[[]]],[11,"into","","",5,[[]]],[11,"to_owned","","",5,[[]]],[11,"clone_into","","",5,[[]]],[11,"borrow","","",5,[[]]],[11,"borrow_mut","","",5,[[]]],[11,"try_from","","",5,[[],["result",4]]],[11,"try_into","","",5,[[],["result",4]]],[11,"type_id","","",5,[[],["typeid",3]]],[11,"from","","",62,[[]]],[11,"into","","",62,[[]]],[11,"to_owned","","",62,[[]]],[11,"clone_into","","",62,[[]]],[11,"borrow","","",62,[[]]],[11,"borrow_mut","","",62,[[]]],[11,"try_from","","",62,[[],["result",4]]],[11,"try_into","","",62,[[],["result",4]]],[11,"type_id","","",62,[[],["typeid",3]]],[11,"from","","",6,[[]]],[11,"into","","",6,[[]]],[11,"to_owned","","",6,[[]]],[11,"clone_into","","",6,[[]]],[11,"borrow","","",6,[[]]],[11,"borrow_mut","","",6,[[]]],[11,"try_from","","",6,[[],["result",4]]],[11,"try_into","","",6,[[],["result",4]]],[11,"type_id","","",6,[[],["typeid",3]]],[11,"from","","",7,[[]]],[11,"into","","",7,[[]]],[11,"to_owned","","",7,[[]]],[11,"clone_into","","",7,[[]]],[11,"borrow","","",7,[[]]],[11,"borrow_mut","","",7,[[]]],[11,"try_from","","",7,[[],["result",4]]],[11,"try_into","","",7,[[],["result",4]]],[11,"type_id","","",7,[[],["typeid",3]]],[11,"from","","",8,[[]]],[11,"into","","",8,[[]]],[11,"to_owned","","",8,[[]]],[11,"clone_into","","",8,[[]]],[11,"borrow","","",8,[[]]],[11,"borrow_mut","","",8,[[]]],[11,"try_from","","",8,[[],["result",4]]],[11,"try_into","","",8,[[],["result",4]]],[11,"type_id","","",8,[[],["typeid",3]]],[11,"from","","",9,[[]]],[11,"into","","",9,[[]]],[11,"to_owned","","",9,[[]]],[11,"clone_into","","",9,[[]]],[11,"borrow","","",9,[[]]],[11,"borrow_mut","","",9,[[]]],[11,"try_from","","",9,[[],["result",4]]],[11,"try_into","","",9,[[],["result",4]]],[11,"type_id","","",9,[[],["typeid",3]]],[11,"from","","",10,[[]]],[11,"into","","",10,[[]]],[11,"to_owned","","",10,[[]]],[11,"clone_into","","",10,[[]]],[11,"borrow","","",10,[[]]],[11,"borrow_mut","","",10,[[]]],[11,"try_from","","",10,[[],["result",4]]],[11,"try_into","","",10,[[],["result",4]]],[11,"type_id","","",10,[[],["typeid",3]]],[11,"from","","",11,[[]]],[11,"into","","",11,[[]]],[11,"to_owned","","",11,[[]]],[11,"clone_into","","",11,[[]]],[11,"borrow","","",11,[[]]],[11,"borrow_mut","","",11,[[]]],[11,"try_from","","",11,[[],["result",4]]],[11,"try_into","","",11,[[],["result",4]]],[11,"type_id","","",11,[[],["typeid",3]]],[11,"from","","",12,[[]]],[11,"into","","",12,[[]]],[11,"to_owned","","",12,[[]]],[11,"clone_into","","",12,[[]]],[11,"borrow","","",12,[[]]],[11,"borrow_mut","","",12,[[]]],[11,"try_from","","",12,[[],["result",4]]],[11,"try_into","","",12,[[],["result",4]]],[11,"type_id","","",12,[[],["typeid",3]]],[11,"from","","",13,[[]]],[11,"into","","",13,[[]]],[11,"to_owned","","",13,[[]]],[11,"clone_into","","",13,[[]]],[11,"borrow","","",13,[[]]],[11,"borrow_mut","","",13,[[]]],[11,"try_from","","",13,[[],["result",4]]],[11,"try_into","","",13,[[],["result",4]]],[11,"type_id","","",13,[[],["typeid",3]]],[11,"from","","",14,[[]]],[11,"into","","",14,[[]]],[11,"to_owned","","",14,[[]]],[11,"clone_into","","",14,[[]]],[11,"borrow","","",14,[[]]],[11,"borrow_mut","","",14,[[]]],[11,"try_from","","",14,[[],["result",4]]],[11,"try_into","","",14,[[],["result",4]]],[11,"type_id","","",14,[[],["typeid",3]]],[11,"from","","",15,[[]]],[11,"into","","",15,[[]]],[11,"to_owned","","",15,[[]]],[11,"clone_into","","",15,[[]]],[11,"borrow","","",15,[[]]],[11,"borrow_mut","","",15,[[]]],[11,"try_from","","",15,[[],["result",4]]],[11,"try_into","","",15,[[],["result",4]]],[11,"type_id","","",15,[[],["typeid",3]]],[11,"from","","",16,[[]]],[11,"into","","",16,[[]]],[11,"to_owned","","",16,[[]]],[11,"clone_into","","",16,[[]]],[11,"borrow","","",16,[[]]],[11,"borrow_mut","","",16,[[]]],[11,"try_from","","",16,[[],["result",4]]],[11,"try_into","","",16,[[],["result",4]]],[11,"type_id","","",16,[[],["typeid",3]]],[11,"from","","",17,[[]]],[11,"into","","",17,[[]]],[11,"to_owned","","",17,[[]]],[11,"clone_into","","",17,[[]]],[11,"borrow","","",17,[[]]],[11,"borrow_mut","","",17,[[]]],[11,"try_from","","",17,[[],["result",4]]],[11,"try_into","","",17,[[],["result",4]]],[11,"type_id","","",17,[[],["typeid",3]]],[11,"from","","",18,[[]]],[11,"into","","",18,[[]]],[11,"to_owned","","",18,[[]]],[11,"clone_into","","",18,[[]]],[11,"borrow","","",18,[[]]],[11,"borrow_mut","","",18,[[]]],[11,"try_from","","",18,[[],["result",4]]],[11,"try_into","","",18,[[],["result",4]]],[11,"type_id","","",18,[[],["typeid",3]]],[11,"from","","",19,[[]]],[11,"into","","",19,[[]]],[11,"to_owned","","",19,[[]]],[11,"clone_into","","",19,[[]]],[11,"borrow","","",19,[[]]],[11,"borrow_mut","","",19,[[]]],[11,"try_from","","",19,[[],["result",4]]],[11,"try_into","","",19,[[],["result",4]]],[11,"type_id","","",19,[[],["typeid",3]]],[11,"from","","",20,[[]]],[11,"into","","",20,[[]]],[11,"to_owned","","",20,[[]]],[11,"clone_into","","",20,[[]]],[11,"borrow","","",20,[[]]],[11,"borrow_mut","","",20,[[]]],[11,"try_from","","",20,[[],["result",4]]],[11,"try_into","","",20,[[],["result",4]]],[11,"type_id","","",20,[[],["typeid",3]]],[11,"from","","",21,[[]]],[11,"into","","",21,[[]]],[11,"to_owned","","",21,[[]]],[11,"clone_into","","",21,[[]]],[11,"borrow","","",21,[[]]],[11,"borrow_mut","","",21,[[]]],[11,"try_from","","",21,[[],["result",4]]],[11,"try_into","","",21,[[],["result",4]]],[11,"type_id","","",21,[[],["typeid",3]]],[11,"from","","",22,[[]]],[11,"into","","",22,[[]]],[11,"to_owned","","",22,[[]]],[11,"clone_into","","",22,[[]]],[11,"borrow","","",22,[[]]],[11,"borrow_mut","","",22,[[]]],[11,"try_from","","",22,[[],["result",4]]],[11,"try_into","","",22,[[],["result",4]]],[11,"type_id","","",22,[[],["typeid",3]]],[11,"from","","",23,[[]]],[11,"into","","",23,[[]]],[11,"to_owned","","",23,[[]]],[11,"clone_into","","",23,[[]]],[11,"borrow","","",23,[[]]],[11,"borrow_mut","","",23,[[]]],[11,"try_from","","",23,[[],["result",4]]],[11,"try_into","","",23,[[],["result",4]]],[11,"type_id","","",23,[[],["typeid",3]]],[11,"from","","",24,[[]]],[11,"into","","",24,[[]]],[11,"to_owned","","",24,[[]]],[11,"clone_into","","",24,[[]]],[11,"borrow","","",24,[[]]],[11,"borrow_mut","","",24,[[]]],[11,"try_from","","",24,[[],["result",4]]],[11,"try_into","","",24,[[],["result",4]]],[11,"type_id","","",24,[[],["typeid",3]]],[11,"from","","",25,[[]]],[11,"into","","",25,[[]]],[11,"to_owned","","",25,[[]]],[11,"clone_into","","",25,[[]]],[11,"borrow","","",25,[[]]],[11,"borrow_mut","","",25,[[]]],[11,"try_from","","",25,[[],["result",4]]],[11,"try_into","","",25,[[],["result",4]]],[11,"type_id","","",25,[[],["typeid",3]]],[11,"from","","",26,[[]]],[11,"into","","",26,[[]]],[11,"to_owned","","",26,[[]]],[11,"clone_into","","",26,[[]]],[11,"borrow","","",26,[[]]],[11,"borrow_mut","","",26,[[]]],[11,"try_from","","",26,[[],["result",4]]],[11,"try_into","","",26,[[],["result",4]]],[11,"type_id","","",26,[[],["typeid",3]]],[11,"from","","",27,[[]]],[11,"into","","",27,[[]]],[11,"to_owned","","",27,[[]]],[11,"clone_into","","",27,[[]]],[11,"borrow","","",27,[[]]],[11,"borrow_mut","","",27,[[]]],[11,"try_from","","",27,[[],["result",4]]],[11,"try_into","","",27,[[],["result",4]]],[11,"type_id","","",27,[[],["typeid",3]]],[11,"from","","",28,[[]]],[11,"into","","",28,[[]]],[11,"to_owned","","",28,[[]]],[11,"clone_into","","",28,[[]]],[11,"borrow","","",28,[[]]],[11,"borrow_mut","","",28,[[]]],[11,"try_from","","",28,[[],["result",4]]],[11,"try_into","","",28,[[],["result",4]]],[11,"type_id","","",28,[[],["typeid",3]]],[11,"from","","",29,[[]]],[11,"into","","",29,[[]]],[11,"to_owned","","",29,[[]]],[11,"clone_into","","",29,[[]]],[11,"borrow","","",29,[[]]],[11,"borrow_mut","","",29,[[]]],[11,"try_from","","",29,[[],["result",4]]],[11,"try_into","","",29,[[],["result",4]]],[11,"type_id","","",29,[[],["typeid",3]]],[11,"from","","",30,[[]]],[11,"into","","",30,[[]]],[11,"to_owned","","",30,[[]]],[11,"clone_into","","",30,[[]]],[11,"borrow","","",30,[[]]],[11,"borrow_mut","","",30,[[]]],[11,"try_from","","",30,[[],["result",4]]],[11,"try_into","","",30,[[],["result",4]]],[11,"type_id","","",30,[[],["typeid",3]]],[11,"from","","",31,[[]]],[11,"into","","",31,[[]]],[11,"to_owned","","",31,[[]]],[11,"clone_into","","",31,[[]]],[11,"borrow","","",31,[[]]],[11,"borrow_mut","","",31,[[]]],[11,"try_from","","",31,[[],["result",4]]],[11,"try_into","","",31,[[],["result",4]]],[11,"type_id","","",31,[[],["typeid",3]]],[11,"from","","",32,[[]]],[11,"into","","",32,[[]]],[11,"to_owned","","",32,[[]]],[11,"clone_into","","",32,[[]]],[11,"borrow","","",32,[[]]],[11,"borrow_mut","","",32,[[]]],[11,"try_from","","",32,[[],["result",4]]],[11,"try_into","","",32,[[],["result",4]]],[11,"type_id","","",32,[[],["typeid",3]]],[11,"from","","",33,[[]]],[11,"into","","",33,[[]]],[11,"to_owned","","",33,[[]]],[11,"clone_into","","",33,[[]]],[11,"borrow","","",33,[[]]],[11,"borrow_mut","","",33,[[]]],[11,"try_from","","",33,[[],["result",4]]],[11,"try_into","","",33,[[],["result",4]]],[11,"type_id","","",33,[[],["typeid",3]]],[11,"from","","",34,[[]]],[11,"into","","",34,[[]]],[11,"to_owned","","",34,[[]]],[11,"clone_into","","",34,[[]]],[11,"borrow","","",34,[[]]],[11,"borrow_mut","","",34,[[]]],[11,"try_from","","",34,[[],["result",4]]],[11,"try_into","","",34,[[],["result",4]]],[11,"type_id","","",34,[[],["typeid",3]]],[11,"from","","",35,[[]]],[11,"into","","",35,[[]]],[11,"to_owned","","",35,[[]]],[11,"clone_into","","",35,[[]]],[11,"borrow","","",35,[[]]],[11,"borrow_mut","","",35,[[]]],[11,"try_from","","",35,[[],["result",4]]],[11,"try_into","","",35,[[],["result",4]]],[11,"type_id","","",35,[[],["typeid",3]]],[11,"from","","",36,[[]]],[11,"into","","",36,[[]]],[11,"to_owned","","",36,[[]]],[11,"clone_into","","",36,[[]]],[11,"borrow","","",36,[[]]],[11,"borrow_mut","","",36,[[]]],[11,"try_from","","",36,[[],["result",4]]],[11,"try_into","","",36,[[],["result",4]]],[11,"type_id","","",36,[[],["typeid",3]]],[11,"from","","",37,[[]]],[11,"into","","",37,[[]]],[11,"to_owned","","",37,[[]]],[11,"clone_into","","",37,[[]]],[11,"borrow","","",37,[[]]],[11,"borrow_mut","","",37,[[]]],[11,"try_from","","",37,[[],["result",4]]],[11,"try_into","","",37,[[],["result",4]]],[11,"type_id","","",37,[[],["typeid",3]]],[11,"from","","",38,[[]]],[11,"into","","",38,[[]]],[11,"to_owned","","",38,[[]]],[11,"clone_into","","",38,[[]]],[11,"to_string","","",38,[[],["string",3]]],[11,"borrow","","",38,[[]]],[11,"borrow_mut","","",38,[[]]],[11,"try_from","","",38,[[],["result",4]]],[11,"try_into","","",38,[[],["result",4]]],[11,"type_id","","",38,[[],["typeid",3]]],[11,"from","","",39,[[]]],[11,"into","","",39,[[]]],[11,"to_owned","","",39,[[]]],[11,"clone_into","","",39,[[]]],[11,"borrow","","",39,[[]]],[11,"borrow_mut","","",39,[[]]],[11,"try_from","","",39,[[],["result",4]]],[11,"try_into","","",39,[[],["result",4]]],[11,"type_id","","",39,[[],["typeid",3]]],[11,"from","","",40,[[]]],[11,"into","","",40,[[]]],[11,"to_owned","","",40,[[]]],[11,"clone_into","","",40,[[]]],[11,"borrow","","",40,[[]]],[11,"borrow_mut","","",40,[[]]],[11,"try_from","","",40,[[],["result",4]]],[11,"try_into","","",40,[[],["result",4]]],[11,"type_id","","",40,[[],["typeid",3]]],[11,"from","","",41,[[]]],[11,"into","","",41,[[]]],[11,"to_owned","","",41,[[]]],[11,"clone_into","","",41,[[]]],[11,"borrow","","",41,[[]]],[11,"borrow_mut","","",41,[[]]],[11,"try_from","","",41,[[],["result",4]]],[11,"try_into","","",41,[[],["result",4]]],[11,"type_id","","",41,[[],["typeid",3]]],[11,"from","","",42,[[]]],[11,"into","","",42,[[]]],[11,"to_owned","","",42,[[]]],[11,"clone_into","","",42,[[]]],[11,"borrow","","",42,[[]]],[11,"borrow_mut","","",42,[[]]],[11,"try_from","","",42,[[],["result",4]]],[11,"try_into","","",42,[[],["result",4]]],[11,"type_id","","",42,[[],["typeid",3]]],[11,"from","","",63,[[]]],[11,"into","","",63,[[]]],[11,"to_owned","","",63,[[]]],[11,"clone_into","","",63,[[]]],[11,"borrow","","",63,[[]]],[11,"borrow_mut","","",63,[[]]],[11,"try_from","","",63,[[],["result",4]]],[11,"try_into","","",63,[[],["result",4]]],[11,"type_id","","",63,[[],["typeid",3]]],[11,"from","","",64,[[]]],[11,"into","","",64,[[]]],[11,"to_owned","","",64,[[]]],[11,"clone_into","","",64,[[]]],[11,"borrow","","",64,[[]]],[11,"borrow_mut","","",64,[[]]],[11,"try_from","","",64,[[],["result",4]]],[11,"try_into","","",64,[[],["result",4]]],[11,"type_id","","",64,[[],["typeid",3]]],[11,"from","","",65,[[]]],[11,"into","","",65,[[]]],[11,"to_owned","","",65,[[]]],[11,"clone_into","","",65,[[]]],[11,"borrow","","",65,[[]]],[11,"borrow_mut","","",65,[[]]],[11,"try_from","","",65,[[],["result",4]]],[11,"try_into","","",65,[[],["result",4]]],[11,"type_id","","",65,[[],["typeid",3]]],[11,"from","","",43,[[]]],[11,"into","","",43,[[]]],[11,"to_owned","","",43,[[]]],[11,"clone_into","","",43,[[]]],[11,"borrow","","",43,[[]]],[11,"borrow_mut","","",43,[[]]],[11,"try_from","","",43,[[],["result",4]]],[11,"try_into","","",43,[[],["result",4]]],[11,"type_id","","",43,[[],["typeid",3]]],[11,"from","","",44,[[]]],[11,"into","","",44,[[]]],[11,"to_owned","","",44,[[]]],[11,"clone_into","","",44,[[]]],[11,"borrow","","",44,[[]]],[11,"borrow_mut","","",44,[[]]],[11,"try_from","","",44,[[],["result",4]]],[11,"try_into","","",44,[[],["result",4]]],[11,"type_id","","",44,[[],["typeid",3]]],[11,"from","","",45,[[]]],[11,"into","","",45,[[]]],[11,"to_owned","","",45,[[]]],[11,"clone_into","","",45,[[]]],[11,"borrow","","",45,[[]]],[11,"borrow_mut","","",45,[[]]],[11,"try_from","","",45,[[],["result",4]]],[11,"try_into","","",45,[[],["result",4]]],[11,"type_id","","",45,[[],["typeid",3]]],[11,"from","","",66,[[]]],[11,"into","","",66,[[]]],[11,"to_owned","","",66,[[]]],[11,"clone_into","","",66,[[]]],[11,"borrow","","",66,[[]]],[11,"borrow_mut","","",66,[[]]],[11,"try_from","","",66,[[],["result",4]]],[11,"try_into","","",66,[[],["result",4]]],[11,"type_id","","",66,[[],["typeid",3]]],[11,"from","","",46,[[]]],[11,"into","","",46,[[]]],[11,"to_owned","","",46,[[]]],[11,"clone_into","","",46,[[]]],[11,"borrow","","",46,[[]]],[11,"borrow_mut","","",46,[[]]],[11,"try_from","","",46,[[],["result",4]]],[11,"try_into","","",46,[[],["result",4]]],[11,"type_id","","",46,[[],["typeid",3]]],[11,"from","","",47,[[]]],[11,"into","","",47,[[]]],[11,"to_owned","","",47,[[]]],[11,"clone_into","","",47,[[]]],[11,"borrow","","",47,[[]]],[11,"borrow_mut","","",47,[[]]],[11,"try_from","","",47,[[],["result",4]]],[11,"try_into","","",47,[[],["result",4]]],[11,"type_id","","",47,[[],["typeid",3]]],[11,"from","","",67,[[]]],[11,"into","","",67,[[]]],[11,"to_owned","","",67,[[]]],[11,"clone_into","","",67,[[]]],[11,"borrow","","",67,[[]]],[11,"borrow_mut","","",67,[[]]],[11,"try_from","","",67,[[],["result",4]]],[11,"try_into","","",67,[[],["result",4]]],[11,"type_id","","",67,[[],["typeid",3]]],[11,"from","","",48,[[]]],[11,"into","","",48,[[]]],[11,"to_owned","","",48,[[]]],[11,"clone_into","","",48,[[]]],[11,"borrow","","",48,[[]]],[11,"borrow_mut","","",48,[[]]],[11,"try_from","","",48,[[],["result",4]]],[11,"try_into","","",48,[[],["result",4]]],[11,"type_id","","",48,[[],["typeid",3]]],[11,"from","","",49,[[]]],[11,"into","","",49,[[]]],[11,"to_owned","","",49,[[]]],[11,"clone_into","","",49,[[]]],[11,"borrow","","",49,[[]]],[11,"borrow_mut","","",49,[[]]],[11,"try_from","","",49,[[],["result",4]]],[11,"try_into","","",49,[[],["result",4]]],[11,"type_id","","",49,[[],["typeid",3]]],[11,"from","","",50,[[]]],[11,"into","","",50,[[]]],[11,"to_owned","","",50,[[]]],[11,"clone_into","","",50,[[]]],[11,"borrow","","",50,[[]]],[11,"borrow_mut","","",50,[[]]],[11,"try_from","","",50,[[],["result",4]]],[11,"try_into","","",50,[[],["result",4]]],[11,"type_id","","",50,[[],["typeid",3]]],[11,"from","","",51,[[]]],[11,"into","","",51,[[]]],[11,"to_owned","","",51,[[]]],[11,"clone_into","","",51,[[]]],[11,"borrow","","",51,[[]]],[11,"borrow_mut","","",51,[[]]],[11,"try_from","","",51,[[],["result",4]]],[11,"try_into","","",51,[[],["result",4]]],[11,"type_id","","",51,[[],["typeid",3]]],[11,"from","","",52,[[]]],[11,"into","","",52,[[]]],[11,"to_owned","","",52,[[]]],[11,"clone_into","","",52,[[]]],[11,"borrow","","",52,[[]]],[11,"borrow_mut","","",52,[[]]],[11,"try_from","","",52,[[],["result",4]]],[11,"try_into","","",52,[[],["result",4]]],[11,"type_id","","",52,[[],["typeid",3]]],[11,"from","","",53,[[]]],[11,"into","","",53,[[]]],[11,"to_owned","","",53,[[]]],[11,"clone_into","","",53,[[]]],[11,"borrow","","",53,[[]]],[11,"borrow_mut","","",53,[[]]],[11,"try_from","","",53,[[],["result",4]]],[11,"try_into","","",53,[[],["result",4]]],[11,"type_id","","",53,[[],["typeid",3]]],[11,"from","browser_window_core::window::c","",54,[[]]],[11,"into","","",54,[[]]],[11,"to_owned","","",54,[[]]],[11,"clone_into","","",54,[[]]],[11,"borrow","","",54,[[]]],[11,"borrow_mut","","",54,[[]]],[11,"try_from","","",54,[[],["result",4]]],[11,"try_into","","",54,[[],["result",4]]],[11,"type_id","","",54,[[],["typeid",3]]],[11,"clone","browser_window_core::prelude","",15,[[],["ctimespec",3]]],[11,"clone","","",62,[[],["cbw_applicationenginedata",3]]],[11,"clone","","",36,[[],["cdrand48_data",3]]],[11,"clone","","",5,[[],["cbw_application",3]]],[11,"clone","","",63,[[],["c_io_marker",3]]],[11,"clone","","",52,[[],["c__locale_data",3]]],[11,"clone","","",43,[[],["c_io_file",3]]],[11,"clone","","",45,[[],["cbw_pos2d",3]]],[11,"clone","","",4,[[],["cbw_cstrslice",3]]],[11,"clone","","",40,[[],["c__mbstate_t__bindgen_ty_1",19]]],[11,"clone","","",12,[[],["c__fsid_t",3]]],[11,"clone","","",17,[[],["c__pthread_internal_list",3]]],[11,"clone","","",3,[[],["cbw_strslice",3]]],[11,"clone","","",38,[[],["cbw_err",3]]],[11,"clone","","",23,[[],["c__pthread_cond_s__bindgen_ty_1__bindgen_ty_1",3]]],[11,"clone","","",19,[[],["c__pthread_mutex_s",3]]],[11,"clone","","",64,[[],["c_io_codecvt",3]]],[11,"clone","","",46,[[],["cbw_windowcallbacks",3]]],[11,"clone","","",39,[[],["c__mbstate_t",3]]],[11,"clone","","",21,[[],["c__pthread_cond_s",3]]],[11,"clone","","",18,[[],["c__pthread_internal_slist",3]]],[11,"clone","","",11,[[],["clldiv_t",3]]],[11,"clone","","",26,[[],["cpthread_mutexattr_t",19]]],[11,"clone","","",28,[[],["cpthread_attr_t",19]]],[11,"clone","","",51,[[],["cbw_browserwindow",3]]],[11,"clone","","",42,[[],["c_g_fpos64_t",3]]],[11,"clone","","",2,[[],["cmax_align_t",3]]],[11,"clone","","",6,[[],["cbw_applicationdispatchdata",3]]],[11,"clone","","",25,[[],["c__pthread_cond_s__bindgen_ty_2__bindgen_ty_1",3]]],[11,"clone","","",67,[[],["cbw_windowdispatchdata",3]]],[11,"clone","","",30,[[],["cpthread_cond_t",19]]],[11,"clone","","",31,[[],["cpthread_rwlock_t",19]]],[11,"clone","","",22,[[],["c__pthread_cond_s__bindgen_ty_1",19]]],[11,"clone","","",16,[[],["cfd_set",3]]],[11,"clone","","",41,[[],["c_g_fpos_t",3]]],[11,"clone","","",60,[[],["cbw_applicationimpl",3]]],[11,"clone","","",44,[[],["cbw_dims2d",3]]],[11,"clone","","",10,[[],["cldiv_t",3]]],[11,"clone","","",50,[[],["cbw_browserwindowsource",3]]],[11,"clone","","",13,[[],["c__sigset_t",3]]],[11,"clone","","",24,[[],["c__pthread_cond_s__bindgen_ty_2",19]]],[11,"clone","","",7,[[],["cbw_applicationsettings",3]]],[11,"clone","","",49,[[],["cbw_browserwindowoptions",3]]],[11,"clone","","",53,[[],["c__va_list_tag",3]]],[11,"clone","","",14,[[],["ctimeval",3]]],[11,"clone","","",61,[[],["cbw_applicationengineimpl",3]]],[11,"clone","","",29,[[],["cpthread_mutex_t",19]]],[11,"clone","","",66,[[],["cbw_windowimpl",3]]],[11,"clone","","",47,[[],["cbw_windowoptions",3]]],[11,"clone","","",8,[[],["cbw_browserwindowimpl",3]]],[11,"clone","","",35,[[],["crandom_data",3]]],[11,"clone","","",33,[[],["cpthread_barrier_t",19]]],[11,"clone","","",32,[[],["cpthread_rwlockattr_t",19]]],[11,"clone","","",27,[[],["cpthread_condattr_t",19]]],[11,"clone","","",37,[[],["c__locale_struct",3]]],[11,"clone","","",20,[[],["c__pthread_rwlock_arch_t",3]]],[11,"clone","","",65,[[],["c_io_wide_data",3]]],[11,"clone","","",9,[[],["cdiv_t",3]]],[11,"clone","","",34,[[],["cpthread_barrierattr_t",19]]],[11,"clone","","",48,[[],["cbw_window",3]]],[11,"source","","",38,[[],[["option",4],["error",8]]]],[11,"fmt","","",13,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",8,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",4,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",6,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",15,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",7,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",67,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",5,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",44,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",35,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",19,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",10,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",50,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",53,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",46,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",11,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",66,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",47,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",45,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",9,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",60,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",23,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",20,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",63,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",61,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",3,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",2,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",51,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",12,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",49,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",14,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",36,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",38,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",37,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",16,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",25,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",52,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",18,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",17,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",64,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",43,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",48,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",62,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",65,[[["formatter",3]],[["result",4],["error",3]]]],[11,"from","","",4,[[],["cbw_cstrslice",3]]],[11,"fmt","","",38,[[["formatter",3]],[["result",4],["error",3]]]],[11,"into","","",3,[[]]],[11,"into","","",4,[[],["string",3]]],[11,"into","","",3,[[],["string",3]]],[11,"into","","",4,[[]]],[11,"assert_correct_thread","browser_window_core::application::c","",57,[[]]],[11,"dispatch","","",57,[[]]],[11,"exit","","",57,[[]]],[11,"exit_threadsafe","","",57,[[]]],[11,"finish","","",57,[[]]],[11,"initialize","","",57,[[["applicationsettings",3],["c_int",6]]]],[11,"run","","",57,[[]]],[11,"eval_js","browser_window_core::browser_window::c","",58,[[["evaljscallbackfn",6]]]],[11,"eval_js_threadsafe","","",58,[[["evaljscallbackfn",6]]]],[11,"navigate","","",58,[[]]],[11,"new","","",58,[[["source",6],["creationcallbackfn",6],["applicationimpl",3],["windowimpl",3],["option",4],["windowoptions",6],["browserwindowoptions",6],["externalinvocationhandlerfn",6]]]],[11,"user_data","","",58,[[]]],[11,"window","","",58,[[],["windowimpl",3]]],[11,"app","browser_window_core::window::c","",54,[[],["applicationimpl",3]]],[11,"destroy","","",54,[[]]],[11,"drop","","",54,[[]]],[11,"get_content_dimensions","","",54,[[],["dims2d",6]]],[11,"get_opacity","","",54,[[]]],[11,"get_position","","",54,[[],["pos2d",6]]],[11,"get_title","","",54,[[],["string",3]]],[11,"get_window_dimensions","","",54,[[],["dims2d",6]]],[11,"hide","","",54,[[]]],[11,"set_content_dimensions","","",54,[[["dims2d",6]]]],[11,"set_opacity","","",54,[[]]],[11,"set_position","","",54,[[["pos2d",6]]]],[11,"set_title","","",54,[[]]],[11,"set_window_dimensions","","",54,[[["dims2d",6]]]],[11,"show","","",54,[[]]],[11,"clone","browser_window_core::application::c","",57,[[],["applicationimpl",3]]],[11,"clone","browser_window_core::browser_window::c","",58,[[],["browserwindowimpl",3]]],[11,"clone","browser_window_core::window::c","",54,[[],["windowimpl",3]]],[11,"default","browser_window_core::application","",56,[[],["applicationsettings",3]]],[11,"default","browser_window_core::window::c","",54,[[]]],[11,"fmt","browser_window_core::browser_window::c","",59,[[["formatter",3]],["result",6]]],[11,"fmt","","",59,[[["formatter",3]],["result",6]]],[11,"source","","",59,[[],[["option",4],["error",8]]]],[11,"empty","browser_window_core::prelude","",3,[[],["cbw_strslice",3]]],[11,"empty","","",4,[[],["cbw_cstrslice",3]]]],"p":[[8,"ApplicationExt"],[8,"BrowserWindowExt"],[3,"cmax_align_t"],[3,"cbw_StrSlice"],[3,"cbw_CStrSlice"],[3,"cbw_Application"],[3,"cbw_ApplicationDispatchData"],[3,"cbw_ApplicationSettings"],[3,"cbw_BrowserWindowImpl"],[3,"cdiv_t"],[3,"cldiv_t"],[3,"clldiv_t"],[3,"c__fsid_t"],[3,"c__sigset_t"],[3,"ctimeval"],[3,"ctimespec"],[3,"cfd_set"],[3,"c__pthread_internal_list"],[3,"c__pthread_internal_slist"],[3,"c__pthread_mutex_s"],[3,"c__pthread_rwlock_arch_t"],[3,"c__pthread_cond_s"],[19,"c__pthread_cond_s__bindgen_ty_1"],[3,"c__pthread_cond_s__bindgen_ty_1__bindgen_ty_1"],[19,"c__pthread_cond_s__bindgen_ty_2"],[3,"c__pthread_cond_s__bindgen_ty_2__bindgen_ty_1"],[19,"cpthread_mutexattr_t"],[19,"cpthread_condattr_t"],[19,"cpthread_attr_t"],[19,"cpthread_mutex_t"],[19,"cpthread_cond_t"],[19,"cpthread_rwlock_t"],[19,"cpthread_rwlockattr_t"],[19,"cpthread_barrier_t"],[19,"cpthread_barrierattr_t"],[3,"crandom_data"],[3,"cdrand48_data"],[3,"c__locale_struct"],[3,"cbw_Err"],[3,"c__mbstate_t"],[19,"c__mbstate_t__bindgen_ty_1"],[3,"c_G_fpos_t"],[3,"c_G_fpos64_t"],[3,"c_IO_FILE"],[3,"cbw_Dims2D"],[3,"cbw_Pos2D"],[3,"cbw_WindowCallbacks"],[3,"cbw_WindowOptions"],[3,"cbw_Window"],[3,"cbw_BrowserWindowOptions"],[3,"cbw_BrowserWindowSource"],[3,"cbw_BrowserWindow"],[3,"c__locale_data"],[3,"c__va_list_tag"],[3,"WindowImpl"],[8,"WindowExt"],[3,"ApplicationSettings"],[3,"ApplicationImpl"],[3,"BrowserWindowImpl"],[3,"JsEvaluationError"],[3,"cbw_ApplicationImpl"],[3,"cbw_ApplicationEngineImpl"],[3,"cbw_ApplicationEngineData"],[3,"c_IO_marker"],[3,"c_IO_codecvt"],[3,"c_IO_wide_data"],[3,"cbw_WindowImpl"],[3,"cbw_WindowDispatchData"]]},\
"futures_channel":{"doc":"Asynchronous channels.","i":[[0,"mpsc","futures_channel","A multi-producer, single-consumer queue for sending values…",null,null],[3,"Sender","futures_channel::mpsc","The transmission end of a bounded mpsc channel.",null,null],[3,"UnboundedSender","","The transmission end of an unbounded mpsc channel.",null,null],[3,"Receiver","","The receiving end of a bounded mpsc channel.",null,null],[3,"UnboundedReceiver","","The receiving end of an unbounded mpsc channel.",null,null],[3,"SendError","","The error type for `Sender`s used as `Sink`s.",null,null],[3,"TrySendError","","The error type returned from `try_send`.",null,null],[3,"TryRecvError","","The error type returned from `try_next`.",null,null],[5,"channel","","Creates a bounded mpsc channel for communicating between…",null,[[]]],[5,"unbounded","","Creates an unbounded mpsc channel for communicating…",null,[[]]],[11,"is_full","","Returns `true` if this error is a result of the channel…",0,[[]]],[11,"is_disconnected","","Returns `true` if this error is a result of the receiver…",0,[[]]],[11,"is_full","","Returns `true` if this error is a result of the channel…",1,[[]]],[11,"is_disconnected","","Returns `true` if this error is a result of the receiver…",1,[[]]],[11,"into_inner","","Returns the message that was attempted to be sent but…",1,[[]]],[11,"into_send_error","","Drops the message and converts into a `SendError`.",1,[[],["senderror",3]]],[11,"try_send","","Attempts to send a message on this `Sender`, returning the…",2,[[],[["trysenderror",3],["result",4]]]],[11,"start_send","","Send a message on the channel.",2,[[],[["result",4],["senderror",3]]]],[11,"poll_ready","","Polls the channel to determine if there is guaranteed…",2,[[["context",3]],[["poll",4],["result",4]]]],[11,"is_closed","","Returns whether this channel is closed without needing a…",2,[[]]],[11,"close_channel","","Closes this channel from the sender side, preventing any…",2,[[]]],[11,"disconnect","","Disconnects this sender from the channel, closing it if…",2,[[]]],[11,"same_receiver","","Returns whether the senders send to the same receiver.",2,[[]]],[11,"is_connected_to","","Returns whether the sender send to this receiver.",2,[[["receiver",3]]]],[11,"hash_receiver","","Hashes the receiver into the provided hasher",2,[[]]],[11,"poll_ready","","Check if the channel is ready to receive a message.",3,[[["context",3]],[["poll",4],["result",4]]]],[11,"is_closed","","Returns whether this channel is closed without needing a…",3,[[]]],[11,"close_channel","","Closes this channel from the sender side, preventing any…",3,[[]]],[11,"disconnect","","Disconnects this sender from the channel, closing it if…",3,[[]]],[11,"start_send","","Send a message on the channel.",3,[[],[["result",4],["senderror",3]]]],[11,"unbounded_send","","Sends a message along this channel.",3,[[],[["trysenderror",3],["result",4]]]],[11,"same_receiver","","Returns whether the senders send to the same receiver.",3,[[]]],[11,"is_connected_to","","Returns whether the sender send to this receiver.",3,[[["unboundedreceiver",3]]]],[11,"hash_receiver","","Hashes the receiver into the provided hasher",3,[[]]],[11,"close","","Closes the receiving half of a channel, without dropping it.",4,[[]]],[11,"try_next","","Tries to receive the next message without notifying a…",4,[[],[["tryrecverror",3],["result",4],["option",4]]]],[11,"close","","Closes the receiving half of a channel, without dropping it.",5,[[]]],[11,"try_next","","Tries to receive the next message without notifying a…",5,[[],[["tryrecverror",3],["result",4],["option",4]]]],[0,"oneshot","futures_channel","A channel for sending a single message between…",null,null],[3,"Receiver","futures_channel::oneshot","A future for a value that will be provided by another…",null,null],[3,"Sender","","A means of transmitting a single value to another task.",null,null],[3,"Cancellation","","A future that resolves when the receiving end of a channel…",null,null],[3,"Canceled","","Error returned from a `Receiver` when the corresponding…",null,null],[5,"channel","","Creates a new one-shot channel for sending a single value…",null,[[]]],[11,"send","","Completes this oneshot with a successful result.",6,[[],["result",4]]],[11,"poll_canceled","","Polls this `Sender` half to detect whether its associated…",6,[[["context",3]],["poll",4]]],[11,"cancellation","","Creates a future that resolves when this `Sender`\'s…",6,[[],["cancellation",3]]],[11,"is_canceled","","Tests to see whether this `Sender`\'s corresponding…",6,[[]]],[11,"is_connected_to","","Tests to see whether this `Sender` is connected to the…",6,[[["receiver",3]]]],[11,"close","","Gracefully close this receiver, preventing any subsequent…",7,[[]]],[11,"try_recv","","Attempts to receive a message outside of the context of a…",7,[[],[["result",4],["option",4],["canceled",3]]]],[11,"from","futures_channel::mpsc","",2,[[]]],[11,"into","","",2,[[]]],[11,"to_owned","","",2,[[]]],[11,"clone_into","","",2,[[]]],[11,"borrow","","",2,[[]]],[11,"borrow_mut","","",2,[[]]],[11,"try_from","","",2,[[],["result",4]]],[11,"try_into","","",2,[[],["result",4]]],[11,"type_id","","",2,[[],["typeid",3]]],[11,"from","","",3,[[]]],[11,"into","","",3,[[]]],[11,"to_owned","","",3,[[]]],[11,"clone_into","","",3,[[]]],[11,"borrow","","",3,[[]]],[11,"borrow_mut","","",3,[[]]],[11,"try_from","","",3,[[],["result",4]]],[11,"try_into","","",3,[[],["result",4]]],[11,"type_id","","",3,[[],["typeid",3]]],[11,"from","","",4,[[]]],[11,"into","","",4,[[]]],[11,"borrow","","",4,[[]]],[11,"borrow_mut","","",4,[[]]],[11,"try_from","","",4,[[],["result",4]]],[11,"try_into","","",4,[[],["result",4]]],[11,"type_id","","",4,[[],["typeid",3]]],[11,"try_poll_next","","",4,[[["pin",3],["context",3]],[["poll",4],["option",4]]]],[11,"from","","",5,[[]]],[11,"into","","",5,[[]]],[11,"borrow","","",5,[[]]],[11,"borrow_mut","","",5,[[]]],[11,"try_from","","",5,[[],["result",4]]],[11,"try_into","","",5,[[],["result",4]]],[11,"type_id","","",5,[[],["typeid",3]]],[11,"try_poll_next","","",5,[[["pin",3],["context",3]],[["poll",4],["option",4]]]],[11,"from","","",0,[[]]],[11,"into","","",0,[[]]],[11,"to_owned","","",0,[[]]],[11,"clone_into","","",0,[[]]],[11,"to_string","","",0,[[],["string",3]]],[11,"borrow","","",0,[[]]],[11,"borrow_mut","","",0,[[]]],[11,"try_from","","",0,[[],["result",4]]],[11,"try_into","","",0,[[],["result",4]]],[11,"type_id","","",0,[[],["typeid",3]]],[11,"from","","",1,[[]]],[11,"into","","",1,[[]]],[11,"to_owned","","",1,[[]]],[11,"clone_into","","",1,[[]]],[11,"to_string","","",1,[[],["string",3]]],[11,"borrow","","",1,[[]]],[11,"borrow_mut","","",1,[[]]],[11,"try_from","","",1,[[],["result",4]]],[11,"try_into","","",1,[[],["result",4]]],[11,"type_id","","",1,[[],["typeid",3]]],[11,"from","","",8,[[]]],[11,"into","","",8,[[]]],[11,"to_string","","",8,[[],["string",3]]],[11,"borrow","","",8,[[]]],[11,"borrow_mut","","",8,[[]]],[11,"try_from","","",8,[[],["result",4]]],[11,"try_into","","",8,[[],["result",4]]],[11,"type_id","","",8,[[],["typeid",3]]],[11,"from","futures_channel::oneshot","",7,[[]]],[11,"into","","",7,[[]]],[11,"borrow","","",7,[[]]],[11,"borrow_mut","","",7,[[]]],[11,"try_from","","",7,[[],["result",4]]],[11,"try_into","","",7,[[],["result",4]]],[11,"type_id","","",7,[[],["typeid",3]]],[11,"into_future","","",7,[[]]],[11,"try_poll","","",7,[[["pin",3],["context",3]],["poll",4]]],[11,"from","","",6,[[]]],[11,"into","","",6,[[]]],[11,"borrow","","",6,[[]]],[11,"borrow_mut","","",6,[[]]],[11,"try_from","","",6,[[],["result",4]]],[11,"try_into","","",6,[[],["result",4]]],[11,"type_id","","",6,[[],["typeid",3]]],[11,"from","","",9,[[]]],[11,"into","","",9,[[]]],[11,"borrow","","",9,[[]]],[11,"borrow_mut","","",9,[[]]],[11,"try_from","","",9,[[],["result",4]]],[11,"try_into","","",9,[[],["result",4]]],[11,"type_id","","",9,[[],["typeid",3]]],[11,"into_future","","",9,[[]]],[11,"from","","",10,[[]]],[11,"into","","",10,[[]]],[11,"to_owned","","",10,[[]]],[11,"clone_into","","",10,[[]]],[11,"to_string","","",10,[[],["string",3]]],[11,"borrow","","",10,[[]]],[11,"borrow_mut","","",10,[[]]],[11,"try_from","","",10,[[],["result",4]]],[11,"try_into","","",10,[[],["result",4]]],[11,"type_id","","",10,[[],["typeid",3]]],[11,"drop","futures_channel::mpsc","",4,[[]]],[11,"drop","","",5,[[]]],[11,"drop","futures_channel::oneshot","",6,[[]]],[11,"drop","","",7,[[]]],[11,"clone","futures_channel::mpsc","",0,[[],["senderror",3]]],[11,"clone","","",1,[[],["trysenderror",3]]],[11,"clone","","",2,[[]]],[11,"clone","","",3,[[]]],[11,"clone","futures_channel::oneshot","",10,[[],["canceled",3]]],[11,"eq","futures_channel::mpsc","",0,[[["senderror",3]]]],[11,"ne","","",0,[[["senderror",3]]]],[11,"eq","","",1,[[["trysenderror",3]]]],[11,"ne","","",1,[[["trysenderror",3]]]],[11,"eq","futures_channel::oneshot","",10,[[["canceled",3]]]],[11,"fmt","futures_channel::mpsc","",2,[[["formatter",3]],["result",6]]],[11,"fmt","","",3,[[["formatter",3]],["result",6]]],[11,"fmt","","",4,[[["formatter",3]],["result",6]]],[11,"fmt","","",5,[[["formatter",3]],["result",6]]],[11,"fmt","","",0,[[["formatter",3]],["result",6]]],[11,"fmt","","",1,[[["formatter",3]],["result",6]]],[11,"fmt","","",8,[[["formatter",3]],["result",6]]],[11,"fmt","futures_channel::oneshot","",7,[[["formatter",3]],["result",6]]],[11,"fmt","","",6,[[["formatter",3]],["result",6]]],[11,"fmt","","",9,[[["formatter",3]],["result",6]]],[11,"fmt","","",10,[[["formatter",3]],["result",6]]],[11,"fmt","futures_channel::mpsc","",0,[[["formatter",3]],["result",6]]],[11,"fmt","","",1,[[["formatter",3]],["result",6]]],[11,"fmt","","",8,[[["formatter",3]],["result",6]]],[11,"fmt","futures_channel::oneshot","",10,[[["formatter",3]],["result",6]]],[11,"poll","","",9,[[["context",3],["pin",3]],["poll",4]]],[11,"poll","","",7,[[["context",3],["pin",3]],[["poll",4],["result",4]]]],[11,"is_terminated","","",7,[[]]],[11,"poll_next","futures_channel::mpsc","",4,[[["context",3],["pin",3]],[["option",4],["poll",4]]]],[11,"poll_next","","",5,[[["context",3],["pin",3]],[["option",4],["poll",4]]]],[11,"is_terminated","","",4,[[]]],[11,"is_terminated","","",5,[[]]]],"p":[[3,"SendError"],[3,"TrySendError"],[3,"Sender"],[3,"UnboundedSender"],[3,"Receiver"],[3,"UnboundedReceiver"],[3,"Sender"],[3,"Receiver"],[3,"TryRecvError"],[3,"Cancellation"],[3,"Canceled"]]},\
"futures_core":{"doc":"Core traits and types for asynchronous operations in Rust.","i":[[0,"future","futures_core","Futures.",null,null],[8,"Future","futures_core::future","A future represents an asynchronous computation.",null,null],[16,"Output","","The type of value produced on completion.",0,null],[10,"poll","","Attempt to resolve the future to a final value,…",0,[[["context",3],["pin",3]],["poll",4]]],[6,"BoxFuture","","An owned dynamically typed [`Future`] for use in cases…",null,null],[6,"LocalBoxFuture","","`BoxFuture`, but without the `Send` requirement.",null,null],[8,"FusedFuture","","A future which tracks whether or not the underlying future…",null,null],[10,"is_terminated","","Returns `true` if the underlying future should no longer…",1,[[]]],[8,"TryFuture","","A convenience for futures that return `Result` values that…",null,null],[16,"Ok","","The type of successful values yielded by this future",2,null],[16,"Error","","The type of failures yielded by this future",2,null],[10,"try_poll","","Poll this `TryFuture` as if it were a `Future`.",2,[[["context",3],["pin",3]],[["poll",4],["result",4]]]],[0,"stream","futures_core","Asynchronous streams.",null,null],[6,"BoxStream","futures_core::stream","An owned dynamically typed [`Stream`] for use in cases…",null,null],[6,"LocalBoxStream","","`BoxStream`, but without the `Send` requirement.",null,null],[8,"Stream","","A stream of values produced asynchronously.",null,null],[16,"Item","","Values yielded by the stream.",3,null],[10,"poll_next","","Attempt to pull out the next value of this stream,…",3,[[["context",3],["pin",3]],[["option",4],["poll",4]]]],[11,"size_hint","","Returns the bounds on the remaining length of the stream.",3,[[]]],[8,"FusedStream","","A stream which tracks whether or not the underlying stream…",null,null],[10,"is_terminated","","Returns `true` if the stream should no longer be polled.",4,[[]]],[8,"TryStream","","A convenience for streams that return `Result` values that…",null,null],[16,"Ok","","The type of successful values yielded by this future",5,null],[16,"Error","","The type of failures yielded by this future",5,null],[10,"try_poll_next","","Poll this `TryStream` as if it were a `Stream`.",5,[[["context",3],["pin",3]],[["option",4],["poll",4]]]],[0,"task","futures_core","Task notification.",null,null],[3,"Context","futures_core::task","The `Context` of an asynchronous task.",null,null],[4,"Poll","","Indicates whether a value is available or if the current…",null,null],[13,"Ready","","Represents that a value is immediately ready.",6,null],[13,"Pending","","Represents that a value is not ready yet.",6,null],[3,"Waker","","A `Waker` is a handle for waking up a task by notifying…",null,null],[3,"RawWaker","","A `RawWaker` allows the implementor of a task executor to…",null,null],[3,"RawWakerVTable","","A virtual function pointer table (vtable) that specifies…",null,null],[14,"ready","futures_core","Extracts the successful type of a `Poll<T>`.",null,null],[11,"from","futures_core::task","",7,[[]]],[11,"into","","",7,[[]]],[11,"borrow","","",7,[[]]],[11,"borrow_mut","","",7,[[]]],[11,"try_from","","",7,[[],["result",4]]],[11,"try_into","","",7,[[],["result",4]]],[11,"type_id","","",7,[[],["typeid",3]]],[11,"from","","",6,[[]]],[11,"from","","",6,[[]]],[11,"into","","",6,[[]]],[11,"to_owned","","",6,[[]]],[11,"clone_into","","",6,[[]]],[11,"borrow","","",6,[[]]],[11,"borrow_mut","","",6,[[]]],[11,"try_from","","",6,[[],["result",4]]],[11,"try_into","","",6,[[],["result",4]]],[11,"type_id","","",6,[[],["typeid",3]]],[11,"from","","",8,[[]]],[11,"into","","",8,[[]]],[11,"to_owned","","",8,[[]]],[11,"clone_into","","",8,[[]]],[11,"borrow","","",8,[[]]],[11,"borrow_mut","","",8,[[]]],[11,"try_from","","",8,[[],["result",4]]],[11,"try_into","","",8,[[],["result",4]]],[11,"type_id","","",8,[[],["typeid",3]]],[11,"from","","",9,[[]]],[11,"into","","",9,[[]]],[11,"borrow","","",9,[[]]],[11,"borrow_mut","","",9,[[]]],[11,"try_from","","",9,[[],["result",4]]],[11,"try_into","","",9,[[],["result",4]]],[11,"type_id","","",9,[[],["typeid",3]]],[11,"from","","",10,[[]]],[11,"into","","",10,[[]]],[11,"to_owned","","",10,[[]]],[11,"clone_into","","",10,[[]]],[11,"borrow","","",10,[[]]],[11,"borrow_mut","","",10,[[]]],[11,"try_from","","",10,[[],["result",4]]],[11,"try_into","","",10,[[],["result",4]]],[11,"type_id","","",10,[[],["typeid",3]]],[11,"clone","","",10,[[],["rawwakervtable",3]]],[11,"clone","","",6,[[],["poll",4]]],[11,"clone","","",8,[[],["waker",3]]],[11,"from","","Convert to a `Ready` variant.",6,[[],["poll",4]]],[11,"fmt","","",7,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",10,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",9,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",6,[[["formatter",3]],[["result",4],["error",3]]]],[11,"fmt","","",8,[[["formatter",3]],[["result",4],["error",3]]]],[11,"eq","","",10,[[["rawwakervtable",3]]]],[11,"ne","","",10,[[["rawwakervtable",3]]]],[11,"eq","","",6,[[["poll",4]]]],[11,"ne","","",6,[[["poll",4]]]],[11,"eq","","",9,[[["rawwaker",3]]]],[11,"ne","","",9,[[["rawwaker",3]]]],[11,"drop","","",8,[[]]],[11,"cmp","","",6,[[["poll",4]],["ordering",4]]],[11,"hash","","",6,[[]]],[11,"into_result","","",6,[[],["result",4]]],[11,"from_error","","",6,[[],[["poll",4],["result",4]]]],[11,"from_ok","","",6,[[],[["poll",4],["result",4]]]],[11,"into_result","","",6,[[],["result",4]]],[11,"from_error","","",6,[[],[["poll",4],["option",4]]]],[11,"from_ok","","",6,[[],[["poll",4],["option",4]]]],[11,"partial_cmp","","",6,[[["poll",4]],[["option",4],["ordering",4]]]],[11,"lt","","",6,[[["poll",4]]]],[11,"le","","",6,[[["poll",4]]]],[11,"gt","","",6,[[["poll",4]]]],[11,"ge","","",6,[[["poll",4]]]],[11,"from","","",8,[[["arc",3]],["waker",3]]],[11,"from","","",9,[[["arc",3]],["rawwaker",3]]],[11,"from_waker","","Create a new `Context` from a `&Waker`.",7,[[["waker",3]],["context",3]]],[11,"waker","","Returns a reference to the `Waker` for the current task.",7,[[],["waker",3]]],[11,"map","","Changes the ready value of this `Poll` with the closure…",6,[[],["poll",4]]],[11,"is_ready","","Returns `true` if this is `Poll::Ready`",6,[[]]],[11,"is_pending","","Returns `true` if this is `Poll::Pending`",6,[[]]],[11,"map_ok","","Changes the success value of this `Poll` with the closure…",6,[[],[["result",4],["poll",4]]]],[11,"map_err","","Changes the error value of this `Poll` with the closure…",6,[[],[["poll",4],["result",4]]]],[11,"map_ok","","Changes the success value of this `Poll` with the closure…",6,[[],[["option",4],["poll",4]]]],[11,"map_err","","Changes the error value of this `Poll` with the closure…",6,[[],[["option",4],["poll",4]]]],[11,"wake","","Wake up the task associated with this `Waker`.",8,[[]]],[11,"wake_by_ref","","Wake up the task associated with this `Waker` without…",8,[[]]],[11,"will_wake","","Returns `true` if this `Waker` and another `Waker` have…",8,[[["waker",3]]]],[11,"from_raw","","Creates a new `Waker` from [`RawWaker`].",8,[[["rawwaker",3]],["waker",3]]],[11,"new","","Creates a new `RawWaker` from the provided `data` pointer…",9,[[["rawwakervtable",3]],["rawwaker",3]]],[11,"new","","Creates a new `RawWakerVTable` from the provided `clone`,…",10,[[],["rawwakervtable",3]]]],"p":[[8,"Future"],[8,"FusedFuture"],[8,"TryFuture"],[8,"Stream"],[8,"FusedStream"],[8,"TryStream"],[4,"Poll"],[3,"Context"],[3,"Waker"],[3,"RawWaker"],[3,"RawWakerVTable"]]},\
"lazy_static":{"doc":"A macro for declaring lazily evaluated statics.","i":[[5,"initialize","lazy_static","Takes a shared reference to a lazy static and initializes…",null,[[]]],[8,"LazyStatic","","Support trait for enabling a few common operation on lazy…",null,null],[14,"lazy_static","","",null,null]],"p":[]},\
"unsafe_send_sync":{"doc":"","i":[[3,"UnsafeSend","unsafe_send_sync","A wrapper type that is always `Send`.",null,null],[12,"i","","",0,null],[3,"UnsafeSync","","A wrapper type that is always `Sync`.",null,null],[12,"i","","",1,null],[3,"UnsafeSendSync","","A wrapper type that is always `Send` and `Sync`.",null,null],[12,"i","","",2,null],[11,"new","","",0,[[]]],[11,"unwrap","","",0,[[]]],[11,"new","","",1,[[]]],[11,"unwrap","","",1,[[]]],[11,"new","","",2,[[]]],[11,"unwrap","","",2,[[]]],[11,"from","","",0,[[]]],[11,"into","","",0,[[]]],[11,"to_owned","","",0,[[]]],[11,"clone_into","","",0,[[]]],[11,"borrow","","",0,[[]]],[11,"borrow_mut","","",0,[[]]],[11,"try_from","","",0,[[],["result",4]]],[11,"try_into","","",0,[[],["result",4]]],[11,"type_id","","",0,[[],["typeid",3]]],[11,"from","","",1,[[]]],[11,"into","","",1,[[]]],[11,"to_owned","","",1,[[]]],[11,"clone_into","","",1,[[]]],[11,"borrow","","",1,[[]]],[11,"borrow_mut","","",1,[[]]],[11,"try_from","","",1,[[],["result",4]]],[11,"try_into","","",1,[[],["result",4]]],[11,"type_id","","",1,[[],["typeid",3]]],[11,"from","","",2,[[]]],[11,"into","","",2,[[]]],[11,"to_owned","","",2,[[]]],[11,"clone_into","","",2,[[]]],[11,"borrow","","",2,[[]]],[11,"borrow_mut","","",2,[[]]],[11,"try_from","","",2,[[],["result",4]]],[11,"try_into","","",2,[[],["result",4]]],[11,"type_id","","",2,[[],["typeid",3]]],[11,"clone","","",0,[[]]],[11,"clone","","",1,[[]]],[11,"clone","","",2,[[]]],[11,"default","","",0,[[]]],[11,"default","","",1,[[]]],[11,"default","","",2,[[]]],[11,"deref","","",0,[[]]],[11,"deref","","",1,[[]]],[11,"deref","","",2,[[]]],[11,"deref_mut","","",0,[[]]],[11,"deref_mut","","",1,[[]]],[11,"deref_mut","","",2,[[]]]],"p":[[3,"UnsafeSend"],[3,"UnsafeSync"],[3,"UnsafeSendSync"]]}\
}');
addSearchOptions(searchIndex);initSearch(searchIndex);