use std::fs::{DirEntry};
use std::io::{Error,ErrorKind};

/// The get_ext function will take a DirEntry object and return the
/// file extention. This saves us a lot of efforts and conversion
/// between types. 
pub fn get_ext(entry:&DirEntry)->Result<String,Error>{
    let path_buf = entry.path();
    let ext = path_buf.extension();
    match ext {
        Some(ft)=>{
            let ft_again = ft.to_str().map(|s| s.to_string());
                    match ft_again{
                     Some(ft_last)=>{
                        return Ok(ft_last);
                     },
                     None=>{
                        let e = Error::new(ErrorKind::NotFound,"failed to get extention from file");
                        return Err(e);   
                     },   
                    }
        },
        None=> {
            let e = Error::new(ErrorKind::NotFound,"failed to get extention");
            return Err(e);
        },
    }
}