use std::process::Command;

fn main() {
    let output = Command::new("git")
        .args(&["rev-parse", "--short", "HEAD"])
        .output()
        .unwrap();

    let git_hash = String::from_utf8(output.stdout).unwrap();

    println!(
        "cargo:rustc-env={}={}",
        concat!("CARGO_", env!("CARGO_PKG_NAME"), "_GIT_HASH"),
        git_hash
    );
}
