use anyhow::Result;
use brevdash_data as data;
use std::path::Path;
use structopt::StructOpt;

#[derive(Debug, StructOpt)]
pub enum Command {
    /// List the characteristics
    Characteristics,

    /// List the projects
    Projects,
}

impl Command {
    pub fn process(&self, working_directory: &Path) -> Result<()> {
        let repo = data::Repository::open(working_directory)?;

        match self {
            Command::Characteristics => {
                for key in repo.description.characteristics.keys() {
                    println!("{}", key);
                }
            }
            Command::Projects => {
                for id in repo.load_project_ids()? {
                    println!("{}", id);
                }
            }
        }

        Ok(())
    }
}
