#[rustfmt::skip]
pub fn fighter_name(name: &str) -> String {
    match name {
        "Captain"        => String::from("Captain Falcon"),
        "Dedede"         => String::from("King Dedede"),
        "Diddy"          => String::from("Diddy Kong"),
        "Donkey"         => String::from("Donkey Kong"),
        "Falco"          => String::from("Falco"),
        "Fox"            => String::from("Fox"),
        "GKoopa"         => String::from("Giga Bowser"),
        "GameWatch"      => String::from("Game & Watch"),
        "Ganon"          => String::from("Ganondorf"),
        "Ike"            => String::from("Ike"),
        "Kirby"          => String::from("Kirby"),
        "Koopa"          => String::from("Bowser"),
        "Link"           => String::from("Link"),
        "Lucario"        => String::from("Lucario"),
        "Lucas"          => String::from("Lucas"),
        "Luigi"          => String::from("Luigi"),
        "Mario"          => String::from("Mario"),
        "Marth"          => String::from("Marth"),
        "Metaknight"     => String::from("Meta Knight"),
        "Mewtwo"         => String::from("Mewtwo"),
        "Ness"           => String::from("Ness"),
        "Peach"          => String::from("Peach"),
        "Pikachu"        => String::from("Pikachu"),
        "Pikmin"         => String::from("Olimar"),
        "Pit"            => String::from("Pit"),
        "PokeFushigisou" => String::from("Ivysaur"),
        "PokeLizardon"   => String::from("Charizard"),
        "PokeTrainer"    => String::from("Pokemon Trainer"),
        "PokeZenigame"   => String::from("Squirtle"),
        "Popo"           => String::from("Ice Climbers"),
        "Purin"          => String::from("Jigglypuff"),
        "Robot"          => String::from("R.O.B"),
        "Roy"            => String::from("Roy"),
        "SZerosuit"      => String::from("Zero Suit Samus"),
        "Samus"          => String::from("Samus"),
        "Sheik"          => String::from("Sheik"),
        "Snake"          => String::from("Snake"),
        "Sonic"          => String::from("Sonic"),
        "ToonLink"       => String::from("Toon Link"),
        "Wario"          => String::from("Wario"),
        "WarioMan"       => String::from("Wario-Man"),
        "Wolf"           => String::from("Wolf"),
        "Yoshi"          => String::from("Yoshi"),
        "Zakoball"       => String::from("Green Alloy"),
        "Zakoboy"        => String::from("Red Alloy"),
        "Zakochild"      => String::from("Yellow Alloy"),
        "Zakogirl"       => String::from("Blue Alloy"),
        "Zelda"          => String::from("Zelda"),
        _                => name.to_string(),
    }
}

#[rustfmt::skip]
pub fn fighter_id(name: &str) -> Option<u8> {
    match name {
        "Captain"        => Some(0x09),
        "Dedede"         => Some(0x20),
        "Diddy"          => Some(0x1B),
        "Donkey"         => Some(0x01),
        "Falco"          => Some(0x13),
        "Fox"            => Some(0x06),
        "GKoopa"         => Some(0x30),
        "GameWatch"      => Some(0x12),
        "Ganon"          => Some(0x14),
        "Ike"            => Some(0x22),
        "Kirby"          => Some(0x05),
        "Knuckles"       => Some(0x2D),
        "Koopa"          => Some(0x0B),
        "Link"           => Some(0x02),
        "Lucario"        => Some(0x21),
        "Lucas"          => Some(0x1A),
        "Luigi"          => Some(0x08),
        "Mario"          => Some(0x00),
        "Marth"          => Some(0x11),
        "Metaknight"     => Some(0x16),
        "Mewtwo"         => Some(0x26),
        "Nana"           => Some(0x10),
        "Ness"           => Some(0x0A),
        "Peach"          => Some(0x0C),
        "Pikachu"        => Some(0x07),
        "Pikmin"         => Some(0x19),
        "Pit"            => Some(0x17),
        "PokeFushigisou" => Some(0x1F),
        "PokeLizardon"   => Some(0x1D),
        "PokeTrainer"    => Some(0x1C),
        "PokeZenigame"   => Some(0x1E),
        "Popo"           => Some(0x0F),
        "Purin"          => Some(0x25),
        "Robot"          => Some(0x23),
        "Roy"            => Some(0x27),
        "SZerosuit"      => Some(0x18),
        "Samus"          => Some(0x03),
        "Sheik"          => Some(0x0E),
        "Snake"          => Some(0x2E),
        "Sonic"          => Some(0x2F),
        "ToonLink"       => Some(0x29),
        "Wario"          => Some(0x15),
        "WarioMan"       => Some(0x31),
        "Wolf"           => Some(0x2C),
        "Yoshi"          => Some(0x04),
        "Zakoball"       => Some(0x35),
        "Zakoboy"        => Some(0x32),
        "Zakochild"      => Some(0x34),
        "Zakogirl"       => Some(0x33),
        "Zelda"          => Some(0x0D),
        _                => None
    }
}
