use winit::event::VirtualKeyCode;

pub fn virtual_key_code_to_scan(key: VirtualKeyCode) -> u32 {
    match key {
        VirtualKeyCode::Escape => 1,
        VirtualKeyCode::F1 => 59,
        VirtualKeyCode::F2 => 60,
        VirtualKeyCode::F3 => 61,
        VirtualKeyCode::F4 => 62,
        VirtualKeyCode::F5 => 63,
        VirtualKeyCode::F6 => 64,
        VirtualKeyCode::F7 => 65,
        VirtualKeyCode::F8 => 66,
        VirtualKeyCode::F9 => 67,
        VirtualKeyCode::F10 => 68,
        VirtualKeyCode::F11 => 87,
        VirtualKeyCode::F12 => 88,
        VirtualKeyCode::Scroll => 70,
        VirtualKeyCode::Pause => 69,
        VirtualKeyCode::Back => 14,
        VirtualKeyCode::Grave => 41,
        VirtualKeyCode::Key1 => 2,
        VirtualKeyCode::Key2 => 3,
        VirtualKeyCode::Key3 => 4,
        VirtualKeyCode::Key4 => 5,
        VirtualKeyCode::Key5 => 6,
        VirtualKeyCode::Key6 => 7,
        VirtualKeyCode::Key7 => 8,
        VirtualKeyCode::Key8 => 9,
        VirtualKeyCode::Key9 => 10,
        VirtualKeyCode::Key0 => 11,
        VirtualKeyCode::Minus => 12,
        VirtualKeyCode::Equals => 13,
        VirtualKeyCode::Insert => 82,
        VirtualKeyCode::Home => 71,
        VirtualKeyCode::PageUp => 73,
        VirtualKeyCode::NumpadDivide => 53,
        VirtualKeyCode::NumpadMultiply => 55,
        VirtualKeyCode::NumpadSubtract => 74,
        VirtualKeyCode::Tab => 15,
        VirtualKeyCode::Q => 16,
        VirtualKeyCode::W => 17,
        VirtualKeyCode::E => 18,
        VirtualKeyCode::R => 19,
        VirtualKeyCode::T => 20,
        VirtualKeyCode::Y => 21,
        VirtualKeyCode::U => 22,
        VirtualKeyCode::I => 23,
        VirtualKeyCode::O => 24,
        VirtualKeyCode::P => 25,
        VirtualKeyCode::LBracket => 26,
        VirtualKeyCode::RBracket => 27,
        VirtualKeyCode::Backslash => 43,
        VirtualKeyCode::Delete => 83,
        VirtualKeyCode::End => 79,
        VirtualKeyCode::PageDown => 81,
        VirtualKeyCode::Numpad7 => 71,
        VirtualKeyCode::Numpad8 => 72,
        VirtualKeyCode::Numpad9 => 73,
        VirtualKeyCode::NumpadAdd => 78,
        VirtualKeyCode::Capital => 58,
        VirtualKeyCode::A => 30,
        VirtualKeyCode::S => 31,
        VirtualKeyCode::D => 32,
        VirtualKeyCode::F => 33,
        VirtualKeyCode::G => 34,
        VirtualKeyCode::H => 35,
        VirtualKeyCode::J => 36,
        VirtualKeyCode::K => 37,
        VirtualKeyCode::L => 38,
        VirtualKeyCode::Semicolon => 39,
        VirtualKeyCode::Apostrophe => 40,
        VirtualKeyCode::Return => 28,
        VirtualKeyCode::Numpad4 => 75,
        VirtualKeyCode::Numpad5 => 76,
        VirtualKeyCode::Numpad6 => 77,
        VirtualKeyCode::LShift => 42,
        VirtualKeyCode::Z => 44,
        VirtualKeyCode::X => 45,
        VirtualKeyCode::C => 46,
        VirtualKeyCode::V => 47,
        VirtualKeyCode::B => 48,
        VirtualKeyCode::N => 49,
        VirtualKeyCode::M => 50,
        VirtualKeyCode::Comma => 51,
        VirtualKeyCode::Period => 52,
        VirtualKeyCode::Slash => 53,
        VirtualKeyCode::RShift => 54,
        VirtualKeyCode::Up => 72,
        VirtualKeyCode::Numpad1 => 79,
        VirtualKeyCode::Numpad2 => 80,
        VirtualKeyCode::Numpad3 => 81,
        VirtualKeyCode::LControl => 29,
        VirtualKeyCode::LWin => 91,
        VirtualKeyCode::LAlt => 56,
        VirtualKeyCode::Space => 57,
        VirtualKeyCode::RAlt => 56,
        VirtualKeyCode::Apps => 93,
        VirtualKeyCode::RControl => 29,
        VirtualKeyCode::Left => 75,
        VirtualKeyCode::Down => 80,
        VirtualKeyCode::Right => 77,
        VirtualKeyCode::Numpad0 => 82,
        VirtualKeyCode::NumpadDecimal => 83,
        _ => 0,
    }
}

pub(crate) fn char_to_keycode(c: char) -> Option<VirtualKeyCode> {
    match c {
        '`' => Some(VirtualKeyCode::Grave),
        '1' => Some(VirtualKeyCode::Key1),
        '2' => Some(VirtualKeyCode::Key2),
        '3' => Some(VirtualKeyCode::Key3),
        '4' => Some(VirtualKeyCode::Key4),
        '5' => Some(VirtualKeyCode::Key5),
        '6' => Some(VirtualKeyCode::Key6),
        '7' => Some(VirtualKeyCode::Key7),
        '8' => Some(VirtualKeyCode::Key8),
        '9' => Some(VirtualKeyCode::Key9),
        '0' => Some(VirtualKeyCode::Key0),
        'a' => Some(VirtualKeyCode::A),
        'b' => Some(VirtualKeyCode::B),
        'c' => Some(VirtualKeyCode::C),
        'd' => Some(VirtualKeyCode::D),
        'e' => Some(VirtualKeyCode::E),
        'f' => Some(VirtualKeyCode::F),
        'g' => Some(VirtualKeyCode::G),
        'h' => Some(VirtualKeyCode::H),
        'i' => Some(VirtualKeyCode::I),
        'j' => Some(VirtualKeyCode::J),
        'k' => Some(VirtualKeyCode::K),
        'l' => Some(VirtualKeyCode::L),
        'm' => Some(VirtualKeyCode::M),
        'n' => Some(VirtualKeyCode::N),
        'o' => Some(VirtualKeyCode::O),
        'p' => Some(VirtualKeyCode::P),
        'q' => Some(VirtualKeyCode::Q),
        'r' => Some(VirtualKeyCode::R),
        's' => Some(VirtualKeyCode::S),
        't' => Some(VirtualKeyCode::T),
        'u' => Some(VirtualKeyCode::U),
        'v' => Some(VirtualKeyCode::V),
        'w' => Some(VirtualKeyCode::W),
        'x' => Some(VirtualKeyCode::X),
        'y' => Some(VirtualKeyCode::Y),
        'z' => Some(VirtualKeyCode::Z),
        '\t' => Some(VirtualKeyCode::Tab),
        '\n' => Some(VirtualKeyCode::Return),
        ',' => Some(VirtualKeyCode::Comma),
        '.' => Some(VirtualKeyCode::Period),
        '/' => Some(VirtualKeyCode::Slash),
        '[' => Some(VirtualKeyCode::LBracket),
        ']' => Some(VirtualKeyCode::RBracket),
        '\\' => Some(VirtualKeyCode::Backslash),
        _ => None,
    }
}
