# Banksea-Oracle-Lib
This crate contain a library of banksea oracle which providers NFT price evaluation service on-chain.
## Installation
Add the library to your Cargo.toml:
```rust
[dependencies]
banksea-oracle-client="<version>"
```
You can find the latest version of the library in [crate.io](https://crates.io/crates/banksea-oracle-client)
## Usage
You can call the `get_report_info` in your program on-chain.
```rust
let report_info = banksea_oracle::get_report_info(report_account)?;
```
It will return a struct of `ReportInfo`. 

The details of `ReportInfo`:
| **Field Name** | **Description**                                              |
| -------------- | ------------------------------------------------------------ |
| source_chain   | The chain where the NFT born.                                |
| name           | The NFT name.                                                |
| price          | The lastest price of the NFT.                                |
| decimal        | The decimals count of the price value.                       |
| price_type     | The symbol of the price.                                     |
| time           | the time of price updated                                    |
| risk           | the risk of the NFT represents price stability               |
| program_addr   | On Ethereum: the contract address of the NFT collection; <br />On Solana: the token program id. |
| token_addr     | On Ethereum: the token id of the NFT; <br />On Solana: the mint of the NFT. |
| local_addr     | The mint address of the NFT on Solana. It is useful for cross-chain. |
## Example
You can find [example](https://github.com/Banksea-Finance/banksea-oracle-example) on github

