// pub(crate) type Callback = Box<
//     dyn Fn(&String, TaskContext, &serde_json::Value, SharedState) -> HandlerResult + Sync + Send>;
use async_trait::async_trait;
use std::error::Error;

pub trait BoxcarMessageTrait {
    fn encode(&self, buf: &mut Vec<u8>) -> Result<(), Box<dyn Error>>;
    fn decode(&self, buf: Vec<u8>) -> Result<(), Box<dyn Error>>;
}

#[async_trait]
pub trait HandlerTrait {
    async fn handle(&self, method: &str, arguments: Vec<u8>) -> Result<Vec<u8>, Box<dyn Error>>;
    fn contains(&self, _: String) -> bool;
    fn package(&self) -> &str;
}

pub type Handler = Box<dyn HandlerTrait + Sync + Send + 'static>;
pub type Callback = Box<dyn Fn(&str) -> bool + Sync + Send>;
// pub(crate) type Handler = Box<dyn GeneratedMethodTrait + Sync + Send + 'static>;
