use boxcar_rpc::Transport;
use std::error::Error;
use std::net::SocketAddr;
use tokio::net::{TcpListener, TcpStream};


async fn handle_connection(raw_stream: TcpStream, addr: SocketAddr) {
    println!("Incoming TCP connection from: {}", addr);

    let server = Transport::server(raw_stream, addr.clone()).await;
    if server.is_err() {

    }

    let server: Transport  = server.unwrap();

    loop {
        let packet = server.recv().await;
        println!("got packet {:?}", packet)
    }

}

#[tokio::main]
async fn main() -> Result<(), Box<dyn Error>> {
    tracing_subscriber::fmt::init();

    let try_socket = TcpListener::bind("127.0.0.1:5430").await;
    let listener = try_socket.expect("Failed to bind");

    // Let's spawn the handling of each connection in a separate task.
    while let Ok((stream, addr)) = listener.accept().await {
        tokio::spawn(handle_connection( stream, addr));
    }



    Ok(())
}

