use anyhow::Result;
use boxcar_rpc::Transport;
use std::error::Error;
use std::thread::sleep;
use std::time::Duration;

#[tokio::main]
async fn main() -> Result<(), Box<dyn Error>> {
    tracing_subscriber::fmt::init();

    let client = Transport::client("ws://127.0.0.1:5430").await?;

    let _ = client.send(None, vec![0, 1, 2, 3, 4, 5, 6, 7, 8, 9], false).await;

    sleep(Duration::from_secs(3));

    Ok(())
}

//
// struct BoxcarClient {
//     send_tx: mpsc::Sender<BoxcarMessage>,
//     recv_rx: mpsc::Receiver<BoxcarMessage>,
//
//     /// When an RPC is made, the server returns a slot number
//     /// This slot number is stored here, and an empty RpcRequest is created.
//     ///
//     /// If the server sends an RpcResponse, the slot number is read and the associated record here
//     /// is updated with the result.
//     mapping: Arc<RwLock<BTreeMap<u16, RpcResponse>>>,
//
// }
// impl BoxcarClient {
//     async fn new(endpoint: &str) -> Self {
//
//         let mapping = Arc::new(RwLock::new(BTreeMap::new()));
//
//         let (ws_stream, foo) = tokio_tungstenite::connect_async("").await.unwrap();
//
//         let (mut ws_tx, ws_rx) = ws_stream.split();
//
//         let (recv_tx, recv_rx) = mpsc::channel(10);
//         let (send_tx, mut send_rx) = mpsc::channel(10);
//
//         let map = mapping.clone();
//
//         // background loop that takes outgoing messages and actually sends them
//         tokio::spawn(async move {
//             loop {
//                 let msg: BoxcarMessage = send_rx.blocking_recv().unwrap();
//                 ws_tx.send(tokio_tungstenite::tungstenite::Message::Binary(msg.encode())).await;
//             }
//         });
//
//         // background processor that accepts incoming messages from the server
//         tokio::spawn(async move {
//             let _ = ws_rx.for_each( |raw| async {
//                 let recv_tx = recv_tx.clone();
//                 let data = raw.unwrap();
//
//                 let buf = data.into_data();
//                 let msg = BoxcarMessage::decode(buf).unwrap();
//
//                 log::debug!("server sent: {:?}", &msg);
//
//                 match msg {
//                     // send these messages to recv_tx, because the only reason the server would send
//                     // one of these is because the clinet explicitly asked for it
//                     BoxcarMessage::RpcStatus(_) | BoxcarMessage::ServerError(_)=> recv_tx.send(msg.clone()).await.unwrap(),
//                     BoxcarMessage::RpcResponse(rsp) => {
//                         // a rpc has returned, put the result into the proper slot
//                         let mut result_map = map.write().unwrap();
//                         let result_slot = a.get_mut(&rsp.slot);
//                         // if the slot is some
//                         if let Some(i) = result_slot {
//                             // set the underlying data to the message we just got. it doesn't matter
//                             // what already is there... right?
//                             *i = rsp;
//                         } else {
//                             // we got a result that we didn't ask for?
//                             // don't know how this could have happened, but whatever. let's keep it
//                             log::warn!("slot {} is for some reason not in memory...", &rsp.slot);
//
//                             // explicitly drop the handle, just to make sure it's closed before we
//                             // try and open a new one
//                             drop(result_slot);
//
//                             let _ = map.write().unwrap().insert(rsp.slot.clone(), rsp).unwrap();
//                         }
//
//                     }
//                     _ => log::error!("server sent unexpected message: {:?}", msg)
//                 }
//
//             }).await;
//         }).await;
//
//         BoxcarClient {
//             send_tx,
//             mapping,
//             recv_rx
//         }
//
//     }
//
//     /// Kick off an RPC.
//     pub async fn call(&mut self, req: boxcar::MethodInvocation) -> anyhow::Result<BoxcarRequest> {
//
//         // build and send the BoxcarMessage to the channel. If all goes well, the background task
//         // should consume the message and send it down the wire
//         self.send_tx.send(boxcar::BoxcarMessage::RpcReq(req)).await?;
//
//         // wait for a response from the server by way of the recv_rx channel
//         if let Some(msg) = self.recv_rx.blocking_recv() {
//             match msg {
//                 BoxcarMessage::RpcReqStatus(inner) => match inner {
//                     RpcReqStatus::Accepted(slot) => {
//                         // create an empty RpcResponse object & insert it into the slot map
//                         let _ = self.mapping.write().unwrap().insert(slot.clone(), RpcResponse {
//                            slot,
//                            finish: false,
//                            body: vec![]
//                        });
//
//                         return Ok(BoxcarRequest {
//                             slot,
//                             send_tx: self.send_tx.clone(),
//                             mapping: self.mapping.clone()
//                         })
//                     },
//                     RpcReqStatus::Rejected(reason) => bail!("rpc was rejected by the server. {:?}", reason)
//                 }
//                 _ => bail!("invalid packet received")
//             }
//
//         } else {
//             // not sure how this could even happen
//             bail!("response was none")
//         }
//     }
//
// }
//
