#[macro_use]
extern crate lazy_static;
extern crate mut_static;

mod logger;

///
/// log regular information
///
pub fn log_info<T: Into<String>>(line: T) {
    let owned: String = line.into();
    logger::read_on_static(|r| (r.on_info)(&owned));
}

///
/// log warnings
///
pub fn log_warn<T: Into<String>>(line: T) {
    let owned: String = line.into();
    logger::read_on_static(|r| (r.on_warn)(&owned));
}

///
/// log exceptionnal errors
///
pub fn log_error<T: Into<String>>(line: T) {
    let owned: String = line.into();
    logger::read_on_static(|r| (r.on_error)(&owned));
}

///
/// module for conveniency
///
mod prelude {
    pub use super::log_error;
    pub use super::log_info;
    pub use super::log_warn;
}
