#[test]
fn test() {
    // This test is actually intended for the crate documentation in lib.rs
    // But currently we can't get all of the following there:
    //   - test the example with `cargo test` or `cargo test --all-features`
    //   - run `cargo doc` and `cargo doc --all-features` without errors
    fn main() -> Result<(), Box<dyn std::error::Error>> {
        use bos::AbosStr;
        use serde::{Deserialize, Deserializer};
        use std::sync::Arc;

        #[derive(Debug, Eq, PartialEq, Deserialize)]
        struct Request<'a> {
            id: AbosStr<'a>,

            #[serde(deserialize_with = "arc_string_if_long")]
            name: AbosStr<'a>,
        }

        fn arc_string_if_long<'b, 'de, D>(d: D) -> Result<AbosStr<'b>, D::Error>
        where
            D: Deserializer<'de>,
        {
            let s: String = Deserialize::deserialize(d)?;
            Ok(if s.len() < 7 {
                AbosStr::Owned(s)
            } else {
                AbosStr::Arc(Arc::new(s))
            })
        }

        // Let's pretend this JSON String came over the network.
        let request_string = String::from(r#"{ "id":"12345", "name":"Grace" }"#);
        let request: Request<'static> = serde_json::from_str(&request_string)?;
        assert_eq!(
            request,
            Request {
                id: "12345".into(),
                name: "Grace".into(),
            }
        );
        assert_matches::assert_matches!(
            request,
            Request {
                id: AbosStr::Owned(_),
                name: AbosStr::Arc(_),
            }
        );
        Ok(())
    }
    main().unwrap()
}
