/*!
A module for smart pointers to sized types like [`HashMap`][std::collections::HashMap].

Prefer [`Abos`] and [`Bos`] in this module
1. if your type is always [`Sized`], like most types in Rust.
2. if your type doesn't need heap allocation.
3. if your type does **not** have a different owned or borrowed type.

See the [crate-level documentation][crate#borrowed-sized-or-boxed]
for a comparison of borrowed, sized and boxed smart pointers.
*/

mod abos;
mod bos;

pub use self::abos::Abos;
pub use self::bos::Bos;
