/*!
A module for smart pointers to types that should be heap allocated,
like [trait objects](https://doc.rust-lang.org/reference/types/trait-object.html).

Prefer [`Abos`] and [`Bos`] in this module
1. if your type does **not** have a different owned or borrowed type.
2. if your type is not [`Sized`].
3. or your type needs heap allocation.

See the [crate-level documentation][crate#borrowed-sized-or-boxed]
for a comparison of borrowed, sized and boxed smart pointers.
*/

mod abos;
mod bos;

pub use self::abos::Abos;
pub use self::bos::Bos;
