/*!
A module for smart pointers to dynamically sized borrowed types like [`str`], the borrowed form of [`String`].

The dynamically sized borrowed types in [`std`] at the time of writing are all the slice types:
- [slice `[T]`](slice), the borrowed form of [`Vec<T>`]
- [`Path`][std::path::Path], the borrowed form of [`PathBuf`][std::path::PathBuf]
- [`OsStr`][std::ffi::OsStr], the borrowed form of [`OsString`][std::ffi::OsString]
- [`CStr`][std::ffi::CStr], the borrowed form of [`CString`][std::ffi::CString]
- and the already mentioned [`str`], with its owned form [`String`]

[`Abos`] and [`Bos`] in this module should be preferred for these and similar types.

See the [crate-level documentation][crate#borrowed-sized-or-boxed]
for a comparison of borrowed, sized and boxed smart pointers.

# `SharedOwned` and `SharedBorrowed` variants

[`Abos`] and [`Bos`] in this module are defined using the [`ToOwned`] trait.
They both have `SharedBorrowed` variants in addition to `SharedOwned` variants.
For example [`Abos`] has the [`ArcBorrowed`][Abos::ArcBorrowed] and [`ArcOwned`][Abos::ArcOwned] variants.
*/

mod abos;
mod bos;

pub use self::abos::Abos;
pub use self::bos::Bos;
